/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.jmi.reflect.ConstraintViolationException;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.ResourceClass;
import org.netbeans.mdr.handlers.ClassProxyHandler;
import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.mdr.storagemodel.StorableBaseObject;
import org.netbeans.mdr.storagemodel.StorableClass;
import org.netbeans.mdr.storagemodel.StorableFeatured;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.jmiimpl.javamodel.ResourceImpl;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;

public abstract class ResourceClassImpl
extends ClassProxyHandler
implements ResourceClass {
    private static final String NAME_INDEX = "Java.Resource.name";
    static final /* synthetic */ boolean $assertionsDisabled;

    public ResourceClassImpl(StorableClass s) {
        super(s);
    }

    public Resource createResource(String name, long timestamp, List classifiers, List imports, String packageName, MultipartId packageIdentifier, List packageAnnotations) {
        if (!$assertionsDisabled && name.startsWith("/")) {
            throw new AssertionError((Object)"Resource name cannot start with /");
        }
        if (this.resolveResource(name, false) == null) {
            FileObject f = this.createFile(name);
            ResourceImpl r = (ResourceImpl)this.super_createResource(name, timestamp, null, null, null, null, null);
            r.setFileToDeleteOnRollback(f);
            r._setPackageName(packageName);
            r.objectChanged(512);
            r.getClassifiers().addAll(classifiers);
            r.getImports().addAll(imports);
            return r;
        }
        throw new ConstraintViolationException((Object)this, this.refMetaObject(), "Resource named " + name + " already exists.");
    }

    private FileObject createFile(String name) {
        FileObject currentFolder = ((JMManager)JavaMetamodel.getManager()).getCPRoot((JavaModelPackage)this.refImmediatePackage());
        StringTokenizer folderNames = new StringTokenizer(name, "/");
        FileObject fileToDelete = null;
        while (folderNames.hasMoreTokens()) {
            String newFolderName = folderNames.nextToken();
            if (folderNames.hasMoreTokens()) {
                FileObject newFolder = currentFolder.getFileObject(newFolderName);
                if (newFolder == null) {
                    try {
                        newFolder = currentFolder.createFolder(newFolderName);
                        if (fileToDelete == null) {
                            fileToDelete = newFolder;
                        }
                    }
                    catch (IOException ioe) {
                        ErrorManager.getDefault().notify((Throwable)ioe);
                    }
                }
                currentFolder = newFolder;
                continue;
            }
            try {
                FileObject f = currentFolder.createData(newFolderName);
                if (fileToDelete != null) continue;
                fileToDelete = f;
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().notify((Throwable)ioe);
            }
        }
        return fileToDelete;
    }

    public Resource resolveResource(String name, boolean create, boolean createFile) {
        Iterator it;
        if (name == null || !name.endsWith(".java") && !name.endsWith(".class")) {
            return null;
        }
        StorableFeatured storable = (StorableFeatured)this._getDelegate();
        MOFID packageID = storable.getOutermostPackageId();
        Collection items = storable.getMdrStorage().getObjectsFromAdditionalIndex(packageID, NAME_INDEX, (Object)name);
        Resource res = null;
        if (items != null && (it = items.iterator()).hasNext()) {
            StorableBaseObject sbo = (StorableBaseObject)it.next();
            if (it.hasNext()) {
                ErrorManager.getDefault().log("Multiple Resource instances for " + name);
            }
            Resource resource = res = (res = (Resource)this._getRepository().getHandler(sbo)) != null && res.isValid() ? res : null;
        }
        if (res == null && create) {
            if (!$assertionsDisabled && name.startsWith("/")) {
                throw new AssertionError((Object)"Resource name cannot start with /");
            }
            if (createFile) {
                this.createFile(name);
            }
            return this.super_createResource(name, 0L, null, null, null, null, null);
        }
        return res;
    }

    public Resource resolveResource(String name, boolean create) {
        return this.resolveResource(name, create, true);
    }

    public Resource createResource() {
        ResourceImpl ret = (ResourceImpl)this.super_createResource();
        ret.setNew();
        ret.setData();
        return ret;
    }

    protected abstract Resource super_createResource(String var1, long var2, List var4, List var5, String var6, MultipartId var7, List var8);

    protected abstract Resource super_createResource();

    static {
        $assertionsDisabled = !ResourceClassImpl.class.desiredAssertionStatus();
    }
}

