/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.java;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.ListCellRenderer;
import org.netbeans.editor.ext.Completion;
import org.netbeans.editor.ext.CompletionQuery;
import org.netbeans.editor.ext.CompletionView;
import org.netbeans.editor.ext.ExtEditorUI;
import org.netbeans.editor.ext.ListCompletionView;
import org.netbeans.editor.ext.java.JCCellRenderer;
import org.netbeans.editor.ext.java.JCClass;
import org.netbeans.editor.ext.java.JCClassProvider;
import org.netbeans.editor.ext.java.JCClassProvider2;
import org.netbeans.editor.ext.java.JCConstructor;
import org.netbeans.editor.ext.java.JCField;
import org.netbeans.editor.ext.java.JCFinder;
import org.netbeans.editor.ext.java.JCMethod;
import org.netbeans.editor.ext.java.JCPackage;
import org.netbeans.editor.ext.java.JCParameter;
import org.netbeans.editor.ext.java.JCType;
import org.netbeans.editor.ext.java.JavaTokenContext;

public abstract class JavaCompletion
extends Completion {
    public static final int PUBLIC_LEVEL = 3;
    public static final int PROTECTED_LEVEL = 2;
    public static final int PACKAGE_LEVEL = 1;
    public static final int PRIVATE_LEVEL = 0;
    public static final SimpleClass BOOLEAN_CLASS;
    public static final SimpleClass BYTE_CLASS;
    public static final SimpleClass CHAR_CLASS;
    public static final SimpleClass DOUBLE_CLASS;
    public static final SimpleClass FLOAT_CLASS;
    public static final SimpleClass INT_CLASS;
    public static final SimpleClass LONG_CLASS;
    public static final SimpleClass SHORT_CLASS;
    public static final SimpleClass VOID_CLASS;
    public static final BaseType BOOLEAN_TYPE;
    public static final BaseType BYTE_TYPE;
    public static final BaseType CHAR_TYPE;
    public static final BaseType DOUBLE_TYPE;
    public static final BaseType FLOAT_TYPE;
    public static final BaseType INT_TYPE;
    public static final BaseType LONG_TYPE;
    public static final BaseType SHORT_TYPE;
    public static final BaseType VOID_TYPE;
    public static final SimpleClass INVALID_CLASS;
    public static final BaseType INVALID_TYPE;
    public static final SimpleClass NULL_CLASS;
    public static final BaseType NULL_TYPE;
    public static final SimpleClass OBJECT_CLASS_ARRAY;
    public static final BaseType OBJECT_TYPE_ARRAY;
    public static final SimpleClass OBJECT_CLASS;
    public static final BaseType OBJECT_TYPE;
    public static final SimpleClass CLASS_CLASS;
    public static final BaseType CLASS_TYPE;
    public static final SimpleClass STRING_CLASS;
    public static final BaseType STRING_TYPE;
    static final int INTERFACE_BIT = 0x40000000;
    public static final int LOCAL_MEMBER_BIT = 0x20000000;
    public static final int DEPRECATED_BIT = 0x100000;
    private static final HashMap str2PrimitiveClass;
    private static final HashMap str2PrimitiveType;
    private static final HashMap str2PredefinedType;
    public static final JCParameter[] EMPTY_PARAMETERS;
    public static final JCClass[] EMPTY_CLASSES;
    public static final JCPackage[] EMPTY_PACKAGES;
    public static final JCField[] EMPTY_FIELDS;
    public static final JCConstructor[] EMPTY_CONSTRUCTORS;
    public static final JCMethod[] EMPTY_METHODS;
    private static JCFinder finder;
    private static int debugMode;
    private static HashMap classCache;
    private static HashMap typeCache;
    public static final int DEBUG_EXP = 1;
    public static final int DEBUG_FIND = 2;
    private static JCFinderInitializer initializer;

    public static synchronized JCFinder getFinder() {
        if (finder == null) {
            if (initializer == null) {
                throw new IllegalStateException("Editor: Java completion can't be initialized.");
            }
            initializer.initJCFinder();
        }
        return finder;
    }

    public static synchronized void setFinder(JCFinder f) {
        finder = f;
    }

    public static void setFinderInitializer(JCFinderInitializer initializer) {
        JavaCompletion.initializer = initializer;
    }

    public JavaCompletion(ExtEditorUI extEditorUI) {
        super(extEditorUI);
    }

    protected CompletionView createView() {
        return new ListCompletionView((ListCellRenderer)new JCCellRenderer());
    }

    protected abstract CompletionQuery createQuery();

    public static int getLevel(int modifiers) {
        if ((modifiers & 1) != 0) {
            return 3;
        }
        if ((modifiers & 4) != 0) {
            return 2;
        }
        if ((modifiers & 2) == 0) {
            return 1;
        }
        return 0;
    }

    public static boolean isPrimitiveClassName(String s) {
        return JavaTokenContext.isTypeOrVoid(s);
    }

    public static boolean isPrimitiveClass(JCClass c) {
        return c.getPackageName().length() == 0 && JavaCompletion.isPrimitiveClassName(c.getName());
    }

    public static JCClass getPrimitiveClass(String s) {
        return (JCClass)str2PrimitiveClass.get(s);
    }

    public static JCType getPrimitiveType(String s) {
        return (JCType)str2PrimitiveType.get(s);
    }

    public static JCType getPredefinedType(String s) {
        JCType ret = JavaCompletion.getPrimitiveType(s);
        if (ret == null) {
            ret = (JCType)str2PredefinedType.get(s);
        }
        return ret;
    }

    public static Iterator getPrimitiveClassIterator() {
        return str2PrimitiveClass.values().iterator();
    }

    public static JCClass getSimpleClass(String fullClassName, int packageNameLen) {
        JCClass cls = (JCClass)classCache.get(fullClassName);
        if (cls == null || packageNameLen != cls.getPackageName().length()) {
            cls = new SimpleClass(fullClassName, packageNameLen, true);
            classCache.put(fullClassName, cls);
        }
        return cls;
    }

    public static JCClass getSimpleClass(JCClass cls) {
        return JavaCompletion.getSimpleClass(cls.getFullName(), cls.getPackageName().length());
    }

    public static JCClass createSimpleClass(String fullClassName) {
        int nameInd = fullClassName.lastIndexOf(46) + 1;
        return JavaCompletion.createSimpleClass(fullClassName.substring(nameInd), nameInd > 0 ? fullClassName.substring(0, nameInd - 1) : "");
    }

    public static JCClass createSimpleClass(String name, String packageName) {
        return new SimpleClass(name, packageName);
    }

    public static JCType createType(JCClass cls, int arrayDepth) {
        return new BaseType(cls, arrayDepth);
    }

    public static JCType getType(JCClass cls, int arrayDepth) {
        if (cls == null) {
            return null;
        }
        JCType[] types = (JCType[])typeCache.get(cls);
        if (types != null) {
            if (arrayDepth < types.length) {
                if (types[arrayDepth] == null) {
                    types[arrayDepth] = new BaseType(types[0].getClazz(), arrayDepth);
                }
            } else {
                cls = types[0].getClazz();
                JCType[] tmp = new JCType[arrayDepth + 1];
                System.arraycopy(types, 0, tmp, 0, types.length);
                types = tmp;
                types[arrayDepth] = new BaseType(cls, arrayDepth);
                typeCache.put(cls, types);
            }
        } else {
            cls = JavaCompletion.getSimpleClass(cls.getFullName(), cls.getPackageName().length());
            if (arrayDepth > 0) {
                types = new JCType[arrayDepth + 1];
                types[arrayDepth] = new BaseType(cls, arrayDepth);
            } else {
                types = new JCType[2];
            }
            types[0] = new BaseType(cls, 0);
            typeCache.put(cls, types);
        }
        return types[arrayDepth];
    }

    public static int getDebugMode() {
        return debugMode;
    }

    public static void setDebugMode(int newDebugMode) {
        debugMode = newDebugMode;
    }

    static {
        String typeName;
        int i;
        BOOLEAN_CLASS = new SimpleClass("boolean", "");
        BYTE_CLASS = new SimpleClass("byte", "");
        CHAR_CLASS = new SimpleClass("char", "");
        DOUBLE_CLASS = new SimpleClass("double", "");
        FLOAT_CLASS = new SimpleClass("float", "");
        INT_CLASS = new SimpleClass("int", "");
        LONG_CLASS = new SimpleClass("long", "");
        SHORT_CLASS = new SimpleClass("short", "");
        VOID_CLASS = new SimpleClass("void", "");
        BOOLEAN_TYPE = new BaseType(BOOLEAN_CLASS, 0);
        BYTE_TYPE = new BaseType(BYTE_CLASS, 0);
        CHAR_TYPE = new BaseType(CHAR_CLASS, 0);
        DOUBLE_TYPE = new BaseType(DOUBLE_CLASS, 0);
        FLOAT_TYPE = new BaseType(FLOAT_CLASS, 0);
        INT_TYPE = new BaseType(INT_CLASS, 0);
        LONG_TYPE = new BaseType(LONG_CLASS, 0);
        SHORT_TYPE = new BaseType(SHORT_CLASS, 0);
        VOID_TYPE = new BaseType(VOID_CLASS, 0);
        INVALID_CLASS = new SimpleClass("", "");
        INVALID_TYPE = new BaseType(INVALID_CLASS, 0);
        NULL_CLASS = new SimpleClass("null", "");
        NULL_TYPE = new BaseType(NULL_CLASS, 0);
        OBJECT_CLASS_ARRAY = new SimpleClass("java.lang.Object[]", "java.lang".length(), true);
        OBJECT_TYPE_ARRAY = new BaseType(OBJECT_CLASS_ARRAY, 0);
        OBJECT_CLASS = new SimpleClass("java.lang.Object", "java.lang".length(), true);
        OBJECT_TYPE = new BaseType(OBJECT_CLASS, 0);
        CLASS_CLASS = new SimpleClass("java.lang.Class", "java.lang".length(), true);
        CLASS_TYPE = new BaseType(CLASS_CLASS, 0);
        STRING_CLASS = new SimpleClass("java.lang.String", "java.lang".length(), true);
        STRING_TYPE = new BaseType(STRING_CLASS, 0);
        str2PrimitiveClass = new HashMap();
        str2PrimitiveType = new HashMap();
        str2PredefinedType = new HashMap();
        BaseType[] types = new BaseType[]{BOOLEAN_TYPE, BYTE_TYPE, CHAR_TYPE, DOUBLE_TYPE, FLOAT_TYPE, INT_TYPE, LONG_TYPE, SHORT_TYPE, VOID_TYPE};
        for (i = types.length - 1; i >= 0; --i) {
            typeName = types[i].getClazz().getName();
            str2PrimitiveClass.put(typeName, types[i].getClazz());
            str2PrimitiveType.put(typeName, types[i]);
        }
        types = new BaseType[]{NULL_TYPE, OBJECT_TYPE_ARRAY, OBJECT_TYPE, CLASS_TYPE, STRING_TYPE};
        for (i = types.length - 1; i >= 0; --i) {
            typeName = types[i].getClazz().getName();
            str2PredefinedType.put(typeName, types[i]);
            str2PredefinedType.put(types[i].getClazz().getFullName(), types[i]);
        }
        EMPTY_PARAMETERS = new JCParameter[0];
        EMPTY_CLASSES = new JCClass[0];
        EMPTY_PACKAGES = new JCPackage[0];
        EMPTY_FIELDS = new JCField[0];
        EMPTY_CONSTRUCTORS = new JCConstructor[0];
        EMPTY_METHODS = new JCMethod[0];
        classCache = new HashMap(5003);
        typeCache = new HashMap(5003);
    }

    public static interface JCFinderInitializer {
        public void initJCFinder();
    }

    public static class SingleProvider
    extends AbstractProvider
    implements Iterator {
        JCClass c;
        boolean next = true;

        public SingleProvider(JCClass c) {
            this.c = c;
        }

        public Iterator getClasses() {
            if (this.next) {
                return this;
            }
            throw new IllegalStateException();
        }

        public boolean hasNext() {
            return this.next;
        }

        public Object next() {
            this.next = false;
            return this.c;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class ListProvider
    extends AbstractProvider {
        private List classList;

        public ListProvider() {
            this.classList = new ArrayList();
        }

        public ListProvider(List classList) {
            this.classList = classList;
        }

        protected boolean appendClass(JCClass c) {
            this.classList.add(c);
            return true;
        }

        public Iterator getClasses() {
            return this.classList.iterator();
        }

        public int getClassCount() {
            return this.classList.size();
        }
    }

    public static abstract class AbstractProvider
    implements JCClassProvider2 {
        public abstract Iterator getClasses();

        public boolean remove(JCClassProvider cp) {
            Iterator i = cp.getClasses();
            while (i.hasNext()) {
                JCClass c = (JCClass)i.next();
                if (!cp.notifyAppend(c, false)) {
                    return false;
                }
                if (!this.removeClass(c)) {
                    return false;
                }
                if (cp.notifyAppend(c, true)) continue;
                return false;
            }
            return true;
        }

        public boolean append(JCClassProvider cp) {
            Iterator i = cp.getClasses();
            while (i.hasNext()) {
                JCClass c = (JCClass)i.next();
                if (!cp.notifyAppend(c, false)) {
                    return false;
                }
                if (!this.appendClass(c)) {
                    return false;
                }
                if (cp.notifyAppend(c, true)) continue;
                return false;
            }
            return true;
        }

        protected boolean appendClass(JCClass c) {
            return true;
        }

        protected boolean removeClass(JCClass c) {
            return true;
        }

        public void reset() {
        }

        public boolean notifyAppend(JCClass c, boolean appendFinished) {
            return true;
        }
    }

    public static class BaseMethod
    extends BaseConstructor
    implements JCMethod {
        protected String name;
        protected JCType returnType;

        public BaseMethod(JCClass clazz, String name, int modifiers, JCType returnType, JCParameter[] parameters, JCClass[] exceptions) {
            super(clazz, modifiers, parameters, exceptions);
            this.name = name;
            this.returnType = returnType;
        }

        BaseMethod() {
        }

        public String getName() {
            return this.name;
        }

        public JCType getReturnType() {
            return this.returnType;
        }

        public int compareTo(Object o) {
            if (this == o) {
                return 0;
            }
            JCMethod m = (JCMethod)o;
            int order = this.name.compareTo(m.getName());
            if (order == 0) {
                order = super.compareTo(o);
            }
            return order;
        }

        public int hashCode() {
            return this.name.hashCode() ^ super.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof JCMethod) {
                return this.compareTo(o) == 0;
            }
            return false;
        }

        public String toString() {
            String rtn = this.getReturnType().toString();
            return this.toString(rtn.length() > 0 ? rtn + ' ' : "", this.name);
        }
    }

    public static class BaseConstructor
    implements JCConstructor {
        protected JCClass clazz;
        protected int tagOffset;
        protected int modifiers;
        protected JCParameter[] parameters;
        protected JCClass[] exceptions;

        public BaseConstructor(JCClass clazz, int modifiers, JCParameter[] parameters, JCClass[] exceptions) {
            this.clazz = clazz;
            this.modifiers = modifiers;
            this.parameters = parameters;
            this.exceptions = exceptions;
        }

        BaseConstructor() {
        }

        public JCClass getClazz() {
            return this.clazz;
        }

        public int getTagOffset() {
            return this.tagOffset;
        }

        public int getModifiers() {
            return this.modifiers;
        }

        public JCParameter[] getParameters() {
            return this.parameters;
        }

        public JCClass[] getExceptions() {
            return this.exceptions;
        }

        public int compareTo(Object o) {
            if (this == o) {
                return 0;
            }
            JCConstructor c = (JCConstructor)o;
            int order = 0;
            JCParameter[] mp = c.getParameters();
            int commonCnt = Math.min(this.parameters.length, mp.length);
            for (int i = 0; i < commonCnt; ++i) {
                order = this.parameters[i].compareTo(mp[i]);
                if (order == 0) continue;
                return order;
            }
            order = this.parameters.length - mp.length;
            return order;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof JCConstructor) {
                return this.compareTo(o) == 0;
            }
            return false;
        }

        public int hashCode() {
            int h = 0;
            for (int i = 0; i < this.parameters.length; ++i) {
                h ^= this.parameters[i].hashCode();
            }
            return h;
        }

        String toString(String returnTypeName, String methodName) {
            int i;
            StringBuffer sb = new StringBuffer(Modifier.toString(this.modifiers));
            sb.append(' ');
            sb.append(returnTypeName);
            sb.append(methodName);
            sb.append('(');
            int cntM1 = this.parameters.length - 1;
            for (i = 0; i <= cntM1; ++i) {
                sb.append(this.parameters[i].toString());
                if (i >= cntM1) continue;
                sb.append(", ");
            }
            sb.append(')');
            cntM1 = this.exceptions.length - 1;
            if (cntM1 >= 0) {
                sb.append(" throws ");
                for (i = 0; i <= cntM1; ++i) {
                    sb.append(this.exceptions[i].toString());
                    if (i >= cntM1) continue;
                    sb.append(", ");
                }
            }
            return sb.toString();
        }

        public String toString() {
            return this.toString("", this.getClazz().getName());
        }
    }

    public static class BaseField
    extends BaseParameter
    implements JCField {
        protected JCClass clazz;
        protected int modifiers;
        protected int tagOffset;

        public BaseField(JCClass clazz, String name, JCType type, int modifiers) {
            super(name, type);
            this.clazz = clazz;
            this.modifiers = modifiers;
        }

        BaseField() {
        }

        public int getModifiers() {
            return this.modifiers;
        }

        public JCClass getClazz() {
            return this.clazz;
        }

        public int getTagOffset() {
            return this.tagOffset;
        }

        public int compareTo(Object o) {
            if (this == o) {
                return 0;
            }
            JCField f = (JCField)o;
            int order = super.compareTo(o);
            if (order == 0) {
                order = this.name.compareTo(f.getName());
            }
            return order;
        }

        public int hashCode() {
            return this.type.hashCode() ^ this.name.hashCode() ^ this.modifiers;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof JCField) {
                JCField p = (JCField)o;
                return this.name.equals(p.getName()) && this.type.equals(p.getType());
            }
            return false;
        }

        public String toString() {
            return Modifier.toString(this.modifiers) + ' ' + super.toString();
        }
    }

    public static class BaseParameter
    implements JCParameter {
        protected String name;
        protected JCType type;

        public BaseParameter(String name, JCType type) {
            this.name = name;
            this.type = type;
        }

        BaseParameter() {
        }

        public String getName() {
            return this.name;
        }

        public JCType getType() {
            return this.type;
        }

        public int compareTo(Object o) {
            if (this == o) {
                return 0;
            }
            JCParameter p = (JCParameter)o;
            return this.type.compareTo(p.getType());
        }

        public int hashCode() {
            return this.type.hashCode() ^ this.name.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof JCParameter) {
                JCParameter p = (JCParameter)o;
                return this.type.equals(p.getType());
            }
            return false;
        }

        public String toString() {
            return this.type.toString() + ' ' + this.name;
        }
    }

    public static class BaseType
    implements JCType {
        protected JCClass clazz;
        protected int arrayDepth;

        public BaseType(JCClass clazz, int arrayDepth) {
            this.clazz = clazz;
            this.arrayDepth = arrayDepth;
            if (arrayDepth < 0) {
                throw new IllegalArgumentException("Array depth " + arrayDepth + " < 0.");
            }
        }

        BaseType() {
        }

        public JCClass getClazz() {
            return this.clazz;
        }

        public int getArrayDepth() {
            return this.arrayDepth;
        }

        public String format(boolean useFullName) {
            StringBuffer sb = new StringBuffer(useFullName ? this.getClazz().getFullName() : this.getClazz().getName());
            for (int ad = this.arrayDepth; ad > 0; --ad) {
                sb.append("[]");
            }
            return sb.toString();
        }

        public int compareTo(Object o) {
            if (this == o) {
                return 0;
            }
            JCType t = (JCType)o;
            int order = this.clazz.compareTo(t.getClazz());
            if (order == 0) {
                order = this.arrayDepth - t.getArrayDepth();
            }
            return order;
        }

        public int hashCode() {
            return this.clazz.hashCode() + this.arrayDepth;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof JCType) {
                JCType t = (JCType)o;
                return this.clazz.equals(t.getClazz()) && this.arrayDepth == t.getArrayDepth();
            }
            return false;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(this.clazz.toString());
            for (int ad = this.arrayDepth; ad > 0; --ad) {
                sb.append("[]");
            }
            return sb.toString();
        }
    }

    public static abstract class AbstractClass
    extends SimpleClass {
        protected int modifiers;
        protected Body body;

        public AbstractClass(String name, String packageName, boolean iface, int modifiers) {
            super(name, packageName);
            this.modifiers = modifiers;
            if (iface) {
                this.modifiers |= 0x200;
            }
        }

        public AbstractClass(String name, String packageName, boolean iface, boolean deprecated, int modifiers) {
            super(name, packageName);
            this.modifiers = modifiers;
            if (iface) {
                this.modifiers |= 0x200;
            }
            if (deprecated) {
                this.modifiers |= 0x100000;
            }
        }

        AbstractClass() {
        }

        protected abstract void init();

        public boolean isInterface() {
            return (this.modifiers & 0x200) != 0 || (this.modifiers & 0x40000000) != 0;
        }

        public int getModifiers() {
            return this.modifiers;
        }

        public synchronized int getTagOffset() {
            if (this.body == null) {
                this.init();
            }
            return this.body.tagOffset;
        }

        public synchronized JCClass getSuperclass() {
            if (this.body == null) {
                this.init();
            }
            return this.body.superClass;
        }

        public synchronized JCClass[] getInterfaces() {
            if (this.body == null) {
                this.init();
            }
            return this.body.interfaces;
        }

        public synchronized JCField[] getFields() {
            if (this.body == null) {
                this.init();
            }
            return this.body.fields;
        }

        public synchronized JCConstructor[] getConstructors() {
            if (this.body == null) {
                this.init();
            }
            return this.body.constructors;
        }

        public synchronized JCMethod[] getMethods() {
            if (this.body == null) {
                this.init();
            }
            return this.body.methods;
        }

        public static class Body {
            public int tagOffset;
            public JCClass superClass;
            public JCClass[] interfaces;
            public JCField[] fields;
            public JCConstructor[] constructors;
            public JCMethod[] methods;
        }
    }

    public static class SimpleClass
    implements JCClass {
        protected String name;
        protected String packageName;
        protected String fullName;
        private String stringValue;

        public SimpleClass(String name, String packageName) {
            this.name = name;
            this.packageName = packageName;
            if (name == null || packageName == null) {
                throw new NullPointerException("className=" + name + ", packageName=" + packageName);
            }
        }

        public SimpleClass(String fullName, int packageNameLen, boolean intern) {
            this.fullName = fullName;
            if (packageNameLen <= 0 || packageNameLen >= fullName.length()) {
                this.name = fullName;
                this.packageName = "";
            } else {
                this.name = fullName.substring(packageNameLen + 1);
                this.packageName = fullName.substring(0, packageNameLen);
                if (intern) {
                    this.name = this.name.intern();
                    this.packageName = this.packageName.intern();
                }
            }
        }

        SimpleClass() {
        }

        public final String getName() {
            return this.name;
        }

        public final String getPackageName() {
            return this.packageName;
        }

        public String getFullName() {
            if (this.fullName == null) {
                this.fullName = this.packageName.length() > 0 ? this.packageName + "." + this.name : this.name;
            }
            return this.fullName;
        }

        public int getTagOffset() {
            return -1;
        }

        public boolean isInterface() {
            return false;
        }

        public int getModifiers() {
            return 0;
        }

        public JCClass getSuperclass() {
            return null;
        }

        public JCClass[] getInterfaces() {
            return EMPTY_CLASSES;
        }

        public JCField[] getFields() {
            return EMPTY_FIELDS;
        }

        public JCConstructor[] getConstructors() {
            return EMPTY_CONSTRUCTORS;
        }

        public JCMethod[] getMethods() {
            return EMPTY_METHODS;
        }

        public int compareTo(Object o) {
            if (this == o) {
                return 0;
            }
            JCClass c = (JCClass)o;
            int order = this.packageName.compareTo(c.getPackageName());
            if (order == 0) {
                order = this.name.compareTo(c.getName());
            }
            return order;
        }

        public int hashCode() {
            return this.name.hashCode() ^ this.packageName.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof JCClass) {
                JCClass c = (JCClass)o;
                String className = c.getName() == null ? null : c.getName().replace('.', '$');
                String thisName = this.name.replace('.', '$');
                return thisName.equals(className) && this.packageName.equals(c.getPackageName());
            }
            return false;
        }

        public String toString() {
            if (this.stringValue == null) {
                this.stringValue = this.getPackageName().length() > 0 ? this.getPackageName() + '.' + this.getName().replace('.', '$') : this.getName().replace('.', '$');
            }
            return this.stringValue;
        }
    }

    public static class BasePackage
    implements JCPackage {
        private String name;
        private JCClass[] classes;
        private int dotCnt = -1;
        private String lastName;

        public BasePackage(String name) {
            this(name, EMPTY_CLASSES);
        }

        public BasePackage(String name, JCClass[] classes) {
            this.name = name;
            this.classes = classes;
        }

        public final String getName() {
            return this.name;
        }

        public String getLastName() {
            if (this.lastName == null) {
                this.lastName = this.name.substring(this.name.lastIndexOf(46) + 1);
            }
            return this.lastName;
        }

        public JCClass[] getClasses() {
            return this.classes;
        }

        public void setClasses(JCClass[] classes) {
            this.classes = classes;
        }

        public int getDotCount() {
            if (this.dotCnt < 0) {
                int i = 0;
                do {
                    ++this.dotCnt;
                } while ((i = this.name.indexOf(46, i) + 1) > 0);
            }
            return this.dotCnt;
        }

        public int compareTo(Object o) {
            if (this == o) {
                return 0;
            }
            JCPackage p = (JCPackage)o;
            return this.name.compareTo(p.getName());
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof JCPackage) {
                return this.name.equals(((JCPackage)o).getName());
            }
            if (o instanceof String) {
                return this.name.equals((String)o);
            }
            return false;
        }

        public String toString() {
            return this.name;
        }
    }
}

