/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.java;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.DialogSupport;
import org.netbeans.editor.LocaleSupport;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtSettingsDefaults;
import org.netbeans.editor.ext.ListCompletionView;
import org.netbeans.editor.ext.java.JCCellRenderer;
import org.netbeans.editor.ext.java.JCClass;
import org.netbeans.editor.ext.java.JCResultItem;
import org.netbeans.editor.ext.java.JavaFastImportPanel;
import org.netbeans.editor.ext.java.JavaSyntaxSupport;

public abstract class JavaFastImport
implements ActionListener {
    public static final int IMPORT_CLASS = 0;
    public static final int IMPORT_PACKAGE = 1;
    public static final int IMPORT_FQN = 2;
    protected JTextComponent target;
    private String exp;
    private JavaFastImportPanel panel;
    private ListCellRenderer cellRenderer;
    private JList resultList;
    private Dialog dialog;
    private JButton[] buttons;
    private int[] block;
    private int importType;

    public JavaFastImport(JTextComponent target) {
        this.target = target;
        try {
            this.block = Utilities.getIdentifierBlock((JTextComponent)target, (int)target.getCaret().getDot());
            Document doc = target.getDocument();
            this.exp = this.block != null ? doc.getText(this.block[0], this.block[1] - this.block[0]) : null;
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
        this.importType = this.getPackageImportSetting();
        if (this.exp != null) {
            String untrimmedExp = this.exp;
            this.exp = this.exp.trim();
            int nLeadingSpaces = untrimmedExp.indexOf(this.exp);
            int nTrailingSpaces = untrimmedExp.length() - this.exp.length() - nLeadingSpaces;
            this.block[0] = this.block[0] + nLeadingSpaces;
            this.block[1] = this.block[1] - nTrailingSpaces;
        }
    }

    private int getPackageImportSetting() {
        Class kitClass = Utilities.getKitClass((JTextComponent)this.target);
        if (kitClass != null) {
            return SettingsUtil.getInteger((Class)kitClass, (String)"fast-import-selection", (Integer)ExtSettingsDefaults.defaultFastImportSelection);
        }
        return ExtSettingsDefaults.defaultFastImportSelection;
    }

    public void setDialogVisible(boolean visible) {
        List result = null;
        if (visible) {
            result = this.evaluate();
            if (result == null || result.size() == 0) {
                return;
            }
            this.populate(result);
        }
        if (this.dialog == null) {
            this.dialog = this.createDialog();
        }
        this.getResultList().requestFocus();
        this.dialog.setVisible(visible);
        if (visible) {
            this.getPanel().popupNotify();
        } else {
            this.dialog.dispose();
        }
    }

    protected boolean isAlreadyImported(JCClass cls) {
        BaseDocument doc = Utilities.getDocument((JTextComponent)this.target);
        if (doc == null) {
            return false;
        }
        JavaSyntaxSupport sup = (JavaSyntaxSupport)doc.getSyntaxSupport().get(JavaSyntaxSupport.class);
        if (sup == null) {
            return false;
        }
        sup.refreshJavaImport();
        return sup.isImported(cls);
    }

    protected void updateImport(Object item) {
    }

    protected ListCellRenderer createCellRenderer() {
        JCCellRenderer rr = new JCCellRenderer();
        return rr;
    }

    protected JList createResultList() {
        ListCompletionView list = new ListCompletionView(this.getCellRenderer());
        list.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    JavaFastImport.this.actionPerformed(new ActionEvent(JavaFastImport.this.getButtons()[0], 0, ""));
                }
            }
        });
        list.addListSelectionListener(new ListSelectionListener((JList)list){
            private final /* synthetic */ JList val$list;
            {
                this.val$list = jList;
            }

            public void valueChanged(ListSelectionEvent e) {
                JavaFastImport.this.getPanel().setPackageImportEnabled(!JavaFastImport.this.isInnerClass(this.val$list.getSelectedValue()));
            }
        });
        return list;
    }

    protected boolean isInnerClass(Object item) {
        return false;
    }

    private JButton[] getButtons() {
        if (this.buttons == null) {
            this.buttons = new JButton[]{new JButton(LocaleSupport.getString((String)"JFI_import", (String)"Import")), new JButton(LocaleSupport.getString((String)"JFI_cancelButton", (String)"Cancel"))};
            this.buttons[0].getAccessibleContext().setAccessibleDescription(LocaleSupport.getString((String)"ACSD_JFI_import"));
            this.buttons[1].getAccessibleContext().setAccessibleDescription(LocaleSupport.getString((String)"ACSD_JFI_cancelButton"));
        }
        return this.buttons;
    }

    private Dialog createDialog() {
        String title = LocaleSupport.getString((String)"JFI_title", (String)"Import Class");
        Dialog dialog = DialogSupport.createDialog((String)title, (JPanel)this.getPanel(), (boolean)true, (JButton[])this.getButtons(), (boolean)false, (int)0, (int)1, (ActionListener)this);
        dialog.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent evt) {
                Utilities.returnFocus();
            }
        });
        return dialog;
    }

    private JavaFastImportPanel getPanel() {
        if (this.panel == null) {
            this.panel = new JavaFastImportPanel(this, this.importType);
        }
        return this.panel;
    }

    ListCellRenderer getCellRenderer() {
        if (this.cellRenderer == null) {
            this.cellRenderer = this.createCellRenderer();
        }
        return this.cellRenderer;
    }

    JList getResultList() {
        if (this.resultList == null) {
            this.resultList = this.createResultList();
        }
        return this.resultList;
    }

    protected abstract List findClasses(String var1, int var2);

    List evaluate() {
        return this.exp != null && this.exp.length() > 0 ? this.findClasses(this.exp, this.getPanel().getImportType()) : null;
    }

    void populate(List result) {
        if (result != null && this.getResultList() instanceof ListCompletionView) {
            ((ListCompletionView)this.getResultList()).setResult(result);
        }
    }

    protected void setFastImportSettings(int importType) {
    }

    protected String getItemFQN(Object item) {
        if (item instanceof JCClass) {
            return ((JCClass)item).getFullName();
        }
        if (item instanceof JCResultItem) {
            return ((JCResultItem)item).getItemText();
        }
        return item.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pasteFQN(String fqn) {
        block8: {
            try {
                Document document = this.target.getDocument();
                if (document instanceof BaseDocument) {
                    BaseDocument doc = (BaseDocument)document;
                    try {
                        doc.atomicLock();
                        try {
                            doc.remove(this.block[0], this.block[1] - this.block[0]);
                            doc.insertString(this.block[0], fqn, null);
                            this.target.getCaret().setDot(this.block[0] + fqn.length());
                            break block8;
                        }
                        finally {
                            doc.atomicUnlock();
                        }
                    }
                    catch (BadLocationException ble) {}
                    break block8;
                }
                document.remove(this.block[0], this.block[1] - this.block[0]);
                document.insertString(this.block[0], fqn, null);
                this.target.getCaret().setDot(this.block[0] + fqn.length());
            }
            catch (BadLocationException ex) {
                throw new IllegalStateException();
            }
        }
    }

    public void actionPerformed(ActionEvent evt) {
        Object src = evt.getSource();
        if (this.buttons != null && src == this.buttons[0]) {
            int importType = this.getPanel().getImportType();
            switch (importType) {
                case 0: 
                case 1: {
                    int selIndex = this.getResultList().getSelectedIndex();
                    if (selIndex < 0) break;
                    this.updateImport(this.getResultList().getModel().getElementAt(selIndex));
                    break;
                }
                case 2: {
                    int selIndex = this.getResultList().getSelectedIndex();
                    if (selIndex < 0) {
                        return;
                    }
                    Object item = this.getResultList().getModel().getElementAt(selIndex);
                    String clsName = this.getItemFQN(item);
                    this.pasteFQN(clsName);
                }
            }
            this.setFastImportSettings(importType);
            this.setDialogVisible(false);
        } else if (this.buttons != null && src == this.buttons[this.buttons.length - 1]) {
            this.setDialogVisible(false);
        }
    }
}

