/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring;

import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.refactoring.CheckUtils;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImpl;
import org.openide.filesystems.FileObject;
import org.openide.text.PositionBounds;

public class JavadocElement
extends SimpleRefactoringElementImpl {
    ClassMember feature;
    int textoffset;
    String text;
    private String plainText;
    private PositionBounds bounds = null;
    private String htmlText;

    public JavadocElement(int offset, String txt, ClassMember f) {
        this.textoffset = offset;
        this.text = txt;
        this.feature = f;
        this.computeText();
    }

    public String getDisplayText() {
        return "/** " + this.htmlText;
    }

    public Element getJavaElement() {
        return this.feature;
    }

    public FileObject getParentFile() {
        return null;
    }

    public PositionBounds getPosition() {
        if (this.bounds == null) {
            this.bounds = JavaMetamodel.getManager().getElementPosition((Element)this.feature.getJavadoc());
        }
        return this.bounds;
    }

    public String getText() {
        return this.plainText;
    }

    public void performChange() {
    }

    private void computeText() {
        String commentText = this.feature.getJavadocText();
        int start = commentText.lastIndexOf(10, this.textoffset);
        int end = commentText.indexOf(10, this.textoffset);
        StringBuffer htmlBuffer = new StringBuffer();
        if (end == -1) {
            end = commentText.length();
        }
        htmlBuffer.append("<i>");
        htmlBuffer.append(CheckUtils.htmlize(commentText.substring(start + 1, this.textoffset)));
        htmlBuffer.append("<b>");
        htmlBuffer.append(commentText.substring(this.textoffset, this.textoffset + this.text.length()));
        htmlBuffer.append("</b>");
        htmlBuffer.append(CheckUtils.trimToEnd(CheckUtils.htmlize(commentText.substring(this.textoffset + this.text.length(), end))));
        htmlBuffer.append("</i>");
        this.htmlText = htmlBuffer.toString();
        this.plainText = commentText.substring(start + 1, end);
    }
}

