/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.api;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.EnumConstant;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.classpath.Util;

public final class EncapsulateFieldsRefactoring
extends AbstractRefactoring {
    private Element[] selectedObjects;
    private EncapsulateFieldInfo[] refactorFields;
    private int methodModifier;
    private int fieldModifier;
    private boolean alwaysUseAccessors;

    public EncapsulateFieldsRefactoring(Element[] selectedObjects) {
        this.selectedObjects = selectedObjects;
    }

    public Element[] getFields() {
        if (this.selectedObjects.length == 1 && this.selectedObjects[0] instanceof JavaClass) {
            ArrayList fields = new ArrayList();
            JavaClass encClass = (JavaClass)this.selectedObjects[0];
            List features = encClass.getFeatures();
            Iterator it = features.iterator();
            while (it.hasNext()) {
                Object o = it.next();
                if (!(o instanceof Field) || o instanceof EnumConstant) continue;
                fields.add(o);
            }
            return fields.toArray(new Field[fields.size()]);
        }
        return this.selectedObjects;
    }

    protected void setClassPath() {
        Util.setClassPath(this.selectedObjects[0]);
    }

    public EncapsulateFieldInfo[] getRefactorFields() {
        return this.refactorFields;
    }

    public int getMethodModifier() {
        return this.methodModifier;
    }

    public int getFieldModifier() {
        return this.fieldModifier;
    }

    public boolean isAlwaysUseAccessors() {
        return this.alwaysUseAccessors;
    }

    public void setRefactorFields(EncapsulateFieldInfo[] refactorFields) {
        this.refactorFields = refactorFields;
    }

    public void setMethodModifier(int methodModifier) {
        this.methodModifier = methodModifier;
    }

    public void setFieldModifier(int fieldModifier) {
        this.fieldModifier = fieldModifier;
    }

    public void setAlwaysUseAccessors(boolean alwaysUseAccessors) {
        this.alwaysUseAccessors = alwaysUseAccessors;
    }

    public Element[] getSelectedObjects() {
        return this.selectedObjects;
    }

    public static final class EncapsulateFieldInfo {
        Field field;
        String getterName;
        String setterName;

        public EncapsulateFieldInfo(Field field, String getterName, String setterName) {
            this.field = field;
            this.getterName = getterName;
            this.setterName = setterName;
        }

        public String getGetterName() {
            return this.getterName;
        }

        public String getSetterName() {
            return this.setterName;
        }

        public Field getField() {
            return this.field;
        }
    }
}

