/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.plugins;

import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.jmi.reflect.RefFeatured;
import javax.jmi.reflect.RefObject;
import org.netbeans.jmi.javamodel.CallableFeature;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.ElementPartKind;
import org.netbeans.jmi.javamodel.ElementPartKindEnum;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Invocation;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.StatementBlock;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.internalapi.JavaModelUtil;
import org.netbeans.modules.javacore.internalapi.ProgressEvent;
import org.netbeans.modules.javacore.internalapi.ProgressListener;
import org.netbeans.modules.javacore.jmiimpl.javamodel.CallableFeatureImpl;
import org.netbeans.modules.refactoring.CheckUtils;
import org.netbeans.modules.refactoring.api.ChangeParametersRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.plugins.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImpl;
import org.openide.filesystems.FileObject;
import org.openide.text.PositionBounds;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class ChangeParametersPlugin
extends JavaRefactoringPlugin
implements ProgressListener {
    RefObject selectedObject;
    CallableFeature method;
    ChangeParametersRefactoring.ParameterInfo[] paramTable;
    int modifier;
    private ChangeParametersRefactoring refactoring;

    public ChangeParametersPlugin(ChangeParametersRefactoring refactoring) {
        this.refactoring = refactoring;
        this.selectedObject = (RefObject)refactoring.getRefactoredObject();
    }

    public Problem checkParameters() {
        return this.setParameters(this.refactoring.getParameterInfo(), this.refactoring.getModifiers());
    }

    public Problem fastCheckParameters() {
        return this.checkParameters(this.refactoring.getParameterInfo(), this.refactoring.getModifiers());
    }

    public Problem preCheck() {
        String msg;
        Iterator iter;
        Problem result = ChangeParametersPlugin.isElementAvail((Element)this.selectedObject);
        if (result != null) {
            return result;
        }
        if (!(this.selectedObject instanceof CallableFeature)) {
            return ChangeParametersPlugin.createProblem(result, true, NbBundle.getMessage((Class)ChangeParametersRefactoring.class, (String)"ERR_ChangeParamsWrongType"));
        }
        if (CheckUtils.isFromLibrary(((CallableFeature)this.selectedObject).getResource())) {
            return ChangeParametersPlugin.createProblem(result, true, ChangeParametersPlugin.getCannotRefactor(((Element)this.selectedObject).getResource()));
        }
        if (!CheckUtils.isElementInOpenProject((Element)this.selectedObject)) {
            return new Problem(true, NbBundle.getMessage((Class)JavaRefactoringPlugin.class, (String)"ERR_ProjectNotOpened"));
        }
        Collection overridesMethod = null;
        Collection overridenMethod = null;
        this.method = (CallableFeature)this.selectedObject;
        List pars = this.method.getParameters();
        ArrayList<Type> typeList = new ArrayList<Type>();
        Iterator parIt = pars.iterator();
        while (parIt.hasNext()) {
            Parameter par = (Parameter)parIt.next();
            typeList.add(par.getType());
        }
        if (this.method instanceof Method) {
            overridesMethod = CheckUtils.overrides((Method)this.method, this.method.getName(), typeList, true);
            overridenMethod = CheckUtils.isOverridden((Method)this.method, this.method.getName(), typeList);
        }
        if (CheckUtils.hasVarArgs(this.method)) {
            String msg2 = ChangeParametersPlugin.getString("ERR_HasVarArg");
            result = ChangeParametersPlugin.createProblem(result, true, msg2);
        }
        if (overridesMethod != null) {
            iter = overridesMethod.iterator();
            while (iter.hasNext()) {
                msg = new MessageFormat(ChangeParametersPlugin.getString("ERR_MethodOverrides")).format(new Object[]{this.getDefClassName(((Method)iter.next()).getDeclaringClass())});
                result = ChangeParametersPlugin.createProblem(result, false, msg);
            }
        }
        if (overridenMethod != null) {
            iter = overridenMethod.iterator();
            while (iter.hasNext()) {
                msg = new MessageFormat(ChangeParametersPlugin.getString("ERR_MethodIsOverridden")).format(new Object[]{this.getDefClassName(((Method)iter.next()).getDeclaringClass())});
                result = ChangeParametersPlugin.createProblem(result, false, msg);
            }
        }
        return result;
    }

    private static final String getCannotRefactor(Resource r) {
        return new MessageFormat(NbBundle.getMessage((Class)RenameRefactoring.class, (String)"ERR_CannotRefactorFile")).format(new Object[]{r.getName()});
    }

    private Problem checkParameters(ChangeParametersRefactoring.ParameterInfo[] aParamTable, int modifier) {
        ClassDefinition cd;
        if ((this.method.getModifiers() & modifier) == 0 && (cd = this.method.getDeclaringClass()) instanceof JavaClass && ((JavaClass)cd).isInterface()) {
            return new Problem(true, ChangeParametersPlugin.getString("ERR_CannotChangeModifiers"));
        }
        ChangeParametersRefactoring.ParameterInfo[] oldParamTable = this.paramTable;
        int oldModifier = this.modifier;
        this.paramTable = aParamTable;
        this.modifier = modifier;
        Problem emptyArgs = this.checkParameterAttributes();
        Problem result = null;
        HashSet<String> paramNames = new HashSet<String>(3);
        for (int i = 0; i < this.paramTable.length; ++i) {
            Type type = this.paramTable[i].getType();
            if (type != null && type.getName() != null && type.getName().endsWith("...")) {
                result = ChangeParametersPlugin.createProblem(result, true, ChangeParametersPlugin.getString("ERR_HasVarArg"));
            }
            String name = null;
            int orIdx = this.paramTable[i].getOriginalIndex();
            name = orIdx > -1 ? ((Parameter)this.method.getParameters().get(orIdx)).getName() : this.paramTable[i].getName();
            if (name != null && !Utilities.isJavaIdentifier((String)name)) {
                String msg = new MessageFormat(ChangeParametersPlugin.getString("ERR_InvalidIdentifier")).format(new Object[]{name});
                result = ChangeParametersPlugin.createProblem(result, true, msg);
            }
            if (name != null && !paramNames.add(name)) {
                result = ChangeParametersPlugin.createProblem(result, true, new MessageFormat(ChangeParametersPlugin.getString("ERR_DuplicateName")).format(new Object[]{name}));
            }
            if (orIdx != -1 || name == null || !CheckUtils.getAllVariableNames((Feature)this.method).contains(name)) continue;
            result = ChangeParametersPlugin.createProblem(result, true, new MessageFormat(ChangeParametersPlugin.getString("ERR_NameAlreadyUsed")).format(new Object[]{name}));
        }
        if (this.method instanceof Method) {
            Method duplicateMethod = this.methodClashes(this.paramTable);
            if (duplicateMethod != null && !this.method.equals(duplicateMethod)) {
                result = ChangeParametersPlugin.createProblem(result, true, new MessageFormat(ChangeParametersPlugin.getString("ERR_existingMethod")).format(new Object[]{duplicateMethod.getName(), this.getDefClassName(duplicateMethod.getDeclaringClass())}));
            }
        } else {
            Constructor duplicateConstr = this.constructorClashes(this.paramTable);
            if (duplicateConstr != null && !this.method.equals(duplicateConstr)) {
                result = ChangeParametersPlugin.createProblem(result, true, new MessageFormat(ChangeParametersPlugin.getString("ERR_existingConstr")).format(new Object[]{this.getDefClassName(duplicateConstr.getDeclaringClass())}));
            }
        }
        if (emptyArgs != null) {
            Problem toAdd = emptyArgs;
            while (toAdd.getNext() != null) {
                toAdd = toAdd.getNext();
            }
            toAdd.setNext(result);
            result = toAdd;
        }
        this.paramTable = oldParamTable;
        this.modifier = oldModifier;
        return result;
    }

    private Problem setParameters(ChangeParametersRefactoring.ParameterInfo[] aParamTable, int modifier) {
        this.paramTable = aParamTable;
        this.modifier = modifier;
        return this.checkParameters(aParamTable, modifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Problem prepare(RefactoringElementsBag elements) {
        JavaMetamodel.getManager().getProgressSupport().addProgressListener((ProgressListener)this);
        Problem problem = null;
        try {
            Problem problem2;
            int origAccessMods = this.method.getModifiers() & 7;
            boolean checkMod = ChangeParametersPlugin.compareModifiers(origAccessMods, this.modifier) == -1;
            this.referencesIterator = ((CallableFeatureImpl)this.method).findDependencies(true, true, true).iterator();
            elements.add(this.refactoring, new SignatureElement(this.method, this.paramTable, this.modifier));
            int parNum = ((CallableFeature)this.refactoring.getRefactoredObject()).getParameters().size();
            while (this.referencesIterator.hasNext()) {
                if (this.cancelRequest) {
                    problem2 = null;
                    return problem2;
                }
                Object ref = this.referencesIterator.next();
                if (ref instanceof Invocation) {
                    if (((Invocation)ref).getParameters().size() != parNum) continue;
                    if (problem == null && checkMod) {
                        String msg;
                        Feature f = JavaModelUtil.getDeclaringFeature((Element)((Invocation)ref));
                        if (Modifier.isPrivate(this.modifier)) {
                            if (!Utilities.compareObjects((Object)ChangeParametersPlugin.getOutermostClass(f), (Object)ChangeParametersPlugin.getOutermostClass((Feature)this.method))) {
                                msg = ChangeParametersPlugin.getString("ERR_StrongAccMod");
                                problem = new Problem(false, new MessageFormat(msg).format(new Object[]{"private"}));
                            }
                        } else if (Modifier.isProtected(this.modifier)) {
                            if (!this.method.getResource().getPackageName().equals(f.getResource().getPackageName())) {
                                msg = ChangeParametersPlugin.getString("ERR_StrongAccMod");
                                problem = new Problem(false, new MessageFormat(msg).format(new Object[]{"protected"}));
                            }
                        } else if (this.modifier == 0 && !f.getResource().getPackageName().equals(this.method.getResource().getPackageName())) {
                            msg = ChangeParametersPlugin.getString("ERR_StrongAccMod");
                            problem = new Problem(false, new MessageFormat(msg).format(new Object[]{"default"}));
                        }
                    }
                    elements.add(this.refactoring, new CallerElement((Invocation)ref, this.paramTable));
                    continue;
                }
                elements.add(this.refactoring, new SignatureElement((CallableFeature)ref, this.paramTable, this.modifier));
            }
            problem2 = problem;
            return problem2;
        }
        finally {
            this.referencesIterator = null;
            JavaMetamodel.getManager().getProgressSupport().removeProgressListener((ProgressListener)this);
        }
    }

    private Problem checkParameterAttributes() {
        Problem p = null;
        for (int i = 0; i < this.paramTable.length; ++i) {
            int origIndex = this.paramTable[i].getOriginalIndex();
            String s = this.paramTable[i].getName();
            if (origIndex == -1 && (s == null || s.length() < 1)) {
                p = ChangeParametersPlugin.createProblem(p, true, ChangeParametersPlugin.newParMessage("ERR_parname"));
            }
            Type t = this.paramTable[i].getType();
            if (origIndex == -1 && t == null) {
                p = ChangeParametersPlugin.createProblem(p, true, ChangeParametersPlugin.newParMessage("ERR_partype"));
            }
            s = this.paramTable[i].getDefaultValue();
            if (origIndex != -1 || s != null && s.length() >= 1) continue;
            p = ChangeParametersPlugin.createProblem(p, true, ChangeParametersPlugin.newParMessage("ERR_pardefv"));
        }
        return p;
    }

    private Method methodClashes(ChangeParametersRefactoring.ParameterInfo[] parInfo) {
        if (!(this.method instanceof Method)) {
            return null;
        }
        ArrayList<Type> paramTypes = new ArrayList<Type>(parInfo.length);
        List parameters = this.method.getParameters();
        for (int i = 0; i < parInfo.length; ++i) {
            Type t = parInfo[i].getType();
            if (t == null) {
                t = ((Parameter)parameters.get(parInfo[i].getOriginalIndex())).getType();
            }
            paramTypes.add(t);
        }
        return this.method.getDeclaringClass().getMethod(this.method.getName(), paramTypes, false);
    }

    private Constructor constructorClashes(ChangeParametersRefactoring.ParameterInfo[] parInfo) {
        if (!(this.method instanceof Constructor)) {
            return null;
        }
        ArrayList<Type> paramTypes = new ArrayList<Type>(parInfo.length);
        List parameters = this.method.getParameters();
        for (int i = 0; i < parInfo.length; ++i) {
            Type t = parInfo[i].getType();
            if (t == null) {
                t = ((Parameter)parameters.get(parInfo[i].getOriginalIndex())).getType();
            }
            paramTypes.add(t);
        }
        return this.method.getDeclaringClass().getConstructor(paramTypes, false);
    }

    private static String newParMessage(String par) {
        return new MessageFormat(ChangeParametersPlugin.getString("ERR_newpar")).format(new Object[]{ChangeParametersPlugin.getString(par)});
    }

    private static String getString(String key) {
        return NbBundle.getMessage((Class)ChangeParametersRefactoring.class, (String)key);
    }

    private String getDefClassName(ClassDefinition dc) {
        if (dc instanceof JavaClass) {
            return ((JavaClass)dc).getName();
        }
        return "";
    }

    private static int compareModifiers(int first, int second) {
        if (first == second) {
            return 0;
        }
        int[] mods = new int[]{first, second};
        for (int i = 0; i < 2; ++i) {
            mods[i] = Modifier.isPublic(mods[i]) ? 0 : (Modifier.isProtected(mods[i]) ? 1 : (Modifier.isPrivate(mods[i]) ? 3 : 2));
        }
        return mods[0] > mods[1] ? 1 : -1;
    }

    private static JavaClass getOutermostClass(Feature feature) {
        RefFeatured o = feature.refImmediateComposite();
        RefFeatured lastComposite = null;
        while (o != null && !(o instanceof Resource)) {
            lastComposite = o;
            o = ((RefObject)o).refImmediateComposite();
        }
        if (lastComposite instanceof JavaClass) {
            return (JavaClass)lastComposite;
        }
        return null;
    }

    public void start(ProgressEvent event) {
        this.fireProgressListenerStart(event.getOperationType(), event.getCount());
    }

    public void step(ProgressEvent event) {
        this.fireProgressListenerStep();
    }

    public void stop(ProgressEvent event) {
        this.fireProgressListenerStop();
    }

    static class SignatureElement
    extends SimpleRefactoringElementImpl {
        private PositionBounds bounds;
        private final CallableFeature element;
        private ChangeParametersRefactoring.ParameterInfo[] paramTable;
        private int modifier;
        private final String displayText;
        private final String text;

        public SignatureElement(CallableFeature element, ChangeParametersRefactoring.ParameterInfo[] paramTable, int modifier) {
            this.element = element;
            this.paramTable = paramTable;
            this.bounds = null;
            this.modifier = modifier;
            String decl = ChangeParametersPlugin.getString("LBL_chngsigdecl");
            Object[] args = new Object[2];
            String key = element instanceof Method ? "LBL_Method" : "LBL_Constructor";
            args[0] = ChangeParametersPlugin.getString(key);
            int b = element.getPartStartOffset((ElementPartKind)ElementPartKindEnum.HEADER);
            int e = element.getPartEndOffset((ElementPartKind)ElementPartKindEnum.HEADER);
            args[1] = element.getResource().getSourceText().substring(b, e);
            this.text = MessageFormat.format(decl, args);
            args[1] = "<b>" + args[1] + "</b>";
            this.displayText = MessageFormat.format(decl, args);
        }

        public String getText() {
            return this.text;
        }

        public String getDisplayText() {
            return this.displayText;
        }

        public void performChange() {
            List parameters = this.element.getParameters();
            Parameter[] origParameters = parameters.toArray(new Parameter[0]);
            int oldMod = this.element.getModifiers();
            if ((oldMod & this.modifier) == 0) {
                int newMod = oldMod & 0xFFFFFFF8 | this.modifier;
                this.element.setModifiers(newMod);
            }
            parameters.clear();
            JavaModelPackage modelPackage = (JavaModelPackage)this.getJavaElement().refImmediatePackage();
            for (int i = 0; i < this.paramTable.length; ++i) {
                ChangeParametersRefactoring.ParameterInfo parInfo = this.paramTable[i];
                int origIndex = parInfo.getOriginalIndex();
                Parameter parameter = null;
                if (origIndex == -1) {
                    parameter = modelPackage.getParameter().createParameter();
                    parameter.setName(parInfo.getName());
                    parameter.setType(parInfo.getType());
                } else {
                    parameter = origParameters[origIndex];
                    String val = parInfo.getName();
                    if (val != null) {
                        parameter.setName(val);
                    }
                    if ((val = parInfo.getType()) != null) {
                        parameter.setType((Type)val);
                    }
                }
                parameters.add(parameter);
            }
        }

        public void undoChange() {
            throw new UnsupportedOperationException();
        }

        public Element getJavaElement() {
            return this.element;
        }

        public PositionBounds getPosition() {
            if (this.bounds == null) {
                this.bounds = JavaMetamodel.getManager().getElementPosition((Element)this.element);
            }
            return this.bounds;
        }

        public FileObject getParentFile() {
            return null;
        }
    }

    static class CallerElement
    extends SimpleRefactoringElementImpl {
        private PositionBounds bounds;
        private final Invocation element;
        private ChangeParametersRefactoring.ParameterInfo[] paramTable;
        private final String text;
        private final String displayText;
        private List paramList = Collections.EMPTY_LIST;
        private RefObject comp = null;

        public CallerElement(Invocation element, ChangeParametersRefactoring.ParameterInfo[] paramTable) {
            this.element = element;
            this.paramTable = paramTable;
            this.bounds = null;
            Element disp = CallerElement.getDisplayElement((Element)element);
            int b = disp.getStartOffset();
            int e = disp.getEndOffset();
            int bb = element.getPartStartOffset((ElementPartKind)ElementPartKindEnum.NAME);
            int be = element.getEndOffset();
            String src = element.getResource().getSourceText();
            this.text = src.substring(b, e);
            this.displayText = src.substring(b, bb) + "<b>" + src.substring(bb, be) + "</b>" + src.substring(be, e);
        }

        public String getText() {
            return this.text;
        }

        public String getDisplayText() {
            return this.displayText;
        }

        public void performChange() {
            List parameters = this.element.getParameters();
            Element[] origParameters = parameters.toArray(new Element[0]);
            parameters.clear();
            for (int i = 0; i < this.paramTable.length; ++i) {
                Element par;
                ChangeParametersRefactoring.ParameterInfo parInfo = this.paramTable[i];
                int origIndex = parInfo.getOriginalIndex();
                if (origIndex == -1) {
                    JavaModelPackage jmp = (JavaModelPackage)this.getJavaElement().refImmediatePackage();
                    par = jmp.getMultipartId().createMultipartId(parInfo.getDefaultValue(), null, null);
                } else {
                    par = origParameters[origIndex];
                }
                parameters.add(par);
            }
        }

        public Element getJavaElement() {
            if (this.comp == null) {
                this.comp = this.element;
                while (!(this.comp instanceof Feature) && !(this.comp instanceof Resource)) {
                    this.comp = (RefObject)this.comp.refImmediateComposite();
                }
            }
            return (Element)this.comp;
        }

        public PositionBounds getPosition() {
            if (this.bounds == null) {
                this.bounds = JavaMetamodel.getManager().getElementPosition((Element)this.element);
            }
            return this.bounds;
        }

        private static Element getDisplayElement(Element obj) {
            Element result = obj;
            while (!(result instanceof Feature) && !(result.refImmediateComposite() instanceof StatementBlock)) {
                result = (Element)result.refImmediateComposite();
            }
            return result;
        }

        public FileObject getParentFile() {
            return null;
        }
    }
}

