/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.ui;

import java.io.IOException;
import java.text.MessageFormat;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.refactoring.CheckUtils;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.ui.RenameAction;
import org.netbeans.spi.java.project.support.ui.PackageRenameHandler;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class PackageRenameHandlerImpl
implements PackageRenameHandler {
    public void handleRename(Node node, String newName) {
        DataFolder dob = (DataFolder)node.getCookie(DataObject.class);
        FileObject fo = dob.getPrimaryFile();
        if (node.isLeaf()) {
            try {
                if (!CheckUtils.isValidPackageName(newName)) {
                    String msg = new MessageFormat(NbBundle.getMessage((Class)AbstractRefactoring.class, (String)"ERR_InvalidPackage")).format(new Object[]{newName});
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg, 1));
                    return;
                }
                FileUtil.createFolder((FileObject)((JMManager)JMManager.getManager()).getMergedClassPath().findOwnerRoot(fo), (String)newName.replace('.', '/'));
                while (dob.getChildren().length == 0 && dob.isDeleteAllowed()) {
                    DataFolder parent = dob.getFolder();
                    dob.delete();
                    dob = parent;
                }
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().notify((Throwable)ioe);
            }
            return;
        }
        RenameAction a = (RenameAction)RenameAction.findObject((Class)RenameAction.class, (boolean)true);
        a.performAction(fo, newName, true);
    }
}

