/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xsd;

import java.io.FileInputStream;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.api.xml.services.UserCatalog;
import org.netbeans.modules.xml.xsd.XSDContentHandler;
import org.netbeans.modules.xml.xsd.XSDGrammar;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XSDParser {
    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.err.println("Error: missing file parameter required or too many args");
        }
        FileInputStream fistr = new FileInputStream(args[0]);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        XMLReader reader = factory.newSAXParser().getXMLReader();
        XSDContentHandler handler = new XSDContentHandler(System.out);
        reader.setContentHandler(handler);
        reader.parse(new InputSource(fistr));
    }

    public XSDGrammar parse(InputSource in) {
        XSDContentHandler handler = new XSDContentHandler(System.out);
        try {
            EntityResolver res;
            SAXParserFactory factory = SAXParserFactory.newInstance();
            XMLReader reader = factory.newSAXParser().getXMLReader();
            UserCatalog catalog = UserCatalog.getDefault();
            EntityResolver entityResolver = res = catalog == null ? null : catalog.getEntityResolver();
            if (res != null) {
                reader.setEntityResolver(res);
            }
            reader.setContentHandler(handler);
            reader.parse(in);
            return handler.getGrammar();
        }
        catch (SAXException ex) {
            if (Boolean.getBoolean("netbeans.debug.xml") || Boolean.getBoolean("netbeans.debug.exceptions")) {
                ex.printStackTrace();
                if (ex.getException() instanceof RuntimeException) {
                    ex.getException().printStackTrace();
                }
            }
            return handler.getGrammar();
        }
        catch (IOException ex) {
            if (Boolean.getBoolean("netbeans.debug.xml")) {
                ex.printStackTrace();
            }
            return handler.getGrammar();
        }
        catch (ParserConfigurationException e) {
            if (Boolean.getBoolean("netbeans.debug.xml")) {
                e.printStackTrace();
            }
            return handler.getGrammar();
        }
    }
}

