/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.actions;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.netbeans.modules.form.actions.CustomizeEmptySpaceAction;
import org.netbeans.modules.form.layoutdesign.LayoutComponent;
import org.netbeans.modules.form.layoutdesign.LayoutInterval;
import org.netbeans.modules.form.layoutdesign.LayoutModel;
import org.netbeans.modules.form.layoutdesign.LayoutUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

class EmptySpaceCustomizer
extends JPanel {
    JComboBox leftSize = new JComboBox();
    JComboBox rightSize = new JComboBox();
    JComboBox topSize = new JComboBox();
    JComboBox bottomSize = new JComboBox();
    JCheckBox leftResizable = new JCheckBox();
    JCheckBox rightResizable = new JCheckBox();
    JCheckBox topResizable = new JCheckBox();
    JCheckBox bottomResizable = new JCheckBox();
    LayoutModel model;
    String compId;
    String padding;

    EmptySpaceCustomizer(LayoutModel model, String compId) {
        this.model = model;
        this.compId = compId;
        this.initComponents();
        LayoutComponent comp = model.getLayoutComponent(compId);
        this.initValues(comp, 0, 0, this.leftSize, this.leftResizable);
        this.initValues(comp, 0, 1, this.rightSize, this.rightResizable);
        this.initValues(comp, 1, 0, this.topSize, this.topResizable);
        this.initValues(comp, 1, 1, this.bottomSize, this.bottomResizable);
    }

    private void initValues(LayoutComponent comp, int dimension, int direction, JComboBox size, JCheckBox resizable) {
        LayoutInterval space = LayoutUtils.getAdjacentEmptySpace(comp, dimension, direction);
        if (space != null) {
            int pref = space.getPreferredSize(false);
            int max = space.getMaximumSize(false);
            size.setSelectedItem(pref == -1 ? this.padding : "" + pref);
            resizable.setSelected(max != -2 && max != pref);
        } else {
            size.setSelectedItem(NbBundle.getMessage(CustomizeEmptySpaceAction.class, (String)"VALUE_NoEmptySpace"));
            size.setEnabled(false);
            resizable.setEnabled(false);
        }
    }

    boolean checkValues() {
        return this.checkValue(this.leftSize) && this.checkValue(this.rightSize) && this.checkValue(this.topSize) && this.checkValue(this.bottomSize);
    }

    private boolean checkValue(JComboBox size) {
        Object selSize = size.getSelectedItem();
        if (size.isEnabled() && !selSize.equals(this.padding)) {
            try {
                int newPref = Integer.parseInt((String)selSize);
                if (newPref < 0) {
                    this.notify("MSG_NegativeSpaceSize");
                    return false;
                }
                if (newPref > Short.MAX_VALUE) {
                    this.notify("MSG_TooLargeSpaceSize");
                    return false;
                }
            }
            catch (NumberFormatException nfex) {
                this.notify("MSG_CorruptedSpaceSize");
                return false;
            }
        }
        return true;
    }

    private void notify(String messageKey) {
        NotifyDescriptor.Message descriptor = new NotifyDescriptor.Message((Object)NbBundle.getBundle(CustomizeEmptySpaceAction.class).getString(messageKey));
        DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
    }

    void applyValues() {
        LayoutComponent comp = this.model.getLayoutComponent(this.compId);
        this.applyValues(comp, 0, 0, this.leftSize, this.leftResizable);
        this.applyValues(comp, 0, 1, this.rightSize, this.rightResizable);
        this.applyValues(comp, 1, 0, this.topSize, this.topResizable);
        this.applyValues(comp, 1, 1, this.bottomSize, this.bottomResizable);
    }

    private void applyValues(LayoutComponent comp, int dimension, int direction, JComboBox size, JCheckBox resizable) {
        LayoutInterval space = LayoutUtils.getAdjacentEmptySpace(comp, dimension, direction);
        if (space != null) {
            int newPref;
            int pref = space.getPreferredSize(false);
            int max = space.getMaximumSize(false);
            boolean oldResizable = max != -2 && max != pref;
            boolean newResizable = resizable.isSelected();
            Object selSize = size.getSelectedItem();
            if (selSize.equals(this.padding)) {
                newPref = -1;
            } else {
                try {
                    newPref = Integer.parseInt((String)selSize);
                    if (newPref < 0) {
                        newPref = pref;
                    }
                }
                catch (NumberFormatException nfex) {
                    newPref = pref;
                }
            }
            if (pref != newPref || oldResizable != newResizable) {
                this.model.setIntervalSize(space, newResizable ? -1 : -2, newPref, newResizable ? Short.MAX_VALUE : -2);
            }
        }
    }

    private void initComponents() {
        ResourceBundle bundle = NbBundle.getBundle(EmptySpaceCustomizer.class);
        this.setLayout(new GridBagLayout());
        this.setBorder(new TitledBorder(bundle.getString("TITLE_EmptySpace")));
        JLabel leftLabel = new JLabel();
        JLabel rightLabel = new JLabel();
        JLabel topLabel = new JLabel();
        JLabel bottomLabel = new JLabel();
        JLabel sizeLabel = new JLabel(bundle.getString("NAME_SpaceSize"));
        JLabel resizableLabel = new JLabel(bundle.getString("NAME_SpaceResizable"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 6, 3, 0);
        this.add((Component)leftLabel, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        this.add((Component)rightLabel, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        this.add((Component)topLabel, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(3, 6, 6, 0);
        this.add((Component)bottomLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 6, 3, 6);
        this.add((Component)sizeLabel, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.insets = new Insets(0, 6, 3, 6);
        this.add((Component)resizableLabel, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        this.add((Component)this.leftResizable, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        this.add((Component)this.rightResizable, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        this.add((Component)this.topResizable, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        this.add((Component)this.bottomResizable, gridBagConstraints);
        leftLabel.setLabelFor(this.leftSize);
        rightLabel.setLabelFor(this.rightSize);
        topLabel.setLabelFor(this.topSize);
        bottomLabel.setLabelFor(this.bottomSize);
        Mnemonics.setLocalizedText((JLabel)leftLabel, (String)bundle.getString("NAME_LeftSpace"));
        Mnemonics.setLocalizedText((JLabel)rightLabel, (String)bundle.getString("NAME_RightSpace"));
        Mnemonics.setLocalizedText((JLabel)topLabel, (String)bundle.getString("NAME_TopSpace"));
        Mnemonics.setLocalizedText((JLabel)bottomLabel, (String)bundle.getString("NAME_BottomSpace"));
        this.leftSize.setEditable(true);
        this.rightSize.setEditable(true);
        this.topSize.setEditable(true);
        this.bottomSize.setEditable(true);
        this.padding = bundle.getString("VALUE_DefaultPadding");
        this.leftSize.setModel(new DefaultComboBoxModel<String>(new String[]{this.padding}));
        this.rightSize.setModel(new DefaultComboBoxModel<String>(new String[]{this.padding}));
        this.topSize.setModel(new DefaultComboBoxModel<String>(new String[]{this.padding}));
        this.bottomSize.setModel(new DefaultComboBoxModel<String>(new String[]{this.padding}));
        this.leftResizable.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_LeftResizable"));
        this.rightResizable.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_RightResizable"));
        this.topResizable.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_TopResizable"));
        this.bottomResizable.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_BottomResizable"));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 6, 3, 6);
        this.add((Component)this.leftSize, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        this.add((Component)this.rightSize, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        this.add((Component)this.topSize, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(3, 6, 6, 6);
        this.add((Component)this.bottomSize, gridBagConstraints);
    }
}

