/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.fakepeer;

import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.BufferCapabilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.PaintEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.VolatileImage;
import java.awt.peer.ContainerPeer;
import org.netbeans.modules.form.fakepeer.FakePeerSupport;
import org.netbeans.modules.form.fakepeer.FakePeerUtils;

abstract class FakeComponentPeer {
    Component _delegate;
    Component _target;

    FakeComponentPeer(Component target) {
        this._target = target;
        this._delegate = this.createDelegate();
        this.initDelegate();
    }

    void initDelegate() {
        Rectangle r = this._target.getBounds();
        this.setBounds(r.x, r.y, r.width, r.height);
        this.setVisible(this._target.isVisible());
        this.setCursor(this._target.getCursor());
        this.setEnabled(this._target.isEnabled());
        Container parent = this._target.getParent();
        Color color = this._target.getBackground();
        if (color != null && (parent == null || parent.getBackground() != color)) {
            this._delegate.setBackground(color);
        } else {
            this._target.setBackground(this._delegate.getBackground());
        }
        color = this._target.getForeground();
        if (color != null && (parent == null || parent.getForeground() != color)) {
            this._delegate.setForeground(color);
        } else {
            this._target.setForeground(this._delegate.getForeground());
        }
        Font font = this._target.getFont();
        if (font == null || parent != null && parent.getFont() == font) {
            font = FakePeerSupport.getDefaultAWTFont();
        }
        this._delegate.setFont(font);
        this._delegate.setName(this._target.getName());
        this._delegate.setDropTarget(this._target.getDropTarget());
        this._delegate.setComponentOrientation(this._target.getComponentOrientation());
        this.repaint();
    }

    abstract Component createDelegate();

    public boolean isObscured() {
        return false;
    }

    public boolean canDetermineObscurity() {
        return false;
    }

    public void setVisible(boolean visible) {
        this._delegate.setVisible(visible);
    }

    public void setEnabled(boolean enabled) {
        this._delegate.setEnabled(enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        Font oldFont = g.getFont();
        Color oldColor = g.getColor();
        try {
            this._delegate.paint(g);
            this._target.paint(g);
            Object var5_4 = null;
            g.setColor(oldColor);
            g.setFont(oldFont);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            g.setColor(oldColor);
            g.setFont(oldFont);
            throw throwable;
        }
    }

    public void repaint(long tm, int x, int y, int w, int h) {
        this._delegate.repaint(tm, x, y, w, h);
    }

    public void print(Graphics g1) {
    }

    public void setBounds(int x, int y, int width, int height) {
        this._delegate.setBounds(x, y, width, height);
    }

    public void setBounds(int x, int y, int width, int height, int op) {
        this._delegate.setBounds(x, y, width, height);
    }

    public Rectangle getBounds() {
        return this._delegate.getBounds();
    }

    public void handleEvent(AWTEvent e) {
    }

    public void coalescePaintEvent(PaintEvent e) {
    }

    public Point getLocationOnScreen() {
        return null;
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        return this._delegate.getMinimumSize();
    }

    public ColorModel getColorModel() {
        return this._delegate.getColorModel();
    }

    public Toolkit getToolkit() {
        return this._delegate.getToolkit();
    }

    public Graphics getGraphics() {
        Container parent = this._target.getParent();
        if (parent != null) {
            Graphics g = parent.getGraphics();
            if (g != null) {
                Rectangle bounds = this._target.getBounds();
                g.translate(bounds.x, bounds.y);
                g.setClip(0, 0, bounds.width, bounds.height);
            }
            return g;
        }
        return null;
    }

    public FontMetrics getFontMetrics(Font font) {
        return null;
    }

    public void dispose() {
        this._target = null;
        this._delegate = null;
    }

    public void setForeground(Color color) {
        this._delegate.setForeground(color);
    }

    public void setBackground(Color color) {
        this._delegate.setBackground(color);
    }

    public void setFont(Font font) {
        this._delegate.setFont(font);
    }

    public void setCursor(Cursor cursor) {
        this._delegate.setCursor(cursor);
    }

    public void updateCursorImmediately() {
    }

    public void requestFocus() {
    }

    public boolean requestFocus(Component lightweightChild, boolean temporary, boolean focusedWindowChangeAllowed, long time) {
        return false;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public boolean isFocusable() {
        return false;
    }

    public Image createImage(ImageProducer producer) {
        return this.getToolkit().createImage(producer);
    }

    public Image createImage(int width, int height) {
        return new BufferedImage(width, height, 1);
    }

    public VolatileImage createVolatileImage(int width, int height) {
        GraphicsConfiguration gc = this.getGraphicsConfiguration();
        return gc != null ? gc.createCompatibleVolatileImage(width, height) : null;
    }

    public boolean prepareImage(Image img, int w, int h, ImageObserver imageObserver) {
        return this._delegate.prepareImage(img, w, h, imageObserver);
    }

    public int checkImage(Image img, int w, int h, ImageObserver imageObserver) {
        return this._delegate.checkImage(img, w, h, imageObserver);
    }

    public GraphicsConfiguration getGraphicsConfiguration() {
        return this._target.getGraphicsConfiguration();
    }

    public boolean handlesWheelScrolling() {
        return false;
    }

    public void createBuffers(int numBuffers, BufferCapabilities caps) throws AWTException {
    }

    public Image getBackBuffer() {
        return null;
    }

    public void flip(BufferCapabilities.FlipContents flipAction) {
    }

    public void destroyBuffers() {
    }

    public void reparent(ContainerPeer newContainer) {
    }

    public boolean isReparentSupported() {
        return false;
    }

    public void layout() {
    }

    public Dimension preferredSize() {
        return this.getPreferredSize();
    }

    public Dimension minimumSize() {
        return this.getMinimumSize();
    }

    public void show() {
        this.setVisible(true);
    }

    public void hide() {
        this.setVisible(false);
    }

    public void enable() {
        this.setEnabled(true);
    }

    public void disable() {
        this.setEnabled(false);
    }

    public void reshape(int x, int y, int width, int height) {
        this.setBounds(x, y, width, height);
    }

    void clearRectBeforePaint(Graphics g, Rectangle r) {
        g.clearRect(r.x, r.y, r.width, r.height);
    }

    void repaint() {
        Dimension sz = this._target.getSize();
        this.repaint(0L, 0, 0, sz.width, sz.height);
    }

    protected class Delegate
    extends Component {
        protected Delegate() {
        }

        public void paint(Graphics g) {
            Dimension sz = FakeComponentPeer.this._target.getSize();
            Color c = FakeComponentPeer.this._target.getBackground();
            if (c == null) {
                c = SystemColor.window;
            }
            g.setColor(c);
            FakePeerUtils.drawLoweredBox(g, 0, 0, sz.width, sz.height);
            Font origFont = g.getFont();
            g.setFont(origFont.deriveFont(1, origFont.getSize() + 1));
            String className = FakeComponentPeer.this._target.getClass().getName();
            className = className.substring(className.lastIndexOf(46) + 1);
            FontMetrics fm = g.getFontMetrics();
            int w = fm.stringWidth(className);
            int h = fm.getHeight() - fm.getDescent();
            int x = (sz.width - w) / 2;
            g.setColor(SystemColor.text);
            g.drawString(className, x, (sz.height - h) / 2 + h - 1);
        }

        public Dimension getMinimumSize() {
            String className = FakeComponentPeer.this._target.getClass().getName();
            className = className.substring(className.lastIndexOf(46) + 1);
            FontMetrics fm = this.getFontMetrics(new Font("Dialog", 1, 12));
            int w = fm.stringWidth(className);
            int h = fm.getHeight();
            return new Dimension(w + 10, h + 4);
        }
    }
}

