/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.palette;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.form.palette.AddToPaletteWizard;
import org.netbeans.modules.form.palette.PaletteUtils;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.HelpCtx;

class ChooseLibraryWizardPanel
implements WizardDescriptor.Panel {
    private LibrarySelector librarySelector;
    private EventListenerList listenerList;

    ChooseLibraryWizardPanel() {
    }

    public Component getComponent() {
        if (this.librarySelector == null) {
            this.librarySelector = new LibrarySelector();
            this.librarySelector.setName(PaletteUtils.getBundleString("CTL_SelectLibrary_Caption"));
            this.librarySelector.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(0));
            this.librarySelector.list.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    ChooseLibraryWizardPanel.this.fireStateChanged();
                }
            });
        }
        return this.librarySelector;
    }

    public HelpCtx getHelp() {
        return new HelpCtx("beans.adding");
    }

    public boolean isValid() {
        return this.librarySelector != null && this.librarySelector.getSelectedLibraries() != null;
    }

    public void readSettings(Object settings) {
    }

    public void storeSettings(Object settings) {
        if (this.librarySelector != null) {
            Library[] libraries = this.librarySelector.getSelectedLibraries();
            HashMap<String, File> fileMap = new HashMap<String, File>();
            HashMap<String, String> libraryMap = new HashMap<String, String>();
            for (int i = 0; i < libraries.length; ++i) {
                List content = libraries[i].getContent("classpath");
                for (URL rootURL : content) {
                    String path;
                    int index;
                    if ("jar".equals(rootURL.getProtocol()) && (index = (path = rootURL.getPath()).lastIndexOf(33)) != -1) {
                        try {
                            rootURL = new URL(path.substring(0, index));
                        }
                        catch (MalformedURLException mex) {
                            ErrorManager.getDefault().notify(1, (Throwable)mex);
                            continue;
                        }
                    }
                    File rootFile = FileUtil.toFile((FileObject)URLMapper.findFileObject((URL)rootURL));
                    String rootPath = rootFile.getAbsolutePath();
                    fileMap.put(rootPath, rootFile);
                    libraryMap.put(rootPath, libraries[i].getName());
                }
            }
            File[] libFiles = new File[fileMap.size()];
            fileMap.values().toArray(libFiles);
            AddToPaletteWizard wizard = (AddToPaletteWizard)((Object)settings);
            wizard.setJARFiles(libFiles);
            wizard.libraryNameMap = libraryMap;
        }
    }

    public void addChangeListener(ChangeListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(ChangeListener.class, listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        if (this.listenerList != null) {
            this.listenerList.remove(ChangeListener.class, listener);
        }
    }

    void fireStateChanged() {
        if (this.listenerList == null) {
            return;
        }
        ChangeEvent e = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            if (e == null) {
                e = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i + 1]).stateChanged(e);
        }
    }

    private static class LibraryRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final Border hasFocusBorder = new LineBorder(UIManager.getColor("List.focusCellHighlight"));
        private static final Border noFocusBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);

        public LibraryRenderer() {
            this.setOpaque(true);
            this.setBorder(noFocusBorder);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Library lib = (Library)value;
            this.setText(lib.getDisplayName());
            if (isSelected) {
                this.setBackground(UIManager.getColor("List.selectionBackground"));
                this.setForeground(UIManager.getColor("List.selectionForeground"));
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setBorder(cellHasFocus ? hasFocusBorder : noFocusBorder);
            return this;
        }
    }

    static class LibrarySelector
    extends JPanel {
        JList list = new JList();
        List libList;

        LibrarySelector() {
            this.list.setCellRenderer(new LibraryRenderer());
            this.list.setLayoutOrientation(1);
            this.list.setVisibleRowCount(0);
            this.updateLibraryList();
            this.setLayout(new GridBagLayout());
            JLabel label1 = new JLabel();
            Mnemonics.setLocalizedText((JLabel)label1, (String)PaletteUtils.getBundleString("CTL_Libraries"));
            label1.setLabelFor(this.list);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(0, 0, 6, 0);
            gridBagConstraints.anchor = 17;
            this.add((Component)label1, gridBagConstraints);
            JScrollPane scrollpane1 = new JScrollPane();
            scrollpane1.setViewportView(this.list);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.add((Component)scrollpane1, gridBagConstraints);
        }

        Library[] getSelectedLibraries() {
            Object[] selected = this.list.getSelectedValues();
            Library[] libraries = new Library[selected.length];
            for (int i = 0; i < selected.length; ++i) {
                libraries[i] = (Library)selected[i];
            }
            return libraries;
        }

        void updateLibraryList() {
            Library[] libraries = LibraryManager.getDefault().getLibraries();
            this.libList = new ArrayList(libraries.length);
            for (int i = 0; i < libraries.length; ++i) {
                if (!libraries[i].getType().equals("j2se")) continue;
                this.libList.add(libraries[i]);
            }
            this.list.setModel(new AbstractListModel(){

                public int getSize() {
                    return LibrarySelector.this.libList.size();
                }

                public Object getElementAt(int i) {
                    return LibrarySelector.this.libList.get(i);
                }
            });
        }

        public void addNotify() {
            super.addNotify();
            this.list.requestFocus();
        }

        public Dimension getPreferredSize() {
            return new Dimension(400, 300);
        }
    }
}

