/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.verification.persistence.rules.member;

import java.util.Arrays;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.j2ee.verification.AbstractRule;
import org.netbeans.modules.j2ee.verification.Problem;
import org.netbeans.modules.j2ee.verification.ProblemFinderContext;
import org.netbeans.modules.j2ee.verification.persistence.PersistenceAPIHelper;
import org.netbeans.modules.j2ee.verification.persistence.predicates.member.AnnotatedAsEmbeddedIdPred;

public class EitherSimpleIdOrEmbeddedId
extends AbstractRule {
    public EitherSimpleIdOrEmbeddedId() {
        super(null, Arrays.asList(new AnnotatedAsEmbeddedIdPred()));
    }

    public String getId() {
        return "EitherSimpleIdOrEmbeddedId";
    }

    protected String getMessageKey() {
        return "MSG_BothIdAndEmbeddedIdPresent";
    }

    protected boolean isApplicable(Element subject, ProblemFinderContext ctx) {
        if ((ctx.isIsEntityClass() || ctx.isMappedSuperclass()) && super.isApplicable(subject, ctx)) {
            JavaClass javaClass = ctx.getMainJavaClass();
            return PersistenceAPIHelper.getEmbeddedId(javaClass) != null;
        }
        return false;
    }

    public Problem apply(Element subject, ProblemFinderContext ctx) {
        JavaClass javaClass;
        if (this.isApplicable(subject, ctx) && PersistenceAPIHelper.getSimpleIdFields(javaClass = ctx.getMainJavaClass()).length > 0) {
            return this.createProblem(ctx, subject);
        }
        return null;
    }
}

