/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.WeakHashMap;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.openide.ErrorManager;
import org.openide.awt.AWTTask;
import org.openide.awt.MouseUtils;
import org.openide.awt.Toolbar;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.FolderInstance;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public final class ToolbarPool
extends JComponent
implements Accessible {
    private static ToolbarPool defaultPool;
    private Folder instance;
    private DataFolder folder;
    private Map toolbars;
    private Map toolbarConfigs;
    private String name = "";
    private Component center;
    private PopupListener listener;
    private AccessibleContext accessibleContext = null;
    public static final String DEFAULT_CONFIGURATION = "Standard";
    private TPTaskListener taskListener;
    private int preferredIconSize = 24;
    static final long serialVersionUID = 3420915387298484008L;
    private static Color mid;
    private static final Border lowerBorder;
    private static final Border upperBorder;
    private static Boolean isXP;
    static /* synthetic */ Class class$org$openide$awt$ToolbarPool;
    static /* synthetic */ Class class$org$openide$awt$ToolbarPool$Configuration;
    static /* synthetic */ Class class$java$awt$Component;

    public static synchronized ToolbarPool getDefault() {
        if (defaultPool == null) {
            FileObject fo = Repository.getDefault().getDefaultFileSystem().findResource("Toolbars");
            if (fo == null) {
                throw new IllegalStateException("No Toolbars/");
            }
            DataFolder folder = DataFolder.findFolder(fo);
            defaultPool = new ToolbarPool(folder);
            ToolbarPool.defaultPool.instance.recreate();
        }
        return defaultPool;
    }

    public ToolbarPool(DataFolder df) {
        this.folder = df;
        this.setLayout(new BorderLayout());
        this.listener = new PopupListener();
        this.toolbars = new TreeMap();
        this.toolbarConfigs = new TreeMap();
        this.instance = new Folder(df);
        this.getAccessibleContext().setAccessibleName(this.instance.instanceName());
        this.getAccessibleContext().setAccessibleDescription(this.instance.instanceName());
        if ("Windows".equals(UIManager.getLookAndFeel().getID())) {
            if (ToolbarPool.isXPTheme()) {
                this.setBorder(BorderFactory.createCompoundBorder(upperBorder, BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, ToolbarPool.fetchColor("controlShadow", Color.DARK_GRAY)), BorderFactory.createMatteBorder(0, 0, 1, 0, mid))));
            } else {
                this.setBorder(BorderFactory.createEtchedBorder());
            }
        } else if ("GTK".equals(UIManager.getLookAndFeel().getID())) {
            this.setBorder(BorderFactory.createEmptyBorder(5, 0, 3, 0));
        }
    }

    public int getPreferredIconSize() {
        return this.preferredIconSize;
    }

    public void setPreferredIconSize(int preferredIconSize) throws IllegalArgumentException {
        if (preferredIconSize != 16 && preferredIconSize != 24) {
            throw new IllegalArgumentException("Unsupported argument value:" + preferredIconSize);
        }
        this.preferredIconSize = preferredIconSize;
    }

    public Border getBorder() {
        if (this.center != null && this.center instanceof Container && ((Container)this.center).getComponentCount() > 0) {
            boolean show = false;
            for (int i = 0; i < ((Container)this.center).getComponentCount(); ++i) {
                Component c = ((Container)this.center).getComponent(i);
                if (!c.isVisible()) continue;
                show = true;
                break;
            }
            if (show) {
                return super.getBorder();
            }
        }
        return lowerBorder;
    }

    private static Color fetchColor(String key, Color fallback) {
        Color result = (Color)UIManager.get(key);
        if (result == null) {
            result = fallback;
        }
        return result;
    }

    public final void waitFinished() {
        this.instance.instanceFinished();
    }

    void update(Map toolbars, Map conf) {
        this.toolbars = toolbars;
        this.toolbarConfigs = conf;
        if (!"".equals(this.name)) {
            this.setConfiguration(this.name);
        }
    }

    private synchronized void updateDefault() {
        Toolbar[] toolbars = this.getToolbars();
        this.name = "";
        if (toolbars.length == 1) {
            this.revalidate(toolbars[0]);
        } else {
            JPanel tp = new JPanel(new FlowLayout(0, 0, 0));
            for (int i = 0; i < toolbars.length; ++i) {
                tp.add(toolbars[i]);
            }
            this.revalidate(tp);
        }
    }

    private synchronized void activate(Configuration c) {
        Component comp = c.activate();
        this.name = c.getName();
        this.revalidate(comp);
    }

    public void setToolbarsListener(Toolbar.DnDListener l) {
        Iterator it = this.toolbars.values().iterator();
        while (it.hasNext()) {
            ((Toolbar)it.next()).setDnDListener(l);
        }
    }

    private void revalidate(Component c) {
        if (c != this.center) {
            if (this.center != null) {
                this.remove(this.center);
                this.center.removeMouseListener((MouseListener)((Object)this.listener));
            }
            this.center = c;
            this.add(this.center, "Center");
            this.center.addMouseListener((MouseListener)((Object)this.listener));
        }
    }

    public final Toolbar findToolbar(String name) {
        return (Toolbar)this.toolbars.get(name);
    }

    public final String getConfiguration() {
        return this.name;
    }

    public final void setConfiguration(String n) {
        String old = this.name;
        if (!this.instance.isFinished()) {
            if (this.taskListener == null) {
                this.taskListener = new TPTaskListener();
                this.instance.addTaskListener(this.taskListener);
            }
            this.taskListener.setConfiguration(n);
            return;
        }
        if (this.taskListener != null) {
            this.instance.removeTaskListener(this.taskListener);
            this.taskListener = null;
        }
        Configuration config = null;
        if (n != null) {
            config = (Configuration)this.toolbarConfigs.get(n);
        }
        if (config != null) {
            this.activate(config);
        } else if (this.toolbarConfigs.isEmpty()) {
            this.updateDefault();
        } else {
            config = (Configuration)this.toolbarConfigs.get(DEFAULT_CONFIGURATION);
            if (config == null) {
                config = (Configuration)this.toolbarConfigs.values().iterator().next();
            }
            this.activate(config);
        }
        this.firePropertyChange("configuration", old, this.name);
    }

    public final DataFolder getFolder() {
        return this.folder;
    }

    public final synchronized Toolbar[] getToolbars() {
        Toolbar[] arr = new Toolbar[this.toolbars.size()];
        return this.toolbars.values().toArray(arr);
    }

    public final synchronized String[] getConfigurations() {
        ArrayList list = new ArrayList(this.toolbarConfigs.keySet());
        Collections.sort(list);
        String[] arr = new String[list.size()];
        return list.toArray(arr);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new JComponent.AccessibleJComponent(){

                public AccessibleRole getAccessibleRole() {
                    return AccessibleRole.TOOL_BAR;
                }
            };
        }
        return this.accessibleContext;
    }

    private static boolean isXPTheme() {
        if (isXP == null) {
            Boolean xp = (Boolean)Toolkit.getDefaultToolkit().getDesktopProperty("win.xpstyle.themeActive");
            isXP = Boolean.TRUE.equals(xp) ? Boolean.TRUE : Boolean.FALSE;
        }
        return isXP;
    }

    boolean isInEditMode() {
        return null != this.getClientProperty("editMode");
    }

    static {
        Color lo = ToolbarPool.fetchColor("controlShadow", Color.DARK_GRAY);
        Color hi = ToolbarPool.fetchColor("control", Color.GRAY);
        int r = (lo.getRed() + hi.getRed()) / 2;
        int g = (lo.getGreen() + hi.getGreen()) / 2;
        int b = (lo.getBlue() + hi.getBlue()) / 2;
        mid = new Color(r, g, b);
        lowerBorder = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, ToolbarPool.fetchColor("controlShadow", Color.DARK_GRAY)), BorderFactory.createMatteBorder(0, 0, 1, 0, mid));
        upperBorder = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, ToolbarPool.fetchColor("controlShadow", Color.DARK_GRAY)), BorderFactory.createMatteBorder(1, 0, 0, 0, ToolbarPool.fetchColor("controlLtHighlight", Color.WHITE)));
        isXP = null;
    }

    private static final class ComponentConfiguration
    extends JPopupMenu
    implements Configuration,
    ActionListener {
        private Component comp;
        static final long serialVersionUID = -409474484612485719L;

        ComponentConfiguration() {
        }

        public ComponentConfiguration(Component comp) {
            this.comp = comp;
        }

        public Component activate() {
            return this.comp;
        }

        public String getName() {
            return this.comp.getName();
        }

        public JPopupMenu getContextMenu() {
            this.removeAll();
            Iterator<String> it = Arrays.asList(ToolbarPool.getDefault().getConfigurations()).iterator();
            ButtonGroup bg = new ButtonGroup();
            String current = ToolbarPool.getDefault().getConfiguration();
            while (it.hasNext()) {
                String name;
                JRadioButtonMenuItem mi = new JRadioButtonMenuItem(name, (name = it.next()).compareTo(current) == 0);
                mi.addActionListener(this);
                bg.add(mi);
                this.add(mi);
            }
            return this;
        }

        public void actionPerformed(ActionEvent evt) {
            ToolbarPool.getDefault().setConfiguration(evt.getActionCommand());
        }
    }

    public static interface Configuration {
        public Component activate();

        public String getName();

        public JPopupMenu getContextMenu();
    }

    private class PopupListener
    extends MouseUtils.PopupMouseAdapter {
        PopupListener() {
        }

        protected void showPopup(MouseEvent e) {
            Configuration conf = (Configuration)ToolbarPool.this.toolbarConfigs.get(ToolbarPool.this.name);
            if (conf != null) {
                JPopupMenu pop = conf.getContextMenu();
                pop.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    private class Folder
    extends FolderInstance {
        private WeakHashMap foldersCache;

        public Folder(DataFolder f) {
            super(f);
            this.foldersCache = new WeakHashMap(15);
        }

        public String instanceName() {
            return this.instanceClass().getName();
        }

        public Class instanceClass() {
            return class$org$openide$awt$ToolbarPool == null ? (class$org$openide$awt$ToolbarPool = ToolbarPool.class$("org.openide.awt.ToolbarPool")) : class$org$openide$awt$ToolbarPool;
        }

        protected InstanceCookie acceptCookie(InstanceCookie cookie) throws IOException, ClassNotFoundException {
            Class cls;
            if ((class$org$openide$awt$ToolbarPool$Configuration == null ? (class$org$openide$awt$ToolbarPool$Configuration = ToolbarPool.class$("org.openide.awt.ToolbarPool$Configuration")) : class$org$openide$awt$ToolbarPool$Configuration).isAssignableFrom(cls = cookie.instanceClass())) {
                return cookie;
            }
            if ((class$java$awt$Component == null ? (class$java$awt$Component = ToolbarPool.class$("java.awt.Component")) : class$java$awt$Component).isAssignableFrom(cls)) {
                return cookie;
            }
            return null;
        }

        protected InstanceCookie acceptFolder(DataFolder df) {
            InstanceCookie ic = (InstanceCookie)this.foldersCache.get(df);
            if (ic == null) {
                ic = new Toolbar(df, true).waitFinished();
                this.foldersCache.put(df, ic);
            }
            return ic;
        }

        protected Object createInstance(InstanceCookie[] cookies) throws IOException, ClassNotFoundException {
            int length = cookies.length;
            TreeMap<String, Toolbar> toolbars = new TreeMap<String, Toolbar>();
            TreeMap<String, Configuration> conf = new TreeMap<String, Configuration>();
            for (int i = 0; i < length; ++i) {
                try {
                    String name;
                    Object obj = cookies[i].instanceCreate();
                    if (obj instanceof Toolbar) {
                        Toolbar toolbar = (Toolbar)obj;
                        toolbar.removeMouseListener((MouseListener)((Object)ToolbarPool.this.listener));
                        toolbar.addMouseListener((MouseListener)((Object)ToolbarPool.this.listener));
                        toolbars.put(toolbar.getName(), toolbar);
                        continue;
                    }
                    if (obj instanceof Configuration) {
                        Configuration config = (Configuration)obj;
                        name = config.getName();
                        if (name == null) {
                            name = cookies[i].instanceName();
                        }
                        conf.put(name, config);
                        continue;
                    }
                    if (!(obj instanceof Component)) continue;
                    Component comp = (Component)obj;
                    name = comp.getName();
                    if (name == null) {
                        name = cookies[i].instanceName();
                    }
                    conf.put(name, new ComponentConfiguration(comp));
                    continue;
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                    continue;
                }
                catch (ClassNotFoundException ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
            }
            ToolbarPool.this.update(toolbars, conf);
            return ToolbarPool.this;
        }

        protected Task postCreationTask(Runnable run) {
            return new AWTTask(run);
        }
    }

    private class TPTaskListener
    implements TaskListener {
        private String conf;

        TPTaskListener() {
        }

        public void taskFinished(Task task) {
            ToolbarPool.this.setConfiguration(this.conf);
            this.conf = null;
        }

        void setConfiguration(String conf) {
            if (this.conf == null) {
                this.conf = conf;
            }
        }
    }
}

