/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.actions;

import java.sql.ResultSet;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import org.netbeans.lib.ddl.impl.CreateIndex;
import org.netbeans.lib.ddl.impl.DriverSpecification;
import org.netbeans.lib.ddl.impl.DropIndex;
import org.netbeans.lib.ddl.impl.Specification;
import org.netbeans.modules.db.explorer.actions.DatabaseAction;
import org.netbeans.modules.db.explorer.dlg.LabeledComboDialog;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;

public class AddToIndexAction
extends DatabaseAction {
    static final long serialVersionUID = -1416260930649261633L;

    protected boolean enable(Node[] activatedNodes) {
        return activatedNodes != null && activatedNodes.length == 1;
    }

    public void performAction(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length <= 0) {
            return;
        }
        Node node = activatedNodes[0];
        try {
            DatabaseNodeInfo info = (DatabaseNodeInfo)node.getCookie(DatabaseNodeInfo.class);
            DatabaseNodeInfo nfo = info.getParent(this.nodename);
            String tablename = (String)nfo.get("table");
            Specification spec = (Specification)nfo.getSpecification();
            DriverSpecification drvSpec = info.getDriverSpecification();
            String index = (String)nfo.get("index");
            HashSet<String> ixrm = new HashSet<String>();
            drvSpec.getIndexInfo(tablename, false, true);
            ResultSet rs = drvSpec.getResultSet();
            HashMap rset = new HashMap();
            boolean isUQ = false;
            while (rs.next()) {
                rset = drvSpec.getRow();
                String ixname = (String)rset.get(new Integer(6));
                if (!index.equals(ixname)) continue;
                String colname = (String)rset.get(new Integer(9));
                ixrm.add(colname);
                String val = (String)rset.get(new Integer(4));
                isUQ = val.equals("1") ? false : Boolean.valueOf(val) == false;
                rset.clear();
            }
            rs.close();
            Vector<String> cols = new Vector<String>(5);
            drvSpec.getColumns(tablename, "%");
            rs = drvSpec.getResultSet();
            while (rs.next()) {
                rset = drvSpec.getRow();
                String colname = (String)rset.get(new Integer(4));
                if (!ixrm.contains(colname)) {
                    cols.add(colname);
                }
                rset.clear();
            }
            rs.close();
            if (cols.size() == 0) {
                throw new Exception(AddToIndexAction.bundle().getString("EXC_NoUsableColumnInPlace"));
            }
            LabeledComboDialog dlg = new LabeledComboDialog(AddToIndexAction.bundle().getString("AddToIndexTitle"), AddToIndexAction.bundle().getString("AddToIndexLabel"), cols);
            if (dlg.run()) {
                CreateIndex icmd = spec.createCommandCreateIndex(tablename);
                icmd.setIndexName(index);
                icmd.setObjectOwner((String)info.get("schema"));
                if (isUQ) {
                    icmd.setIndexType("unique");
                } else {
                    icmd.setIndexType(new String());
                }
                Iterator enu = ixrm.iterator();
                while (enu.hasNext()) {
                    icmd.specifyColumn((String)enu.next());
                }
                icmd.specifyColumn((String)dlg.getSelectedItem());
                DropIndex dicmd = spec.createCommandDropIndex(index);
                dicmd.setObjectOwner((String)info.get("schema"));
                dicmd.setTableName(tablename);
                dicmd.execute();
                icmd.execute();
                info.getParent("table").refreshChildren();
            }
        }
        catch (Exception exc) {
            String message = MessageFormat.format(AddToIndexAction.bundle().getString("ERR_UnableToPerformOperation"), node.getName(), exc.getMessage());
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0));
        }
    }
}

