/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Vector;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.lib.ddl.DDLException;
import org.netbeans.modules.db.ExceptionListener;
import org.netbeans.modules.db.explorer.ConnectionList;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.actions.DatabaseAction;
import org.netbeans.modules.db.explorer.dlg.ConnectionDialog;
import org.netbeans.modules.db.explorer.dlg.ConnectionDialogMediator;
import org.netbeans.modules.db.explorer.dlg.NewConnectionPanel;
import org.netbeans.modules.db.explorer.dlg.SchemaPanel;
import org.netbeans.modules.db.explorer.driver.JDBCDriverSupport;
import org.netbeans.modules.db.explorer.infos.ConnectionNodeInfo;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.netbeans.modules.db.explorer.infos.DriverNodeInfo;
import org.netbeans.modules.db.explorer.infos.RootNodeInfo;
import org.netbeans.modules.db.explorer.nodes.RootNode;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;

public class ConnectUsingDriverAction
extends DatabaseAction {
    static final long serialVersionUID = 8245005834483564671L;

    protected boolean enable(Node[] activatedNodes) {
        return activatedNodes != null && activatedNodes.length == 1;
    }

    public void performAction(Node[] activatedNodes) {
        String driverClass;
        String driverName;
        Node node = activatedNodes[0];
        DriverNodeInfo info = (DriverNodeInfo)node.getCookie(DatabaseNodeInfo.class);
        JDBCDriver driver = info.getJDBCDriver();
        if (driver != null) {
            driverName = driver.getName();
            driverClass = driver.getClassName();
        } else {
            driverName = info.getName();
            driverClass = info.getURL();
        }
        new NewConnectionDialogDisplayer().showDialog(driverName, driverClass);
    }

    public static final class NewConnectionDialogDisplayer
    extends ConnectionDialogMediator {
        ConnectionDialog dlg;
        ConnectionNodeInfo cni;
        boolean advancedPanel = false;
        boolean okPressed = false;

        public void showDialog(String driverName, String driverClass) {
            this.showDialog(driverName, driverClass, null, null, null);
        }

        public DatabaseConnection showDialog(JDBCDriver driver, String databaseUrl, String user, String password) {
            String driverName = driver != null ? driver.getName() : null;
            String driverClass = driver != null ? driver.getClassName() : null;
            return this.showDialog(driverName, driverClass, databaseUrl, user, password);
        }

        public DatabaseConnection showDialog(String driverName, String driverClass, String databaseUrl, String user, String password) {
            JDBCDriver[] drivers;
            String finalDriverClass = null;
            if (null != databaseUrl && null != driverClass) {
                drivers = JDBCDriverManager.getDefault().getDrivers(driverClass);
                finalDriverClass = driverClass;
            } else {
                drivers = JDBCDriverManager.getDefault().getDrivers();
            }
            String selectedDriverName = null;
            String selectedDriverClass = null;
            if (driverName == null || driverClass == null) {
                for (int i = 0; i < drivers.length; ++i) {
                    if (!JDBCDriverSupport.isAvailable(drivers[i])) continue;
                    if (selectedDriverName == null) {
                        selectedDriverName = drivers[i].getName();
                        selectedDriverClass = drivers[i].getClassName();
                    }
                    if (!"org.apache.derby.jdbc.ClientDriver".equals(drivers[i].getClassName())) continue;
                    selectedDriverName = drivers[i].getName();
                    selectedDriverClass = drivers[i].getClassName();
                    break;
                }
            } else {
                selectedDriverName = driverName;
                selectedDriverClass = driverClass;
            }
            final DatabaseConnection cinfo = new DatabaseConnection();
            cinfo.setDriverName(selectedDriverName);
            cinfo.setDriver(selectedDriverClass);
            if (user != null) {
                cinfo.setUser(user);
            }
            if (password != null) {
                cinfo.setPassword(password);
            }
            if (null != databaseUrl) {
                cinfo.setDatabase(databaseUrl);
            }
            final NewConnectionPanel basePanel = new NewConnectionPanel(this, finalDriverClass, cinfo);
            final SchemaPanel schemaPanel = new SchemaPanel(this, cinfo);
            PropertyChangeListener argumentListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    if (event.getPropertyName().equals("argumentChanged")) {
                        schemaPanel.setSchemas(new Vector(), "");
                        schemaPanel.resetProgress();
                        try {
                            Connection conn = cinfo.getConnection();
                            if (conn != null && !conn.isClosed()) {
                                conn.close();
                            }
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                }
            };
            basePanel.addPropertyChangeListener(argumentListener);
            PropertyChangeListener connectionListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    if (event.getPropertyName().equals("connecting")) {
                        NewConnectionDialogDisplayer.this.fireConnectionStarted();
                    }
                    if (event.getPropertyName().equals("failed")) {
                        NewConnectionDialogDisplayer.this.fireConnectionFailed();
                    }
                    if (event.getPropertyName().equals("connected")) {
                        if (!NewConnectionDialogDisplayer.this.retrieveSchemas(schemaPanel, cinfo, cinfo.getUser())) {
                            NewConnectionDialogDisplayer.this.fireConnectionFinished();
                            NewConnectionDialogDisplayer.this.dlg.setSelectedComponent(schemaPanel);
                            return;
                        }
                        cinfo.setSchema(schemaPanel.getSchema());
                        NewConnectionDialogDisplayer.this.fireConnectionFinished();
                        if (NewConnectionDialogDisplayer.this.advancedPanel && !NewConnectionDialogDisplayer.this.okPressed) {
                            return;
                        }
                        try {
                            ((RootNodeInfo)RootNode.getInstance().getInfo()).addConnection(cinfo);
                        }
                        catch (DatabaseException exc) {
                            ErrorManager.getDefault().notify(1, (Throwable)exc);
                            String message = MessageFormat.format(DatabaseAction.bundle().getString("ERR_UnableToAddConnection"), exc.getMessage());
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0));
                            try {
                                cinfo.getConnection().close();
                            }
                            catch (SQLException e) {
                                // empty catch block
                            }
                            return;
                        }
                        if (NewConnectionDialogDisplayer.this.dlg != null) {
                            NewConnectionDialogDisplayer.this.dlg.close();
                        }
                    } else {
                        NewConnectionDialogDisplayer.this.okPressed = false;
                    }
                }
            };
            ExceptionListener excListener = new ExceptionListener(){

                public void exceptionOccurred(Exception exc) {
                    if (exc instanceof DDLException) {
                        ErrorManager.getDefault().notify(1, exc.getCause());
                    } else {
                        ErrorManager.getDefault().notify(1, (Throwable)exc);
                    }
                    String message = null;
                    if (exc instanceof ClassNotFoundException) {
                        message = MessageFormat.format(DatabaseAction.bundle().getString("EXC_ClassNotFound"), exc.getMessage());
                    } else {
                        StringBuffer buffer = new StringBuffer();
                        buffer.append(MessageFormat.format(DatabaseAction.bundle().getString("ERR_UnableToAddConnection"), exc.getMessage()));
                        if (exc instanceof DDLException && exc.getCause() instanceof SQLException) {
                            for (SQLException sqlEx = ((SQLException)exc.getCause()).getNextException(); sqlEx != null; sqlEx = sqlEx.getNextException()) {
                                buffer.append("\n\n" + sqlEx.getMessage());
                            }
                        }
                        message = buffer.toString();
                    }
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0));
                }
            };
            cinfo.addPropertyChangeListener(connectionListener);
            cinfo.addExceptionListener(excListener);
            ActionListener actionListener = new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void actionPerformed(ActionEvent event) {
                    if (event.getSource() == DialogDescriptor.OK_OPTION) {
                        NewConnectionDialogDisplayer.this.okPressed = true;
                        basePanel.setConnectionInfo();
                        try {
                            if (cinfo.getConnection() == null || cinfo.getConnection().isClosed()) {
                                cinfo.connect();
                            } else {
                                cinfo.setSchema(schemaPanel.getSchema());
                                ((RootNodeInfo)RootNode.getInstance().getInfo()).addConnection(cinfo);
                                if (NewConnectionDialogDisplayer.this.dlg != null) {
                                    NewConnectionDialogDisplayer.this.dlg.close();
                                }
                            }
                        }
                        catch (SQLException exc) {
                            cinfo.connect();
                        }
                        catch (DatabaseException exc) {
                            ErrorManager.getDefault().notify(1, (Throwable)exc);
                            String message = MessageFormat.format(DatabaseAction.bundle().getString("ERR_UnableToAddConnection"), exc.getMessage());
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0));
                            try {
                                cinfo.getConnection().close();
                                cinfo.setConnection(null);
                            }
                            catch (SQLException e) {
                                cinfo.setConnection(null);
                            }
                        }
                        return;
                    }
                }
            };
            ChangeListener changeTabListener = new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    if (((JTabbedPane)e.getSource()).getSelectedComponent().equals(schemaPanel)) {
                        NewConnectionDialogDisplayer.this.advancedPanel = true;
                        basePanel.setConnectionInfo();
                    } else {
                        NewConnectionDialogDisplayer.this.advancedPanel = false;
                    }
                }
            };
            this.dlg = new ConnectionDialog(this, basePanel, schemaPanel, basePanel.getTitle(), actionListener, changeTabListener);
            this.dlg.setVisible(true);
            return ConnectionList.getDefault().getConnection(cinfo);
        }

        protected boolean retrieveSchemas(SchemaPanel schemaPanel, DatabaseConnection dbcon, String defaultSchema) {
            this.fireConnectionStep(DatabaseAction.bundle().getString("ConnectionProgress_Schemas"));
            Vector<String> schemas = new Vector<String>();
            try {
                ResultSet rs = dbcon.getConnection().getMetaData().getSchemas();
                if (rs != null) {
                    while (rs.next()) {
                        schemas.add(rs.getString(1).trim());
                    }
                }
            }
            catch (SQLException exc) {
                String message = MessageFormat.format(DatabaseAction.bundle().getString("ERR_UnableObtainSchemas"), exc.getMessage());
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0));
            }
            return schemaPanel.setSchemas(schemas, defaultSchema);
        }
    }
}

