/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.nodes;

import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import org.netbeans.lib.ddl.CommandNotSupportedException;
import org.netbeans.lib.ddl.impl.AddColumn;
import org.netbeans.lib.ddl.impl.RenameTable;
import org.netbeans.lib.ddl.impl.Specification;
import org.netbeans.lib.ddl.impl.TableColumn;
import org.netbeans.modules.db.explorer.ConnectionList;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.DatabaseNodeChildren;
import org.netbeans.modules.db.explorer.DbMetaDataTransferProvider;
import org.netbeans.modules.db.explorer.infos.ColumnNodeInfo;
import org.netbeans.modules.db.explorer.infos.ConnectionNodeInfo;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.netbeans.modules.db.explorer.infos.TableListNodeInfo;
import org.netbeans.modules.db.explorer.infos.TableNodeInfo;
import org.netbeans.modules.db.explorer.nodes.DatabaseNode;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.datatransfer.PasteType;

public class TableNode
extends DatabaseNode {
    public void setInfo(DatabaseNodeInfo nodeinfo) {
        super.setInfo(nodeinfo);
        this.getCookieSet().add((Node.Cookie)this);
    }

    public void setName(String newname) {
        try {
            DatabaseNodeInfo info = this.getInfo();
            Specification spec = (Specification)info.getSpecification();
            RenameTable cmd = spec.createCommandRenameTable(info.getName(), newname);
            cmd.setObjectOwner((String)info.get("schema"));
            cmd.execute();
            super.setName(newname);
            info.put("table", newname);
        }
        catch (CommandNotSupportedException ex) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)ex.getMessage(), 0));
        }
        catch (Exception ex) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)ex.getMessage(), 0));
        }
    }

    public Transferable clipboardCopy() throws IOException {
        Transferable result;
        final DbMetaDataTransferProvider dbTansferProvider = (DbMetaDataTransferProvider)Lookup.getDefault().lookup(DbMetaDataTransferProvider.class);
        if (dbTansferProvider != null) {
            ExTransferable exTransferable = ExTransferable.create((Transferable)super.clipboardCopy());
            ConnectionNodeInfo cni = (ConnectionNodeInfo)this.getInfo().getParent("connection");
            final DatabaseConnection dbconn = ConnectionList.getDefault().getConnection(cni.getDatabaseConnection());
            exTransferable.put(new ExTransferable.Single(dbTansferProvider.getTableDataFlavor()){

                protected Object getData() {
                    return dbTansferProvider.createTableData(dbconn.getDatabaseConnection(), dbconn.findJDBCDriver(), TableNode.this.getInfo().getName());
                }
            });
            result = exTransferable;
        } else {
            result = super.clipboardCopy();
        }
        return result;
    }

    protected void createPasteTypes(Transferable t, List s) {
        super.createPasteTypes(t, s);
        Node n = NodeTransfer.node((Transferable)t, (int)6);
        if (n != null && n.canDestroy()) {
            ColumnNodeInfo nfo = (ColumnNodeInfo)n.getCookie(ColumnNodeInfo.class);
            if (nfo != null) {
                s.add(new ColumnPasteType(nfo, n));
                return;
            }
        } else {
            DatabaseNodeInfo nfo = (DatabaseNodeInfo)NodeTransfer.cookie((Transferable)t, (int)6, (Class)ColumnNodeInfo.class);
            if (nfo != null) {
                s.add(new ColumnPasteType((ColumnNodeInfo)nfo, null));
                return;
            }
        }
    }

    public String getShortDescription() {
        return NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("ND_Table");
    }

    private class ColumnPasteType
    extends PasteType {
        final ResourceBundle bundle = NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle");
        private DatabaseNodeInfo info;
        private Node node;

        public ColumnPasteType(ColumnNodeInfo info, Node node) {
            this.info = info;
            this.node = node;
        }

        public String getName() {
            return this.bundle.getString("PasteColumnName");
        }

        public Transferable paste() throws IOException {
            ResourceBundle bundle = NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle");
            TableNodeInfo ownerinfo = (TableNodeInfo)TableNode.this.getInfo();
            if (this.info != null) {
                try {
                    String name = this.info.getName();
                    ColumnNodeInfo coli = (ColumnNodeInfo)this.info;
                    TableColumn col = coli.getColumnSpecification();
                    Specification spec = (Specification)ownerinfo.getSpecification();
                    AddColumn cmd = spec.createCommandAddColumn(ownerinfo.getTable());
                    cmd.getColumns().add(col);
                    cmd.setObjectOwner((String)this.info.get("schema"));
                    cmd.execute();
                    ownerinfo.addColumn(name);
                    if (this.node != null) {
                        this.node.destroy();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } else {
                throw new IOException(bundle.getString("EXC_CannotFindColumnOwnerInformation"));
            }
            return null;
        }
    }

    private class TablePasteType
    extends PasteType {
        private DatabaseNodeInfo info;
        private Node node;

        public TablePasteType(TableNodeInfo info, Node node) {
            this.info = info;
            this.node = node;
        }

        public String getName() {
            ResourceBundle bundle = NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle");
            return bundle.getString("PasteTableName");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Transferable paste() throws IOException {
            TableNodeInfo info = (TableNodeInfo)TableNode.this.getInfo();
            ResourceBundle bundle = NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle_noi18n");
            TableListNodeInfo ownerinfo = (TableListNodeInfo)TableNode.this.getInfo().getParent("tablelist");
            if (info == null) throw new IOException(bundle.getString("EXC_CannotFindTableOwnerInformation"));
            TableNodeInfo exinfo = ownerinfo.getChildrenTableInfo(info);
            DatabaseNodeChildren chi = (DatabaseNodeChildren)TableNode.this.getChildren();
            String name = info.getName();
            if (exinfo != null) {
                String namefmt = bundle.getString("PasteTableNameFormat");
                name = MessageFormat.format(namefmt, name);
            }
            try {
                ownerinfo.addTable(name);
                if (this.node == null) return null;
                this.node.destroy();
                return null;
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
        }
    }
}

