/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.debugger.jpda;

import com.sun.jdi.Bootstrap;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.ListeningConnector;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.netbeans.api.debugger.jpda.AbstractDICookie;

public final class ListeningDICookie
extends AbstractDICookie {
    public static final String ID = "netbeans-jpda-ListeningDICookie";
    private ListeningConnector listeningConnector;
    private Map args;

    private ListeningDICookie(ListeningConnector listeningConnector, Map args) {
        this.listeningConnector = listeningConnector;
        this.args = args;
    }

    public static ListeningDICookie create(ListeningConnector listeningConnector, Map args) {
        return new ListeningDICookie(listeningConnector, args);
    }

    public static ListeningDICookie create(int portNumber) {
        return new ListeningDICookie(ListeningDICookie.findListeningConnector("socket"), ListeningDICookie.getArgs(ListeningDICookie.findListeningConnector("socket"), portNumber));
    }

    public static ListeningDICookie create(String name) {
        return new ListeningDICookie(ListeningDICookie.findListeningConnector("socket"), ListeningDICookie.getArgs(ListeningDICookie.findListeningConnector("socket"), name));
    }

    private static ListeningConnector findListeningConnector(String s) {
        Iterator<ListeningConnector> iter = Bootstrap.virtualMachineManager().listeningConnectors().iterator();
        while (iter.hasNext()) {
            ListeningConnector ac = iter.next();
            if (ac.transport() == null || ac.transport().name().toLowerCase().indexOf(s) <= -1) continue;
            return ac;
        }
        return null;
    }

    private static Map getArgs(ListeningConnector listeningConnector, int portNumber) {
        Map<String, Connector.Argument> args = listeningConnector.defaultArguments();
        args.get("port").setValue("" + portNumber);
        return args;
    }

    private static Map getArgs(ListeningConnector listeningConnector, String name) {
        Map<String, Connector.Argument> args = listeningConnector.defaultArguments();
        args.get("name").setValue(name);
        return args;
    }

    public ListeningConnector getListeningConnector() {
        return this.listeningConnector;
    }

    public Map getArgs() {
        return this.args;
    }

    public int getPortNumber() {
        Connector.Argument a = (Connector.Argument)this.args.get("port");
        if (a == null) {
            return -1;
        }
        String pn = a.value();
        if (pn == null) {
            return -1;
        }
        try {
            return Integer.parseInt(pn);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public String getSharedMemoryName() {
        Connector.Argument a = (Connector.Argument)this.args.get("name");
        if (a == null) {
            return null;
        }
        return a.value();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VirtualMachine getVirtualMachine() throws IOException, IllegalConnectorArgumentsException {
        try {
            try {
                this.listeningConnector.startListening(this.args);
            }
            catch (Exception exception) {
                // empty catch block
            }
            VirtualMachine virtualMachine = this.listeningConnector.accept(this.args);
            return virtualMachine;
        }
        finally {
            try {
                this.listeningConnector.stopListening(this.args);
            }
            catch (Exception exception) {}
        }
    }
}

