/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.model;

import com.sun.jdo.api.persistence.model.Model;
import com.sun.jdo.api.persistence.model.mapping.MappingClassElement;
import com.sun.jdo.spi.persistence.utility.JavaTypeHelper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.netbeans.api.java.classpath.ClassPath;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.src.ClassElement;
import org.openide.src.FieldElement;
import org.openide.src.Identifier;
import org.openide.src.MemberElement;
import org.openide.src.MethodElement;
import org.openide.src.Type;

public class DevelopmentModel
extends Model {
    private HashMap _locks;
    private FileObject[] _sourceRoots;
    private HashMap primitiveTypes;

    protected DevelopmentModel() {
        this(null);
    }

    protected DevelopmentModel(FileObject[] sourceRoots) {
        this._sourceRoots = sourceRoots;
        this.primitiveTypes = new HashMap();
        this.primitiveTypes.put("boolean", Type.BOOLEAN);
        this.primitiveTypes.put("byte", Type.BYTE);
        this.primitiveTypes.put("short", Type.SHORT);
        this.primitiveTypes.put("char", Type.CHAR);
        this.primitiveTypes.put("int", Type.INT);
        this.primitiveTypes.put("long", Type.LONG);
        this.primitiveTypes.put("float", Type.FLOAT);
        this.primitiveTypes.put("double", Type.DOUBLE);
        this.primitiveTypes.put("void", Type.VOID);
    }

    protected FileObject[] getSourceRoots() {
        return this._sourceRoots;
    }

    public boolean isInterface(String className) {
        ClassElement classElement = (ClassElement)this.getClass(className);
        return classElement != null ? classElement.isInterface() : false;
    }

    protected BufferedInputStream getInputStreamForResource(String className, ClassLoader classLoader, String resourceName) {
        try {
            FileObject file = this.getFile(className, resourceName);
            return file != null ? new BufferedInputStream(file.getInputStream()) : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected String findPenultimateSuperclass(String className) {
        ClassElement classElement = (ClassElement)this.getClass(className);
        Identifier objectClass = ClassElement.ROOT_OBJECT;
        Identifier testClass = null;
        if (classElement == null) {
            return className;
        }
        while ((testClass = classElement.getSuperclass()) != null) {
            String testName = testClass.getFullName();
            if (testClass.equals((Object)objectClass)) break;
            classElement = (ClassElement)this.getClass(testName);
            if (classElement != null) continue;
            return Model.RUNTIME.findPenultimateSuperclass(testName);
        }
        return classElement.getName().getFullName();
    }

    protected String getSuperclass(String className) {
        ClassElement classElement = (ClassElement)this.getClass(className);
        if (classElement != null) {
            Identifier superclass = classElement.getSuperclass();
            return superclass != null ? superclass.getFullName() : null;
        }
        return null;
    }

    private synchronized HashMap getLocks() {
        if (this._locks == null) {
            this._locks = new HashMap();
        }
        return this._locks;
    }

    private synchronized FileLock getLock(String className) {
        return (FileLock)this.getLocks().get(className);
    }

    private synchronized void putLock(String className, FileLock lock) {
        this.getLocks().put(className, lock);
    }

    private synchronized void removeLock(String className) {
        this.getLocks().remove(className);
    }

    protected BufferedOutputStream createFile(String className, String baseFileName, String extension) throws IOException {
        char extensionCharacter = '.';
        FileObject file = this.getFile(className, baseFileName + extensionCharacter + extension);
        if (file == null) {
            String shortClassName;
            String packageName;
            Repository repository = Repository.getDefault();
            FileObject javaFile = repository.find(packageName = JavaTypeHelper.getPackageName(className), shortClassName = JavaTypeHelper.getShortClassName(className), "java");
            if (javaFile != null) {
                file = javaFile.getParent().createData(shortClassName, extension);
            } else {
                throw new FileNotFoundException();
            }
        }
        if (file != null) {
            return new BufferedOutputStream(file.getOutputStream(this.lockFile(className, file)));
        }
        return null;
    }

    public void lockFile(String className) throws IOException {
        this.lockFile(className, this.getFile(className, this.getFileNameWithExtension(className)));
    }

    private FileLock lockFile(String className, FileObject file) throws IOException {
        FileLock lock = null;
        if (file != null && (lock = this.getLock(className)) == null) {
            lock = file.lock();
            this.putLock(className, lock);
        }
        return lock;
    }

    public void unlockFile(String className) {
        FileLock lock;
        if (className != null && (lock = this.getLock(className)) != null) {
            lock.releaseLock();
            this.removeLock(className);
        }
        super.unlockFile(className);
    }

    public void updateKeyForClass(MappingClassElement mappingClass, String oldName) {
        FileLock lock;
        super.updateKeyForClass(mappingClass, oldName);
        if (oldName != null && (lock = this.getLock(oldName)) != null) {
            this.unlockFile(oldName);
            if (mappingClass != null) {
                try {
                    this.lockFile(mappingClass.getName());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteFile(String className, String fileName) throws IOException {
        FileObject file = this.getFile(className, fileName);
        FileLock lock = this.lockFile(className, file);
        try {
            file.delete(lock);
        }
        finally {
            this.unlockFile(className);
        }
    }

    protected FileObject getFile(String className, String fileName) throws IOException {
        FileObject[] sourceRoots = this.getSourceRoots();
        if (fileName != null && sourceRoots != null) {
            for (int i = 0; i < sourceRoots.length; ++i) {
                ClassPath cp = ClassPath.getClassPath((FileObject)sourceRoots[i], (String)"classpath/compile");
                List matches = cp.findAllResources(fileName.replace(File.separatorChar, '/'));
                Iterator iterator = matches.iterator();
                while (iterator.hasNext()) {
                    FileObject nextMatch = (FileObject)iterator.next();
                    if (nextMatch.getFileSystem().isReadOnly()) continue;
                    return nextMatch;
                }
            }
        }
        return null;
    }

    public Object getClass(String className, ClassLoader classLoader) {
        FileObject[] sourceRoots = this.getSourceRoots();
        if (className != null && sourceRoots != null) {
            for (int i = 0; i < sourceRoots.length; ++i) {
                ClassElement returnObject = ClassElement.forName((String)className, (FileObject)sourceRoots[i]);
                if (returnObject == null) continue;
                return returnObject;
            }
        }
        return null;
    }

    public boolean implementsInterface(Object classElement, String interfaceName) {
        Identifier superclass;
        if (classElement == null || !(classElement instanceof ClassElement) || interfaceName == null) {
            return false;
        }
        ClassElement thisClass = (ClassElement)classElement;
        Identifier[] interfaces = thisClass.getInterfaces();
        if (interfaces != null) {
            for (int i = 0; i < interfaces.length; ++i) {
                if (!interfaces[i].getFullName().equals(interfaceName)) continue;
                return true;
            }
        }
        if ((superclass = thisClass.getSuperclass()) == null || superclass.equals((Object)ClassElement.ROOT_OBJECT)) {
            return false;
        }
        return this.implementsInterface((ClassElement)this.getClass(superclass.getFullName()), interfaceName);
    }

    public boolean hasConstructor(String className) {
        ClassElement classElement = (ClassElement)this.getClass(className);
        return classElement != null ? classElement.getConstructors().length != 0 : false;
    }

    public Object getConstructor(String className, String[] argTypeNames) {
        ClassElement classElement = (ClassElement)this.getClass(className);
        return classElement != null ? classElement.getConstructor(this.getTypesForNames(argTypeNames)) : null;
    }

    public Object getMethod(String className, String methodName, String[] argTypeNames) {
        ClassElement classElement = (ClassElement)this.getClass(className);
        return classElement != null ? classElement.getMethod(Identifier.create((String)methodName), this.getTypesForNames(argTypeNames)) : null;
    }

    public String getType(Object element) {
        return this.getNameForType(this.getTypeObject(element));
    }

    public List getFields(String className) {
        ArrayList<String> returnList = new ArrayList<String>();
        ClassElement classElement = (ClassElement)this.getClass(className);
        if (classElement != null) {
            FieldElement[] fields = classElement.getFields();
            int count = fields != null ? fields.length : 0;
            for (int i = 0; i < count; ++i) {
                returnList.add(fields[i].getName().getName());
            }
        }
        return returnList;
    }

    public Object getField(String className, String fieldName) {
        ClassElement classElement = (ClassElement)this.getClass(className);
        if (classElement != null) {
            Identifier fieldIdentifier = Identifier.create((String)fieldName);
            return classElement.getField(fieldIdentifier);
        }
        return null;
    }

    public boolean isSerializable(Object fieldElement) {
        Type type = this.getTypeObject(fieldElement);
        ClassElement classElement = null;
        if (type == null || !(fieldElement instanceof FieldElement)) {
            return false;
        }
        while (type.isArray()) {
            type = type.getElementType();
        }
        if (type.isPrimitive()) {
            return true;
        }
        classElement = (ClassElement)this.getClass(type.getClassName().getFullName());
        return classElement == null ? false : this.implementsInterface(classElement, "java.io.Serializable");
    }

    public boolean isArray(String className, String fieldName) {
        Object fieldElement = this.getField(className, fieldName);
        return fieldElement != null ? this.getTypeObject(fieldElement).isArray() : false;
    }

    public String getDeclaringClass(Object memberElement) {
        ClassElement classElement = null;
        if (memberElement != null && memberElement instanceof MemberElement) {
            classElement = ((MemberElement)memberElement).getDeclaringClass();
        }
        return classElement != null ? classElement.getName().getFullName() : null;
    }

    public int getModifiers(Object memberElement) {
        int modifiers = 0;
        if (memberElement != null && memberElement instanceof MemberElement) {
            modifiers = ((MemberElement)memberElement).getModifiers();
        }
        return modifiers;
    }

    protected Type getTypeObject(Object element) {
        Type type = null;
        if (element != null) {
            if (element instanceof FieldElement) {
                type = ((FieldElement)element).getType();
            } else if (element instanceof MethodElement) {
                type = ((MethodElement)element).getReturn();
            }
        }
        return type;
    }

    private String getNameForType(Type type) {
        String typeName = null;
        if (type != null) {
            typeName = type.isArray() ? this.getNameForType(type.getElementType()) + "[]" : (type.isPrimitive() ? type.toString() : type.getClassName().getFullName());
        }
        return typeName;
    }

    private Type[] getTypesForNames(String[] typeNames) {
        Type[] types = new Type[typeNames.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = this.getTypeForName(typeNames[i]);
        }
        return types;
    }

    private Type getTypeForName(String typeName) {
        Type type = (Type)this.primitiveTypes.get(typeName);
        if (type == null) {
            type = Type.createClass((Identifier)Identifier.create((String)typeName));
        }
        return type;
    }
}

