/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.modules.persistence.mapping.ejb;

import com.sun.jdo.api.persistence.mapping.ejb.AbstractNameMapper;
import com.sun.jdo.spi.persistence.utility.JavaTypeHelper;
import com.sun.jdo.spi.persistence.utility.StringHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.j2ee.dd.api.ejb.CmpField;
import org.netbeans.modules.j2ee.dd.api.ejb.CmrField;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJar;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbRelation;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbRelationshipRole;
import org.netbeans.modules.j2ee.dd.api.ejb.EnterpriseBeans;
import org.netbeans.modules.j2ee.dd.api.ejb.Entity;
import org.netbeans.modules.j2ee.dd.api.ejb.Relationships;

public class DevelopmentNameMapper
extends AbstractNameMapper {
    private final EjbJar bundleDescriptor;
    private final Map generatedRelToInverseRelMap;
    private final Map relToInverseGeneratedRelMap;
    private final Map nameToPcClassNameMap;

    protected DevelopmentNameMapper(EjbJar bundleDescriptor) {
        this.bundleDescriptor = bundleDescriptor;
        this.generatedRelToInverseRelMap = new HashMap();
        this.relToInverseGeneratedRelMap = new HashMap();
        this.nameToPcClassNameMap = new HashMap();
        this.initGeneratedRelationshipMaps();
        EnterpriseBeans allBeans = this.getBundleDescriptor().getEnterpriseBeans();
        Entity[] entityBeans = allBeans.getEntity();
        int count = entityBeans != null ? entityBeans.length : 0;
        for (int i = 0; i < count; ++i) {
            Entity testEntity = entityBeans[i];
            boolean isEntity = "Container".equals(testEntity.getPersistenceType());
            if (!isEntity) continue;
            String testName = testEntity.getEjbName();
            this.nameToPcClassNameMap.put(testName, this.getPersistenceClassForAbstractBean(testEntity.getEjbClass(), testName));
        }
    }

    private void initGeneratedRelationshipMaps() {
        EjbJar descriptor = this.getBundleDescriptor();
        Relationships relationships = descriptor.getSingleRelationships();
        if (relationships != null) {
            EjbRelation relationship;
            EjbRelation[] rels = relationships.getEjbRelation();
            ArrayList<EjbRelation> generatedRels = new ArrayList<EjbRelation>();
            int counter = 0;
            for (int i = 0; i < rels.length; ++i) {
                relationship = rels[i];
                if (relationship.getEjbRelationshipRole().getCmrField() == null) {
                    generatedRels.add(relationship);
                }
                if (relationship.getEjbRelationshipRole2().getCmrField() != null) continue;
                generatedRels.add(relationship);
            }
            Iterator iterator = generatedRels.iterator();
            while (iterator.hasNext()) {
                relationship = (EjbRelation)iterator.next();
                EjbRelationshipRole source = relationship.getEjbRelationshipRole();
                String sourceEjbName = source.getEjbRelationshipRoleName();
                CmrField sourceCMRField = source.getCmrField();
                boolean sourceIsNull = sourceCMRField == null;
                EjbRelationshipRole sink = relationship.getEjbRelationshipRole2();
                String sinkEjbName = sink.getEjbRelationshipRoleName();
                String ejbName = sourceIsNull ? sourceEjbName : sinkEjbName;
                String otherEjbName = sourceIsNull ? sinkEjbName : sourceEjbName;
                List<String> ejbField = Arrays.asList(otherEjbName, sourceIsNull ? sink.getCmrField().getCmrFieldName() : sourceCMRField.getCmrFieldName());
                List<String> generatedField = null;
                String uniqueName = null;
                if (ejbName == null) continue;
                while (this.hasField(ejbName, uniqueName = "thisRelationshipFieldWasGeneratedByTheNameMapper" + ++counter)) {
                }
                generatedField = Arrays.asList(ejbName, uniqueName);
                this.generatedRelToInverseRelMap.put(generatedField, ejbField);
                this.relToInverseGeneratedRelMap.put(ejbField, generatedField);
            }
        }
    }

    protected Map getGeneratedFieldsMap() {
        return this.generatedRelToInverseRelMap;
    }

    protected Map getInverseFieldsMap() {
        return this.relToInverseGeneratedRelMap;
    }

    private boolean hasField(String ejbName, String fieldName) {
        List fields = this.getFieldsForEjb(ejbName);
        return fields.contains(fieldName) || this.getGeneratedRelationshipsForEjbName(ejbName).contains(fieldName);
    }

    EjbJar getBundleDescriptor() {
        return this.bundleDescriptor;
    }

    public boolean isEjbName(String name) {
        return name != null ? this.getDescriptorForEjbName(name) != null : false;
    }

    Entity getDescriptorForEjbName(String name) {
        if (name != null) {
            EnterpriseBeans allBeans = this.getBundleDescriptor().getEnterpriseBeans();
            Entity[] entityBeans = allBeans.getEntity();
            int count = entityBeans != null ? entityBeans.length : 0;
            for (int i = 0; i < count; ++i) {
                Entity testEntity = entityBeans[i];
                if (!"Container".equals(testEntity.getPersistenceType()) || !name.equals(testEntity.getEjbName())) continue;
                return testEntity;
            }
        }
        return null;
    }

    private Entity getRelatedEjbDescriptor(String ejbName, String ejbFieldName) {
        Relationships relationships = this.getBundleDescriptor().getSingleRelationships();
        if (relationships != null && ejbName != null) {
            EjbRelation[] rels = relationships.getEjbRelation();
            int count = rels != null ? rels.length : 0;
            for (int i = 0; i < count; ++i) {
                boolean hasCMRField;
                EjbRelation relationship = rels[i];
                String cmrField = this.getCMRField(relationship.getEjbRelationshipRole2(), ejbName);
                boolean bl = hasCMRField = cmrField != null;
                if (this.hasMatchingCMRField(cmrField, ejbFieldName)) {
                    return this.getDescriptorForEjbName(relationship.getEjbRelationshipRole().getRelationshipRoleSource().getEjbName());
                }
                if (!(!hasCMRField ? this.hasMatchingCMRField(cmrField = this.getCMRField(relationship.getEjbRelationshipRole(), ejbName), ejbFieldName) : hasCMRField && ejbName.equals(relationship.getEjbRelationshipRole().getRelationshipRoleSource().getEjbName()) && this.hasMatchingCMRField(cmrField = this.getCMRField(relationship.getEjbRelationshipRole(), ejbName), ejbFieldName))) continue;
                return this.getDescriptorForEjbName(relationship.getEjbRelationshipRole2().getRelationshipRoleSource().getEjbName());
            }
        }
        return null;
    }

    protected List getFieldsForEjb(String ejbName) {
        Entity entity = this.getDescriptorForEjbName(ejbName);
        ArrayList<String> returnList = new ArrayList<String>();
        if (entity != null) {
            CmpField[] fields = entity.getCmpField();
            int count = fields != null ? fields.length : 0;
            for (int i = 0; i < count; ++i) {
                returnList.add(fields[i].getFieldName());
            }
        }
        returnList.addAll(this.getRelationshipFieldsForEjb(ejbName));
        return returnList;
    }

    protected List getRelationshipFieldsForEjb(String ejbName) {
        Relationships relationships = this.getBundleDescriptor().getSingleRelationships();
        ArrayList<String> returnList = new ArrayList<String>();
        if (relationships != null && ejbName != null) {
            EjbRelation[] rels = relationships.getEjbRelation();
            int count = rels != null ? rels.length : 0;
            for (int i = 0; i < count; ++i) {
                EjbRelation relationship = rels[i];
                EjbRelationshipRole testRole = relationship.getEjbRelationshipRole();
                String cmrField = this.getCMRField(testRole, ejbName);
                if (cmrField != null) {
                    returnList.add(cmrField);
                }
                if ((cmrField = this.getCMRField(testRole = relationship.getEjbRelationshipRole2(), ejbName)) == null) continue;
                returnList.add(cmrField);
            }
        }
        return returnList;
    }

    private String getCMRField(EjbRelationshipRole testRole, String ejbName) {
        CmrField cmrField;
        String returnValue = null;
        if (ejbName.equals(testRole.getRelationshipRoleSource().getEjbName()) && (cmrField = testRole.getCmrField()) != null) {
            returnValue = cmrField.getCmrFieldName();
        }
        return returnValue;
    }

    private boolean hasMatchingCMRField(String candidateCMR, String fieldName) {
        return candidateCMR != null && candidateCMR.equals(fieldName);
    }

    public String getAbstractBeanClassForEjbName(String name) {
        Entity entity = this.getDescriptorForEjbName(name);
        return entity != null ? entity.getEjbClass() : null;
    }

    public String getKeyClassForEjbName(String name) {
        Entity entity = this.getDescriptorForEjbName(name);
        return entity != null ? entity.getPrimKeyClass() : null;
    }

    public int getKeyClassTypeForEjbName(String name) {
        String keyClass = this.getKeyClassForEjbName(name);
        if (!"java.lang.Object".equals(keyClass)) {
            Entity descriptor = this.getDescriptorForEjbName(name);
            return descriptor.getPrimkeyField() != null ? 2 : 1;
        }
        return 3;
    }

    public String getAbstractSchemaForEjbName(String name) {
        Entity entity = this.getDescriptorForEjbName(name);
        return entity != null ? entity.getAbstractSchemaName() : null;
    }

    public String getEjbNameForPersistenceClass(String className) {
        String candidateName = JavaTypeHelper.getShortClassName(className);
        String packageName = JavaTypeHelper.getPackageName(className);
        if (className != null && candidateName != null && packageName != null) {
            EnterpriseBeans allBeans = this.getBundleDescriptor().getEnterpriseBeans();
            Entity[] entityBeans = allBeans.getEntity();
            int count = entityBeans != null ? entityBeans.length : 0;
            for (int i = 0; i < count; ++i) {
                Entity testEntity = entityBeans[i];
                if (!"Container".equals(testEntity.getPersistenceType()) || !candidateName.equals(testEntity.getEjbName()) || !packageName.equals(JavaTypeHelper.getPackageName(testEntity.getEjbClass()))) continue;
                return testEntity.getEjbName();
            }
        }
        return null;
    }

    public String getPersistenceClassForEjbName(String name) {
        String cachedName = (String)this.nameToPcClassNameMap.get(name);
        return cachedName != null ? cachedName : this.getPersistenceClassForAbstractBean(this.getAbstractBeanClassForEjbName(name), name);
    }

    private String getPersistenceClassForAbstractBean(String abstractBean, String name) {
        if (abstractBean != null) {
            return JavaTypeHelper.getPackageName(abstractBean) + '.' + name;
        }
        return null;
    }

    public boolean isLocalInterface(String name) {
        if (name != null) {
            EnterpriseBeans allBeans = this.getBundleDescriptor().getEnterpriseBeans();
            Entity[] entityBeans = allBeans.getEntity();
            int count = entityBeans != null ? entityBeans.length : 0;
            for (int i = 0; i < count; ++i) {
                Entity testEntity = entityBeans[i];
                if (!"Container".equals(testEntity.getPersistenceType()) || !name.equals(testEntity.getLocal())) continue;
                return true;
            }
        }
        return false;
    }

    public String getEjbNameForLocalInterface(String ejbName, String fieldName, String interfaceName) {
        Entity descriptor = this.getRelatedEjbDescriptor(ejbName, fieldName);
        return descriptor != null && !StringHelper.isEmpty(interfaceName) && interfaceName.equals(descriptor.getLocal()) ? descriptor.getEjbName() : null;
    }

    public String getLocalInterfaceForEjbName(String name) {
        Entity entity = this.getDescriptorForEjbName(name);
        return entity != null ? entity.getLocal() : null;
    }

    public boolean isRemoteInterface(String name) {
        if (name != null) {
            EnterpriseBeans allBeans = this.getBundleDescriptor().getEnterpriseBeans();
            Entity[] entityBeans = allBeans.getEntity();
            int count = entityBeans != null ? entityBeans.length : 0;
            for (int i = 0; i < count; ++i) {
                Entity testEntity = entityBeans[i];
                if (!"Container".equals(testEntity.getPersistenceType()) || !name.equals(testEntity.getRemote())) continue;
                return true;
            }
        }
        return false;
    }

    public String getEjbNameForRemoteInterface(String ejbName, String fieldName, String interfaceName) {
        Entity descriptor = this.getRelatedEjbDescriptor(ejbName, fieldName);
        return descriptor != null && !StringHelper.isEmpty(interfaceName) && interfaceName.equals(descriptor.getRemote()) ? descriptor.getEjbName() : null;
    }

    public String getRemoteInterfaceForEjbName(String name) {
        Entity entity = this.getDescriptorForEjbName(name);
        return entity != null ? entity.getRemote() : null;
    }

    public String getEjbFieldForPersistenceField(String className, String fieldName) {
        return fieldName;
    }

    public String getPersistenceFieldForEjbField(String name, String fieldName) {
        return fieldName;
    }
}

