/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.ddl.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.lib.ddl.DDLException;
import org.netbeans.lib.ddl.impl.AbstractCommand;
import org.netbeans.lib.ddl.util.CommandFormatter;
import org.openide.util.NbBundle;

public class AbstractTableColumn
implements Serializable {
    private String name;
    private String cname;
    private String format;
    private String otype;
    private Map addprops;
    String reftab;
    String refcol;
    static final long serialVersionUID = -5128289937199572117L;

    public String getObjectName() {
        return this.name;
    }

    public void setObjectName(String oname) {
        this.name = oname;
    }

    public String getObjectType() {
        return this.otype;
    }

    public void setObjectType(String type) {
        this.otype = type;
    }

    public String getColumnName() {
        return this.cname;
    }

    public void setColumnName(String columnName) {
        this.cname = columnName;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String fmt) {
        this.format = fmt;
    }

    public String getReferencedTableName() {
        return this.reftab;
    }

    public void setReferencedTableName(String table) {
        this.reftab = table;
    }

    public String getReferencedColumnName() {
        return this.refcol;
    }

    public void setReferencedColumnName(String col) {
        this.refcol = col;
    }

    public Object getProperty(String pname) {
        return this.addprops.get(pname);
    }

    public void setProperty(String pname, Object pval) {
        if (this.addprops == null) {
            this.addprops = new HashMap();
        }
        this.addprops.put(pname, pval);
    }

    public Map getColumnProperties(AbstractCommand cmd) throws DDLException {
        HashMap<String, String> args = new HashMap<String, String>();
        String oname = this.getObjectName();
        String cname = this.getColumnName();
        if (this.addprops != null) {
            args.putAll(this.addprops);
        }
        if (oname == null) {
            throw new DDLException(NbBundle.getBundle((String)"org.netbeans.lib.ddl.resources.Bundle").getString("EXC_Unknown"));
        }
        args.put("object.name", cmd.quote(oname));
        if (cname == null) {
            throw new DDLException(NbBundle.getBundle((String)"org.netbeans.lib.ddl.resources.Bundle").getString("EXC_Unknown"));
        }
        args.put("column.name", cmd.quote(cname));
        if (this.reftab != null) {
            args.put("fkobject.name", cmd.quote(this.reftab));
        }
        if (this.refcol != null) {
            args.put("fkcolumn.name", cmd.quote(this.refcol));
        }
        return args;
    }

    public String getCommand(AbstractCommand cmd) throws DDLException {
        if (this.format == null) {
            throw new DDLException(NbBundle.getBundle((String)"org.netbeans.lib.ddl.resources.Bundle").getString("EXC_NoFormatSpec"));
        }
        try {
            Map cprops = this.getColumnProperties(cmd);
            return CommandFormatter.format(this.format, cprops);
        }
        catch (Exception e) {
            throw new DDLException(e.getMessage());
        }
    }

    public void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.name = (String)in.readObject();
        this.cname = (String)in.readObject();
        this.format = (String)in.readObject();
        this.otype = (String)in.readObject();
        this.addprops = (Map)in.readObject();
        this.reftab = (String)in.readObject();
        this.refcol = (String)in.readObject();
    }

    public void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.name);
        out.writeObject(this.cname);
        out.writeObject(this.format);
        out.writeObject(this.otype);
        out.writeObject(this.addprops);
        out.writeObject(this.reftab);
        out.writeObject(this.refcol);
    }
}

