/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.navigator;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.FocusManager;
import javax.swing.JComboBox;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.netbeans.modules.navigator.NavigatorTC;
import org.netbeans.modules.navigator.ProviderRegistry;
import org.netbeans.spi.navigator.NavigatorLookupHint;
import org.netbeans.spi.navigator.NavigatorPanel;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

final class NavigatorController
implements LookupListener,
ActionListener,
Lookup.Provider,
PropertyChangeListener {
    static final int COALESCE_TIME = 100;
    private NavigatorTC navigatorTC;
    private RequestProcessor.Task nodeSetterTask;
    private final Object NODE_SETTER_LOCK = new Object();
    private static final Lookup.Template CUR_NODES = new Lookup.Template(Node.class);
    private static final Lookup.Template CUR_HINTS = new Lookup.Template(NavigatorLookupHint.class);
    private Lookup.Result curNodes;
    private Lookup.Result curHints;
    private Node curNode;
    private WeakReference oldNodeRef;
    private final Lookup clientsLookup;
    private final Lookup panelLookup;
    private Reference lastActivatedRef;

    public NavigatorController(NavigatorTC navigatorTC) {
        this.navigatorTC = navigatorTC;
        this.clientsLookup = Lookups.proxy((Lookup.Provider)this);
        this.panelLookup = Lookups.proxy((Lookup.Provider)new PanelLookupWrapper());
    }

    public void navigatorTCOpened() {
        this.curNodes = Utilities.actionsGlobalContext().lookup(CUR_NODES);
        this.curNodes.addLookupListener((LookupListener)this);
        this.curHints = Utilities.actionsGlobalContext().lookup(CUR_HINTS);
        this.curHints.addLookupListener((LookupListener)this);
        this.navigatorTC.getPanelSelector().addActionListener(this);
        TopComponent.getRegistry().addPropertyChangeListener((PropertyChangeListener)this);
        this.updateContext();
    }

    public void navigatorTCClosed() {
        this.curNodes.removeLookupListener((LookupListener)this);
        this.curHints.removeLookupListener((LookupListener)this);
        this.navigatorTC.getPanelSelector().removeActionListener(this);
        TopComponent.getRegistry().removePropertyChangeListener((PropertyChangeListener)this);
        this.curNodes = null;
        this.curHints = null;
        this.curNode = null;
        this.lastActivatedRef = null;
    }

    public Lookup getPanelLookup() {
        return this.panelLookup;
    }

    public void actionPerformed(ActionEvent e) {
        NavigatorPanel oldPanel;
        int index = this.navigatorTC.getPanelSelector().getSelectedIndex();
        if (index == -1) {
            return;
        }
        NavigatorPanel newPanel = (NavigatorPanel)this.navigatorTC.getPanels().get(index);
        if (!newPanel.equals(oldPanel = this.navigatorTC.getSelectedPanel())) {
            if (oldPanel != null) {
                oldPanel.panelDeactivated();
            }
            newPanel.panelActivated(this.clientsLookup);
            this.navigatorTC.setSelectedPanel(newPanel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resultChanged(LookupEvent ev) {
        if (!((Object)((Object)this.navigatorTC)).equals(WindowManager.getDefault().getRegistry().getActivated())) {
            ActNodeSetter nodeSetter = new ActNodeSetter();
            Object object = this.NODE_SETTER_LOCK;
            synchronized (object) {
                if (this.nodeSetterTask != null) {
                    this.nodeSetterTask.cancel();
                }
                this.nodeSetterTask = RequestProcessor.getDefault().post((Runnable)nodeSetter, 100);
                this.nodeSetterTask.addTaskListener((TaskListener)nodeSetter);
            }
        }
    }

    private Node obtainFirstCurNode() {
        Collection nodeList = this.curNodes.allInstances();
        return nodeList.isEmpty() ? null : (Node)nodeList.iterator().next();
    }

    private void updateContext() {
        Node[] nodeArray;
        Node node = this.curNode = this.obtainFirstCurNode();
        Node oldNode = this.oldNodeRef != null ? (Node)this.oldNodeRef.get() : null;
        this.oldNodeRef = node != null ? new WeakReference<Node>(node) : null;
        List providers = this.obtainProviders(node);
        List oldProviders = this.navigatorTC.getPanels();
        if (node == null) {
            nodeArray = new Node[]{};
        } else {
            Node[] nodeArray2 = new Node[1];
            nodeArray = nodeArray2;
            nodeArray2[0] = node;
        }
        this.navigatorTC.setActivatedNodes(nodeArray);
        this.updateTCTitle(providers != null && !providers.isEmpty() ? node : null);
        if (oldProviders == null && providers == null) {
            return;
        }
        NavigatorPanel selPanel = this.navigatorTC.getSelectedPanel();
        if (oldProviders != null && oldProviders.contains(selPanel) && providers != null && providers.contains(selPanel)) {
            this.clientsLookup.lookup(Node.class);
            return;
        }
        if (selPanel != null) {
            selPanel.panelDeactivated();
        }
        if (providers != null && providers.size() > 0) {
            NavigatorPanel newSel = (NavigatorPanel)providers.get(0);
            newSel.panelActivated(this.clientsLookup);
        }
        this.navigatorTC.getPanelSelector().removeActionListener(this);
        this.navigatorTC.setPanels(providers);
        this.navigatorTC.getPanelSelector().addActionListener(this);
    }

    private void updateTCTitle(Node node) {
        String newTitle = node != null ? NbBundle.getMessage((Class)NavigatorTC.class, (String)"FMT_Navigator", (Object)node.getDisplayName()) : NbBundle.getMessage((Class)NavigatorTC.class, (String)"LBL_Navigator");
        this.navigatorTC.setName(newTitle);
    }

    List obtainProviders(Node node) {
        List providers;
        ArrayList result = null;
        NavigatorLookupHint lkpHint = (NavigatorLookupHint)Utilities.actionsGlobalContext().lookup(NavigatorLookupHint.class);
        if (lkpHint != null && (providers = ProviderRegistry.getInstance().getProviders(lkpHint.getContentType())) != null && !providers.isEmpty()) {
            result = new ArrayList(providers.size());
            result.addAll(providers);
        }
        if (node != null) {
            FileObject fo;
            DataObject dObj = (DataObject)node.getLookup().lookup(DataObject.class);
            while (dObj instanceof DataShadow) {
                dObj = ((DataShadow)dObj).getOriginal();
            }
            if (dObj != null && !(fo = dObj.getPrimaryFile()).isVirtual()) {
                String contentType = fo.getMIMEType();
                List providers2 = ProviderRegistry.getInstance().getProviders(contentType);
                if (providers2 != null && !providers2.isEmpty()) {
                    if (result == null) {
                        result = new ArrayList(providers2.size());
                    }
                    result.addAll(providers2);
                }
            }
        }
        return result;
    }

    public Lookup getLookup() {
        if (this.curNode == null) {
            return Lookup.EMPTY;
        }
        return this.curNode.getLookup();
    }

    public void installActions() {
        KeyStroke returnKey = KeyStroke.getKeyStroke(27, 0, true);
        this.navigatorTC.getInputMap(2).put(returnKey, "return");
        this.navigatorTC.getActionMap().put("return", new ESCHandler());
    }

    public void propertyChange(PropertyChangeEvent evt) {
        TopComponent tc;
        if ("activated".equals(evt.getPropertyName()) && (tc = TopComponent.getRegistry().getActivated()) != null && tc != this.navigatorTC) {
            this.lastActivatedRef = new WeakReference<TopComponent>(tc);
        }
    }

    private class ActNodeSetter
    implements Runnable,
    TaskListener {
        private ActNodeSetter() {
        }

        public void run() {
            if (RequestProcessor.getDefault().isRequestProcessorThread()) {
                SwingUtilities.invokeLater(this);
            } else if (NavigatorController.this.curNodes != null) {
                NavigatorController.this.updateContext();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void taskFinished(Task task) {
            Object object = NavigatorController.this.NODE_SETTER_LOCK;
            synchronized (object) {
                if (task == NavigatorController.this.nodeSetterTask) {
                    NavigatorController.this.nodeSetterTask = null;
                }
            }
        }
    }

    private class PanelLookupWrapper
    implements Lookup.Provider {
        private PanelLookupWrapper() {
        }

        public Lookup getLookup() {
            Lookup panelLkp;
            NavigatorPanel selPanel = NavigatorController.this.navigatorTC.getSelectedPanel();
            if (selPanel != null && (panelLkp = selPanel.getLookup()) != null) {
                return panelLkp;
            }
            return Lookup.EMPTY;
        }
    }

    private class ESCHandler
    extends AbstractAction {
        private ESCHandler() {
        }

        public void actionPerformed(ActionEvent evt) {
            Component focusOwner = FocusManager.getCurrentManager().getFocusOwner();
            if (NavigatorController.this.lastActivatedRef == null || focusOwner == null || !SwingUtilities.isDescendingFrom(focusOwner, (Component)((Object)NavigatorController.this.navigatorTC)) || focusOwner instanceof JComboBox) {
                return;
            }
            TopComponent prevFocusedTc = (TopComponent)NavigatorController.this.lastActivatedRef.get();
            if (prevFocusedTc != null) {
                prevFocusedTc.requestActive();
            }
        }
    }
}

