/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2;

import java.awt.EventQueue;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.Reader;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.core.output2.Controller;
import org.netbeans.core.output2.IOEvent;
import org.netbeans.core.output2.NbIOProvider;
import org.netbeans.core.output2.NbWriter;
import org.netbeans.core.output2.OutWriter;
import org.openide.ErrorManager;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

class NbIO
implements InputOutput {
    private Boolean focusTaken = null;
    private Boolean closed = null;
    private String name;
    private Action[] actions;
    private NbWriter out = null;
    private boolean streamClosed = false;
    private boolean streamClosedSet = false;
    private boolean wasReset = false;
    private IOReader in = null;

    NbIO(String name, Action[] toolbarActions) {
        this(name);
        this.actions = toolbarActions;
    }

    NbIO(String name) {
        this.name = name;
    }

    public void closeInputOutput() {
        if (Controller.log) {
            Controller.log("CLOSE INPUT OUTPUT CALLED FOR " + this);
        }
        if (this.out != null) {
            if (Controller.log) {
                Controller.log(" - Its output is non null, calling close() on " + (Object)((Object)this.out));
            }
            this.out.close();
        }
        NbIO.post(this, 7, true);
    }

    String getName() {
        return this.name;
    }

    public OutputWriter getErr() {
        return ((NbWriter)this.getOut()).getErr();
    }

    NbWriter writer() {
        return this.out;
    }

    void dispose() {
        if (Controller.log) {
            Controller.log(this + ": IO " + this.getName() + " is being disposed");
        }
        if (this.out != null) {
            if (Controller.log) {
                Controller.log(this + ": Still has an OutWriter.  Disposing it");
            }
            this.out().dispose();
            this.out = null;
            if (this.in != null) {
                this.in.eof();
                this.in = null;
            }
            this.focusTaken = null;
        }
        NbIOProvider.dispose(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputWriter getOut() {
        NbIO nbIO = this;
        synchronized (nbIO) {
            if (this.out == null) {
                OutWriter realout = new OutWriter(this);
                this.out = new NbWriter(realout, this);
            }
        }
        return this.out;
    }

    OutWriter out() {
        return this.out == null ? null : this.out.out();
    }

    void setClosed(boolean val) {
        this.closed = val ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean isClosed() {
        return Boolean.TRUE.equals(this.closed);
    }

    public boolean isErrSeparated() {
        return false;
    }

    public boolean isFocusTaken() {
        return Boolean.TRUE.equals(this.focusTaken);
    }

    boolean isStreamClosed() {
        return this.out == null ? true : (this.streamClosedSet ? this.streamClosed : false);
    }

    public void select() {
        if (Controller.log) {
            Controller.log(this + ": select");
        }
        NbIO.post(this, 6, true);
    }

    public void setErrSeparated(boolean value) {
    }

    public void setErrVisible(boolean value) {
    }

    public void setFocusTaken(boolean value) {
        this.focusTaken = value ? Boolean.TRUE : Boolean.FALSE;
        NbIO.post(this, 5, value);
    }

    public void setInputVisible(boolean value) {
        if (Controller.log) {
            Controller.log(this + ": SetInputVisible");
        }
        NbIO.post(this, 2, value);
    }

    public void setOutputVisible(boolean value) {
    }

    boolean hasStreamClosed() {
        return this.streamClosedSet;
    }

    public void setStreamClosed(boolean value) {
        if (Controller.log) {
            Controller.log("setStreamClosed on " + this + " to " + value);
        }
        if (this.streamClosed != value || !this.streamClosedSet) {
            this.streamClosed = value;
            this.streamClosedSet = true;
            NbIO.post(this, 8, value);
        }
    }

    public void setToolbarActions(Action[] a) {
        this.actions = a;
        NbIO.post(this, 10, a);
    }

    Action[] getToolbarActions() {
        return this.actions;
    }

    boolean checkReset() {
        boolean result = this.wasReset;
        this.wasReset = false;
        return result;
    }

    public void reset() {
        if (Controller.log) {
            Controller.log(this + ": reset");
        }
        this.closed = null;
        boolean wasReset = true;
        this.streamClosedSet = false;
        this.streamClosed = false;
        if (this.in != null) {
            this.in.eof();
            this.in.reuse();
        }
        NbIO.post(this, 9, true);
    }

    private static void post(NbIO io, int command, boolean val) {
        IOEvent evt = new IOEvent(io, command, val);
        NbIO.post(evt);
    }

    private static void post(NbIO io, int command, Object data) {
        IOEvent evt = new IOEvent(io, command, data);
        NbIO.post(evt);
    }

    static void post(IOEvent evt) {
        if (SwingUtilities.isEventDispatchThread()) {
            if (Controller.log) {
                Controller.log("Synchronously dispatching " + evt + " from call on EQ");
            }
            evt.dispatch();
        } else {
            if (Controller.log) {
                Controller.log("Asynchronously posting " + evt + " to EQ");
            }
            EventQueue eq = Toolkit.getDefaultToolkit().getSystemEventQueue();
            eq.postEvent(evt);
        }
    }

    public String toString() {
        return "NbIO@" + System.identityHashCode(this) + " " + this.getName();
    }

    IOReader in() {
        return this.in;
    }

    public Reader getIn() {
        if (this.in == null) {
            this.in = new IOReader();
        }
        return this.in;
    }

    public Reader flushReader() {
        return this.getIn();
    }

    class IOReader
    extends Reader {
        private boolean pristine;
        private boolean inputClosed;

        IOReader() {
            super(new StringBuffer());
            this.pristine = true;
            this.inputClosed = false;
        }

        void reuse() {
            this.pristine = true;
            this.inputClosed = false;
        }

        private StringBuffer buffer() {
            return (StringBuffer)this.lock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void pushText(String txt) {
            if (Controller.log) {
                Controller.log(NbIO.this + ": Input text: " + txt);
            }
            Object object = this.lock;
            synchronized (object) {
                this.buffer().append(txt);
                this.lock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void eof() {
            Object object = this.lock;
            synchronized (object) {
                try {
                    this.close();
                }
                catch (IOException ioe) {
                    ErrorManager.getDefault().notify((Throwable)ioe);
                }
            }
        }

        private void checkPristine() throws IOException {
            if (SwingUtilities.isEventDispatchThread()) {
                throw new IOException("Cannot call read() from the event thread, it will deadlock");
            }
            if (this.pristine) {
                NbIO.this.setInputVisible(true);
                this.pristine = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(char[] cbuf, int off, int len) throws IOException {
            if (Controller.log) {
                Controller.log(NbIO.this + ":Input read: " + off + " len " + len);
            }
            this.checkPristine();
            Object object = this.lock;
            synchronized (object) {
                while (!this.inputClosed && this.buffer().length() == 0) {
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        IOException ioe = new IOException("Interrupted: " + e.getMessage());
                        ErrorManager.getDefault().annotate((Throwable)ioe, (Throwable)e);
                        throw ioe;
                    }
                }
                if (this.inputClosed) {
                    this.reuse();
                    return -1;
                }
                int realLen = Math.min(this.buffer().length(), len);
                this.buffer().getChars(0, realLen, cbuf, off);
                this.buffer().delete(0, realLen);
                return realLen;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read() throws IOException {
            if (Controller.log) {
                Controller.log(NbIO.this + ": Input read one char");
            }
            this.checkPristine();
            Object object = this.lock;
            synchronized (object) {
                while (!this.inputClosed && this.buffer().length() == 0) {
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        IOException ioe = new IOException("Interrupted: " + e.getMessage());
                        ErrorManager.getDefault().annotate((Throwable)ioe, (Throwable)e);
                        throw ioe;
                    }
                }
                if (this.inputClosed) {
                    this.reuse();
                    return -1;
                }
                char i = this.buffer().charAt(0);
                this.buffer().deleteCharAt(0);
                return i;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean ready() throws IOException {
            Object object = this.lock;
            synchronized (object) {
                return !this.inputClosed && this.buffer().length() > 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long skip(long n) throws IOException {
            if (Controller.log) {
                Controller.log(NbIO.this + ": Input skip " + n);
            }
            this.checkPristine();
            Object object = this.lock;
            synchronized (object) {
                while (!this.inputClosed && this.buffer().length() == 0) {
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        IOException ioe = new IOException("Interrupted: " + e.getMessage());
                        ErrorManager.getDefault().annotate((Throwable)ioe, (Throwable)e);
                        throw ioe;
                    }
                }
                if (this.inputClosed) {
                    this.reuse();
                    return 0L;
                }
                int realLen = Math.min(this.buffer().length(), (int)n);
                this.buffer().delete(0, realLen);
                return realLen;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            if (Controller.log) {
                Controller.log(NbIO.this + ": Input close");
            }
            NbIO.this.setInputVisible(false);
            Object object = this.lock;
            synchronized (object) {
                this.inputClosed = true;
                this.buffer().setLength(0);
                this.lock.notifyAll();
            }
        }

        public boolean isClosed() {
            return this.inputClosed;
        }
    }
}

