/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.plaf.aqua;

import java.awt.Color;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import org.netbeans.swing.plaf.aqua.ShapeGradientContext;

public class ShapeGradientPaint
implements Paint {
    protected Color shadowColor;
    protected Color mBackgroundColor;
    protected Rectangle bounds;
    private static PaintContext last = null;
    private static AffineTransform lastXform = null;
    private static Rectangle lastBounds = null;

    public ShapeGradientPaint(Rectangle r, Color pointColor, Color backgroundColor) {
        this.shadowColor = pointColor;
        this.mBackgroundColor = backgroundColor;
        this.bounds = r;
    }

    public PaintContext createContext(ColorModel cm, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform xform, RenderingHints hints) {
        if (last != null && xform.equals(lastXform) && this.bounds.equals(lastBounds)) {
            return last;
        }
        lastBounds = this.bounds;
        lastXform = xform;
        Rectangle r = new Rectangle(this.bounds);
        Point2D.Double xl = new Point2D.Double(r.x, r.y);
        Point2D.Double rl = new Point2D.Double(r.x + r.width, r.y + r.height);
        r.x = (int)xl.x;
        r.y = (int)xl.y;
        r.width = (int)(rl.x - xl.x);
        r.height = (int)(rl.y - xl.y);
        last = new ShapeGradientContext(r, this.shadowColor, this.mBackgroundColor);
        return last;
    }

    public int getTransparency() {
        int a2;
        int a1 = this.shadowColor.getAlpha();
        return (a1 & (a2 = this.mBackgroundColor.getAlpha())) == 255 ? 1 : 3;
    }
}

