/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistryEvent;
import org.netbeans.api.java.classpath.GlobalPathRegistryListener;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.openide.filesystems.FileObject;

public final class GlobalPathRegistry {
    private static GlobalPathRegistry DEFAULT;
    private int resetCount;
    private final Map paths = new HashMap();
    private final List listeners = new ArrayList();
    private Set sourceRoots = null;
    private Set results = new HashSet();
    private final ChangeListener resultListener = new SFBQListener();
    private PropertyChangeListener classpathListener = new PropertyChangeListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent evt) {
            GlobalPathRegistry globalPathRegistry = GlobalPathRegistry.this;
            synchronized (globalPathRegistry) {
                GlobalPathRegistry.this.resetSourceRootsCache();
            }
        }
    };
    static final /* synthetic */ boolean $assertionsDisabled;

    public static GlobalPathRegistry getDefault() {
        return DEFAULT;
    }

    private GlobalPathRegistry() {
    }

    void clear() {
        this.paths.clear();
        this.listeners.clear();
    }

    public synchronized Set getPaths(String id) {
        if (id == null) {
            throw new NullPointerException();
        }
        List l = (List)this.paths.get(id);
        if (l != null && !l.isEmpty()) {
            return Collections.unmodifiableSet(new HashSet(l));
        }
        return Collections.EMPTY_SET;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(String id, ClassPath[] paths) {
        if (id == null || paths == null) {
            throw new NullPointerException();
        }
        GlobalPathRegistryEvent evt = null;
        GlobalPathRegistryListener[] _listeners = null;
        GlobalPathRegistry globalPathRegistry = this;
        synchronized (globalPathRegistry) {
            ArrayList<ClassPath> l = (ArrayList<ClassPath>)this.paths.get(id);
            if (l == null) {
                l = new ArrayList<ClassPath>();
                this.paths.put(id, l);
            }
            HashSet<ClassPath> added = this.listeners.isEmpty() ? null : new HashSet<ClassPath>();
            for (int i = 0; i < paths.length; ++i) {
                if (paths[i] == null) {
                    throw new NullPointerException("Null path encountered in " + Arrays.asList(paths) + " of type " + id);
                }
                if (added != null && !added.contains(paths[i]) && !l.contains(paths[i])) {
                    added.add(paths[i]);
                }
                if (!l.contains(paths[i])) {
                    paths[i].addPropertyChangeListener(this.classpathListener);
                }
                l.add(paths[i]);
            }
            if (added != null && !added.isEmpty()) {
                _listeners = this.listeners.toArray(new GlobalPathRegistryListener[this.listeners.size()]);
                evt = new GlobalPathRegistryEvent(this, id, Collections.unmodifiableSet(added));
            }
            this.resetSourceRootsCache();
        }
        if (_listeners != null) {
            if (!$assertionsDisabled && evt == null) {
                throw new AssertionError();
            }
            for (int i = 0; i < _listeners.length; ++i) {
                _listeners[i].pathsAdded(evt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(String id, ClassPath[] paths) throws IllegalArgumentException {
        if (id == null || paths == null) {
            throw new NullPointerException();
        }
        GlobalPathRegistryEvent evt = null;
        GlobalPathRegistryListener[] _listeners = null;
        GlobalPathRegistry globalPathRegistry = this;
        synchronized (globalPathRegistry) {
            ArrayList l = (ArrayList)this.paths.get(id);
            if (l == null) {
                l = new ArrayList();
            }
            ArrayList l2 = new ArrayList(l);
            HashSet<ClassPath> removed = this.listeners.isEmpty() ? null : new HashSet<ClassPath>();
            for (int i = 0; i < paths.length; ++i) {
                if (paths[i] == null) {
                    throw new NullPointerException();
                }
                if (!l2.remove(paths[i])) {
                    throw new IllegalArgumentException("Attempt to remove nonexistent path " + paths[i]);
                }
                if (removed != null && !removed.contains(paths[i]) && !l2.contains(paths[i])) {
                    removed.add(paths[i]);
                }
                if (l2.contains(paths[i])) continue;
                paths[i].removePropertyChangeListener(this.classpathListener);
            }
            this.paths.put(id, l2);
            if (removed != null && !removed.isEmpty()) {
                _listeners = this.listeners.toArray(new GlobalPathRegistryListener[this.listeners.size()]);
                evt = new GlobalPathRegistryEvent(this, id, Collections.unmodifiableSet(removed));
            }
            this.resetSourceRootsCache();
        }
        if (_listeners != null) {
            if (!$assertionsDisabled && evt == null) {
                throw new AssertionError();
            }
            for (int i = 0; i < _listeners.length; ++i) {
                _listeners[i].pathsRemoved(evt);
            }
        }
    }

    public synchronized void addGlobalPathRegistryListener(GlobalPathRegistryListener l) {
        if (l == null) {
            throw new NullPointerException();
        }
        this.listeners.add(l);
    }

    public synchronized void removeGlobalPathRegistryListener(GlobalPathRegistryListener l) {
        if (l == null) {
            throw new NullPointerException();
        }
        this.listeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getSourceRoots() {
        LinkedHashSet compileAndBootPaths;
        Set sourcePaths;
        int currentResetCount;
        GlobalPathRegistry globalPathRegistry = this;
        synchronized (globalPathRegistry) {
            if (this.sourceRoots != null) {
                return this.sourceRoots;
            }
            currentResetCount = this.resetCount;
            sourcePaths = this.getPaths("classpath/source");
            compileAndBootPaths = new LinkedHashSet(this.getPaths("classpath/compile"));
            compileAndBootPaths.addAll(this.getPaths("classpath/boot"));
        }
        Set<FileObject> newSourceRoots = new LinkedHashSet<FileObject>();
        Iterator it = sourcePaths.iterator();
        while (it.hasNext()) {
            ClassPath sp = (ClassPath)it.next();
            newSourceRoots.addAll(Arrays.asList(sp.getRoots()));
        }
        LinkedList<SourceForBinaryQuery.Result> newResults = new LinkedList<SourceForBinaryQuery.Result>();
        SFBQListener tmpResultListener = new SFBQListener();
        it = compileAndBootPaths.iterator();
        while (it.hasNext()) {
            ClassPath cp = (ClassPath)it.next();
            Iterator it2 = cp.entries().iterator();
            while (it2.hasNext()) {
                ClassPath.Entry entry = (ClassPath.Entry)it2.next();
                SourceForBinaryQuery.Result result = SourceForBinaryQuery.findSourceRoots(entry.getURL());
                result.addChangeListener(tmpResultListener);
                newResults.add(result);
                FileObject[] someRoots = result.getRoots();
                newSourceRoots.addAll(Arrays.asList(someRoots));
            }
        }
        newSourceRoots = Collections.unmodifiableSet(newSourceRoots);
        GlobalPathRegistry globalPathRegistry2 = this;
        synchronized (globalPathRegistry2) {
            if (this.resetCount == currentResetCount) {
                this.sourceRoots = newSourceRoots;
                this.removeTmpSFBQListeners(newResults, tmpResultListener, true);
                this.results.addAll(newResults);
            } else {
                this.removeTmpSFBQListeners(newResults, tmpResultListener, false);
            }
            return newSourceRoots;
        }
    }

    private void removeTmpSFBQListeners(List results, ChangeListener listener, boolean addListener) {
        Iterator it = results.iterator();
        while (it.hasNext()) {
            SourceForBinaryQuery.Result res = (SourceForBinaryQuery.Result)it.next();
            if (addListener) {
                res.addChangeListener(this.resultListener);
            }
            res.removeChangeListener(listener);
        }
    }

    public FileObject findResource(String resource) {
        Iterator it = this.getSourceRoots().iterator();
        while (it.hasNext()) {
            FileObject root = (FileObject)it.next();
            FileObject f = root.getFileObject(resource);
            if (f == null) continue;
            return f;
        }
        return null;
    }

    private synchronized void resetSourceRootsCache() {
        this.sourceRoots = null;
        Iterator it = this.results.iterator();
        while (it.hasNext()) {
            SourceForBinaryQuery.Result result = (SourceForBinaryQuery.Result)it.next();
            result.removeChangeListener(this.resultListener);
        }
        ++this.resetCount;
    }

    static {
        $assertionsDisabled = !GlobalPathRegistry.class.desiredAssertionStatus();
        DEFAULT = new GlobalPathRegistry();
    }

    private class SFBQListener
    implements ChangeListener {
        private SFBQListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stateChanged(ChangeEvent event) {
            GlobalPathRegistry globalPathRegistry = GlobalPathRegistry.this;
            synchronized (globalPathRegistry) {
                GlobalPathRegistry.this.resetSourceRootsCache();
            }
        }
    }
}

