/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.queries;

import java.net.URL;
import java.util.Iterator;
import org.netbeans.spi.java.queries.MultipleRootsUnitTestForSourceQueryImplementation;
import org.netbeans.spi.java.queries.UnitTestForSourceQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public class UnitTestForSourceQuery {
    private static final Lookup.Result implementations = Lookup.getDefault().lookup(new Lookup.Template(UnitTestForSourceQueryImplementation.class));
    private static final Lookup.Result mrImplementations = Lookup.getDefault().lookup(new Lookup.Template(MultipleRootsUnitTestForSourceQueryImplementation.class));

    private UnitTestForSourceQuery() {
    }

    public static URL findUnitTest(FileObject source) {
        URL[] result = UnitTestForSourceQuery.findUnitTests(source);
        return result.length == 0 ? null : result[0];
    }

    public static URL[] findUnitTests(FileObject source) {
        Object query;
        if (source == null) {
            throw new IllegalArgumentException("Parameter source cannot be null");
        }
        Iterator it = implementations.allInstances().iterator();
        while (it.hasNext()) {
            query = (MultipleRootsUnitTestForSourceQueryImplementation)it.next();
            URL[] urls = query.findUnitTests(source);
            if (urls == null) continue;
            return urls;
        }
        it = implementations.allInstances().iterator();
        while (it.hasNext()) {
            query = (UnitTestForSourceQueryImplementation)it.next();
            URL u = query.findUnitTest(source);
            if (u == null) continue;
            return new URL[]{u};
        }
        return new URL[0];
    }

    public static URL findSource(FileObject unitTest) {
        URL[] result = UnitTestForSourceQuery.findSources(unitTest);
        return result.length == 0 ? null : result[0];
    }

    public static URL[] findSources(FileObject unitTest) {
        Object query;
        if (unitTest == null) {
            throw new IllegalArgumentException("Parameter unitTest cannot be null");
        }
        Iterator it = mrImplementations.allInstances().iterator();
        while (it.hasNext()) {
            query = (MultipleRootsUnitTestForSourceQueryImplementation)it.next();
            URL[] urls = query.findSources(unitTest);
            if (urls == null) continue;
            return urls;
        }
        it = implementations.allInstances().iterator();
        while (it.hasNext()) {
            query = (UnitTestForSourceQueryImplementation)it.next();
            URL u = query.findSource(unitTest);
            if (u == null) continue;
            return new URL[]{u};
        }
        return new URL[0];
    }
}

