/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.filebasedfs;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.masterfs.filebasedfs.Statistics;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.FileObjectFactory;
import org.netbeans.modules.masterfs.filebasedfs.utils.FileInfo;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.actions.SystemAction;

public final class FileBasedFileSystem
extends FileSystem {
    private static Map allInstances;
    private final FileObjectFactory factory;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static void reinitForTests() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileBasedFileSystem getInstance(File file) {
        FileBasedFileSystem retVal;
        FileInfo fInfo = new FileInfo(file);
        FileInfo rootInfo = fInfo.getRoot();
        Map map = allInstances;
        synchronized (map) {
            File rootFile = rootInfo.getFile();
            retVal = (FileBasedFileSystem)((Object)allInstances.get(rootFile));
            if (retVal == null && rootInfo.isConvertibleToFileObject()) {
                retVal = new FileBasedFileSystem(rootFile);
                allInstances.put(rootFile, retVal);
            }
        }
        return retVal;
    }

    public static final FileObject getFileObject(File file) {
        FileBasedFileSystem fs = FileBasedFileSystem.getInstance(file);
        return fs != null ? fs.findFileObject(file) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Collection getInstances() {
        Map map = allInstances;
        synchronized (map) {
            return new ArrayList(allInstances.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getSize() {
        Map map = allInstances;
        synchronized (map) {
            return allInstances.size();
        }
    }

    private FileBasedFileSystem(File rootFile) {
        this.factory = FileObjectFactory.getInstance(new FileInfo(rootFile));
    }

    public final FileObject findResource(String name) {
        File f = new File(name);
        if (!$assertionsDisabled && !f.getAbsolutePath().replace('\\', '/').equals(name.replace('\\', '/'))) {
            throw new AssertionError((Object)(name + " versus " + f.getAbsolutePath()));
        }
        return this.findFileObject(f);
    }

    public final FileObject findFileObject(File f) {
        return this.findFileObject(new FileInfo(f));
    }

    public final FileObject findFileObject(FileInfo fInfo) {
        FileObject retVal;
        boolean issue45485;
        File f = fInfo.getFile();
        boolean bl = issue45485 = fInfo.isWindows() && f.getName().endsWith(".");
        if (issue45485) {
            File f2 = FileUtil.normalizeFile((File)f);
            boolean bl2 = issue45485 = !f2.getName().endsWith(".");
            if (issue45485) {
                return null;
            }
        }
        return (retVal = this.getFactory().findFileObject(fInfo)) != null && retVal.isValid() ? retVal : null;
    }

    public final FileObject getRoot() {
        return this.getFactory().getRoot();
    }

    public final String getDisplayName() {
        return this.getFactory().getRoot().getRealRoot().getPath();
    }

    public final SystemAction[] getActions() {
        return new SystemAction[0];
    }

    public final SystemAction[] getActions(Set foSet) {
        return new SystemAction[0];
    }

    public final void refresh(boolean expected) {
        Statistics.StopWatch stopWatch = Statistics.getStopWatch(Statistics.REFRESH_FS);
        stopWatch.start();
        this.getFactory().refreshAll(expected);
        stopWatch.stop();
        ErrorManager.getDefault().getInstance("org.netbeans.modules.masterfs.REFRESH").log("FS.refresh statistics (" + Statistics.fileObjects() + "FileObjects):\n  " + Statistics.REFRESH_FS.toString() + "\n  " + Statistics.LISTENERS_CALLS.toString() + "\n  " + Statistics.REFRESH_FOLDER.toString() + "\n  " + Statistics.REFRESH_FILE.toString() + "\n");
        Statistics.REFRESH_FS.reset();
        Statistics.LISTENERS_CALLS.reset();
        Statistics.REFRESH_FOLDER.reset();
        Statistics.REFRESH_FILE.reset();
    }

    public final boolean isReadOnly() {
        return false;
    }

    public final String toString() {
        return this.getDisplayName();
    }

    public final FileObjectFactory getFactory() {
        return this.factory;
    }

    static {
        $assertionsDisabled = !FileBasedFileSystem.class.desiredAssertionStatus();
        allInstances = new HashMap();
    }
}

