/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.refactoring;

import java.io.IOException;
import javax.jmi.reflect.RefObject;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaPackage;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.layers.LayerUtils;
import org.netbeans.modules.apisupport.refactoring.AbstractRefactoringElement;
import org.netbeans.modules.apisupport.refactoring.AbstractRefactoringPlugin;
import org.netbeans.modules.apisupport.refactoring.Utility;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.ExternalChange;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class NbRenameRefactoringPlugin
extends AbstractRefactoringPlugin {
    private static ThreadLocal semafor = new ThreadLocal();
    private RenameRefactoring rename;
    static /* synthetic */ Class class$org$netbeans$modules$apisupport$refactoring$NbRenameRefactoringPlugin;

    public NbRenameRefactoringPlugin(AbstractRefactoring refactoring) {
        super(refactoring);
    }

    public void cancelRequest() {
    }

    public Problem fastCheckParameters() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Problem prepare(RefactoringElementsBag refactoringElements) {
        if (semafor.get() != null) {
            return null;
        }
        semafor.set(new Object());
        try {
            JavaPackage pack;
            JavaClass clzz;
            Resource res;
            FileObject fo;
            Project project;
            this.rename = (RenameRefactoring)this.refactoring;
            Problem problem = null;
            RefObject refObject = (RefObject)this.rename.getRefactoredObject();
            if (refObject instanceof JavaClass && (project = FileOwnerQuery.getOwner((FileObject)(fo = JavaModel.getFileObject((Resource)(res = (clzz = (JavaClass)refObject).getResource()))))) != null && project instanceof NbModuleProject) {
                this.checkMetaInfServices(project, clzz, refactoringElements);
                this.checkManifest((NbModuleProject)project, clzz, refactoringElements);
                this.checkLayer((NbModuleProject)project, clzz, refactoringElements);
            }
            if (refObject instanceof JavaPackage && (fo = JavaModel.getFileObject((Resource)(res = (pack = (JavaPackage)refObject).getResource()))) != null && (project = FileOwnerQuery.getOwner((FileObject)fo)) != null && project instanceof NbModuleProject) {
                this.checkMetaInfServices(project, pack, refactoringElements);
            }
            if (refObject instanceof Method) {
                Method method = (Method)refObject;
                problem = this.checkLayer(method, refactoringElements);
            }
            err.log("Gonna return problem: " + problem);
            Problem problem2 = problem;
            return problem2;
        }
        finally {
            semafor.set(null);
        }
    }

    protected RefactoringElementImplementation createManifestRefactoring(JavaClass clazz, FileObject manifestFile, String attributeKey, String attributeValue, String section) {
        return new ManifestRenameRefactoringElement(clazz, manifestFile, attributeValue, attributeKey, section);
    }

    protected RefactoringElementImplementation createMetaInfServicesRefactoring(JavaClass clazz, FileObject serviceFile, int line) {
        return new ServicesRenameRefactoringElement(clazz, serviceFile);
    }

    protected final void checkMetaInfServices(Project project, JavaPackage pack, RefactoringElementsBag refactoringElements) {
        FileObject services = Utility.findMetaInfServices(project);
        if (services == null) {
            return;
        }
        String name = pack.getName();
        FileObject[] files = services.getChildren();
        for (int i = 0; i < files.length; ++i) {
            ServicesPackageRenameRefactoringElement elem;
            int line = this.checkContentOfFile(files[i], name);
            if (line == -1 || (elem = new ServicesPackageRenameRefactoringElement(pack, files[i])) == null) continue;
            refactoringElements.add(this.refactoring, (RefactoringElementImplementation)elem);
        }
    }

    protected RefactoringElementImplementation createLayerRefactoring(Constructor constructor, LayerUtils.LayerHandle handle, FileObject layerFileObject, String layerAttribute) {
        return null;
    }

    protected RefactoringElementImplementation createLayerRefactoring(JavaClass clazz, LayerUtils.LayerHandle handle, FileObject layerFileObject, String layerAttribute) {
        return new LayerClassRefactoringElement(clazz, handle, layerFileObject, layerAttribute);
    }

    protected RefactoringElementImplementation createLayerRefactoring(Method method, LayerUtils.LayerHandle handle, FileObject layerFileObject, String layerAttribute) {
        return new LayerMethodRefactoringElement(method, handle, layerFileObject, layerAttribute);
    }

    public final class ServicesPackageRenameRefactoringElement
    extends AbstractRefactoringElement {
        private JavaPackage pack;
        private String oldName;

        public ServicesPackageRenameRefactoringElement(JavaPackage pack, FileObject file) {
            this.name = pack.getName();
            this.parentFile = file;
            this.pack = pack;
            this.oldName = pack.getName();
        }

        public String getDisplayText() {
            return NbBundle.getMessage((Class)(class$org$netbeans$modules$apisupport$refactoring$NbRenameRefactoringPlugin == null ? (class$org$netbeans$modules$apisupport$refactoring$NbRenameRefactoringPlugin = NbRenameRefactoringPlugin.class$("org.netbeans.modules.apisupport.refactoring.NbRenameRefactoringPlugin")) : class$org$netbeans$modules$apisupport$refactoring$NbRenameRefactoringPlugin), (String)"TXT_ServicesPackageRename", (Object)this.name);
        }

        public void performChange() {
            String content = Utility.readFileIntoString(this.parentFile);
            if (content != null) {
                String longName = this.oldName;
                String newName = this.pack.getName();
                longName = longName.replaceAll("[.]", "\\.");
                content = content.replaceAll("^" + longName, newName);
                Utility.writeFileFromString(this.parentFile, content);
            }
        }
    }

    public final class ServicesRenameRefactoringElement
    extends AbstractRefactoringElement
    implements ExternalChange {
        private JavaClass clazz;
        private String oldName;
        private String oldContent;
        private String newName;

        public ServicesRenameRefactoringElement(JavaClass clazz, FileObject file) {
            this.name = clazz.getSimpleName();
            this.parentFile = file;
            this.clazz = clazz;
            this.oldName = clazz.getName();
        }

        public String getDisplayText() {
            return NbBundle.getMessage((Class)(class$org$netbeans$modules$apisupport$refactoring$NbRenameRefactoringPlugin == null ? (class$org$netbeans$modules$apisupport$refactoring$NbRenameRefactoringPlugin = NbRenameRefactoringPlugin.class$("org.netbeans.modules.apisupport.refactoring.NbRenameRefactoringPlugin")) : class$org$netbeans$modules$apisupport$refactoring$NbRenameRefactoringPlugin), (String)"TXT_ServicesRename", (Object)this.name);
        }

        public void performChange() {
            JavaMetamodel.getManager().registerExtChange((ExternalChange)this);
        }

        public void performExternalChange() {
            String content;
            this.oldContent = content = Utility.readFileIntoString(this.parentFile);
            if (content != null) {
                String longName = this.oldName;
                if (this.newName == null) {
                    this.newName = this.clazz.getName();
                    this.clazz = null;
                }
                longName = longName.replaceAll("[.]", "\\.");
                content = content.replaceAll("^" + longName + "[ \\\n]?", this.newName + "\n");
                Utility.writeFileFromString(this.parentFile, content);
            }
        }

        public void undoExternalChange() {
            if (this.oldContent != null) {
                Utility.writeFileFromString(this.parentFile, this.oldContent);
            }
        }
    }

    public final class ManifestRenameRefactoringElement
    extends AbstractRefactoringElement
    implements ExternalChange {
        private JavaClass clazz;
        private String attrName;
        private String sectionName = null;
        private String oldName;
        private String oldContent;
        private String newName;

        public ManifestRenameRefactoringElement(JavaClass clazz, FileObject parentFile, String attributeValue, String attributeName) {
            this.name = attributeValue;
            this.clazz = clazz;
            this.parentFile = parentFile;
            this.attrName = attributeName;
            this.oldName = clazz.getName();
        }

        public ManifestRenameRefactoringElement(JavaClass clazz, FileObject parentFile, String attributeValue, String attributeName, String secName) {
            this(clazz, parentFile, attributeValue, attributeName);
            this.sectionName = secName;
        }

        public String getDisplayText() {
            if (this.sectionName != null) {
                return NbBundle.getMessage((Class)(class$org$netbeans$modules$apisupport$refactoring$NbRenameRefactoringPlugin == null ? (class$org$netbeans$modules$apisupport$refactoring$NbRenameRefactoringPlugin = NbRenameRefactoringPlugin.class$("org.netbeans.modules.apisupport.refactoring.NbRenameRefactoringPlugin")) : class$org$netbeans$modules$apisupport$refactoring$NbRenameRefactoringPlugin), (String)"TXT_ManifestSectionRename", (Object)this.name, (Object)this.sectionName);
            }
            return NbBundle.getMessage((Class)(class$org$netbeans$modules$apisupport$refactoring$NbRenameRefactoringPlugin == null ? (class$org$netbeans$modules$apisupport$refactoring$NbRenameRefactoringPlugin = NbRenameRefactoringPlugin.class$("org.netbeans.modules.apisupport.refactoring.NbRenameRefactoringPlugin")) : class$org$netbeans$modules$apisupport$refactoring$NbRenameRefactoringPlugin), (String)"TXT_ManifestRename", (Object)this.name, (Object)this.attrName);
        }

        public void performChange() {
            JavaMetamodel.getManager().registerExtChange((ExternalChange)this);
        }

        public void performExternalChange() {
            String content;
            this.oldContent = content = Utility.readFileIntoString(this.parentFile);
            if (content != null) {
                String longName = this.oldName;
                if (this.newName == null) {
                    this.newName = this.clazz.getName();
                    this.newName = this.newName.replace('.', '/') + ".class";
                    this.clazz = null;
                }
                longName = longName.replace('.', '/') + ".class";
                content = content.replaceAll(longName, this.newName);
                Utility.writeFileFromString(this.parentFile, content);
            }
        }

        public void undoExternalChange() {
            if (this.oldContent != null) {
                Utility.writeFileFromString(this.parentFile, this.oldContent);
            }
        }
    }

    public final class LayerClassRefactoringElement
    extends LayerAbstractRefactoringElement {
        private JavaClass clazz;
        private String newAttrName;
        private String newAttrValue;
        private String newFileName;

        public LayerClassRefactoringElement(JavaClass clzz, LayerUtils.LayerHandle handle, FileObject layerFile, String attributeName) {
            super(handle, layerFile, attributeName);
            this.clazz = clzz;
            if (this.oldAttrName == null) {
                this.newFileName = this.oldFileName.replaceAll("\\-" + this.clazz.getSimpleName() + "$", "-" + NbRenameRefactoringPlugin.this.rename.getNewName());
            } else if (this.oldAttrName.indexOf(this.clazz.getName().replace('.', '-') + ".instance") > 0) {
                this.newAttrName = this.oldAttrName.replaceAll("-" + this.clazz.getSimpleName() + "\\.", "-" + NbRenameRefactoringPlugin.this.rename.getNewName() + ".");
            } else if (this.oldAttrValue != null) {
                String toReplacePattern = this.clazz.getSimpleName();
                this.newAttrValue = this.oldAttrValue.replaceAll(toReplacePattern, NbRenameRefactoringPlugin.this.rename.getNewName());
            }
        }

        public String getDisplayText() {
            if (this.newFileName != null) {
                return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"TXT_LayerFileRename", (Object)this.oldFileName, (Object)NbRenameRefactoringPlugin.this.rename.getNewName());
            }
            return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"TXT_LayerMethodRename", (Object)this.oldAttrValue, (Object)NbRenameRefactoringPlugin.this.rename.getNewName());
        }

        public void performExternalChange() {
            if (this.newAttrValue != null) {
                this.doAttributeValueChange(this.newAttrValue, this.valueType);
            }
            if (this.newAttrName != null) {
                this.doAttributeMove(this.oldAttrName, this.newAttrName);
            }
            if (this.newFileName != null) {
                this.doFileMove(this.newFileName);
            }
        }

        public void undoExternalChange() {
            if (this.newAttrValue != null) {
                this.doAttributeValueChange(this.oldAttrValue, this.valueType);
            }
            if (this.newAttrName != null) {
                this.doAttributeMove(this.newAttrName, this.oldAttrName);
            }
            if (this.newFileName != null) {
                this.doFileMove(this.oldFileName);
            }
        }
    }

    public final class LayerMethodRefactoringElement
    extends LayerAbstractRefactoringElement {
        private Method method;
        private String newAttrValue;

        public LayerMethodRefactoringElement(Method method, LayerUtils.LayerHandle handle, FileObject layerFile, String attributeName) {
            super(handle, layerFile, attributeName);
            this.method = method;
            this.newAttrValue = this.oldAttrValue.replaceAll("\\." + method.getName() + "$", "." + NbRenameRefactoringPlugin.this.rename.getNewName());
        }

        public String getDisplayText() {
            return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"TXT_LayerMethodRename", (Object)this.oldAttrValue, (Object)NbRenameRefactoringPlugin.this.rename.getNewName());
        }

        public void performExternalChange() {
            this.doAttributeValueChange(this.newAttrValue, this.valueType);
        }

        public void undoExternalChange() {
            this.doAttributeValueChange(this.oldAttrValue, this.valueType);
        }
    }

    public abstract class LayerAbstractRefactoringElement
    extends AbstractRefactoringElement
    implements ExternalChange {
        protected FileObject layerFile;
        protected LayerUtils.LayerHandle handle;
        protected String oldFileName;
        protected String oldAttrName;
        protected String oldAttrValue;
        protected String valueType;

        public LayerAbstractRefactoringElement(LayerUtils.LayerHandle handle, FileObject layerFile, String attributeName) {
            this.layerFile = layerFile;
            this.parentFile = handle.getLayerFile();
            this.handle = handle;
            this.oldFileName = layerFile.getName();
            this.oldAttrName = attributeName;
            if (attributeName != null) {
                Object val = layerFile.getAttribute("literal:" + attributeName);
                if (val == null) {
                    throw new IllegalStateException();
                }
                if (val instanceof String) {
                    this.oldAttrValue = (String)val;
                    if (this.oldAttrValue.startsWith("new:")) {
                        this.oldAttrValue = ((String)val).substring("new:".length());
                        this.valueType = "newvalue:";
                    } else if (this.oldAttrValue.startsWith("method:")) {
                        this.oldAttrValue = ((String)val).substring("method:".length());
                        this.valueType = "methodvalue:";
                    }
                }
            }
        }

        public void performChange() {
            JavaMetamodel.getManager().registerExtChange((ExternalChange)this);
        }

        protected void doAttributeValueChange(String newOne, String type) {
            boolean on = this.handle.isAutosave();
            if (!on) {
                this.handle.setAutosave(true);
            }
            try {
                this.layerFile.setAttribute(this.oldAttrName, (Object)((type != null ? type : "") + newOne));
            }
            catch (IOException exc) {
                ErrorManager.getDefault().notify((Throwable)exc);
            }
            if (!on) {
                this.handle.setAutosave(false);
            }
        }

        protected void doAttributeMove(String oldKey, String newKey) {
            boolean on = this.handle.isAutosave();
            if (!on) {
                this.handle.setAutosave(true);
            }
            try {
                Object obj = this.layerFile.getAttribute(oldKey);
                this.layerFile.setAttribute(oldKey, null);
                this.layerFile.setAttribute(newKey, obj);
            }
            catch (IOException exc) {
                ErrorManager.getDefault().notify((Throwable)exc);
            }
            if (!on) {
                this.handle.setAutosave(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doFileMove(String newName) {
            boolean on = this.handle.isAutosave();
            if (!on) {
                this.handle.setAutosave(true);
            }
            FileLock lock = null;
            try {
                lock = this.layerFile.lock();
                this.layerFile.rename(lock, newName, this.layerFile.getExt());
            }
            catch (IOException exc) {
                ErrorManager.getDefault().notify((Throwable)exc);
            }
            finally {
                if (lock != null) {
                    lock.releaseLock();
                }
            }
            if (!on) {
                this.handle.setAutosave(false);
            }
        }
    }
}

