/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans.beaninfo;

import java.io.IOException;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.java.JavaEditor;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

public final class BeanInfoSource {
    private static final String BEANINFO_NAME_EXT = "BeanInfo";
    private static final String DESCRIPTOR_SECTION = "BeanDescriptor";
    private static final String PROPERTIES_SECTION = "Properties";
    private static final String EVENTSETS_SECTION = "Events";
    private static final String ICONS_SECTION = "Icons";
    private static final String IDX_SECTION = "Idx";
    private static final String METHODS_SECTION = "Methods";
    private static final String SUPERCLASS_SECTION = "Superclass";
    private JavaClass classElement;
    private DataObject biDataObject = null;
    private JavaEditor javaEditor = null;

    public BeanInfoSource(JavaClass classElement) {
        this.classElement = classElement;
        this.findBeanInfo();
    }

    boolean exists() {
        return this.biDataObject != null;
    }

    boolean isNbBeanInfo() {
        if (!this.exists() || this.javaEditor == null) {
            return false;
        }
        JavaEditor.InteriorSection pis = this.javaEditor.findInteriorSection(PROPERTIES_SECTION);
        JavaEditor.InteriorSection eis = this.javaEditor.findInteriorSection(EVENTSETS_SECTION);
        JavaEditor.SimpleSection dss = this.javaEditor.findSimpleSection(IDX_SECTION);
        return pis != null && eis != null && dss != null;
    }

    boolean hasIconInfo() {
        JavaEditor.SimpleSection iss = this.javaEditor.findSimpleSection(ICONS_SECTION);
        return iss != null;
    }

    boolean isNbBeanInfoDescriptor() {
        if (!this.exists() || this.javaEditor == null) {
            return false;
        }
        JavaEditor.InteriorSection dis = this.javaEditor.findInteriorSection(DESCRIPTOR_SECTION);
        return dis != null;
    }

    boolean isNbSuperclass() {
        if (!this.exists() || this.javaEditor == null) {
            return false;
        }
        JavaEditor.InteriorSection dis = this.javaEditor.findInteriorSection(SUPERCLASS_SECTION);
        return dis != null;
    }

    void findBeanInfo() {
        this.javaEditor = null;
        Resource sc = this.classElement.getResource();
        if (sc == null) {
            return;
        }
        DataObject dataObject = JavaMetamodel.getManager().getDataObject(sc);
        if (dataObject == null) {
            return;
        }
        FileObject folder = dataObject.getFolder().getPrimaryFile();
        if (folder == null) {
            return;
        }
        FileObject biFile = folder.getFileObject(dataObject.getName() + BEANINFO_NAME_EXT, "java");
        if (biFile == null) {
            return;
        }
        try {
            this.biDataObject = DataObject.find((FileObject)biFile);
            this.javaEditor = (JavaEditor)this.biDataObject.getCookie(JavaEditor.class);
        }
        catch (DataObjectNotFoundException e) {
            // empty catch block
        }
    }

    void delete() throws IOException {
        this.biDataObject.delete();
    }

    void createFromTemplate(boolean iconBlock) {
        FileObject foTemplates = Repository.getDefault().getDefaultFileSystem().findResource("Templates");
        if (foTemplates == null) {
            return;
        }
        FileObject foClassTemplates = foTemplates.getFileObject("Beans");
        if (foClassTemplates == null) {
            return;
        }
        FileObject foBiTemplate = null;
        foBiTemplate = iconBlock ? foClassTemplates.getFileObject(BEANINFO_NAME_EXT, "java") : foClassTemplates.getFileObject("BeanInfoNoIcon", "java");
        if (foBiTemplate == null) {
            return;
        }
        try {
            DataObject doBiTemplate = DataObject.find((FileObject)foBiTemplate);
            Resource sc = this.classElement.getResource();
            if (sc == null) {
                return;
            }
            DataObject dataObject = JavaMetamodel.getManager().getDataObject(sc);
            if (dataObject == null) {
                return;
            }
            DataFolder folder = dataObject.getFolder();
            this.biDataObject = doBiTemplate.createFromTemplate(folder, dataObject.getName() + BEANINFO_NAME_EXT);
            this.javaEditor = (JavaEditor)this.biDataObject.getCookie(JavaEditor.class);
        }
        catch (DataObjectNotFoundException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    DataObject getDataObject() {
        return this.biDataObject;
    }

    void open() {
        this.javaEditor.open();
    }

    void setDescriptorSection(String header, String bottom) {
        JavaEditor.InteriorSection is = this.javaEditor.findInteriorSection(DESCRIPTOR_SECTION);
        if (is != null) {
            is.setHeader(header);
            is.setBottom(bottom);
        }
    }

    String getDescriptorSection() {
        JavaEditor.InteriorSection is = this.javaEditor.findInteriorSection(DESCRIPTOR_SECTION);
        if (is != null) {
            return is.getText();
        }
        return null;
    }

    void setPropertiesSection(String header, String bottom) {
        JavaEditor.InteriorSection is = this.javaEditor.findInteriorSection(PROPERTIES_SECTION);
        if (is != null) {
            is.setHeader(header);
            is.setBottom(bottom);
        }
    }

    String getPropertiesSection() {
        JavaEditor.InteriorSection is = this.javaEditor.findInteriorSection(PROPERTIES_SECTION);
        if (is != null) {
            return is.getText();
        }
        return null;
    }

    void setMethodsSection(String header, String bottom) {
        JavaEditor.InteriorSection is = this.javaEditor.findInteriorSection(METHODS_SECTION);
        if (is != null) {
            is.setHeader(header);
            is.setBottom(bottom);
        }
    }

    String getMethodsSection() {
        JavaEditor.InteriorSection is = this.javaEditor.findInteriorSection(METHODS_SECTION);
        if (is != null) {
            return is.getText();
        }
        return null;
    }

    void setEventSetsSection(String header, String bottom) {
        JavaEditor.InteriorSection is = this.javaEditor.findInteriorSection(EVENTSETS_SECTION);
        if (is != null) {
            is.setHeader(header);
            is.setBottom(bottom);
        }
    }

    String getEventSetsSection() {
        JavaEditor.InteriorSection is = this.javaEditor.findInteriorSection(EVENTSETS_SECTION);
        if (is != null) {
            return is.getText();
        }
        return null;
    }

    String getIconsSection() {
        JavaEditor.SimpleSection ss = this.javaEditor.findSimpleSection(ICONS_SECTION);
        if (ss != null) {
            return ss.getText();
        }
        return null;
    }

    void setIconsSection(String text) {
        JavaEditor.SimpleSection ss = this.javaEditor.findSimpleSection(ICONS_SECTION);
        if (ss != null) {
            ss.setText(text);
        }
    }

    String getDefaultIdxSection() {
        JavaEditor.SimpleSection ss = this.javaEditor.findSimpleSection(IDX_SECTION);
        if (ss != null) {
            return ss.getText();
        }
        return null;
    }

    void setDefaultIdxSection(String text) {
        JavaEditor.SimpleSection ss = this.javaEditor.findSimpleSection(IDX_SECTION);
        if (ss != null) {
            ss.setText(text);
        }
    }

    void setSuperclassSection(String header, String bottom) {
        JavaEditor.InteriorSection is = this.javaEditor.findInteriorSection(SUPERCLASS_SECTION);
        if (is != null) {
            is.setHeader(header);
            is.setBottom(bottom);
        }
    }

    String getSuperclassSection() {
        JavaEditor.InteriorSection is = this.javaEditor.findInteriorSection(SUPERCLASS_SECTION);
        if (is != null) {
            return is.getText();
        }
        return null;
    }
}

