/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans.beaninfo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyEditorSupport;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

class BiIconEditor
extends PropertyEditorSupport {
    private static final String BEAN_ICONEDITOR_HELP = "beans.icon";
    private FileObject sourceFileObject;
    static ResourceBundle bundle = NbBundle.getBundle((Class)BiIconEditor.class);
    static /* synthetic */ Class class$org$openide$loaders$DataObject;

    public static boolean isImage(String s) {
        return (s = s.toLowerCase()).endsWith(".jpg") || s.endsWith(".gif") || s.endsWith(".jpeg") || s.endsWith(".jpe") || s.equals("jpg") || s.equals("gif") || s.equals("jpeg") || s.equals("jpe");
    }

    public BiIconEditor(FileObject sourceFileObject) {
        this.sourceFileObject = sourceFileObject;
    }

    public String getSourceName() {
        if (this.getValue() instanceof BiImageIcon) {
            return ((BiImageIcon)this.getValue()).getName();
        }
        return null;
    }

    public String getAsText() {
        Object val = this.getValue();
        if (val == null) {
            return "null";
        }
        if (val instanceof BiImageIcon) {
            BiImageIcon ii = (BiImageIcon)val;
            return ii.getName();
        }
        return null;
    }

    public void setAsText(String string) throws IllegalArgumentException {
        try {
            this.setValue(this.iconFromText(string));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private BiImageIcon iconFromText(String string) throws IllegalArgumentException {
        BiImageIcon ii;
        try {
            if (string.length() == 0 || string.equals("null")) {
                ii = null;
            } else {
                ClassPath cp = ClassPath.getClassPath((FileObject)this.sourceFileObject, (String)"classpath/source");
                URL url = cp.findResource(string.substring(1)).getURL();
                ii = new BiImageIcon(url, string);
            }
        }
        catch (Throwable e) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                e.printStackTrace();
            }
            throw new IllegalArgumentException(e.toString());
        }
        return ii;
    }

    public boolean isPaintable() {
        return false;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        return new IconPanel();
    }

    private static class ResourceSelector
    extends JPanel
    implements ExplorerManager.Provider {
        private ExplorerManager manager = new ExplorerManager();

        public ResourceSelector(Node root) {
            this.setLayout(new BorderLayout(0, 5));
            this.setBorder(new EmptyBorder(12, 12, 0, 11));
            this.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_ResourceSelector"));
            this.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_ResourceSelector"));
            this.manager.setRootContext(root);
            BeanTreeView tree = new BeanTreeView();
            tree.setPopupAllowed(false);
            tree.setDefaultActionAllowed(false);
            tree.setBorder((Border)UIManager.get("Nb.ScrollPane.border"));
            tree.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_ResourceSelectorView"));
            tree.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_ResourceSelectorView"));
            this.add((Component)tree, "Center");
        }

        public Dimension getPreferredSize() {
            Dimension dim = super.getPreferredSize();
            dim.height = Math.max(dim.height, Utilities.getUsableScreenBounds().height / 2);
            return dim;
        }

        public Node[] getNodes() {
            return this.manager.getSelectedNodes();
        }

        public ExplorerManager getExplorerManager() {
            return this.manager;
        }
    }

    private static class RootNode
    extends FilterNode {
        RootNode(Node node, String displayName) {
            super(node);
            if (displayName != null) {
                this.disableDelegation(12);
                this.setDisplayName(displayName);
            }
        }
    }

    class IconPanel
    extends JPanel
    implements EnhancedCustomPropertyEditor {
        JRadioButton rbClasspath;
        JRadioButton rbNoPicture;
        JTextField tfName;
        JButton bSelect;
        JScrollPane spImage;
        static final long serialVersionUID = -6904264999063788703L;

        IconPanel() {
            this.setLayout(new BorderLayout(6, 6));
            this.setBorder(new EmptyBorder(6, 6, 6, 6));
            this.getAccessibleContext().setAccessibleName(bundle.getString("ACS_IconPanelA11yName"));
            this.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_IconPanelA11yDesc"));
            JPanel p = new JPanel(new BorderLayout(3, 3));
            JPanel p1 = new JPanel(new BorderLayout());
            p1.setBorder(new TitledBorder(new EtchedBorder(), bundle.getString("CTL_ImageSourceType")));
            JPanel p2 = new JPanel();
            p2.setBorder(new EmptyBorder(0, 3, 0, 3));
            GridBagLayout l = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            p2.setLayout(l);
            c.anchor = 17;
            this.rbClasspath = new JRadioButton(bundle.getString("CTL_Classpath"));
            p2.add(this.rbClasspath);
            this.rbClasspath.setToolTipText(bundle.getString("ACS_ClasspathA11yDesc"));
            this.rbClasspath.setMnemonic(bundle.getString("CTL_Classpath_Mnemonic").charAt(0));
            c.gridwidth = 1;
            l.setConstraints(this.rbClasspath, c);
            JLabel lab = new JLabel(bundle.getString("CTL_ClasspathExample"));
            p2.add(lab);
            lab.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_ClasspathExampleA11yDesc"));
            c.gridwidth = 0;
            l.setConstraints(lab, c);
            this.rbNoPicture = new JRadioButton(bundle.getString("CTL_NoPicture"));
            p2.add(this.rbNoPicture);
            this.rbNoPicture.setToolTipText(bundle.getString("ACS_NoPictureA11yDesc"));
            this.rbNoPicture.setMnemonic(bundle.getString("CTL_NoPicture_Mnemonic").charAt(0));
            c.gridwidth = 1;
            l.setConstraints(this.rbNoPicture, c);
            lab = new JLabel(bundle.getString("CTL_Null"));
            p2.add(lab);
            lab.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_NullA11yDesc"));
            c.gridwidth = 0;
            l.setConstraints(lab, c);
            ButtonGroup bg = new ButtonGroup();
            bg.add(this.rbClasspath);
            bg.add(this.rbNoPicture);
            this.rbClasspath.setSelected(true);
            p1.add((Component)p2, "West");
            p.add((Component)p1, "North");
            p1 = new JPanel(new BorderLayout(6, 6));
            JLabel nameLabel = new JLabel(bundle.getString("CTL_ImageSourceName"));
            nameLabel.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_ImageSourceNameA11yDesc"));
            nameLabel.setDisplayedMnemonic(bundle.getString("CTL_ImageSourceName_Mnemonic").charAt(0));
            p1.add((Component)nameLabel, "West");
            this.tfName = new JTextField();
            p1.add((Component)this.tfName, "Center");
            nameLabel.setLabelFor(this.tfName);
            this.tfName.getAccessibleContext().setAccessibleName(bundle.getString("ACS_ImageSourceNameTextFieldA11yName"));
            this.tfName.setToolTipText(bundle.getString("ACS_ImageSourceNameTextFieldA11yDesc"));
            this.bSelect = new JButton("...");
            p1.add((Component)this.bSelect, "East");
            this.bSelect.getAccessibleContext().setAccessibleName(bundle.getString("ACS_ImageSourceNameBrowseButtonA11yName"));
            this.bSelect.setToolTipText(bundle.getString("ACS_ImageSourceNameBrowseButtonA11yDesc"));
            this.bSelect.setEnabled(false);
            p.add((Component)p1, "South");
            this.add((Component)p, "North");
            this.spImage = new JScrollPane(){

                public Dimension getPreferredSize() {
                    return new Dimension(60, 60);
                }
            };
            this.add((Component)this.spImage, "Center");
            this.tfName.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    IconPanel.this.setValue();
                }
            });
            this.rbClasspath.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    IconPanel.this.bSelect.setEnabled(true);
                    IconPanel.this.tfName.setEnabled(true);
                    IconPanel.this.setValue();
                }
            });
            this.rbNoPicture.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    IconPanel.this.bSelect.setEnabled(false);
                    IconPanel.this.tfName.setEnabled(false);
                    BiIconEditor.this.setValue(null);
                    IconPanel.this.updateIcon();
                }
            });
            this.bSelect.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String name;
                    if (IconPanel.this.rbClasspath.isSelected() && (name = IconPanel.this.selectResource()) != null) {
                        IconPanel.this.tfName.setText("/" + name);
                        IconPanel.this.setValue();
                    }
                }
            });
            this.updateIcon();
            HelpCtx.setHelpIDString((JComponent)this, (String)BiIconEditor.BEAN_ICONEDITOR_HELP);
            Icon i = (Icon)BiIconEditor.this.getValue();
            if (i == null) {
                this.rbNoPicture.setSelected(true);
                this.bSelect.setEnabled(false);
                this.tfName.setEnabled(false);
                return;
            }
            if (!(i instanceof BiImageIcon)) {
                return;
            }
            this.rbClasspath.setSelected(true);
            this.bSelect.setEnabled(true);
            this.tfName.setText(((BiImageIcon)i).getName());
        }

        void updateIcon() {
            Icon i = (Icon)BiIconEditor.this.getValue();
            this.spImage.setViewportView(i == null ? new JLabel() : new JLabel(i));
            this.validate();
        }

        void setValue() {
            String val = this.tfName.getText();
            val.trim();
            if ("".equals(val)) {
                BiIconEditor.this.setValue(null);
                return;
            }
            try {
                BiIconEditor.this.setValue(BiIconEditor.this.iconFromText(val));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.updateIcon();
        }

        public Object getPropertyValue() throws IllegalStateException {
            BiImageIcon ii = null;
            String s = this.tfName.getText().trim();
            try {
                if (this.rbClasspath.isSelected() && s.length() != 0) {
                    ClassPath cp = ClassPath.getClassPath((FileObject)BiIconEditor.this.sourceFileObject, (String)"classpath/source");
                    FileObject f = cp.findResource(s.substring(1));
                    try {
                        ii = new BiImageIcon(f.getURL(), s);
                    }
                    catch (Throwable t) {
                        MessageFormat message = new MessageFormat(bundle.getString("CTL_Icon_not_exists"));
                        Object[] form = new Object[]{s};
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message.format(form), 0));
                    }
                }
            }
            catch (Exception e) {
                if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                    e.printStackTrace();
                }
                throw new IllegalStateException(e.toString());
            }
            BiIconEditor.this.setValue(ii);
            return ii;
        }

        private List getRoots(ClassPath cp) {
            ArrayList<FileObject> list = new ArrayList<FileObject>(cp.entries().size());
            Iterator eit = cp.entries().iterator();
            while (eit.hasNext()) {
                ClassPath.Entry e = (ClassPath.Entry)eit.next();
                URL url = e.getURL();
                SourceForBinaryQuery.Result r = SourceForBinaryQuery.findSourceRoots((URL)url);
                FileObject[] fos = r.getRoots();
                if (fos.length > 0) {
                    for (int i = 0; i < fos.length; ++i) {
                        list.add(fos[i]);
                    }
                    continue;
                }
                if (e.getRoot() == null) continue;
                list.add(e.getRoot());
            }
            return list;
        }

        private String rootDisplayName(FileObject fo) {
            return FileUtil.getFileDisplayName((FileObject)fo);
        }

        private String selectResource() {
            FileObject fob;
            DataObject dob;
            FileObject root;
            ClassPath executionClassPath = ClassPath.getClassPath((FileObject)BiIconEditor.this.sourceFileObject, (String)"classpath/execute");
            List roots = executionClassPath == null ? Collections.EMPTY_LIST : this.getRoots(executionClassPath);
            Node[] nodes = new Node[roots.size()];
            int selRoot = -1;
            try {
                ListIterator iter = roots.listIterator();
                while (iter.hasNext()) {
                    root = (FileObject)iter.next();
                    DataObject dob2 = DataObject.find((FileObject)root);
                    String displayName = this.rootDisplayName(root);
                    nodes[iter.previousIndex()] = new RootNode(dob2.getNodeDelegate(), displayName);
                }
            }
            catch (DataObjectNotFoundException donfex) {
                ErrorManager.getDefault().notify(4096, (Throwable)donfex);
                return null;
            }
            Children.Array children = new Children.Array();
            children.add(nodes);
            root = new AbstractNode((Children)children);
            root.setIconBaseWithExtension("org/netbeans/modules/beans/resources/iconResourceRoot.gif");
            root.setDisplayName(bundle.getString("CTL_ClassPathName"));
            ResourceSelector selector = new ResourceSelector((Node)root);
            DialogDescriptor dd = new DialogDescriptor((Object)selector, bundle.getString("CTL_OpenDialogName"));
            Object res = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
            nodes = res == DialogDescriptor.OK_OPTION ? selector.getNodes() : null;
            String name = null;
            if (nodes != null && nodes.length == 1 && (dob = (DataObject)nodes[0].getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = BiIconEditor.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject)) != null && (fob = dob.getPrimaryFile()) != null) {
                if (executionClassPath.contains(fob)) {
                    name = executionClassPath.getResourceName(fob);
                } else {
                    ClassPath srcClassPath = ClassPath.getClassPath((FileObject)fob, (String)"classpath/source");
                    name = srcClassPath.getResourceName(fob);
                }
            }
            return name;
        }
    }

    public static class BiImageIcon
    extends ImageIcon {
        private String name;

        public BiImageIcon() {
        }

        BiImageIcon(URL url, String name) {
            super(url);
            this.name = name;
        }

        BiImageIcon(String file, String name) {
            super(file);
            this.name = name;
        }

        String getName() {
            return this.name;
        }
    }
}

