/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.docscan;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.tasklist.core.Background;
import org.netbeans.modules.tasklist.core.ColumnProperty;
import org.netbeans.modules.tasklist.core.GoToTaskAction;
import org.netbeans.modules.tasklist.core.ObservableList;
import org.netbeans.modules.tasklist.core.TLUtils;
import org.netbeans.modules.tasklist.core.Task;
import org.netbeans.modules.tasklist.core.TaskList;
import org.netbeans.modules.tasklist.core.TaskListNode;
import org.netbeans.modules.tasklist.core.TaskListView;
import org.netbeans.modules.tasklist.core.filter.Filter;
import org.netbeans.modules.tasklist.core.filter.FilterRepository;
import org.netbeans.modules.tasklist.docscan.Cache;
import org.netbeans.modules.tasklist.docscan.Choosers;
import org.netbeans.modules.tasklist.docscan.FilterSourceTasksAction;
import org.netbeans.modules.tasklist.docscan.FilteredTasksList;
import org.netbeans.modules.tasklist.docscan.SourceTaskNode;
import org.netbeans.modules.tasklist.docscan.SourceTaskProperties;
import org.netbeans.modules.tasklist.docscan.SourceTasksAction;
import org.netbeans.modules.tasklist.docscan.SourceTasksFilter;
import org.netbeans.modules.tasklist.docscan.SourceTasksList;
import org.netbeans.modules.tasklist.docscan.SourceTasksProviderAcceptor;
import org.netbeans.modules.tasklist.docscan.SourceTasksScanner;
import org.netbeans.modules.tasklist.docscan.Util;
import org.netbeans.modules.tasklist.suggestions.ProviderAcceptor;
import org.netbeans.modules.tasklist.suggestions.SuggestionImpl;
import org.netbeans.modules.tasklist.suggestions.SuggestionList;
import org.netbeans.modules.tasklist.suggestions.SuggestionView;
import org.netbeans.modules.tasklist.suggestions.SuggestionsBroker;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAcceptor;
import org.openide.nodes.NodeOperation;
import org.openide.util.Cancellable;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.UserCancelException;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;

final class SourceTasksView
extends TaskListView
implements SourceTasksAction.ScanProgressMonitor,
SuggestionView {
    private static final long serialVersionUID = 1L;
    static final String CATEGORY = "sourcetasks";
    private static final String ICON_PATH = "org/netbeans/modules/tasklist/docscan/todosAction.gif";
    private final int MAIN_COLUMN_UID = 2352;
    private final int PRIORITY_COLUMN_UID = 7896;
    private final int FILE_COLUMN_UID = 8902;
    private final int LINE_COLUMN_UID = 6646;
    private final int LOCATION_COLUMN_UID = 6512;
    private static final int CURRENT_FILE_MODE = 1;
    private static final int OPENED_FILES_MODE = 2;
    private static final int SELECTED_FOLDER_MODE = 3;
    private static final int MODE_COUNT = 3;
    private SuggestionsBroker.Job job;
    private TaskList resultsSnapshot;
    private String reasonMsg;
    private Background background;
    FileObject selectedFolder;
    private static final int RECENT_ITEMS_COUNT = 4;
    private ArrayList recentFolders = new ArrayList(4);
    private SuggestionsBroker.AllOpenedJob allJob;
    private final TabState[] tabStates = new TabState[3];
    private Object windowSystemESCActionKey;
    private ColumnProperty[] allFilesColumns;
    private ColumnProperty[] currentFileColumns;
    private ProgressHandle progress;
    private JButton stop;
    private AbstractButton refresh;
    private JComponent prev;
    private JComponent next;
    private Cancellable cancellable = new Cancellable(){

        public boolean cancel() {
            SourceTasksView.this.handleStop();
            return true;
        }
    };
    private AbstractButton allFilesButton;
    private ButtonGroup group = new ButtonGroup();
    private AbstractButton folderSelector;
    private AbstractButton openedFiles;
    private AbstractButton currentFile;
    private AbstractButton gotoPresenter;
    private final ActionListener dispatcher = new Dispatcher();
    private int realFolders = 0;
    private int estimatedFolders = -1;
    private FileObject scannedFolder;
    private static long lastUISync;
    private JButton filterIconButton = null;
    private JComboBox filterCombo = null;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$netbeans$modules$tasklist$core$GoToTaskAction;
    static /* synthetic */ Class class$org$netbeans$modules$tasklist$docscan$FilterSourceTasksAction;

    public SourceTasksView() {
    }

    public SourceTasksView(SourceTasksList list) {
        super(CATEGORY, Util.getString("win-title"), Utilities.loadImage((String)ICON_PATH), true, (ObservableList)list);
        this.init();
    }

    SourceTasksView(SuggestionsBroker.Job job) {
        super(CATEGORY, Util.getString("win-title"), Utilities.loadImage((String)ICON_PATH), true, SourceTasksView.createFilteredList((TaskList)job.getSuggestionsList()));
        this.job = job;
        this.init();
    }

    private void init() {
        this.putClientProperty("TabPolicy", "HideWhenAlone");
        InputMap inputMap = this.getInputMap(1);
        KeyStroke refresh = KeyStroke.getKeyStroke(82, 0);
        inputMap.put(refresh, refresh);
        this.getActionMap().put(refresh, new DelegateAction(this.getRefresh()));
        KeyStroke editfilter = KeyStroke.getKeyStroke(70, 1);
        inputMap.put(editfilter, editfilter);
        this.getActionMap().put(editfilter, new DelegateAction(this.getFilterIconButton()));
        KeyStroke filtercombo = KeyStroke.getKeyStroke(70, 0);
        inputMap.put(filtercombo, "filtercombo");
        AbstractAction a = new AbstractAction("filtercombo"){

            public void actionPerformed(ActionEvent e) {
                SourceTasksView.this.filterCombo.showPopup();
                SourceTasksView.this.filterCombo.requestFocus();
            }
        };
        a.setEnabled(true);
        this.getActionMap().put("filtercombo", a);
        KeyStroke editor = KeyStroke.getKeyStroke(69, 0);
        inputMap.put(editor, editor);
        this.getActionMap().put(editor, new DelegateAction(this.getGoto()));
        KeyStroke current = KeyStroke.getKeyStroke(67, 0);
        inputMap.put(current, current);
        this.getActionMap().put(current, new DelegateAction(this.getCurrentFile()));
        KeyStroke opened = KeyStroke.getKeyStroke(79, 0);
        inputMap.put(opened, opened);
        this.getActionMap().put(opened, new DelegateAction(this.getOpenedFiles()));
        KeyStroke folder = KeyStroke.getKeyStroke(83, 0);
        inputMap.put(folder, folder);
        this.getActionMap().put(folder, new DelegateAction(this.getAllFiles()));
        KeyStroke selectFolder = KeyStroke.getKeyStroke(83, 1);
        inputMap.put(selectFolder, selectFolder);
        this.getActionMap().put(selectFolder, new DelegateAction(this.getFolderSelector()));
    }

    protected Component createCenterComponent() {
        Component ret = super.createCenterComponent();
        this.getTable().getAccessibleContext().setAccessibleName(Util.getString("treetable"));
        this.getTable().getAccessibleContext().setAccessibleDescription(Util.getString("treetable_hint"));
        return ret;
    }

    public int getPersistenceType() {
        return 1;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(SourceTasksView.class);
    }

    protected Node createRootNode() {
        return new TaskListNode(this.getModel(), new TaskListNode.NodeFactory(){

            public Node createNode(Object task) {
                if (task instanceof SuggestionImpl) {
                    return new SourceTaskNode((SuggestionImpl)task);
                }
                return ((Task)task).createNode()[0];
            }
        });
    }

    protected ColumnProperty[] createColumns() {
        switch (this.getMode()) {
            case 1: {
                if (this.currentFileColumns == null) {
                    this.currentFileColumns = new ColumnProperty[]{this.createMainColumn(800), this.createPriorityColumn(false, 100), this.createLineColumn(true, 50)};
                }
                return this.currentFileColumns;
            }
            case 2: 
            case 3: {
                if (this.allFilesColumns == null) {
                    this.allFilesColumns = new ColumnProperty[]{this.createMainColumn(800), this.createPriorityColumn(false, 100), this.createLocationColumn(true, 200)};
                }
                return this.allFilesColumns;
            }
        }
        throw new IllegalStateException();
    }

    protected ColumnProperty getMainColumn(int width) {
        return this.createColumns()[0];
    }

    protected void loadColumnsConfiguration() {
    }

    protected void storeColumnsConfiguration() {
    }

    private ColumnProperty createMainColumn(int width) {
        return new ColumnProperty(2352, SourceTaskProperties.PROP_TASK, true, width);
    }

    private ColumnProperty createPriorityColumn(boolean visible, int width) {
        return new ColumnProperty(7896, SourceTaskProperties.PROP_PRIORITY, true, visible, width);
    }

    private ColumnProperty createFileColumn(boolean visible, int width) {
        ColumnProperty file = new ColumnProperty(8902, SourceTaskProperties.PROP_FILENAME, true, visible, width);
        return file;
    }

    private ColumnProperty createLineColumn(boolean visible, int width) {
        return new ColumnProperty(6646, SourceTaskProperties.PROP_LINE_NUMBER, true, visible, width);
    }

    private ColumnProperty createLocationColumn(boolean visible, int width) {
        ColumnProperty location = new ColumnProperty(6512, SourceTaskProperties.PROP_LOCATION, true, visible, width);
        return location;
    }

    protected void componentOpened() {
        super.componentOpened();
        this.setNorthComponentVisible(true);
        if (this.job == null) {
            this.handleCurrentFile();
        }
        this.updateButtonsState();
    }

    protected void componentClosed() {
        super.componentClosed();
        if (this.background != null) {
            this.background.interrupt();
        }
        Cache.store();
        this.releaseWorkaround();
        if (this.job != null) {
            this.job.stopBroker();
            this.job = null;
        }
        if (this.allJob != null) {
            this.allJob.stopBroker();
            this.allJob = null;
        }
    }

    protected String preferredID() {
        return "todo-window";
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        Cache.store();
        objectOutput.writeInt(2);
        boolean snapshot = this.job == null;
        objectOutput.writeBoolean(snapshot);
        if (snapshot) {
            // empty if block
        }
        ArrayList recent = this.recentFolders;
        if (this.selectedFolder != null) {
            recent = new ArrayList(this.recentFolders);
            SourceTasksView.addRecent(recent, this.selectedFolder);
        }
        objectOutput.writeObject(recent);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.category = CATEGORY;
        super.setName(Util.getString("win-title"));
        super.setIcon(Utilities.loadImage((String)ICON_PATH));
        int version = objectInput.readInt();
        if (version == 1 || version == 2) {
            boolean snapshot = objectInput.readBoolean();
            this.job = SuggestionsBroker.getDefault().startBroker((ProviderAcceptor)new SourceTasksProviderAcceptor());
            this.category = CATEGORY;
            SourceTasksView.registerTaskListView((TaskListView)this);
            this.setModel(SourceTasksView.createFilteredList((TaskList)this.job.getSuggestionsList()));
            if (version == 2) {
                this.recentFolders = (ArrayList)objectInput.readObject();
            }
        }
        this.init();
    }

    public String getToolTipText() {
        int mode = this.getMode();
        switch (mode) {
            case 1: {
                return Util.getString("win-tt-c");
            }
            case 2: {
                return Util.getString("win-tt-o");
            }
            case 3: {
                return Util.getString("win-tt-f");
            }
        }
        return null;
    }

    public String toString() {
        return "SourceTasksView@" + this.hashCode();
    }

    private ProgressHandle getProgress() {
        if (this.progress == null) {
            this.progress = ProgressHandleFactory.createHandle((String)Util.getString("searching"), (Cancellable)this.cancellable);
            this.progress.start();
        }
        return this.progress;
    }

    private void updateMiniStatus() {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        String prefix = "";
        this.getMiniStatus().setHorizontalAlignment(2);
        StringBuffer msg = new StringBuffer(80);
        if (this.job == null && this.allJob == null && this.selectedFolder != null) {
            if (msg.length() > 0) {
                prefix = ", ";
            }
            msg.append(prefix + Util.getMessage("ctx-flag", SourceTasksView.createLabel(this.selectedFolder)));
        }
        if (this.reasonMsg != null && this.job == null && this.allJob == null) {
            if (msg.length() > 0) {
                prefix = ", ";
            }
            msg.append(prefix + Util.getMessage("usa-flag", "" + TLUtils.recursiveCount(this.getModel().getTasks().iterator())));
            this.getMiniStatus().setToolTipText(this.reasonMsg);
        } else {
            this.getMiniStatus().setToolTipText("");
        }
        this.getMiniStatus().setText(msg.toString());
    }

    AbstractButton getRefresh() {
        if (this.refresh == null) {
            Image image = Utilities.loadImage((String)"org/netbeans/modules/tasklist/docscan/refresh.png");
            JButton button = new JButton(new ImageIcon(image));
            button.setToolTipText(Util.getString("rescan_hint") + " (r)");
            button.setEnabled(this.job == null);
            button.addActionListener(this.dispatcher);
            this.adjustToobarButton(button);
            button.getAccessibleContext().setAccessibleName(Util.getString("rescan"));
            button.getAccessibleContext().setAccessibleDescription(Util.getString("rescan_hint"));
            this.refresh = button;
        }
        return this.refresh;
    }

    private JComponent getPrev() {
        if (this.prev == null) {
            JButton button = new JButton("Prev (Shift+F12)");
            button.addActionListener(this.dispatcher);
            this.adjustToobarButton(button);
            this.prev = button;
        }
        return this.prev;
    }

    private JComponent getNext() {
        if (this.next == null) {
            JButton button = new JButton("Next (F12)");
            button.addActionListener(this.dispatcher);
            this.adjustToobarButton(button);
            this.next = button;
        }
        return this.next;
    }

    AbstractButton getAllFiles() {
        if (this.allFilesButton == null) {
            JToggleButton button = new JToggleButton(Util.getString("see-folder"));
            String tooltiptext = this.selectedFolder == null ? Util.getString("see-folder_hint1") : Util.getString("see-folder_hint2");
            button.setToolTipText(tooltiptext + " (s)");
            this.group.add(button);
            button.setSelected(this.job == null);
            button.addActionListener(this.dispatcher);
            this.adjustToobarButton(button);
            button.getAccessibleContext().setAccessibleName(Util.getString("see-folder"));
            button.getAccessibleContext().setAccessibleDescription(tooltiptext);
            this.allFilesButton = button;
        }
        return this.allFilesButton;
    }

    private AbstractButton getFolderSelector() {
        if (this.folderSelector == null) {
            DropDown button = new DropDown();
            button.setToolTipText(Util.getString("selector_hint") + " (S)");
            button.addActionListener(this.dispatcher);
            this.adjustToobarButton(button);
            button.getAccessibleContext().setAccessibleName(Util.getString("select-folder"));
            button.getAccessibleContext().setAccessibleDescription(Util.getString("selector_hint"));
            this.folderSelector = button;
        }
        return this.folderSelector;
    }

    private void showFolderSelectorPopup() {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem choose = new JMenuItem(Util.getString("select-folder"));
        choose.setMnemonic(Util.getChar("select-folder_mne"));
        choose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SourceTasksView.this.handleSelectFolder();
            }
        });
        popup.add(choose);
        Iterator it = this.recentFolders.iterator();
        int i = 1;
        if (it.hasNext() || this.selectedFolder != null) {
            popup.addSeparator();
        }
        if (this.selectedFolder != null) {
            JMenuItem item = new JMenuItem("0 " + SourceTasksView.createLabel(this.selectedFolder));
            item.setMnemonic(48);
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (SourceTasksView.this.getAllFiles().isSelected()) {
                        return;
                    }
                    SourceTasksView.this.handleAllFiles();
                }
            });
            popup.add(item);
        }
        int[] mnemonics = new int[]{0, 49, 50, 51, 52, 53};
        while (it.hasNext()) {
            FileObject fo = (FileObject)it.next();
            if (fo == null || !fo.isValid() || fo.equals(this.selectedFolder)) continue;
            JMenuItem item = new JMenuItem(i + " " + SourceTasksView.createLabel(fo));
            item.setMnemonic(mnemonics[i]);
            item.addActionListener(new RecentActionListener(fo));
            popup.add(item);
            ++i;
        }
        popup.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            public void popupMenuCanceled(PopupMenuEvent e) {
                if (SourceTasksView.this.selectedFolder == null) {
                    SourceTasksView.this.getCurrentFile().doClick(0);
                }
            }
        });
        popup.show(this.getAllFiles(), 0, this.getAllFiles().getHeight());
    }

    private AbstractButton getOpenedFiles() {
        if (this.openedFiles == null) {
            JToggleButton button = new JToggleButton(Util.getString("opened"));
            button.setToolTipText(Util.getString("opened_desc"));
            this.group.add(button);
            button.setSelected(this.getMode() == 2);
            button.addActionListener(this.dispatcher);
            this.adjustToobarButton(button);
            button.getAccessibleContext().setAccessibleName(Util.getString("opened"));
            button.getAccessibleContext().setAccessibleDescription(Util.getString("opened_desc"));
            this.openedFiles = button;
        }
        return this.openedFiles;
    }

    private AbstractButton getCurrentFile() {
        if (this.currentFile == null) {
            JToggleButton button = new JToggleButton(Util.getString("see-file"));
            button.setToolTipText(Util.getString("see-file_hint") + " (c)");
            this.group.add(button);
            button.setSelected(this.getMode() == 1);
            button.addActionListener(this.dispatcher);
            this.adjustToobarButton(button);
            button.getAccessibleContext().setAccessibleName(Util.getString("see-file"));
            button.getAccessibleContext().setAccessibleDescription(Util.getString("see-file_hint"));
            this.currentFile = button;
        }
        return this.currentFile;
    }

    private AbstractButton getGoto() {
        if (this.gotoPresenter == null) {
            Image image = Utilities.loadImage((String)"org/netbeans/modules/tasklist/docscan/gotosource.png");
            JButton button = new JButton(new ImageIcon(image));
            button.setToolTipText(Util.getString("goto_hint") + " (e)");
            button.addActionListener(this.dispatcher);
            this.adjustToobarButton(button);
            button.getAccessibleContext().setAccessibleName(Util.getString("goto"));
            button.getAccessibleContext().setAccessibleDescription(Util.getString("goto_hint"));
            this.gotoPresenter = button;
        }
        return this.gotoPresenter;
    }

    private void adjustToobarButton(final AbstractButton button) {
        button.setMargin(new Insets(0, 3, 0, 3));
        if (!(button instanceof JToggleButton)) {
            button.setContentAreaFilled(false);
            button.setBorderPainted(false);
            button.addMouseListener(new MouseAdapter(){

                public void mouseEntered(MouseEvent e) {
                    button.setContentAreaFilled(true);
                    button.setBorderPainted(true);
                }

                public void mouseExited(MouseEvent e) {
                    button.setContentAreaFilled(false);
                    button.setBorderPainted(false);
                }
            });
        }
        this.adjustToolbarComponentSize(button);
    }

    private void adjustToolbarComponentSize(JComponent button) {
        if (button.getBorder() instanceof CompoundBorder) {
            Dimension pref = button.getPreferredSize();
            pref.height = SourceTasksView.getToolbarHeight();
            if ("Windows".equals(UIManager.getLookAndFeel().getID())) {
                pref.width += 9;
            }
            button.setPreferredSize(pref);
        }
    }

    public void updateFilterCount() {
    }

    protected Component createNorthComponent() {
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        MatteBorder verysoftbevelborder = BorderFactory.createMatteBorder(0, 0, 1, 0, toolbar.getBackground().darker().darker());
        toolbar.setBorder(verysoftbevelborder);
        toolbar.setLayout(new ToolbarLayout());
        toolbar.add(this.getCurrentFile());
        toolbar.add(this.getOpenedFiles());
        toolbar.add(this.getAllFiles());
        JPanel wrapper = new JPanel();
        wrapper.setOpaque(false);
        wrapper.setLayout(new FlowLayout(1, 0, 0));
        wrapper.add(this.getFolderSelector());
        toolbar.add(wrapper);
        JPanel separator = new JPanel();
        separator.setOpaque(false);
        toolbar.add(separator);
        toolbar.add(this.getGoto());
        toolbar.add(this.getRefresh());
        toolbar.add(this.getFilterIconButton());
        toolbar.add(this.getFilterCombo());
        JPanel separator2 = new JPanel();
        separator2.setOpaque(false);
        toolbar.add(separator2);
        toolbar.add(this.getMiniStatus());
        toolbar.setPreferredSize(new Dimension(Integer.MAX_VALUE, SourceTasksView.getToolbarHeight()));
        return toolbar;
    }

    public void estimate(final int estimate) {
        this.scannedFolder = null;
        this.estimatedFolders = estimate;
        if (estimate == -1) {
            this.getProgress().switchToIndeterminate();
        } else {
            this.getProgress().switchToDeterminate(this.estimatedFolders);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (estimate == -1) {
                    Cache.load();
                }
            }
        });
    }

    public void scanStarted() {
        this.realFolders = 0;
        this.reasonMsg = null;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SourceTasksView.this.getRefresh().setEnabled(false);
            }
        });
    }

    public void folderEntered(FileObject folder) {
        this.scannedFolder = folder;
        if (this.estimatedFolders > 0) {
            ++this.realFolders;
            if (this.realFolders > this.estimatedFolders) {
                this.estimatedFolders = this.realFolders;
                this.getProgress().switchToDeterminate(this.estimatedFolders);
            }
            this.getProgress().progress(this.realFolders);
        }
        SourceTasksView.handlePendingAWTEvents();
    }

    public void fileScanned(FileObject fo) {
        SourceTasksView.handlePendingAWTEvents();
    }

    public void folderScanned(FileObject fo) {
        SourceTasksView.handlePendingAWTEvents();
    }

    public void scanTerminated(int reason) {
        if (reason == -1) {
            this.reasonMsg = Util.getString("mem_ter");
        } else if (reason == -2) {
            this.reasonMsg = Util.getString("usr-ter");
        } else if (reason == -3) {
            this.reasonMsg = Util.getString("usa-ter");
        }
    }

    public void scanFinished() {
        this.estimatedFolders = -1;
        this.progressFinished();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SourceTasksView.this.getRefresh().setEnabled(SourceTasksView.this.job == null);
                SourceTasksView.this.updateMiniStatus();
            }
        });
    }

    private void progressFinished() {
        this.getProgress().finish();
        this.progress = null;
    }

    public void statistics(int todos) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SourceTasksView.this.updateMiniStatus();
            }
        });
    }

    private void handleStop() {
        this.background.interrupt();
        this.getMiniStatus().setText(Util.getString("stopping"));
    }

    protected void componentHidden() {
        super.componentHidden();
    }

    ObservableList discloseModel() {
        return this.getModel();
    }

    Object discloseTable() {
        return this.treeTable;
    }

    Node discloseNode() {
        return this.rootNode;
    }

    private void handleOpenedFiles() {
        this.saveFilterState();
        switch (this.getMode()) {
            case 1: {
                this.job.stopBroker();
                this.job = null;
                break;
            }
            case 2: {
                return;
            }
            case 3: {
                if (this.background != null) {
                    this.handleStop();
                }
                this.background = null;
            }
        }
        this.releaseWorkaround();
        this.allJob = SuggestionsBroker.getDefault().startAllOpenedBroker((ProviderAcceptor)new SourceTasksProviderAcceptor());
        this.treeTable.setProperties((Node.Property[])this.createColumns());
        this.treeTable.setTreePreferredWidth(this.createColumns()[0].getWidth());
        SuggestionList list = this.allJob.getSuggestionList();
        this.setModel((ObservableList)list);
        this.loadFilterState(2);
        this.getRefresh().setEnabled(false);
        this.getTable().requestFocusInWindow();
        this.updateMiniStatus();
        this.putClientProperty("ToolTipText", this.getToolTipText());
    }

    private void handleAllFiles() {
        if (this.selectedFolder == null) {
            if (this.recentFolders.size() > 0) {
                this.showFolderSelectorPopup();
            } else {
                this.handleSelectFolder();
            }
            return;
        }
        DataObject seletedDataFolder = null;
        try {
            seletedDataFolder = DataObject.find((FileObject)this.selectedFolder);
        }
        catch (DataObjectNotFoundException e) {
            // empty catch block
        }
        if (seletedDataFolder == null) {
            if (this.recentFolders.size() > 0) {
                this.showFolderSelectorPopup();
            } else {
                this.handleSelectFolder();
            }
            return;
        }
        this.saveFilterState();
        switch (this.getMode()) {
            case 1: {
                this.job.stopBroker();
                this.job = null;
                break;
            }
            case 2: {
                this.allJob.stopBroker();
                this.allJob = null;
                break;
            }
        }
        this.allFilesButton.setToolTipText(Util.getMessage("see-folder-hint2", SourceTasksView.createLabel(this.selectedFolder)) + " (s)");
        ((JToggleButton)this.allFilesButton).setSelected(true);
        this.treeTable.setProperties((Node.Property[])this.createColumns());
        this.treeTable.setTreePreferredWidth(this.createColumns()[0].getWidth());
        Object list = this.resultsSnapshot == null ? new SourceTasksList() : this.resultsSnapshot;
        this.releaseWorkaround();
        this.setModel((ObservableList)list);
        this.loadFilterState(3);
        this.getRefresh().setEnabled(true);
        this.getTable().requestFocusInWindow();
        if (list != this.resultsSnapshot) {
            try {
                DataObject.Container one = (DataObject.Container)DataObject.find((FileObject)this.selectedFolder);
                DataObject.Container[] folders = new DataObject.Container[]{one};
                this.background = SourceTasksScanner.scanTasksAsync(this, folders);
                this.resultsSnapshot = list;
            }
            catch (DataObjectNotFoundException e) {
                this.selectedFolder = null;
            }
        } else {
            this.getMiniStatus().setText(Util.getMessage("restored", SourceTasksView.createLabel(this.selectedFolder)));
        }
        this.putClientProperty("ToolTipText", this.getToolTipText());
    }

    private void handleRefresh() {
        this.getList().clear();
        try {
            DataObject.Container one = (DataObject.Container)DataObject.find((FileObject)this.selectedFolder);
            DataObject.Container[] folders = new DataObject.Container[]{one};
            this.background = SourceTasksScanner.scanTasksAsync(this, folders);
            this.getTable().requestFocusInWindow();
        }
        catch (DataObjectNotFoundException e) {
            this.getMiniStatus().setText(Util.getMessage("refresh-err", SourceTasksView.createLabel(this.selectedFolder)));
        }
    }

    private static String createLabel(FileObject fo) {
        String path;
        File file = FileUtil.toFile((FileObject)fo);
        if (file == null) {
            path = fo.getPath();
            try {
                path = fo.getFileSystem().getDisplayName() + path;
            }
            catch (FileStateInvalidException fileStateInvalidException) {}
        } else {
            path = file.getPath();
        }
        if (path.length() > 60) {
            return "..." + path.substring(path.length() - 57);
        }
        return path;
    }

    private int getMode() {
        if (this.job != null) {
            return 1;
        }
        if (this.allJob != null) {
            return 2;
        }
        return 3;
    }

    private void saveFilterState() {
        int mode = this.getMode();
        TabState state = this.tabStates[mode - 1];
        if (state == null) {
            this.tabStates[mode - 1] = new TabState();
            state = this.tabStates[mode - 1];
        }
        state.filtered = this.isFiltered();
        state.filter = this.getFilter();
    }

    private void loadFilterState(int mode) {
    }

    private void releaseWorkaround() {
        ObservableList filter = this.getModel();
        if (filter instanceof FilteredTasksList) {
            ((FilteredTasksList)filter).byebye();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCurrentFile() {
        this.saveFilterState();
        switch (this.getMode()) {
            case 1: {
                return;
            }
            case 2: {
                this.allJob.stopBroker();
                this.allJob = null;
                break;
            }
            case 3: {
                if (this.background != null) {
                    this.handleStop();
                }
                this.background = null;
            }
        }
        try {
            this.job = SuggestionsBroker.getDefault().startBroker((ProviderAcceptor)new SourceTasksProviderAcceptor());
            this.treeTable.setProperties((Node.Property[])this.createColumns());
            this.treeTable.setTreePreferredWidth(this.createColumns()[0].getWidth());
            this.setModel(SourceTasksView.createFilteredList((TaskList)this.job.getSuggestionsList()));
            this.loadFilterState(1);
        }
        finally {
            this.getRefresh().setEnabled(false);
            this.getTable().requestFocusInWindow();
            this.updateMiniStatus();
            this.putClientProperty("ToolTipText", this.getToolTipText());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSelectFolder() {
        if (this.background != null) {
            this.handleStop();
        }
        this.background = null;
        final Node content = Choosers.projectView();
        NodeOperation op = NodeOperation.getDefault();
        try {
            Node[] selected = op.select(Util.getString("sel_title"), Util.getString("sel-head"), content, new NodeAcceptor(){

                public boolean acceptNodes(Node[] nodes) {
                    return nodes.length == 1 && nodes[0] != content && nodes[0].getLookup().lookup(class$org$openide$filesystems$FileObject == null ? (class$org$openide$filesystems$FileObject = SourceTasksView.class$("org.openide.filesystems.FileObject")) : class$org$openide$filesystems$FileObject) != null;
                }
            });
            this.resultsSnapshot = null;
            this.updateRecent(this.selectedFolder);
            this.selectedFolder = (FileObject)selected[0].getLookup().lookup(FileObject.class);
            this.handleAllFiles();
        }
        catch (UserCancelException userCancelException) {
        }
        finally {
            Choosers.icons = null;
        }
    }

    private void updateRecent(FileObject fo) {
        SourceTasksView.addRecent(this.recentFolders, fo);
    }

    private static void addRecent(List recentFolders, FileObject fo) {
        if (fo == null) {
            return;
        }
        if (!recentFolders.contains(fo)) {
            if (recentFolders.size() == 4) {
                recentFolders.remove(recentFolders.size() - 1);
            }
            recentFolders.add(0, fo);
        } else {
            recentFolders.remove(fo);
            recentFolders.add(0, fo);
        }
    }

    private void handlePrev() {
        this.prevTask();
    }

    private void handleNext() {
        this.nextTask();
    }

    final void setBackground(Background background) {
        this.background = background;
    }

    private void updateButtonsState() {
        switch (this.getMode()) {
            case 1: {
                this.currentFile.setSelected(true);
                this.openedFiles.setSelected(false);
                this.folderSelector.setSelected(false);
                break;
            }
            case 2: {
                this.currentFile.setSelected(false);
                this.openedFiles.setSelected(true);
                this.folderSelector.setSelected(false);
                break;
            }
            case 3: {
                this.currentFile.setSelected(false);
                this.openedFiles.setSelected(false);
                this.folderSelector.setSelected(true);
            }
        }
    }

    public static void handlePendingAWTEvents() {
        if (SwingUtilities.isEventDispatchThread()) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now - lastUISync < 103L) {
            return;
        }
        lastUISync = now;
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                }
            });
        }
        catch (InterruptedException ignore) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    public boolean isObserved(String category) {
        return this.isShowing() && "nb-tasklist-scannedtask".equals(category);
    }

    public SuggestionList getSuggestionsModel() {
        return null;
    }

    private static ObservableList createFilteredList(TaskList list) {
        return new FilteredTasksList(list);
    }

    public Filter createFilter() {
        return new SourceTasksFilter(NbBundle.getMessage((Class)SourceTaskNode.class, (String)"new-filter-name"));
    }

    public AccessibleContext getAccessibleContext() {
        AccessibleContext ret = super.getAccessibleContext();
        switch (this.getMode()) {
            case 1: {
                ret.setAccessibleDescription(Util.getString("file_desc11"));
                break;
            }
            case 2: {
                ret.setAccessibleDescription(Util.getString("opened_desc11"));
                break;
            }
            case 3: {
                ret.setAccessibleDescription(Util.getMessage("folder_desc11", SourceTasksView.createLabel(this.selectedFolder)));
            }
        }
        return ret;
    }

    protected void setFiltered() {
        super.setFiltered();
    }

    private AbstractButton getFilterIconButton() {
        if (this.filterIconButton == null) {
            ImageIcon icon = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/tasklist/docscan/filter.png"));
            this.filterIconButton = new JButton(icon);
            this.adjustToobarButton(this.filterIconButton);
            this.filterIconButton.setToolTipText(Util.getString("filter_hint") + " (shift+f)");
            this.filterIconButton.addActionListener(this.dispatcher);
            this.filterIconButton.getAccessibleContext().setAccessibleName(Util.getString("filter"));
            this.filterIconButton.getAccessibleContext().setAccessibleDescription(Util.getString("filter_hint"));
        }
        return this.filterIconButton;
    }

    private JComboBox getFilterCombo() {
        if (this.filterCombo == null) {
            this.filterCombo = new JComboBox(new FiltersComboModel(this.getFilters()));
            this.filterCombo.addActionListener(this.dispatcher);
            this.adjustToolbarComponentSize(this.filterCombo);
            Dimension dim = this.filterCombo.getPreferredSize();
            dim.width = 150;
            dim.height = SourceTasksView.getToolbarHeight();
            this.filterCombo.setPreferredSize(dim);
            this.filterCombo.setToolTipText(Util.getString("choose-filter_hint") + " (f)");
            this.filterCombo.getAccessibleContext().setAccessibleName(Util.getString("choose-filter"));
            this.filterCombo.getAccessibleContext().setAccessibleDescription(Util.getString("choose-filter_hint"));
        }
        return this.filterCombo;
    }

    static {
        $assertionsDisabled = !SourceTasksView.class.desiredAssertionStatus();
        lastUISync = System.currentTimeMillis();
    }

    private static class FiltersComboModel
    implements ComboBoxModel {
        private List lsnrs = Collections.synchronizedList(new LinkedList());
        private Filter.ListModelElement[] elements = null;
        private int activei = -1;
        private FilterRepository rep = null;

        public FiltersComboModel(FilterRepository rep) {
            this.rep = rep;
            rep.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    FiltersComboModel.this.onFiltersChanged(evt);
                }
            });
        }

        public void addListDataListener(ListDataListener l) {
            if (this.lsnrs.indexOf(l) == -1) {
                this.lsnrs.add(l);
            }
        }

        public Object getElementAt(int index) {
            if (this.elements == null) {
                this.prepareElements();
            }
            return this.elements[index];
        }

        private void prepareElements() {
            this.elements = new Filter.ListModelElement[this.rep.size() + 1];
            this.elements[0] = new Filter.ListModelElement(null);
            Iterator it = this.rep.iterator();
            for (int i = 1; i < this.rep.size() + 1; ++i) {
                this.elements[i] = new Filter.ListModelElement((Filter)it.next());
            }
            if (this.activei >= this.rep.size() + 1) {
                this.activei = -1;
            }
        }

        public Object getSelectedItem() {
            if (this.elements == null) {
                this.prepareElements();
            }
            if (this.activei == -1) {
                Filter f = this.rep.getActive();
                for (int i = 0; i < this.elements.length; ++i) {
                    if (this.elements[i].filter != f) continue;
                    this.activei = i;
                    break;
                }
            }
            return this.activei >= 0 ? this.elements[this.activei] : null;
        }

        public int getSize() {
            return this.rep.size() + 1;
        }

        public void removeListDataListener(ListDataListener l) {
            this.lsnrs.remove(l);
        }

        public void setSelectedItem(Object anItem) {
            this.rep.setActive(((Filter.ListModelElement)anItem).filter);
        }

        private void onFiltersChanged(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("propFilters")) {
                this.elements = null;
                this.fireContentsChanged();
            } else if (evt.getPropertyName().equals("propActiveFilter")) {
                this.activei = -1;
                this.fireContentsChanged();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireContentsChanged() {
            ListDataEvent evt = new ListDataEvent(this, 0, 0, Integer.MAX_VALUE);
            ArrayList clone = null;
            List list = this.lsnrs;
            synchronized (list) {
                clone = new ArrayList(this.lsnrs);
            }
            Iterator it = clone.iterator();
            while (it.hasNext()) {
                ((ListDataListener)it.next()).contentsChanged(evt);
            }
        }
    }

    private static class TabState {
        boolean filtered;
        Filter filter;

        private TabState() {
        }
    }

    private static class DelegateAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        AbstractButton target;

        DelegateAction(AbstractButton target) {
            this.target = target;
        }

        public void actionPerformed(ActionEvent e) {
            this.target.doClick();
        }
    }

    private class ToolbarLayout
    implements LayoutManager {
        private ToolbarLayout() {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public void layoutContainer(Container parent) {
            Dimension max = parent.getSize();
            int label = max.width - this.preferredLayoutSize((Container)parent).width;
            int components = parent.getComponentCount();
            int horizont = 0;
            for (int i = 0; i < components; ++i) {
                JComponent comp = (JComponent)parent.getComponent(i);
                if (!comp.isVisible()) continue;
                comp.setLocation(horizont, 0);
                Dimension pref = comp.getPreferredSize();
                int width = pref.width;
                if (comp == SourceTasksView.this.getMiniStatus()) {
                    width = label;
                }
                comp.setSize(width, TaskListView.getToolbarHeight() - 1);
                horizont += width;
            }
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public Dimension minimumLayoutSize(Container parent) {
            int components = parent.getComponentCount();
            int horizont = 0;
            for (int i = 0; i < components; ++i) {
                Component comp = parent.getComponent(i);
                if (!comp.isVisible()) continue;
                comp.setLocation(horizont, 0);
                Dimension pref = comp.getPreferredSize();
                horizont += pref.width;
            }
            return new Dimension(horizont, TaskListView.getToolbarHeight());
        }

        public Dimension preferredLayoutSize(Container parent) {
            return SourceTasksView.this.getMinimumSize();
        }
    }

    private class Dispatcher
    implements ActionListener {
        private Dispatcher() {
        }

        public void actionPerformed(ActionEvent e) {
            Object obj = e.getSource();
            if (obj == SourceTasksView.this.getGoto()) {
                GoToTaskAction gotoAction = (GoToTaskAction)SystemAction.get((Class)(class$org$netbeans$modules$tasklist$core$GoToTaskAction == null ? (class$org$netbeans$modules$tasklist$core$GoToTaskAction = SourceTasksView.class$("org.netbeans.modules.tasklist.core.GoToTaskAction")) : class$org$netbeans$modules$tasklist$core$GoToTaskAction));
                if (gotoAction.isEnabled()) {
                    gotoAction.performAction();
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            } else if (obj == SourceTasksView.this.getCurrentFile()) {
                SourceTasksView.this.handleCurrentFile();
            } else if (obj == SourceTasksView.this.getOpenedFiles()) {
                SourceTasksView.this.handleOpenedFiles();
            } else if (obj == SourceTasksView.this.getFolderSelector()) {
                if (SourceTasksView.this.recentFolders.size() > 0 || SourceTasksView.this.selectedFolder != null) {
                    SourceTasksView.this.showFolderSelectorPopup();
                } else {
                    SourceTasksView.this.handleSelectFolder();
                }
            } else if (obj == SourceTasksView.this.getAllFiles()) {
                SourceTasksView.this.handleAllFiles();
            } else if (obj == SourceTasksView.this.getRefresh()) {
                SourceTasksView.this.handleRefresh();
            } else if (obj == SourceTasksView.this.getPrev()) {
                SourceTasksView.this.handlePrev();
            } else if (obj == SourceTasksView.this.getNext()) {
                SourceTasksView.this.handleNext();
            } else if (obj == SourceTasksView.this.getFilterCombo()) {
                if (SourceTasksView.this.filterCombo.getSelectedItem() != null) {
                    SourceTasksView.this.setFilter(((Filter.ListModelElement)((SourceTasksView)SourceTasksView.this).filterCombo.getSelectedItem()).filter);
                }
            } else if (obj == SourceTasksView.this.getFilterIconButton()) {
                FilterSourceTasksAction action = (FilterSourceTasksAction)SystemAction.get((Class)(class$org$netbeans$modules$tasklist$docscan$FilterSourceTasksAction == null ? (class$org$netbeans$modules$tasklist$docscan$FilterSourceTasksAction = SourceTasksView.class$("org.netbeans.modules.tasklist.docscan.FilterSourceTasksAction")) : class$org$netbeans$modules$tasklist$docscan$FilterSourceTasksAction));
                SourceTasksView.this.putClientProperty("fp-selected-filter", SourceTasksView.this.getFilterCombo().getSelectedItem());
                action.actionPerformed(e);
            }
        }
    }

    private class RecentActionListener
    implements ActionListener {
        private final FileObject fo;

        RecentActionListener(FileObject recent) {
            this.fo = recent;
        }

        public void actionPerformed(ActionEvent e) {
            SourceTasksView.this.updateRecent(SourceTasksView.this.selectedFolder);
            SourceTasksView.this.selectedFolder = this.fo;
            SourceTasksView.this.resultsSnapshot = null;
            SourceTasksView.this.handleAllFiles();
        }
    }

    class DropDown
    extends JButton {
        private static final long serialVersionUID = 1L;
        private static final int DROPDOWN_WIDTH = 15;

        DropDown() {
            super(new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/tasklist/docscan/dropdown.gif")));
        }

        public Dimension getPreferredSize() {
            return new Dimension(15, TaskListView.getToolbarHeight());
        }
    }
}

