/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.metadata;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.ErrorManager;
import org.openide.filesystems.FileUtil;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StrippedClassPathImpl
implements ClassPathImplementation,
PropertyChangeListener {
    private final ClassPath orig;
    private final Set<URL> appSrvRoots;
    private final PropertyChangeSupport support;
    private List<PathResourceImplementation> resources;

    public StrippedClassPathImpl(ClassPath orig, File[] appSrvRoots) {
        assert (orig != null);
        assert (appSrvRoots != null);
        this.orig = orig;
        this.appSrvRoots = new HashSet<URL>();
        this.support = new PropertyChangeSupport(this);
        for (File f : appSrvRoots) {
            URL fileRoot = null;
            try {
                fileRoot = f.toURI().toURL();
            }
            catch (MalformedURLException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
            if (FileUtil.isArchiveFile((URL)fileRoot)) {
                fileRoot = FileUtil.getArchiveRoot((URL)fileRoot);
            }
            this.appSrvRoots.add(fileRoot);
        }
        this.orig.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.orig));
    }

    public synchronized List<PathResourceImplementation> getResources() {
        if (this.resources == null) {
            this.resources = new ArrayList<PathResourceImplementation>();
            List entries = this.orig.entries();
            for (ClassPath.Entry entry : entries) {
                URL url = entry.getURL();
                if (this.appSrvRoots.contains(url)) continue;
                this.resources.add(ClassPathSupport.createResource((URL)url));
            }
        }
        return this.resources;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        assert (listener != null);
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        assert (listener != null);
        this.support.removePropertyChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent event) {
        StrippedClassPathImpl strippedClassPathImpl = this;
        synchronized (strippedClassPathImpl) {
            this.resources = null;
        }
        this.support.firePropertyChange("resources", null, null);
    }
}

