/*
 * Decompiled with CFR 0.152.
 */
package org.openide;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.WizardValidationException;
import org.openide.awt.HtmlBrowser;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public class WizardDescriptor
extends DialogDescriptor {
    public static final Object NEXT_OPTION;
    public static final Object FINISH_OPTION;
    public static final Object PREVIOUS_OPTION;
    private static final ActionListener CLOSE_PREVENTER;
    private static final String PROP_AUTO_WIZARD_STYLE = "WizardPanel_autoWizardStyle";
    private static final String PROP_HELP_DISPLAYED = "WizardPanel_helpDisplayed";
    private static final String PROP_CONTENT_DISPLAYED = "WizardPanel_contentDisplayed";
    private static final String PROP_CONTENT_NUMBERED = "WizardPanel_contentNumbered";
    private static final String PROP_CONTENT_SELECTED_INDEX = "WizardPanel_contentSelectedIndex";
    private static final String PROP_CONTENT_DATA = "WizardPanel_contentData";
    private static final String PROP_CONTENT_BACK_COLOR = "WizardPanel_contentBackColor";
    private static final String PROP_CONTENT_FOREGROUND_COLOR = "WizardPanel_contentForegroundColor";
    private static final String PROP_IMAGE = "WizardPanel_image";
    private static final String PROP_IMAGE_ALIGNMENT = "WizardPanel_imageAlignment";
    private static final String PROP_LEFT_DIMENSION = "WizardPanel_leftDimension";
    private static final String PROP_HELP_URL = "WizardPanel_helpURL";
    private static final String PROP_ERROR_MESSAGE = "WizardPanel_errorMessage";
    private static WeakReference defaultImage;
    private static ErrorManager err;
    private final JButton nextButton = new JButton();
    private final JButton finishButton = new JButton();
    private final JButton cancelButton = new JButton();
    private final JButton previousButton = new JButton();
    private FinishAction finishOption;
    private Set newObjects = Collections.EMPTY_SET;
    private transient Component waitingComponent;
    private boolean autoWizardStyle = false;
    private boolean init = false;
    private WizardPanel wizardPanel;
    private Image image;
    private String[] contentData = new String[0];
    private int contentSelectedIndex = -1;
    private Color contentBackColor;
    private Color contentForegroundColor;
    private URL helpURL;
    private PropL propListener;
    private String imageAlignment = "North";
    private Iterator panels;
    private ChangeListener weakChangeListener;
    private PropertyChangeListener weakPropertyChangeListener;
    private ActionListener weakNextButtonListener;
    private ActionListener weakPreviousButtonListener;
    private ActionListener weakFinishButtonListener;
    private ActionListener weakCancelButtonListener;
    private Listener baseListener;
    private Panel current;
    private Object settings;
    private MessageFormat titleFormat;
    private Map properties;
    ResourceBundle bundle = NbBundle.getBundle((Class)WizardDescriptor.class);
    static final RequestProcessor ASYNCHRONOUS_JOBS_RP;
    private RequestProcessor.Task backgroundValidationTask;
    static final /* synthetic */ boolean $assertionsDisabled;

    public WizardDescriptor(Panel[] wizardPanels, Object settings) {
        this(new ArrayIterator(wizardPanels), settings);
    }

    public WizardDescriptor(Panel[] wizardPanels) {
        this(wizardPanels, (Object)CLOSE_PREVENTER);
    }

    public WizardDescriptor(Iterator panels, Object settings) {
        super((Object)"", "", true, -1, null, CLOSE_PREVENTER);
        ResourceBundle b = NbBundle.getBundle((String)"org.openide.Bundle");
        this.nextButton.setText(b.getString("CTL_NEXT"));
        this.previousButton.setText(b.getString("CTL_PREVIOUS"));
        this.finishButton.setText(b.getString("CTL_FINISH"));
        this.finishButton.getAccessibleContext().setAccessibleDescription(b.getString("ACSD_FINISH"));
        this.cancelButton.setText(b.getString("CTL_CANCEL"));
        this.cancelButton.getAccessibleContext().setAccessibleDescription(b.getString("ACSD_CANCEL"));
        this.previousButton.setMnemonic(b.getString("CTL_PREVIOUS_Mnemonic").charAt(0));
        this.finishButton.setMnemonic(b.getString("CTL_FINISH_Mnemonic").charAt(0));
        this.finishButton.setDefaultCapable(true);
        this.nextButton.setDefaultCapable(true);
        this.previousButton.setDefaultCapable(false);
        this.cancelButton.setDefaultCapable(false);
        this.settings = settings == CLOSE_PREVENTER ? this : settings;
        this.baseListener = new Listener();
        try {
            this.weakNextButtonListener = (ActionListener)WeakListeners.create(Class.forName("java.awt.event.ActionListener"), (EventListener)this.baseListener, (Object)this.nextButton);
            this.weakPreviousButtonListener = (ActionListener)WeakListeners.create(Class.forName("java.awt.event.ActionListener"), (EventListener)this.baseListener, (Object)this.previousButton);
            this.weakFinishButtonListener = (ActionListener)WeakListeners.create(Class.forName("java.awt.event.ActionListener"), (EventListener)this.baseListener, (Object)this.finishButton);
            this.weakCancelButtonListener = (ActionListener)WeakListeners.create(Class.forName("java.awt.event.ActionListener"), (EventListener)this.baseListener, (Object)this.cancelButton);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.nextButton.addActionListener(this.weakNextButtonListener);
        this.previousButton.addActionListener(this.weakPreviousButtonListener);
        this.finishButton.addActionListener(this.weakFinishButtonListener);
        this.cancelButton.addActionListener(this.weakCancelButtonListener);
        this.finishOption = new FinishAction();
        super.setOptions(new Object[]{this.previousButton, this.nextButton, this.finishButton, this.cancelButton});
        super.setClosingOptions(new Object[]{this.finishOption, this.cancelButton});
        this.panels = panels;
        this.weakChangeListener = WeakListeners.change((ChangeListener)this.baseListener, (Object)panels);
        panels.addChangeListener(this.weakChangeListener);
        this.callInitialize();
    }

    public WizardDescriptor(Iterator panels) {
        this(panels, (Object)CLOSE_PREVENTER);
    }

    protected void initialize() {
        super.initialize();
        this.updateState();
    }

    public final synchronized void setPanels(Iterator panels) {
        if (panels != null) {
            panels.removeChangeListener(this.weakChangeListener);
        }
        this.panels = panels;
        this.weakChangeListener = WeakListeners.change((ChangeListener)this.baseListener, (Object)panels);
        panels.addChangeListener(this.weakChangeListener);
        this.init = false;
        this.updateState();
    }

    public void setOptions(Object[] options) {
        super.setOptions(this.convertOptions(options));
    }

    public void setAdditionalOptions(Object[] options) {
        super.setAdditionalOptions(this.convertOptions(options));
    }

    public void setClosingOptions(Object[] options) {
        super.setClosingOptions(this.convertOptions(options));
    }

    private Object[] convertOptions(Object[] options) {
        Object[] clonedOptions = (Object[])options.clone();
        for (int i = clonedOptions.length - 1; i >= 0; --i) {
            if (clonedOptions[i] == NEXT_OPTION) {
                clonedOptions[i] = this.nextButton;
            }
            if (clonedOptions[i] == PREVIOUS_OPTION) {
                clonedOptions[i] = this.previousButton;
            }
            if (clonedOptions[i] == FINISH_OPTION) {
                clonedOptions[i] = this.finishButton;
            }
            if (clonedOptions[i] != CANCEL_OPTION) continue;
            clonedOptions[i] = this.cancelButton;
        }
        return clonedOptions;
    }

    public Object getValue() {
        return this.backConvertOption(super.getValue());
    }

    private Object backConvertOption(Object op) {
        if (op == this.nextButton) {
            return NEXT_OPTION;
        }
        if (op == this.previousButton) {
            return PREVIOUS_OPTION;
        }
        if (op == this.finishButton) {
            return FINISH_OPTION;
        }
        if (op == this.cancelButton) {
            return CANCEL_OPTION;
        }
        return op;
    }

    public void setTitleFormat(MessageFormat format) {
        this.titleFormat = format;
        if (this.init) {
            this.updateState();
        }
    }

    public synchronized MessageFormat getTitleFormat() {
        if (this.titleFormat == null) {
            this.titleFormat = new MessageFormat(NbBundle.getMessage((Class)WizardDescriptor.class, (String)"CTL_WizardName"));
        }
        return this.titleFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putProperty(final String name, final Object value) {
        Object oldValue = null;
        WizardDescriptor wizardDescriptor = this;
        synchronized (wizardDescriptor) {
            if (this.properties == null) {
                this.properties = new HashMap(7);
            }
            oldValue = this.properties.get(name);
            this.properties.put(name, value);
        }
        this.firePropertyChange(name, oldValue, value);
        if (this.propListener != null) {
            Mutex.EVENT.readAccess(new Runnable(){

                public void run() {
                    WizardDescriptor.this.propListener.propertyChange(new PropertyChangeEvent(this, name, null, null));
                }
            });
        }
        if (PROP_ERROR_MESSAGE.equals(name) && this.wizardPanel != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    WizardDescriptor.this.wizardPanel.setErrorMessage((String)(value == null ? " " : value), WizardDescriptor.this.nextButton.isEnabled() || WizardDescriptor.this.finishButton.isEnabled() ? Boolean.TRUE : Boolean.FALSE);
                }
            });
        }
    }

    public synchronized Object getProperty(String name) {
        return this.properties == null ? null : this.properties.get(name);
    }

    public void setHelpCtx(HelpCtx helpCtx) {
        if (this.wizardPanel != null && helpCtx != null) {
            HelpCtx.setHelpIDString((JComponent)this.wizardPanel, (String)helpCtx.getHelpID());
        }
        super.setHelpCtx(helpCtx);
    }

    public Set getInstantiatedObjects() {
        if (!FINISH_OPTION.equals(this.getValue())) {
            throw new IllegalStateException();
        }
        return this.newObjects;
    }

    protected synchronized void updateState() {
        Panel p = this.panels.current();
        if (this.current != p) {
            if (this.current != null) {
                this.current.removeChangeListener(this.weakChangeListener);
                this.current.storeSettings(this.settings);
            }
            p = this.panels.current();
            this.panels.removeChangeListener(this.weakChangeListener);
            this.weakChangeListener = WeakListeners.change((ChangeListener)this.baseListener, (Object)p);
            this.panels.addChangeListener(this.weakChangeListener);
            p.addChangeListener(this.weakChangeListener);
            this.current = p;
            this.current.readSettings(this.settings);
        }
        boolean next = this.panels.hasNext();
        boolean prev = this.panels.hasPrevious();
        boolean valid = p.isValid();
        if (SwingUtilities.isEventDispatchThread()) {
            this.updateStateInAWT();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    WizardDescriptor.this.updateStateInAWT();
                }
            });
        }
        this.setHelpCtx(p.getHelp());
        Component c = p.getComponent();
        if (c == null || c instanceof Window) {
            throw new IllegalStateException("Wizard panel " + p + " gave a strange component " + c);
        }
        if (!this.init) {
            if (c instanceof JComponent) {
                this.autoWizardStyle = this.getBooleanProperty((JComponent)c, PROP_AUTO_WIZARD_STYLE);
                if (this.autoWizardStyle) {
                    this.wizardPanel = new WizardPanel(this.getBooleanProperty((JComponent)c, PROP_CONTENT_DISPLAYED), this.getBooleanProperty((JComponent)c, PROP_HELP_DISPLAYED), this.getBooleanProperty((JComponent)c, PROP_CONTENT_NUMBERED), this.getLeftDimension((JComponent)c));
                    this.initBundleProperties();
                }
            }
            if (this.propListener == null) {
                this.propListener = new PropL();
            }
            this.init = true;
        }
        if (this.wizardPanel != null) {
            Component oldComp = this.wizardPanel.getRightComponent();
            if (oldComp != null) {
                oldComp.removePropertyChangeListener(this.weakPropertyChangeListener);
            }
            if (c instanceof JComponent) {
                this.setPanelProperties((JComponent)c);
                this.wizardPanel.setContent(this.contentData);
                this.wizardPanel.setSelectedIndex(this.contentSelectedIndex);
                this.wizardPanel.setContentBackColor(this.contentBackColor);
                this.wizardPanel.setContentForegroundColor(this.contentForegroundColor);
                this.wizardPanel.setImage(this.image);
                this.wizardPanel.setImageAlignment(this.imageAlignment);
                this.wizardPanel.setHelpURL(this.helpURL);
                this.updateButtonAccessibleDescription();
                this.weakPropertyChangeListener = WeakListeners.propertyChange((PropertyChangeListener)this.propListener, (Object)c);
                c.addPropertyChangeListener(this.weakPropertyChangeListener);
            }
            if (this.wizardPanel.getRightComponent() != c) {
                this.wizardPanel.setRightComponent(c);
                if (this.wizardPanel != this.getMessage()) {
                    this.setMessage(this.wizardPanel);
                } else {
                    this.firePropertyChange("message", null, this.wizardPanel);
                }
            }
        } else if (c != this.getMessage()) {
            this.setMessage(c);
        }
        String panelName = c.getName();
        if (panelName == null) {
            panelName = "";
        }
        Object[] args = new Object[]{panelName, this.panels.name()};
        MessageFormat mf = this.getTitleFormat();
        if (this.autoWizardStyle) {
            this.wizardPanel.setPanelName(mf.format(args));
        } else {
            this.setTitle(mf.format(args));
        }
        Component fo = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (fo != null && !fo.isEnabled() && this.wizardPanel != null) {
            this.wizardPanel.requestFocus();
        }
    }

    private void updateStateInAWT() {
        Panel p = this.panels.current();
        boolean next = this.panels.hasNext();
        boolean prev = this.panels.hasPrevious();
        boolean valid = p.isValid();
        this.nextButton.setEnabled(next && valid);
        this.previousButton.setEnabled(prev);
        if (this.current instanceof FinishablePanel) {
            if (((FinishablePanel)this.current).isFinishPanel()) {
                this.finishButton.setEnabled(valid);
            } else {
                this.finishButton.setEnabled(valid && !next);
            }
        } else {
            this.finishButton.setEnabled(valid && (!next || this.current instanceof FinishPanel));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStateWithFeedback() {
        try {
            this.showWaitCursor();
            this.updateState();
        }
        finally {
            this.showNormalCursor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void goToNextStep(Dimension previousSize) {
        try {
            Window parentWindow;
            this.showWaitCursor();
            boolean alreadyUpdated = false;
            Font controlFont = (Font)UIManager.getDefaults().get("controlFont");
            Integer defaultSize = (Integer)UIManager.get("nbDefaultFontSize");
            if (defaultSize == null) {
                defaultSize = new Integer(11);
            }
            if (controlFont != null && controlFont.getSize() > defaultSize && (parentWindow = SwingUtilities.getWindowAncestor((Component)this.getMessage())) != null) {
                this.updateState();
                alreadyUpdated = true;
                this.resizeWizard(parentWindow, previousSize);
            }
            if (!alreadyUpdated) {
                this.updateState();
            }
            if (this.wizardPanel != null) {
                this.wizardPanel.requestFocus();
            }
        }
        finally {
            this.showNormalCursor();
        }
    }

    private void resizeWizard(Window parentWindow, Dimension prevSize) {
        Dimension curSize = this.panels.current().getComponent().getPreferredSize();
        if (curSize.width > prevSize.width || curSize.height > prevSize.height) {
            Rectangle newBounds;
            Rectangle origBounds = parentWindow.getBounds();
            int newWidth = Math.max(origBounds.width + (curSize.width - prevSize.width), origBounds.width);
            int newHeight = Math.max(origBounds.height + (curSize.height - prevSize.height), origBounds.height);
            Rectangle screenBounds = Utilities.getUsableScreenBounds();
            if (origBounds.x + newWidth > screenBounds.width || origBounds.y + newHeight > screenBounds.height) {
                newWidth = Math.min(screenBounds.width, newWidth);
                newHeight = Math.min(screenBounds.height, newHeight);
                newBounds = Utilities.findCenterBounds((Dimension)new Dimension(newWidth, newHeight));
            } else {
                newBounds = new Rectangle(origBounds.x, origBounds.y, newWidth, newHeight);
            }
            parentWindow.setBounds(newBounds);
            parentWindow.invalidate();
            parentWindow.validate();
            parentWindow.repaint();
        }
    }

    private void showWaitCursor() {
        if (this.wizardPanel == null || this.wizardPanel.getRootPane() == null) {
            return;
        }
        this.waitingComponent = this.wizardPanel.getRootPane().getContentPane();
        this.waitingComponent.setCursor(Cursor.getPredefinedCursor(3));
    }

    private void showNormalCursor() {
        if (this.waitingComponent == null) {
            return;
        }
        this.waitingComponent.setCursor(null);
        this.waitingComponent = null;
    }

    private boolean getBooleanProperty(JComponent c, String s) {
        Object property = this.getProperty(s);
        if (property instanceof Boolean) {
            return (Boolean)property;
        }
        property = c.getClientProperty(s);
        if (property instanceof Boolean) {
            return (Boolean)property;
        }
        return false;
    }

    private Dimension getLeftDimension(JComponent c) {
        Object property = c.getClientProperty(PROP_LEFT_DIMENSION);
        Dimension leftDimension = property instanceof Dimension ? (Dimension)property : new Dimension(198, 233);
        return leftDimension;
    }

    private void setPanelProperties(JComponent c) {
        Object property = this.getProperty(PROP_CONTENT_SELECTED_INDEX);
        if (property instanceof Integer) {
            this.contentSelectedIndex = (Integer)property;
        } else {
            property = c.getClientProperty(PROP_CONTENT_SELECTED_INDEX);
            if (property instanceof Integer) {
                this.contentSelectedIndex = (Integer)property;
            }
        }
        property = this.getProperty(PROP_CONTENT_DATA);
        if (property instanceof String[]) {
            this.contentData = (String[])property;
        } else {
            property = c.getClientProperty(PROP_CONTENT_DATA);
            if (property instanceof String[]) {
                this.contentData = (String[])property;
            }
        }
        property = this.getProperty(PROP_IMAGE);
        if (property instanceof Image) {
            this.image = (Image)property;
        } else if ((this.properties == null || !this.properties.containsKey(PROP_IMAGE)) && (property = c.getClientProperty(PROP_IMAGE)) instanceof Image) {
            this.image = (Image)property;
        }
        property = this.getProperty(PROP_IMAGE_ALIGNMENT);
        if (property instanceof String) {
            this.imageAlignment = (String)property;
        } else {
            property = c.getClientProperty(PROP_IMAGE_ALIGNMENT);
            if (property instanceof String) {
                this.imageAlignment = (String)property;
            }
        }
        property = this.getProperty(PROP_CONTENT_BACK_COLOR);
        if (property instanceof Color) {
            this.contentBackColor = (Color)property;
        } else {
            property = c.getClientProperty(PROP_CONTENT_BACK_COLOR);
            if (property instanceof Color) {
                this.contentBackColor = (Color)property;
            }
        }
        property = this.getProperty(PROP_CONTENT_FOREGROUND_COLOR);
        if (property instanceof Color) {
            this.contentForegroundColor = (Color)property;
        } else {
            property = c.getClientProperty(PROP_CONTENT_FOREGROUND_COLOR);
            if (property instanceof Color) {
                this.contentForegroundColor = (Color)property;
            }
        }
        property = c.getClientProperty(PROP_HELP_URL);
        if (property instanceof URL) {
            this.helpURL = (URL)property;
        } else if (property == null) {
            this.helpURL = null;
        }
    }

    private void initBundleProperties() {
        this.contentBackColor = new Color(this.getIntFromBundle("INT_WizardBackRed"), this.getIntFromBundle("INT_WizardBackGreen"), this.getIntFromBundle("INT_WizardBackBlue"));
        this.contentForegroundColor = new Color(this.getIntFromBundle("INT_WizardForegroundRed"), this.getIntFromBundle("INT_WizardForegroundGreen"), this.getIntFromBundle("INT_WizardForegroundBlue"));
        this.imageAlignment = this.bundle.getString("STRING_WizardImageAlignment");
    }

    public void setValue(Object value) {
        Object convertedValue = this.backConvertOption(value);
        Object oldValue = this.getValue();
        this.setValueWithoutPCH(convertedValue);
        if (CLOSED_OPTION.equals(convertedValue)) {
            this.resetWizard();
        } else if ((FINISH_OPTION.equals(convertedValue) || NEXT_OPTION.equals(convertedValue)) && this.current != null) {
            this.current.storeSettings(this.settings);
        }
        this.firePropertyChange("value", oldValue, convertedValue);
    }

    private void resetWizard() {
        if (this.current != null) {
            this.current.storeSettings(this.settings);
            this.current.removeChangeListener(this.weakChangeListener);
            this.current = null;
            if (this.wizardPanel != null) {
                this.wizardPanel.resetPreferredSize();
            }
        }
        this.callUninitialize();
        this.panels.removeChangeListener(this.weakChangeListener);
    }

    private int getIntFromBundle(String key) {
        return Integer.parseInt(this.bundle.getString(key));
    }

    private static Image getDefaultImage() {
        Image img = null;
        if (defaultImage != null) {
            img = (Image)defaultImage.get();
        }
        if (img == null) {
            URL url = NbBundle.getLocalizedFile((String)"org.openide.resources.defaultWizard", (String)"gif");
            Image image = img = url == null ? null : Toolkit.getDefaultToolkit().getImage(url);
            if (img != null) {
                defaultImage = new WeakReference<Image>(img);
            }
        }
        return img;
    }

    private void updateButtonAccessibleDescription() {
        String stepName = this.contentData != null && this.contentSelectedIndex > 0 && this.contentSelectedIndex - 1 < this.contentData.length ? this.contentData[this.contentSelectedIndex - 1] : "";
        this.previousButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)WizardDescriptor.class, (String)"ACSD_PREVIOUS", (Object)new Integer(this.contentSelectedIndex), (Object)stepName));
        stepName = this.contentData != null && this.contentSelectedIndex < this.contentData.length - 1 && this.contentSelectedIndex + 1 >= 0 ? this.contentData[this.contentSelectedIndex + 1] : "";
        this.nextButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)WizardDescriptor.class, (String)"ACSD_NEXT", (Object)new Integer(this.contentSelectedIndex + 2), (Object)stepName));
    }

    private void lazyValidate(final Panel panel, final Runnable onValidPerformer) {
        Runnable validationPeformer = new Runnable(){

            public void run() {
                block5: {
                    err.log(1, "validationPeformer entry.");
                    ValidatingPanel v = (ValidatingPanel)panel;
                    try {
                        v.validate();
                        if (SwingUtilities.isEventDispatchThread()) {
                            WizardDescriptor.this.setValid(true);
                            err.log(1, "Runs onValidPerformer directly in EDT.");
                            onValidPerformer.run();
                        } else {
                            err.log(1, "invokeLater onValidPerformer.");
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    WizardDescriptor.this.setValid(true);
                                    err.log(1, "Runs onValidPerformer from invokeLater.");
                                    onValidPerformer.run();
                                }
                            });
                        }
                    }
                    catch (WizardValidationException wve) {
                        JComponent comp;
                        if (WizardDescriptor.this.wizardPanel != null) {
                            WizardDescriptor.this.wizardPanel.setErrorMessage(wve.getLocalizedMessage(), Boolean.FALSE);
                        }
                        if (wve.getSource() == null || !(comp = wve.getSource()).isFocusable()) break block5;
                        comp.requestFocus();
                    }
                }
            }
        };
        if (panel instanceof AsynchronousValidatingPanel) {
            AsynchronousValidatingPanel p = (AsynchronousValidatingPanel)panel;
            this.setValid(false);
            p.prepareValidation();
            err.log(1, "Do ASYNCHRONOUS_JOBS_RP.post(validationPeformer).");
            this.backgroundValidationTask = ASYNCHRONOUS_JOBS_RP.post(validationPeformer);
        } else if (panel instanceof ValidatingPanel) {
            err.log(1, "Runs validationPeformer.");
            validationPeformer.run();
        } else {
            err.log(1, "Runs onValidPerformer.");
            onValidPerformer.run();
        }
    }

    private void callInitialize() {
        if (!$assertionsDisabled && this.panels == null) {
            throw new AssertionError();
        }
        if (this.panels instanceof InstantiatingIterator) {
            ((InstantiatingIterator)this.panels).initialize(this);
        }
        this.newObjects = Collections.EMPTY_SET;
    }

    private void callUninitialize() {
        if (!$assertionsDisabled && this.panels == null) {
            throw new AssertionError();
        }
        if (this.panels instanceof InstantiatingIterator) {
            ((InstantiatingIterator)this.panels).uninitialize(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callInstantiate() throws IOException {
        if (!$assertionsDisabled && this.panels == null) {
            throw new AssertionError();
        }
        this.panels.current().storeSettings(this.settings);
        if (this.panels instanceof InstantiatingIterator) {
            this.showWaitCursor();
            try {
                if (!$assertionsDisabled && this.panels instanceof AsynchronousInstantiatingIterator && SwingUtilities.isEventDispatchThread()) {
                    throw new AssertionError((Object)"Cannot invoked within EDT if AsynchronousInstantiatingIterator!");
                }
                err.log(1, "Calls instantiate() on iterator: " + this.panels.getClass().getName());
                this.newObjects = ((InstantiatingIterator)this.panels).instantiate();
            }
            finally {
                this.showNormalCursor();
            }
        }
    }

    private static Font doDeriveFont(Font original, int style) {
        if (Utilities.getOperatingSystem() == 4096) {
            return new Font(original.getName(), style, original.getSize());
        }
        return original.deriveFont(style);
    }

    final void doNextClick() {
        if (this.nextButton.isEnabled()) {
            this.nextButton.doClick();
        }
    }

    final void doPreviousClick() {
        if (this.previousButton.isEnabled()) {
            this.previousButton.doClick();
        }
    }

    final void doFinishClick() {
        if (this.finishButton.isEnabled()) {
            this.finishButton.doClick();
        }
    }

    final void doCancelClick() {
        if (this.cancelButton.isEnabled()) {
            this.cancelButton.doClick();
        }
    }

    final boolean isNextEnabled() {
        return this.nextButton.isEnabled();
    }

    final boolean isFinishEnabled() {
        return this.finishButton.isEnabled();
    }

    static {
        $assertionsDisabled = !WizardDescriptor.class.desiredAssertionStatus();
        NEXT_OPTION = new String("NEXT_OPTION");
        FINISH_OPTION = OK_OPTION;
        PREVIOUS_OPTION = new String("PREVIOUS_OPTION");
        CLOSE_PREVENTER = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
            }

            public String toString() {
                return "CLOSE_PREVENTER";
            }
        };
        err = ErrorManager.getDefault().getInstance(WizardDescriptor.class.getName());
        ASYNCHRONOUS_JOBS_RP = new RequestProcessor("wizard-descriptor-asynchronous-jobs", 1, true);
    }

    private static final class FixedHeightLabel
    extends JLabel {
        private static final int ESTIMATED_HEIGHT = 16;
        static final /* synthetic */ boolean $assertionsDisabled;

        public Dimension getPreferredSize() {
            Dimension preferredSize = super.getPreferredSize();
            if (!$assertionsDisabled && 16 != Utilities.loadImage((String)"org/openide/resources/warning.gif").getHeight(null)) {
                throw new AssertionError((Object)"Use only 16px icon.");
            }
            preferredSize.height = Math.max(16, preferredSize.height);
            return preferredSize;
        }

        static {
            $assertionsDisabled = !(class$org$openide$WizardDescriptor == null ? (class$org$openide$WizardDescriptor = WizardDescriptor.class$("org.openide.WizardDescriptor")) : class$org$openide$WizardDescriptor).desiredAssertionStatus();
        }
    }

    static class FinishAction {
        ActionListener listner;

        FinishAction() {
        }

        public void addActionListener(ActionListener ac) {
            this.listner = ac;
        }

        public void removeActionListener(ActionListener ac) {
            this.listner = null;
        }

        public void fireActionPerformed() {
            if (this.listner != null) {
                this.listner.actionPerformed(new ActionEvent(this, 0, ""));
            }
        }
    }

    private static class BoundedHtmlBrowser
    extends HtmlBrowser {
        Dimension dim;

        public BoundedHtmlBrowser(Dimension d) {
            super(false, false);
            this.dim = d;
        }

        public Dimension getPreferredSize() {
            return this.dim;
        }
    }

    private static class WizardPanel
    extends JPanel {
        private JPanel rightPanel = new JPanel(new BorderLayout());
        private JLabel panelName = new JLabel("Step");
        private JList contentList;
        private Component rightComponent;
        private ImagedPanel contentPanel;
        private JPanel contentLabelPanel;
        private WrappedCellRenderer cellRenderer;
        private JTabbedPane tabbedPane;
        private HtmlBrowser htmlBrowser;
        private Dimension cachedDimension;
        private JLabel label;
        private int selectedIndex;
        private JLabel m_lblMessage;
        private Color nbErrorForeground;
        private Color nbWarningForeground;

        public WizardPanel(boolean contentDisplayed, boolean helpDispalyed, boolean contentNumbered, Dimension leftDimension) {
            super(new BorderLayout());
            this.initComponents(contentDisplayed, helpDispalyed, contentNumbered, leftDimension);
            this.setOpaque(false);
            this.resetPreferredSize();
        }

        private void initComponents(boolean contentDisplayed, boolean helpDisplayed, boolean contentNumbered, Dimension leftDimension) {
            if (contentDisplayed) {
                this.createContentPanel(contentNumbered, leftDimension);
                if (!helpDisplayed) {
                    this.add((Component)this.contentPanel, "West");
                }
            }
            if (helpDisplayed) {
                this.htmlBrowser = new BoundedHtmlBrowser(leftDimension);
                this.htmlBrowser.setPreferredSize(leftDimension);
                if (!contentDisplayed) {
                    this.add((Component)this.htmlBrowser, "West");
                }
            }
            if (helpDisplayed && contentDisplayed) {
                this.tabbedPane = new JTabbedPane(3);
                this.tabbedPane.addTab(NbBundle.getMessage((Class)(class$org$openide$WizardDescriptor == null ? (class$org$openide$WizardDescriptor = WizardDescriptor.class$("org.openide.WizardDescriptor")) : class$org$openide$WizardDescriptor), (String)"CTL_ContentName"), this.contentPanel);
                this.tabbedPane.addTab(NbBundle.getMessage((Class)(class$org$openide$WizardDescriptor == null ? (class$org$openide$WizardDescriptor = WizardDescriptor.class$("org.openide.WizardDescriptor")) : class$org$openide$WizardDescriptor), (String)"CTL_HelpName"), (Component)this.htmlBrowser);
                this.tabbedPane.setEnabledAt(1, false);
                this.tabbedPane.setOpaque(false);
                this.add((Component)this.tabbedPane, "West");
            }
            this.panelName.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, this.panelName.getForeground()));
            this.panelName.setFont(WizardDescriptor.doDeriveFont(this.panelName.getFont(), 1));
            JPanel labelPanel = new JPanel(new BorderLayout());
            labelPanel.add((Component)this.panelName, "North");
            labelPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 11));
            this.rightPanel.setBorder(BorderFactory.createEmptyBorder(0, 12, 11, 11));
            this.panelName.setLabelFor(labelPanel);
            this.nbErrorForeground = UIManager.getColor("nb.errorForeground");
            if (this.nbErrorForeground == null) {
                this.nbErrorForeground = new Color(255, 0, 0);
            }
            this.nbWarningForeground = UIManager.getColor("nb.warningForeground");
            if (this.nbWarningForeground == null) {
                this.nbWarningForeground = new Color(51, 51, 51);
            }
            JPanel errorPanel = new JPanel(new BorderLayout());
            errorPanel.setBorder(BorderFactory.createEmptyBorder(0, 12, 12, 11));
            this.m_lblMessage = new FixedHeightLabel();
            this.m_lblMessage.setForeground(this.nbErrorForeground);
            errorPanel.add((Component)this.m_lblMessage, "Center");
            JPanel fullRightPanel = new JPanel(new BorderLayout());
            fullRightPanel.add((Component)labelPanel, "North");
            fullRightPanel.add((Component)this.rightPanel, "Center");
            fullRightPanel.add((Component)errorPanel, "South");
            JSeparator sep = new JSeparator();
            sep.setForeground(Color.darkGray);
            this.add((Component)fullRightPanel, "Center");
            this.add((Component)sep, "South");
        }

        public void setErrorMessage(String msg, Boolean canContinue) {
            this.m_lblMessage.setForeground(this.nbErrorForeground);
            if (msg != null && msg.trim().length() > 0 && canContinue != null) {
                if (canContinue.booleanValue()) {
                    this.m_lblMessage.setIcon(new ImageIcon(Utilities.loadImage((String)"org/openide/resources/warning.gif")));
                    this.m_lblMessage.setForeground(this.nbWarningForeground);
                } else {
                    this.m_lblMessage.setIcon(new ImageIcon(Utilities.loadImage((String)"org/openide/resources/error.gif")));
                }
                this.m_lblMessage.setToolTipText(msg);
            } else {
                this.m_lblMessage.setIcon(null);
                this.m_lblMessage.setToolTipText(null);
            }
            this.m_lblMessage.setText(msg);
        }

        private void createContentPanel(boolean contentNumbered, Dimension leftDimension) {
            this.contentList = new JList();
            this.cellRenderer = new WrappedCellRenderer(contentNumbered, leftDimension.width);
            this.cellRenderer.setOpaque(false);
            this.contentList.setCellRenderer(this.cellRenderer);
            this.contentList.setOpaque(false);
            this.contentList.setEnabled(false);
            this.contentList.getAccessibleContext().setAccessibleDescription("");
            JScrollPane scroll = new JScrollPane(this.contentList);
            scroll.setHorizontalScrollBarPolicy(31);
            scroll.getViewport().setOpaque(false);
            scroll.setBorder(null);
            scroll.setOpaque(false);
            this.label = new JLabel(NbBundle.getMessage((Class)(class$org$openide$WizardDescriptor == null ? (class$org$openide$WizardDescriptor = WizardDescriptor.class$("org.openide.WizardDescriptor")) : class$org$openide$WizardDescriptor), (String)"CTL_ContentName"));
            this.label.setForeground(Color.white);
            this.label.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, this.label.getForeground()));
            this.label.setFont(WizardDescriptor.doDeriveFont(this.label.getFont(), 1));
            this.contentLabelPanel = new JPanel(new BorderLayout());
            this.contentLabelPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 11, 11));
            this.contentLabelPanel.setOpaque(false);
            this.contentLabelPanel.add((Component)this.label, "North");
            this.contentPanel = new ImagedPanel(null);
            this.contentPanel.add((Component)this.contentLabelPanel, "North");
            this.contentPanel.add((Component)scroll, "Center");
            this.contentPanel.setPreferredSize(leftDimension);
            this.label.setLabelFor(this.contentList);
        }

        public void setContent(final String[] content) {
            final JList list = this.contentList;
            if (list == null) {
                return;
            }
            Mutex.EVENT.writeAccess(new Runnable(){

                public void run() {
                    list.setListData(content);
                    list.revalidate();
                    list.repaint();
                    WizardPanel.this.contentLabelPanel.setVisible(content.length > 0);
                }
            });
        }

        public void setSelectedIndex(final int index) {
            this.selectedIndex = index;
            if (this.cellRenderer != null) {
                this.cellRenderer.setSelectedIndex(index);
                final JList list = this.contentList;
                if (list == null) {
                    return;
                }
                Mutex.EVENT.readAccess(new Runnable(){

                    public void run() {
                        list.ensureIndexIsVisible(index);
                        list.setFixedCellWidth(0);
                        list.setFixedCellWidth(-1);
                    }
                });
            }
        }

        public void setContentBackColor(Color color) {
            if (this.contentPanel != null) {
                this.contentPanel.setBackground(color);
            }
        }

        public void setContentForegroundColor(Color color) {
            if (this.cellRenderer == null) {
                return;
            }
            this.cellRenderer.setForegroundColor(color);
            this.label.setForeground(color);
            this.label.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, this.label.getForeground()));
        }

        public void setImage(Image image) {
            if (this.contentPanel != null) {
                this.contentPanel.setImage(image);
            }
        }

        public void setImageAlignment(String align) {
            if (this.contentPanel != null) {
                this.contentPanel.setImageAlignment(align);
            }
        }

        public void setRightComponent(Component c) {
            if (this.rightComponent != null) {
                this.rightPanel.remove(this.rightComponent);
            }
            this.rightComponent = c;
            this.rightPanel.add(this.rightComponent, "Center");
        }

        public Component getRightComponent() {
            return this.rightComponent;
        }

        public void setPanelName(String name) {
            this.panelName.setText(name);
        }

        public void setHelpURL(URL helpURL) {
            if (this.htmlBrowser == null) {
                return;
            }
            if (helpURL != null) {
                if (!helpURL.equals(this.htmlBrowser.getDocumentURL())) {
                    this.htmlBrowser.setURL(helpURL);
                }
                if (this.tabbedPane != null) {
                    this.tabbedPane.setEnabledAt(this.tabbedPane.indexOfComponent((Component)this.htmlBrowser), true);
                }
            } else if (this.tabbedPane != null) {
                this.tabbedPane.setSelectedComponent(this.contentPanel);
                this.tabbedPane.setEnabledAt(this.tabbedPane.indexOfComponent((Component)this.htmlBrowser), false);
            }
        }

        public void resetPreferredSize() {
            this.cachedDimension = new Dimension(600, 365);
        }

        public Dimension getPreferredSize() {
            Dimension dim = super.getPreferredSize();
            if (dim.height > this.cachedDimension.height) {
                this.cachedDimension.height = dim.height;
            }
            if (dim.width > this.cachedDimension.width) {
                this.cachedDimension.width = dim.width;
            }
            return this.cachedDimension;
        }

        public void requestFocus() {
            if (this.rightComponent != null && this.rightComponent.isDisplayable()) {
                JComponent comp = (JComponent)this.rightComponent;
                Container rootAnc = comp.getFocusCycleRootAncestor();
                FocusTraversalPolicy policy = rootAnc.getFocusTraversalPolicy();
                Component focus = policy.getComponentAfter(comp.getFocusCycleRootAncestor(), comp);
                if (focus != null) {
                    focus.requestFocus();
                } else {
                    comp.requestFocus();
                }
            } else {
                super.requestFocus();
            }
        }

        public boolean requestDefaultFocus() {
            if (this.rightComponent instanceof JComponent) {
                return ((JComponent)this.rightComponent).requestDefaultFocus();
            }
            return super.requestDefaultFocus();
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleWizardPanel();
            }
            return this.accessibleContext;
        }

        private class AccessibleWizardPanel
        extends JPanel.AccessibleJPanel {
            AccessibleWizardPanel() {
                super(WizardPanel.this);
            }

            public String getAccessibleDescription() {
                if (this.accessibleDescription != null) {
                    return this.accessibleDescription;
                }
                if (WizardPanel.this.rightComponent instanceof Accessible) {
                    if (WizardPanel.this.rightComponent.getAccessibleContext().getAccessibleDescription() == null) {
                        return null;
                    }
                    return NbBundle.getMessage((Class)(class$org$openide$WizardDescriptor == null ? (class$org$openide$WizardDescriptor = WizardDescriptor.class$("org.openide.WizardDescriptor")) : class$org$openide$WizardDescriptor), (String)"ACSD_WizardPanel", (Object)new Integer(WizardPanel.this.selectedIndex + 1), (Object)WizardPanel.this.panelName.getText(), (Object)WizardPanel.this.rightComponent.getAccessibleContext().getAccessibleDescription());
                }
                return super.getAccessibleDescription();
            }
        }
    }

    private static class WrappedCellRenderer
    extends JPanel
    implements ListCellRenderer {
        JTextArea ta = new JTextArea();
        JLabel numberLabel;
        int selected = -1;
        boolean contentNumbered;
        int taWidth;

        private WrappedCellRenderer(boolean contentNumbered, int wrappingWidth) {
            super(new BorderLayout());
            this.contentNumbered = contentNumbered;
            this.ta.setOpaque(false);
            this.ta.setEditable(false);
            this.ta.setLineWrap(true);
            this.ta.setWrapStyleWord(true);
            this.ta.setFont(UIManager.getFont("Label.font"));
            this.ta.getAccessibleContext().setAccessibleDescription("");
            this.taWidth = wrappingWidth - 12 - 12;
            this.numberLabel = new JLabel(){

                protected void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    if (!WrappedCellRenderer.this.contentNumbered) {
                        Rectangle rect = g.getClipBounds();
                        g.fillOval(rect.x, rect.y, 7, 7);
                    }
                }
            };
            this.numberLabel.setLabelFor(this.ta);
            this.numberLabel.setHorizontalAlignment(2);
            this.numberLabel.setVerticalAlignment(1);
            this.numberLabel.setFont(this.ta.getFont());
            this.numberLabel.setOpaque(false);
            this.numberLabel.setPreferredSize(new Dimension(25, 0));
            this.add((Component)this.numberLabel, "West");
            this.taWidth -= 25;
            Insets taInsets = this.ta.getInsets();
            this.ta.setSize(this.taWidth, taInsets.top + taInsets.bottom + 1);
            this.add((Component)this.ta, "Center");
            this.setBorder(BorderFactory.createEmptyBorder(0, 12, 0, 12));
            this.setOpaque(false);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (index == this.selected) {
                this.numberLabel.setFont(WizardDescriptor.doDeriveFont(this.numberLabel.getFont(), 1));
                this.ta.setFont(WizardDescriptor.doDeriveFont(this.ta.getFont(), 1));
            } else {
                this.numberLabel.setFont(WizardDescriptor.doDeriveFont(this.numberLabel.getFont(), 0));
                this.ta.setFont(WizardDescriptor.doDeriveFont(this.ta.getFont(), 0));
            }
            if (this.contentNumbered) {
                this.numberLabel.setText(Integer.toString(index + 1) + ".");
            }
            Insets taInsets = this.ta.getInsets();
            this.ta.setSize(this.taWidth, taInsets.top + taInsets.bottom + 1);
            this.ta.setText((String)value);
            return this;
        }

        private void setSelectedIndex(int i) {
            this.selected = i;
        }

        private void setForegroundColor(Color color) {
            if (this.numberLabel != null) {
                this.numberLabel.setForeground(color);
                this.numberLabel.setBackground(color);
            }
            this.ta.setForeground(color);
        }
    }

    private static class ImagedPanel
    extends JComponent
    implements Accessible,
    Runnable {
        Image image;
        Image tempImage;
        Image image2Load;
        boolean isDefault = false;
        boolean loadPending = false;
        boolean north = true;
        private final Object IMAGE_LOCK = new Object();

        public ImagedPanel(Image im) {
            this.setImage(im);
            this.setLayout(new BorderLayout());
            this.setOpaque(true);
        }

        protected void paintComponent(Graphics graphics) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (this.image != null) {
                graphics.drawImage(this.image, 0, this.north ? 0 : this.getHeight() - this.image.getHeight(null), this);
            } else if (this.image2Load != null) {
                this.loadImageInBackground(this.image2Load);
                this.image2Load = null;
            }
        }

        public void setImageAlignment(String align) {
            this.north = "North".equals(align);
        }

        public void setImage(Image im) {
            if (im != null) {
                this.loadImage(im);
                this.isDefault = false;
                return;
            }
            if (!this.isDefault) {
                this.loadImage(WizardDescriptor.getDefaultImage());
                this.isDefault = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void loadImage(Image im) {
            MediaTracker mt = new MediaTracker(this);
            mt.addImage(im, 0);
            if (mt.checkID(0)) {
                this.image = im;
                if (this.isShowing()) {
                    this.repaint();
                }
                return;
            }
            if (this.isShowing()) {
                this.loadImageInBackground(im);
            } else {
                Object object = this.IMAGE_LOCK;
                synchronized (object) {
                    this.image = null;
                }
                this.image2Load = im;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void loadImageInBackground(Image image) {
            Object object = this.IMAGE_LOCK;
            synchronized (object) {
                this.tempImage = image;
                if (this.loadPending) {
                    return;
                }
                this.loadPending = true;
            }
            RequestProcessor.getDefault().post((Runnable)this, 30);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Image localImage = null;
            Object object = this.IMAGE_LOCK;
            synchronized (object) {
                localImage = this.tempImage;
                this.tempImage = null;
                this.loadPending = false;
            }
            ImageIcon localImageIcon = new ImageIcon(localImage);
            boolean shouldRepaint = false;
            Object object2 = this.IMAGE_LOCK;
            synchronized (object2) {
                if (!this.loadPending) {
                    this.image = localImageIcon.getImage();
                    shouldRepaint = true;
                }
            }
            if (shouldRepaint) {
                this.repaint();
            }
        }
    }

    private class PropL
    implements PropertyChangeListener {
        PropL() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            if (WizardDescriptor.this.wizardPanel == null) {
                return;
            }
            String propName = e.getPropertyName();
            WizardDescriptor.this.setPanelProperties((JComponent)WizardDescriptor.this.wizardPanel.getRightComponent());
            if (propName.equals(WizardDescriptor.PROP_CONTENT_DATA)) {
                WizardDescriptor.this.wizardPanel.setContent(WizardDescriptor.this.contentData);
                WizardDescriptor.this.updateButtonAccessibleDescription();
            } else if (propName.equals(WizardDescriptor.PROP_CONTENT_SELECTED_INDEX)) {
                WizardDescriptor.this.wizardPanel.setSelectedIndex(WizardDescriptor.this.contentSelectedIndex);
                WizardDescriptor.this.updateButtonAccessibleDescription();
            } else if (propName.equals(WizardDescriptor.PROP_CONTENT_BACK_COLOR)) {
                WizardDescriptor.this.wizardPanel.setContentBackColor(WizardDescriptor.this.contentBackColor);
            } else if (propName.equals(WizardDescriptor.PROP_CONTENT_FOREGROUND_COLOR)) {
                WizardDescriptor.this.wizardPanel.setContentForegroundColor(WizardDescriptor.this.contentForegroundColor);
            } else if (propName.equals(WizardDescriptor.PROP_IMAGE)) {
                WizardDescriptor.this.wizardPanel.setImage(WizardDescriptor.this.image);
            } else if (propName.equals(WizardDescriptor.PROP_IMAGE_ALIGNMENT)) {
                WizardDescriptor.this.wizardPanel.setImageAlignment(WizardDescriptor.this.imageAlignment);
            } else if (propName.equals(WizardDescriptor.PROP_HELP_URL)) {
                WizardDescriptor.this.wizardPanel.setHelpURL(WizardDescriptor.this.helpURL);
            }
        }
    }

    private final class Listener
    implements ChangeListener,
    ActionListener {
        Listener() {
        }

        public void stateChanged(ChangeEvent ev) {
            WizardDescriptor.this.updateState();
        }

        public void actionPerformed(ActionEvent ev) {
            if (WizardDescriptor.this.wizardPanel != null) {
                WizardDescriptor.this.wizardPanel.setErrorMessage(" ", null);
            }
            err.log(1, "actionPerformed entry. Source: " + ev.getSource());
            if (ev.getSource() == WizardDescriptor.this.nextButton) {
                final Dimension previousSize = WizardDescriptor.this.panels.current().getComponent().getSize();
                Runnable onValidPerformer = new Runnable(){

                    public void run() {
                        err.log(1, "onValidPerformer on next button entry.");
                        WizardDescriptor.this.panels.nextPanel();
                        try {
                            WizardDescriptor.this.goToNextStep(previousSize);
                        }
                        catch (IllegalStateException ise) {
                            WizardDescriptor.this.panels.previousPanel();
                            if (ise.getMessage() != null) {
                                DialogDisplayer.getDefault().notify(new NotifyDescriptor.Message(ise.getMessage()));
                            } else {
                                err.notify((Throwable)ise);
                            }
                            WizardDescriptor.this.updateState();
                        }
                        err.log(1, "onValidPerformer on next button exit.");
                    }
                };
                WizardDescriptor.this.lazyValidate(WizardDescriptor.this.panels.current(), onValidPerformer);
            }
            if (ev.getSource() == WizardDescriptor.this.previousButton) {
                WizardDescriptor.this.panels.previousPanel();
                WizardDescriptor.this.updateStateWithFeedback();
            }
            if (ev.getSource() == WizardDescriptor.this.finishButton) {
                Runnable onValidPerformer = new Runnable(){

                    public void run() {
                        err.log(1, "onValidPerformer on finish button entry.");
                        WizardDescriptor.this.cancelButton.setEnabled(false);
                        WizardDescriptor.this.previousButton.setEnabled(false);
                        WizardDescriptor.this.nextButton.setEnabled(false);
                        WizardDescriptor.this.finishButton.setEnabled(false);
                        if (WizardDescriptor.this.wizardPanel != null) {
                            WizardDescriptor.this.wizardPanel.setErrorMessage(NbBundle.getMessage((Class)(class$org$openide$WizardDescriptor == null ? (class$org$openide$WizardDescriptor = WizardDescriptor.class$("org.openide.WizardDescriptor")) : class$org$openide$WizardDescriptor), (String)"MSG_WizardDescriptor_FinishInProgress"), Boolean.TRUE);
                        }
                        Runnable performFinish = new Runnable(){

                            public void run() {
                                err.log(1, "performFinish entry.");
                                try {
                                    WizardDescriptor.this.callInstantiate();
                                }
                                catch (IOException ioe) {
                                    err.notify(1, (Throwable)ioe);
                                    WizardDescriptor.this.setValueWithoutPCH(NEXT_OPTION);
                                    WizardDescriptor.this.updateStateWithFeedback();
                                    WizardDescriptor.this.putProperty(WizardDescriptor.PROP_ERROR_MESSAGE, ioe.getLocalizedMessage());
                                    return;
                                }
                                Object oldValue = WizardDescriptor.this.getValue();
                                WizardDescriptor.this.setValueWithoutPCH(NotifyDescriptor.OK_OPTION);
                                WizardDescriptor.this.resetWizard();
                                WizardDescriptor.this.firePropertyChange("value", oldValue, NotifyDescriptor.OK_OPTION);
                                SwingUtilities.invokeLater(new Runnable(){

                                    public void run() {
                                        err.log(1, "WD.finishOption.fireActionPerformed()");
                                        WizardDescriptor.this.finishOption.fireActionPerformed();
                                        err.log(1, "Set value to OK_OPTION.");
                                        WizardDescriptor.this.setValue(NotifyDescriptor.OK_OPTION);
                                    }
                                });
                                err.log(1, "performFinish exit.");
                            }
                        };
                        if (WizardDescriptor.this.panels instanceof AsynchronousInstantiatingIterator) {
                            err.log(1, "Do ASYNCHRONOUS_JOBS_RP.post(performFinish).");
                            ASYNCHRONOUS_JOBS_RP.post(performFinish);
                        } else {
                            err.log(1, "Run performFinish.");
                            performFinish.run();
                        }
                        err.log(1, "onValidPerformer on finish button exit.");
                    }
                };
                WizardDescriptor.this.lazyValidate(WizardDescriptor.this.panels.current(), onValidPerformer);
            }
            if (ev.getSource() == WizardDescriptor.this.cancelButton) {
                if (WizardDescriptor.this.backgroundValidationTask != null) {
                    WizardDescriptor.this.backgroundValidationTask.cancel();
                }
                Object oldValue = WizardDescriptor.this.getValue();
                WizardDescriptor.this.setValueWithoutPCH(NotifyDescriptor.CANCEL_OPTION);
                if (Arrays.asList(WizardDescriptor.this.getClosingOptions()).contains(WizardDescriptor.this.cancelButton)) {
                    WizardDescriptor.this.resetWizard();
                }
                WizardDescriptor.this.firePropertyChange("value", oldValue, NotifyDescriptor.CANCEL_OPTION);
            }
        }
    }

    public static class ArrayIterator
    implements Iterator {
        private Panel[] panels;
        private int index;

        public ArrayIterator() {
            this.panels = this.initializePanels();
            this.index = 0;
        }

        public ArrayIterator(Panel[] array) {
            this.panels = array;
            this.index = 0;
        }

        protected Panel[] initializePanels() {
            return new Panel[0];
        }

        public Panel current() {
            return this.panels[this.index];
        }

        public String name() {
            return NbBundle.getMessage((Class)(class$org$openide$WizardDescriptor == null ? (class$org$openide$WizardDescriptor = WizardDescriptor.class$("org.openide.WizardDescriptor")) : class$org$openide$WizardDescriptor), (String)"CTL_ArrayIteratorName", (Object)new Integer(this.index + 1), (Object)new Integer(this.panels.length));
        }

        public boolean hasNext() {
            return this.index < this.panels.length - 1;
        }

        public boolean hasPrevious() {
            return this.index > 0;
        }

        public synchronized void nextPanel() {
            if (this.index + 1 == this.panels.length) {
                throw new NoSuchElementException();
            }
            ++this.index;
        }

        public synchronized void previousPanel() {
            if (this.index == 0) {
                throw new NoSuchElementException();
            }
            --this.index;
        }

        public void addChangeListener(ChangeListener l) {
        }

        public void removeChangeListener(ChangeListener l) {
        }

        protected void reset() {
            this.index = 0;
        }
    }

    public static interface AsynchronousInstantiatingIterator
    extends InstantiatingIterator {
        public Set instantiate() throws IOException;
    }

    public static interface InstantiatingIterator
    extends Iterator {
        public Set instantiate() throws IOException;

        public void initialize(WizardDescriptor var1);

        public void uninitialize(WizardDescriptor var1);
    }

    public static interface FinishablePanel
    extends Panel {
        public boolean isFinishPanel();
    }

    public static interface AsynchronousValidatingPanel
    extends ValidatingPanel {
        public void prepareValidation();

        public void validate() throws WizardValidationException;
    }

    public static interface ValidatingPanel
    extends Panel {
        public void validate() throws WizardValidationException;
    }

    public static interface FinishPanel
    extends Panel {
    }

    public static interface Panel {
        public Component getComponent();

        public HelpCtx getHelp();

        public void readSettings(Object var1);

        public void storeSettings(Object var1);

        public boolean isValid();

        public void addChangeListener(ChangeListener var1);

        public void removeChangeListener(ChangeListener var1);
    }

    public static interface Iterator {
        public Panel current();

        public String name();

        public boolean hasNext();

        public boolean hasPrevious();

        public void nextPanel();

        public void previousPanel();

        public void addChangeListener(ChangeListener var1);

        public void removeChangeListener(ChangeListener var1);
    }
}

