/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.folding;

import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.editor.fold.Fold;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldType;
import org.netbeans.api.editor.fold.FoldUtilities;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.structure.api.DocumentElement;
import org.netbeans.modules.editor.structure.api.DocumentModel;
import org.netbeans.modules.editor.structure.api.DocumentModelException;
import org.netbeans.modules.editor.structure.api.DocumentModelListener;
import org.netbeans.modules.xml.text.folding.XmlFoldTypes;
import org.netbeans.spi.editor.fold.FoldHierarchyTransaction;
import org.netbeans.spi.editor.fold.FoldManager;
import org.netbeans.spi.editor.fold.FoldOperation;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

public class XmlFoldManager
implements FoldManager,
SettingsChangeListener,
DocumentModelListener {
    private FoldOperation operation;
    private Timer timer;
    private TimerTask timerTask;
    private int foldsUpdateInterval = 500;
    private long foldsGenerationTime = -1L;
    private DocumentModel model = null;
    private Vector changes = new Vector();
    private static final boolean debug = false;
    private static final boolean lightDebug = false;

    protected FoldOperation getOperation() {
        return this.operation;
    }

    public void init(FoldOperation operation) {
        this.operation = operation;
        Settings.addSettingsChangeListener((SettingsChangeListener)this);
    }

    public void release() {
        Settings.removeSettingsChangeListener((SettingsChangeListener)this);
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        if (this.model != null) {
            this.model.removeDocumentModelListener((DocumentModelListener)this);
            this.model = null;
        }
    }

    public void initFolds(FoldHierarchyTransaction transaction) {
        if (!(this.getDocument() instanceof BaseDocument)) {
            return;
        }
        if (this.getDocument().getLength() > 0) {
            this.timer = new Timer();
            this.restartTimer();
        }
    }

    private void initModelAndFolds() {
        try {
            this.model = DocumentModel.getDocumentModel((Document)((BaseDocument)this.getDocument()));
            this.model.addDocumentModelListener((DocumentModelListener)this);
            this.addElementsRecursivelly(this.changes, this.model.getRootElement());
        }
        catch (DocumentModelException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    private void addElementsRecursivelly(Vector changes, DocumentElement de) {
        try {
            if (!de.equals((Object)this.model.getRootElement()) && !this.isOneLineElement(de)) {
                changes.add(new DocumentModelChangeInfo(de, 1));
            }
        }
        catch (BadLocationException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
        for (DocumentElement child : de.getChildren()) {
            this.addElementsRecursivelly(changes, child);
        }
    }

    public void documentElementAdded(DocumentElement de) {
        this.checkElement2FoldConsistency(de, false);
    }

    public void documentElementRemoved(DocumentElement de) {
        if (!de.equals((Object)this.model.getRootElement()) && !de.getType().equals("content")) {
            this.changes.add(new DocumentModelChangeInfo(de, 2));
        }
        this.checkElement2FoldConsistency(de, true);
        this.restartTimer();
    }

    public void documentElementChanged(DocumentElement de) {
        this.checkElement2FoldConsistency(de, true);
    }

    public void checkElement2FoldConsistency(DocumentElement de, boolean removed) {
        boolean restartTimer = false;
        for (DocumentElement tested = removed ? this.model.getLeafElementForOffset(de.getStartOffset()) : de; tested != null && !tested.equals((Object)this.model.getRootElement()); tested = tested.getParentElement()) {
            if (tested.getType().equals("content")) continue;
            try {
                Fold existingFold = this.getFold(this.getOperation().getHierarchy(), tested);
                boolean oneLineElement = this.isOneLineElement(tested);
                if (existingFold != null && oneLineElement) {
                    this.changes.add(new DocumentModelChangeInfo(tested, 2));
                    restartTimer = true;
                }
                if (existingFold == null && !oneLineElement) {
                    this.changes.add(new DocumentModelChangeInfo(tested, 1));
                    restartTimer = true;
                }
                if (existingFold == null || oneLineElement || this.getFoldTypeForElement(tested) == existingFold.getType() && existingFold.getDescription().equals("<" + tested.getName() + ">")) continue;
                this.changes.add(new DocumentModelChangeInfo(tested, 2));
                this.changes.add(new DocumentModelChangeInfo(tested, 1));
                continue;
            }
            catch (BadLocationException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
        if (restartTimer) {
            this.restartTimer();
        }
    }

    private FoldType getFoldTypeForElement(DocumentElement de) {
        if (de.getType().equals("tag") || de.getType().equals("tag")) {
            return XmlFoldTypes.TAG;
        }
        if (de.getType().equals("pi")) {
            return XmlFoldTypes.PI;
        }
        if (de.getType().equals("doctype")) {
            return XmlFoldTypes.DOCTYPE;
        }
        if (de.getType().equals("comment")) {
            return XmlFoldTypes.COMMENT;
        }
        if (de.getType().equals("cdata")) {
            return XmlFoldTypes.CDATA;
        }
        return null;
    }

    public void documentElementAttributesChanged(DocumentElement de) {
    }

    private void restartTimer() {
        if (this.timer == null) {
            return;
        }
        if (this.timerTask != null) {
            this.timerTask.cancel();
        }
        this.timerTask = this.createTimerTask();
        this.timer.schedule(this.timerTask, this.foldsUpdateInterval);
    }

    private TimerTask createTimerTask() {
        return new TimerTask(){

            public void run() {
                try {
                    if (XmlFoldManager.this.model == null) {
                        XmlFoldManager.this.initModelAndFolds();
                    }
                    XmlFoldManager.this.updateFolds();
                }
                catch (Exception e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFolds() {
        Document doc = this.getDocument();
        if (!(doc instanceof AbstractDocument)) {
            return;
        }
        ((AbstractDocument)doc).readLock();
        try {
            FoldHierarchy fh = this.getOperation().getHierarchy();
            fh.lock();
            try {
                FoldHierarchyTransaction fhTran = this.getOperation().openTransaction();
                try {
                    for (DocumentModelChangeInfo chi : (Vector)this.changes.clone()) {
                        Fold existingFold;
                        DocumentElement de = chi.getDocumentElement();
                        if (chi.getChangeType() == 1 && de.getStartOffset() < de.getEndOffset() && !de.getType().equals("content")) {
                            String foldName = "";
                            FoldType type = XmlFoldTypes.TEXT;
                            if (de.getType().equals("tag") || de.getType().equals("empty_tag")) {
                                foldName = "<" + de.getName() + ">";
                                type = XmlFoldTypes.TAG;
                            } else if (de.getType().equals("pi")) {
                                foldName = NbBundle.getMessage(XmlFoldManager.class, (String)"LBL_PI");
                                type = XmlFoldTypes.PI;
                            } else if (de.getType().equals("doctype")) {
                                foldName = NbBundle.getMessage(XmlFoldManager.class, (String)"LBL_DOCTYPE");
                                type = XmlFoldTypes.DOCTYPE;
                            } else if (de.getType().equals("comment")) {
                                foldName = NbBundle.getMessage(XmlFoldManager.class, (String)"LBL_COMMENT");
                                type = XmlFoldTypes.COMMENT;
                            } else if (de.getType().equals("cdata")) {
                                foldName = NbBundle.getMessage(XmlFoldManager.class, (String)"LBL_CDATA");
                                type = XmlFoldTypes.CDATA;
                            }
                            if (this.getFold(fh, de) != null) continue;
                            this.getOperation().addToHierarchy(type, foldName, false, Math.max(0, de.getStartOffset()), Math.min(this.getDocument().getLength(), de.getEndOffset() + 1), 0, 0, null, fhTran);
                            continue;
                        }
                        if (chi.getChangeType() != 2 || (existingFold = this.getFold(fh, de)) == null) continue;
                        this.getOperation().removeFromHierarchy(existingFold, fhTran);
                    }
                }
                catch (BadLocationException ble) {
                    ErrorManager.getDefault().notify((Throwable)ble);
                }
                finally {
                    fhTran.commit();
                }
            }
            finally {
                fh.unlock();
            }
        }
        finally {
            ((AbstractDocument)doc).readUnlock();
        }
        this.changes.clear();
    }

    private void dumpFolds(Fold f, String indent) {
        System.out.println(indent + f);
        for (int i = 0; i < f.getFoldCount(); ++i) {
            this.dumpFolds(f.getFold(i), indent + "  ");
        }
    }

    private Fold getFold(FoldHierarchy fh, DocumentElement de) {
        int startOffset = de.getStartOffset();
        int endOffset = de.getEndOffset();
        Fold f = FoldUtilities.findNearestFold((FoldHierarchy)fh, (int)de.getStartOffset());
        if (f == null || f.getStartOffset() != de.getStartOffset()) {
            return null;
        }
        if (f.getEndOffset() == de.getEndOffset() || f.getEndOffset() - 1 == de.getEndOffset()) {
            return f;
        }
        return this.getFold(fh, f, de);
    }

    private Fold getFold(FoldHierarchy fh, Fold f, DocumentElement de) {
        int i = 0;
        if (i < f.getFoldCount()) {
            Fold child = f.getFold(i);
            if (child.getStartOffset() == de.getStartOffset()) {
                if (child.getEndOffset() == de.getEndOffset() || child.getEndOffset() - 1 == de.getEndOffset()) {
                    return f;
                }
                return this.getFold(fh, child, de);
            }
            return null;
        }
        return null;
    }

    private boolean isOneLineElement(DocumentElement de) throws BadLocationException {
        BaseDocument bdoc = (BaseDocument)de.getDocument();
        return Utilities.getLineOffset((BaseDocument)bdoc, (int)de.getStartOffset()) == Utilities.getLineOffset((BaseDocument)bdoc, (int)de.getEndOffset());
    }

    public void settingsChange(SettingsChangeEvent evt) {
    }

    private Document getDocument() {
        return this.getOperation().getHierarchy().getComponent().getDocument();
    }

    public long getLastFoldsGenerationTime() {
        return this.foldsGenerationTime;
    }

    public void insertUpdate(DocumentEvent evt, FoldHierarchyTransaction transaction) {
    }

    public void removeUpdate(DocumentEvent evt, FoldHierarchyTransaction transaction) {
    }

    public void changedUpdate(DocumentEvent evt, FoldHierarchyTransaction transaction) {
    }

    public void removeEmptyNotify(Fold epmtyFold) {
    }

    public void removeDamagedNotify(Fold damagedFold) {
    }

    public void expandNotify(Fold expandedFold) {
    }

    private static final class DocumentModelChangeInfo {
        static final int ELEMENT_ADDED = 1;
        static final int ELEMENT_REMOVED = 2;
        private DocumentElement de;
        private int type;

        public DocumentModelChangeInfo(DocumentElement de, int changeType) {
            this.de = de;
            this.type = changeType;
        }

        public DocumentElement getDocumentElement() {
            return this.de;
        }

        public int getChangeType() {
            return this.type;
        }

        public String toString() {
            return "" + (this.type == 1 ? "[ADD]" : "[REMOVE]") + " " + this.de;
        }
    }
}

