/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.ui.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.j2ee.weblogic9.WLPluginProperties;
import org.netbeans.modules.j2ee.weblogic9.ui.wizard.WLInstantiatingIterator;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ServerLocationPanel
extends JPanel
implements WizardDescriptor.Panel {
    private static final String PROP_ERROR_MESSAGE = "WizardPanel_errorMessage";
    private transient WizardDescriptor wizardDescriptor;
    private transient WLInstantiatingIterator instantiatingIterator;
    private JButton locationBrowseButton;
    private JLabel locationLabel;
    private JTextField locationField;
    private JPanel formattingPanel;
    private JFileChooser fileChooser;
    private Vector listeners = new Vector();

    public ServerLocationPanel(String[] steps, int index, ChangeListener listener, WLInstantiatingIterator instantiatingIterator) {
        this.instantiatingIterator = instantiatingIterator;
        this.putClientProperty("WizardPanel_contentData", steps);
        this.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(index));
        this.addChangeListener(listener);
        this.setName(steps[index]);
        this.init();
    }

    public HelpCtx getHelp() {
        return new HelpCtx("j2eeplugins_registering_app_server_weblogic_location");
    }

    public Component getComponent() {
        return this;
    }

    public boolean isValid() {
        this.wizardDescriptor.putProperty(PROP_ERROR_MESSAGE, (Object)"");
        if (!WLPluginProperties.runningOnCorrectJdk()) {
            String msg = NbBundle.getMessage(ServerLocationPanel.class, (String)"ERR_INVALID_JDK");
            this.wizardDescriptor.putProperty(PROP_ERROR_MESSAGE, (Object)msg);
            return false;
        }
        File serverRoot = new File(this.locationField.getText());
        if (!WLPluginProperties.isSupportedVersion(serverRoot)) {
            String msg = NbBundle.getMessage(ServerLocationPanel.class, (String)"ERR_INVALID_SERVER_VERSION");
            this.wizardDescriptor.putProperty(PROP_ERROR_MESSAGE, (Object)msg);
            return false;
        }
        if (!WLPluginProperties.isGoodServerLocation(serverRoot)) {
            String msg = NbBundle.getMessage(ServerLocationPanel.class, (String)"ERR_INVALID_SERVER_ROOT");
            this.wizardDescriptor.putProperty(PROP_ERROR_MESSAGE, (Object)msg);
            return false;
        }
        if (!WLPluginProperties.domainListExists(serverRoot)) {
            String msg = NbBundle.getMessage(ServerLocationPanel.class, (String)"ERR_INVALID_SERVER_ROOT") + " " + NbBundle.getMessage(ServerLocationPanel.class, (String)"DOMAIN_LIST_NOT_FOUND", (Object)(serverRoot.getPath() + File.separator + "common/nodemanager/nodemanager.domains"));
            this.wizardDescriptor.putProperty(PROP_ERROR_MESSAGE, (Object)msg);
            return false;
        }
        WLPluginProperties.getInstance().setInstallLocation(this.locationField.getText());
        WLPluginProperties.getInstance().saveProperties();
        this.instantiatingIterator.setServerRoot(this.locationField.getText());
        return true;
    }

    private void init() {
        this.locationLabel = new JLabel();
        this.locationField = new JTextField();
        this.locationBrowseButton = new JButton();
        this.formattingPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.locationLabel.setText(NbBundle.getMessage(ServerLocationPanel.class, (String)"LBL_SERVER_LOCATION"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        this.locationLabel.setLabelFor(this.locationField);
        this.add((Component)this.locationLabel, gridBagConstraints);
        this.locationField.setColumns(15);
        this.locationField.addKeyListener(new LocationKeyListener());
        String loc = WLPluginProperties.getInstance().getInstallLocation();
        if (loc != null) {
            this.locationField.setText(loc);
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.locationField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServerLocationPanel.class, (String)"ACSD_ServerLocationPanel_locationField"));
        this.add((Component)this.locationField, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.locationBrowseButton, (String)NbBundle.getMessage(ServerLocationPanel.class, (String)"LBL_BROWSE_BUTTON"));
        this.locationBrowseButton.addActionListener(new BrowseActionListener());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.locationBrowseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServerLocationPanel.class, (String)"ACSD_ServerLocationPanel_locationBrowseButton"));
        this.add((Component)this.locationBrowseButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.formattingPanel, gridBagConstraints);
    }

    private void showFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
        }
        this.fileChooser.setFileFilter(new DirectoryFileFilter());
        this.fileChooser.setMultiSelectionEnabled(false);
        this.fileChooser.setFileSelectionMode(1);
        File currentLocation = new File(this.locationField.getText());
        if (currentLocation.exists() && currentLocation.isDirectory()) {
            this.fileChooser.setCurrentDirectory(currentLocation.getParentFile());
            this.fileChooser.setSelectedFile(currentLocation);
        }
        if (this.fileChooser.showOpenDialog(this) == 0) {
            this.locationField.setText(this.fileChooser.getSelectedFile().getPath());
            this.fireChangeEvent();
        }
    }

    public void readSettings(Object object) {
        this.wizardDescriptor = (WizardDescriptor)object;
    }

    public void storeSettings(Object object) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener listener) {
        if (this.listeners != null) {
            Vector vector = this.listeners;
            synchronized (vector) {
                this.listeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener listener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.add(listener);
        }
    }

    private void fireChangeEvent() {
        ChangeEvent event = new ChangeEvent(this);
        this.fireChangeEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChangeEvent(ChangeEvent event) {
        Vector targetListeners;
        Vector vector = this.listeners;
        synchronized (vector) {
            targetListeners = (Vector)this.listeners.clone();
        }
        for (int i = 0; i < targetListeners.size(); ++i) {
            ChangeListener listener = (ChangeListener)targetListeners.elementAt(i);
            listener.stateChanged(event);
        }
    }

    private static class DirectoryFileFilter
    extends FileFilter {
        private DirectoryFileFilter() {
        }

        public boolean accept(File file) {
            return file.exists() && file.isDirectory();
        }

        public String getDescription() {
            return NbBundle.getMessage(ServerLocationPanel.class, (String)"DIRECTORIES_FILTER_NAME");
        }
    }

    private class BrowseActionListener
    implements ActionListener {
        private BrowseActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            ServerLocationPanel.this.showFileChooser();
        }
    }

    private class LocationKeyListener
    extends KeyAdapter {
        private LocationKeyListener() {
        }

        public void keyTyped(KeyEvent event) {
            ServerLocationPanel.this.fireChangeEvent();
        }

        public void keyReleased(KeyEvent event) {
            ServerLocationPanel.this.fireChangeEvent();
        }
    }
}

