/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.projects;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.JEditorPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Element;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.debugger.projects.DebuggerAnnotation;
import org.netbeans.spi.debugger.jpda.EditorContext;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.cookies.SourceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Node;
import org.openide.src.ClassElement;
import org.openide.src.ConstructorElement;
import org.openide.src.FieldElement;
import org.openide.src.Identifier;
import org.openide.src.Import;
import org.openide.src.InitializerElement;
import org.openide.src.SourceElement;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;

public class EditorContextImpl
extends EditorContext {
    private static String fronting = System.getProperty("netbeans.debugger.fronting");
    private PropertyChangeSupport pcs;
    private Map annotationToURL = new HashMap();
    private ChangeListener changedFilesListener;
    private Map timeStampToRegistry = new HashMap();
    private Set modifiedDataObjects;
    private PropertyChangeListener editorObservableListener;
    private Lookup.Result resDataObject;
    private Lookup.Result resEditorCookie;
    private Lookup.Result resNode;
    private Object currentLock = new Object();
    private String currentURL = null;
    private org.openide.src.Element currentElement = null;
    private EditorCookie currentEditorCookie = null;

    public EditorContextImpl() {
        this.pcs = new PropertyChangeSupport((Object)this);
        this.resDataObject = Utilities.actionsGlobalContext().lookup(new Lookup.Template(DataObject.class));
        this.resDataObject.addLookupListener((LookupListener)new EditorLookupListener(DataObject.class));
        this.resEditorCookie = Utilities.actionsGlobalContext().lookup(new Lookup.Template(EditorCookie.class));
        this.resEditorCookie.addLookupListener((LookupListener)new EditorLookupListener(EditorCookie.class));
        this.resNode = Utilities.actionsGlobalContext().lookup(new Lookup.Template(Node.class));
        this.resNode.addLookupListener((LookupListener)new EditorLookupListener(Node.class));
    }

    public boolean showSource(String url, int lineNumber, Object timeStamp) {
        Line l = this.getLine(url, lineNumber, timeStamp);
        if (l == null) {
            return false;
        }
        if (fronting != null) {
            if (fronting.equals("true")) {
                l.show(3);
            } else {
                l.show(2);
            }
            return true;
        }
        if (Utilities.isWindows()) {
            l.show(3);
        } else {
            l.show(2);
        }
        return true;
    }

    public void createTimeStamp(Object timeStamp) {
        this.modifiedDataObjects = new HashSet(DataObject.getRegistry().getModifiedSet());
        Registry r = new Registry();
        this.timeStampToRegistry.put(timeStamp, r);
        Iterator i = this.modifiedDataObjects.iterator();
        while (i.hasNext()) {
            r.register((DataObject)i.next());
        }
        if (this.changedFilesListener == null) {
            this.changedFilesListener = new ChangedFilesListener();
            DataObject.getRegistry().addChangeListener(this.changedFilesListener);
        }
    }

    public void disposeTimeStamp(Object timeStamp) {
        this.timeStampToRegistry.remove(timeStamp);
        if (this.timeStampToRegistry.isEmpty()) {
            DataObject.getRegistry().removeChangeListener(this.changedFilesListener);
            this.changedFilesListener = null;
        }
    }

    public Object annotate(String url, int lineNumber, String annotationType, Object timeStamp) {
        Line l = this.getLine(url, lineNumber, timeStamp);
        if (l == null) {
            return null;
        }
        DebuggerAnnotation annotation = new DebuggerAnnotation(annotationType, l);
        this.annotationToURL.put(annotation, url);
        return annotation;
    }

    public void removeAnnotation(Object a) {
        DebuggerAnnotation annotation = (DebuggerAnnotation)((Object)a);
        annotation.detach();
        if (this.annotationToURL.remove((Object)annotation) == null) {
            return;
        }
    }

    public int getLineNumber(Object annotation, Object timeStamp) {
        DebuggerAnnotation a = (DebuggerAnnotation)((Object)annotation);
        if (timeStamp == null) {
            return a.getLine().getLineNumber() + 1;
        }
        String url = (String)this.annotationToURL.get((Object)a);
        Line.Set lineSet = this.getLineSet(url, timeStamp);
        return lineSet.getOriginalLineNumber(a.getLine()) + 1;
    }

    public void updateTimeStamp(Object timeStamp, String url) {
        Registry registry = (Registry)this.timeStampToRegistry.get(timeStamp);
        registry.register(EditorContextImpl.getDataObject(url));
    }

    public int getCurrentLineNumber() {
        EditorCookie e = this.getCurrentEditorCookie();
        if (e == null) {
            return -1;
        }
        JEditorPane ep = this.getCurrentEditor();
        if (ep == null) {
            return -1;
        }
        StyledDocument d = e.getDocument();
        if (d == null) {
            return -1;
        }
        Caret caret = ep.getCaret();
        if (caret == null) {
            return -1;
        }
        int ln = NbDocument.findLineNumber((StyledDocument)d, (int)caret.getDot());
        return ln + 1;
    }

    public String getCurrentClassName() {
        org.openide.src.Element e = this.getCurrentElement();
        if (e == null) {
            return "";
        }
        if (e instanceof ClassElement) {
            return EditorContextImpl.getClassName((ClassElement)e);
        }
        if (e instanceof ConstructorElement) {
            return EditorContextImpl.getClassName(((ConstructorElement)e).getDeclaringClass());
        }
        if (e instanceof FieldElement) {
            return EditorContextImpl.getClassName(((FieldElement)e).getDeclaringClass());
        }
        if (e instanceof InitializerElement) {
            return EditorContextImpl.getClassName(((InitializerElement)e).getDeclaringClass());
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCurrentURL() {
        Object object = this.currentLock;
        synchronized (object) {
            if (this.currentURL == null) {
                DataObject[] nodes = this.resDataObject.allInstances().toArray(new DataObject[0]);
                this.currentURL = "";
                if (nodes.length != 1) {
                    return this.currentURL;
                }
                DataObject dO = nodes[0];
                if (dO instanceof DataShadow) {
                    dO = ((DataShadow)dO).getOriginal();
                }
                try {
                    this.currentURL = dO.getPrimaryFile().getURL().toString();
                }
                catch (FileStateInvalidException ex) {
                    // empty catch block
                }
            }
            return this.currentURL;
        }
    }

    public String getCurrentMethodName() {
        org.openide.src.Element e = this.getCurrentElement();
        if (e instanceof ConstructorElement) {
            return ((ConstructorElement)e).getName().getName();
        }
        if (e instanceof InitializerElement) {
            return ((InitializerElement)e).isStatic() ? "<clinit>" : "<init>";
        }
        return "";
    }

    public String getCurrentFieldName() {
        org.openide.src.Element e = this.getCurrentElement();
        if (e instanceof FieldElement) {
            return ((FieldElement)e).getName().getName();
        }
        return this.getSelectedIdentifier();
    }

    public String getSelectedIdentifier() {
        JEditorPane ep = this.getCurrentEditor();
        if (ep == null) {
            return null;
        }
        String s = ep.getSelectedText();
        if (s == null) {
            return null;
        }
        if (Utilities.isJavaIdentifier((String)s)) {
            return s;
        }
        return null;
    }

    public String getSelectedMethodName() {
        EditorCookie e = this.getCurrentEditorCookie();
        if (e == null) {
            return "";
        }
        JEditorPane ep = this.getCurrentEditor();
        if (ep == null) {
            return "";
        }
        StyledDocument doc = e.getDocument();
        if (doc == null) {
            return "";
        }
        int offset = ep.getCaret().getDot();
        String t = null;
        int line = NbDocument.findLineNumber((StyledDocument)doc, (int)offset);
        int col = NbDocument.findLineColumn((StyledDocument)doc, (int)offset);
        try {
            int identEnd;
            int identStart;
            Element lineElem = NbDocument.findLineRootElement((StyledDocument)doc).getElement(line);
            if (lineElem == null) {
                return "";
            }
            int lineStartOffset = lineElem.getStartOffset();
            int lineLen = lineElem.getEndOffset() - lineStartOffset;
            t = doc.getText(lineStartOffset, lineLen);
            for (identStart = col; identStart > 0 && Character.isJavaIdentifierPart(t.charAt(identStart - 1)); --identStart) {
            }
            for (identEnd = col; identEnd < lineLen && Character.isJavaIdentifierPart(t.charAt(identEnd)); ++identEnd) {
            }
            int i = t.indexOf(40, identEnd);
            if (i < 0) {
                return "";
            }
            if (t.substring(identEnd, i).trim().length() > 0) {
                return "";
            }
            if (identStart == identEnd) {
                return "";
            }
            return t.substring(identStart, identEnd);
        }
        catch (BadLocationException ex) {
            return "";
        }
    }

    public int getFieldLineNumber(String url, String className, String fieldName) {
        DataObject dataObject = EditorContextImpl.getDataObject(url);
        if (dataObject == null) {
            return -1;
        }
        SourceCookie.Editor sc = (SourceCookie.Editor)dataObject.getCookie(SourceCookie.Editor.class);
        if (sc == null) {
            return -1;
        }
        sc.open();
        StyledDocument sd = sc.getDocument();
        if (sd == null) {
            return -1;
        }
        ClassElement[] classes = sc.getSource().getAllClasses();
        FieldElement fe = null;
        int k = classes.length;
        for (int i = 0; i < k; ++i) {
            if (!classes[i].getName().getFullName().equals(className)) continue;
            fe = classes[i].getField(Identifier.create((String)fieldName));
            break;
        }
        if (fe == null) {
            return -1;
        }
        int position = sc.sourceToText(fe).getStartOffset();
        return NbDocument.findLineNumber((StyledDocument)sd, (int)position) + 1;
    }

    public String getClassName(String url, int lineNumber) {
        int offset;
        DataObject dataObject = EditorContextImpl.getDataObject(url);
        if (dataObject == null) {
            return null;
        }
        SourceCookie.Editor sc = (SourceCookie.Editor)dataObject.getCookie(SourceCookie.Editor.class);
        if (sc == null) {
            return null;
        }
        StyledDocument sd = null;
        try {
            sd = sc.openDocument();
        }
        catch (IOException ex) {
            // empty catch block
        }
        if (sd == null) {
            return null;
        }
        try {
            offset = NbDocument.findLineOffset((StyledDocument)sd, (int)(lineNumber - 1));
        }
        catch (IndexOutOfBoundsException ioobex) {
            return null;
        }
        org.openide.src.Element element = sc.findElement(offset);
        if (element == null) {
            return "";
        }
        if (element instanceof ClassElement) {
            return EditorContextImpl.getClassName((ClassElement)element);
        }
        if (element instanceof ConstructorElement) {
            return EditorContextImpl.getClassName(((ConstructorElement)element).getDeclaringClass());
        }
        if (element instanceof FieldElement) {
            return EditorContextImpl.getClassName(((FieldElement)element).getDeclaringClass());
        }
        if (element instanceof InitializerElement) {
            return EditorContextImpl.getClassName(((InitializerElement)element).getDeclaringClass());
        }
        return "";
    }

    public String[] getImports(String url) {
        DataObject dataObject = EditorContextImpl.getDataObject(url);
        if (dataObject == null) {
            return new String[0];
        }
        SourceCookie.Editor sc = (SourceCookie.Editor)dataObject.getCookie(SourceCookie.Editor.class);
        if (sc == null) {
            return new String[0];
        }
        Import[] is = sc.getSource().getImports();
        int k = is.length;
        String[] is2 = new String[k];
        for (int i = 0; i < k; ++i) {
            is2[i] = is[i].getIdentifier().getFullName();
        }
        return is2;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(propertyName, l);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(propertyName, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private org.openide.src.Element getCurrentElement() {
        Object object = this.currentLock;
        synchronized (object) {
            if (this.currentElement == null) {
                Node[] nodes = TopComponent.getRegistry().getCurrentNodes();
                if (nodes == null) {
                    return null;
                }
                if (nodes.length != 1) {
                    return null;
                }
                Node n = nodes[0];
                this.currentElement = (org.openide.src.Element)n.getCookie(org.openide.src.Element.class);
            }
            return this.currentElement;
        }
    }

    private JEditorPane getCurrentEditor() {
        EditorCookie e = this.getCurrentEditorCookie();
        if (e == null) {
            return null;
        }
        JEditorPane[] op = e.getOpenedPanes();
        if (op == null || op.length < 1) {
            return null;
        }
        return op[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EditorCookie getCurrentEditorCookie() {
        Object object = this.currentLock;
        synchronized (object) {
            if (this.currentEditorCookie == null) {
                TopComponent tc = TopComponent.getRegistry().getActivated();
                if (tc != null) {
                    this.currentEditorCookie = (EditorCookie)tc.getLookup().lookup(EditorCookie.class);
                }
                if (this.currentEditorCookie instanceof EditorCookie.Observable) {
                    if (this.editorObservableListener == null) {
                        this.editorObservableListener = new EditorLookupListener(EditorCookie.Observable.class);
                    }
                    ((EditorCookie.Observable)this.currentEditorCookie).addPropertyChangeListener(this.editorObservableListener);
                }
            }
            return this.currentEditorCookie;
        }
    }

    private static String getClassName(ClassElement e) {
        String f = e.getName().getFullName();
        if (!e.isInner()) {
            return f;
        }
        SourceElement sourceEl = e.getSource();
        if (sourceEl == null) {
            return f;
        }
        Identifier ident = sourceEl.getPackage();
        String c = ident == null ? "" : ident.getFullName();
        if (c.length() > 0) {
            return c + '.' + f.substring(c.length() + 1).replace('.', '$');
        }
        return f.replace('.', '$');
    }

    private Line.Set getLineSet(String url, Object timeStamp) {
        LineCookie lineCookie;
        DataObject dataObject = EditorContextImpl.getDataObject(url);
        if (dataObject == null) {
            return null;
        }
        if (timeStamp != null) {
            Registry registry = (Registry)this.timeStampToRegistry.get(timeStamp);
            Line.Set ls = null;
            try {
                ls = registry.getLineSet(dataObject);
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
            if (ls != null) {
                return ls;
            }
        }
        if ((lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class)) == null) {
            return null;
        }
        return lineCookie.getLineSet();
    }

    private Line getLine(String url, int lineNumber, Object timeStamp) {
        Line.Set ls = this.getLineSet(url, timeStamp);
        if (ls == null) {
            return null;
        }
        try {
            if (timeStamp == null) {
                return ls.getCurrent(lineNumber - 1);
            }
            return ls.getOriginal(lineNumber - 1);
        }
        catch (IndexOutOfBoundsException e) {
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        return null;
    }

    private static DataObject getDataObject(String url) {
        FileObject file;
        try {
            file = URLMapper.findFileObject((URL)new URL(url));
        }
        catch (MalformedURLException e) {
            return null;
        }
        if (file == null) {
            return null;
        }
        try {
            return DataObject.find((FileObject)file);
        }
        catch (DataObjectNotFoundException ex) {
            return null;
        }
    }

    private class EditorLookupListener
    implements LookupListener,
    PropertyChangeListener {
        private Class type;

        public EditorLookupListener(Class type) {
            this.type = type;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resultChanged(LookupEvent ev) {
            if (this.type == (class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = EditorContextImpl.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject)) {
                Object object = EditorContextImpl.this.currentLock;
                synchronized (object) {
                    EditorContextImpl.this.currentURL = null;
                    EditorContextImpl.this.currentElement = null;
                    if (EditorContextImpl.this.currentEditorCookie instanceof EditorCookie.Observable) {
                        ((EditorCookie.Observable)EditorContextImpl.this.currentEditorCookie).removePropertyChangeListener(EditorContextImpl.this.editorObservableListener);
                    }
                    EditorContextImpl.this.currentEditorCookie = null;
                }
                EditorContextImpl.this.pcs.firePropertyChange("currentNodes", null, null);
            } else if (this.type == (class$org$openide$cookies$EditorCookie == null ? (class$org$openide$cookies$EditorCookie = EditorContextImpl.class$("org.openide.cookies.EditorCookie")) : class$org$openide$cookies$EditorCookie)) {
                Object object = EditorContextImpl.this.currentLock;
                synchronized (object) {
                    EditorContextImpl.this.currentURL = null;
                    EditorContextImpl.this.currentElement = null;
                    if (EditorContextImpl.this.currentEditorCookie instanceof EditorCookie.Observable) {
                        ((EditorCookie.Observable)EditorContextImpl.this.currentEditorCookie).removePropertyChangeListener(EditorContextImpl.this.editorObservableListener);
                    }
                    EditorContextImpl.this.currentEditorCookie = null;
                }
                EditorContextImpl.this.pcs.firePropertyChange("currentNodes", null, null);
            } else if (this.type == (class$org$openide$nodes$Node == null ? (class$org$openide$nodes$Node = EditorContextImpl.class$("org.openide.nodes.Node")) : class$org$openide$nodes$Node)) {
                Object object = EditorContextImpl.this.currentLock;
                synchronized (object) {
                    EditorContextImpl.this.currentElement = null;
                }
                EditorContextImpl.this.pcs.firePropertyChange("currentNodes", null, null);
            }
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("openedPanes")) {
                EditorContextImpl.this.pcs.firePropertyChange("openedPanes", null, null);
            }
        }
    }

    private class ChangedFilesListener
    implements ChangeListener {
        private ChangedFilesListener() {
        }

        public void stateChanged(ChangeEvent e) {
            HashSet newDOs = new HashSet(DataObject.getRegistry().getModifiedSet());
            newDOs.removeAll(EditorContextImpl.this.modifiedDataObjects);
            Iterator i1 = EditorContextImpl.this.timeStampToRegistry.values().iterator();
            while (i1.hasNext()) {
                Registry r = (Registry)i1.next();
                Iterator i2 = newDOs.iterator();
                while (i2.hasNext()) {
                    r.register((DataObject)i2.next());
                }
            }
            EditorContextImpl.this.modifiedDataObjects = new HashSet(DataObject.getRegistry().getModifiedSet());
        }
    }

    private static class Registry {
        private Map dataObjectToLineSet = new HashMap();

        private Registry() {
        }

        void register(DataObject dataObject) {
            LineCookie lc = (LineCookie)dataObject.getCookie(class$org$openide$cookies$LineCookie == null ? (class$org$openide$cookies$LineCookie = EditorContextImpl.class$("org.openide.cookies.LineCookie")) : class$org$openide$cookies$LineCookie);
            if (lc == null) {
                return;
            }
            this.dataObjectToLineSet.put(dataObject, lc.getLineSet());
        }

        Line.Set getLineSet(DataObject dataObject) {
            return (Line.Set)this.dataObjectToLineSet.get(dataObject);
        }
    }
}

