/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit;

import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;

public final class ClassNameTextField
extends JTextField {
    public static final int STATUS_VALID = 0;
    public static final int STATUS_EMPTY = 1;
    public static final int STATUS_INVALID = 2;
    public static final int STATUS_VALID_NOT_DEFAULT = 3;
    static final int STATUS_BEFORE_PART = 3;
    private TextListener documentListener;
    private int externalStatus = 0;
    private boolean externalStatusValid = false;
    private ChangeListener changeListener;
    private ChangeEvent changeEvent;
    private String defaultText;

    public ClassNameTextField() {
        this(null);
        this.setupDocumentListener();
    }

    public ClassNameTextField(String text) {
        super(text == null ? "" : text);
        this.setupDocumentListener();
    }

    public void setDefaultText(String defaultText) {
        if (defaultText == null && this.defaultText == null || defaultText != null && defaultText.equals(this.defaultText)) {
            return;
        }
        this.defaultText = defaultText;
        if (defaultText != null || this.externalStatusValid && this.externalStatus == 3) {
            this.statusMaybeChanged();
        }
    }

    private void setupDocumentListener() {
        this.documentListener = new TextListener();
        this.getDocument().addDocumentListener(this.documentListener);
    }

    int determineStatus() {
        String text = this.getText();
        int status = 3;
        char[] chars = text.toCharArray();
        block4: for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            switch (status) {
                case 3: {
                    if (!Character.isJavaIdentifierStart(c)) {
                        return 2;
                    }
                    status = 0;
                    continue block4;
                }
                case 0: {
                    if (c == '.') {
                        status = 3;
                        continue block4;
                    }
                    if (Character.isJavaIdentifierPart(c)) {
                        status = 0;
                        continue block4;
                    }
                    return 2;
                }
                default: {
                    assert (false);
                    continue block4;
                }
            }
        }
        return status;
    }

    public int getStatus() {
        if (!this.externalStatusValid) {
            this.updateExternalStatus();
        }
        return this.externalStatus;
    }

    private void updateExternalStatus() {
        assert (!this.externalStatusValid);
        int internalStatus = this.documentListener.status;
        switch (internalStatus) {
            case 0: {
                this.externalStatus = this.defaultText == null || this.defaultText.equals(this.getText()) ? 0 : 3;
                break;
            }
            case 3: {
                this.externalStatus = this.getText().length() == 0 ? 1 : 2;
                break;
            }
            case 2: {
                this.externalStatus = 2;
                break;
            }
            default: {
                assert (false);
                this.externalStatus = 2;
            }
        }
        this.externalStatusValid = true;
    }

    public void setChangeListener(ChangeListener listener) {
        this.changeEvent = new ChangeEvent(this);
        this.changeListener = listener;
    }

    private void statusMaybeChanged() {
        this.externalStatusValid = false;
        if (this.changeListener != null) {
            int prevExternalStatus = this.externalStatus;
            this.externalStatus = this.getStatus();
            if (this.externalStatus != prevExternalStatus) {
                this.changeListener.stateChanged(this.changeEvent);
            }
        }
    }

    private final class TextListener
    implements DocumentListener {
        private int status;
        private int length;

        public TextListener() {
            this.status = ClassNameTextField.this.determineStatus();
            this.length = ClassNameTextField.this.getText().length();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.length = documentEvent.getDocument().getLength();
            int newStatus = ClassNameTextField.this.determineStatus();
            if (newStatus != this.status) {
                this.status = newStatus;
                ClassNameTextField.this.statusMaybeChanged();
            } else if (this.status == 0 && ClassNameTextField.this.defaultText != null) {
                ClassNameTextField.this.statusMaybeChanged();
            }
            assert (this.length == ClassNameTextField.this.getDocument().getLength());
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            int newStatus;
            boolean wasEmpty;
            boolean bl = wasEmpty = this.length == 0;
            if (documentEvent.getLength() != 1 || documentEvent.getOffset() != this.length) {
                this.length += documentEvent.getLength();
                newStatus = ClassNameTextField.this.determineStatus();
            } else {
                try {
                    char c = documentEvent.getDocument().getText(this.length++, 1).charAt(0);
                    switch (this.status) {
                        case 0: {
                            newStatus = c == '.' ? (newStatus = 3) : (Character.isJavaIdentifierPart(c) ? 0 : 2);
                            break;
                        }
                        case 3: {
                            newStatus = Character.isJavaIdentifierStart(c) ? 0 : 2;
                            break;
                        }
                        case 2: {
                            newStatus = ClassNameTextField.this.determineStatus();
                            break;
                        }
                        default: {
                            assert (false);
                            newStatus = ClassNameTextField.this.determineStatus();
                            break;
                        }
                    }
                }
                catch (BadLocationException ex) {
                    assert (false);
                    this.length = documentEvent.getDocument().getLength();
                    newStatus = ClassNameTextField.this.determineStatus();
                }
            }
            if (newStatus != this.status || wasEmpty) {
                this.status = newStatus;
                ClassNameTextField.this.statusMaybeChanged();
            } else if (this.status == 0 && ClassNameTextField.this.defaultText != null) {
                ClassNameTextField.this.statusMaybeChanged();
            }
            assert (this.length == ClassNameTextField.this.getDocument().getLength());
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            int newStatus;
            if (documentEvent.getLength() != 1 || documentEvent.getOffset() != this.length - 1) {
                this.length -= documentEvent.getLength();
                newStatus = ClassNameTextField.this.determineStatus();
            } else {
                --this.length;
                switch (this.status) {
                    case 0: {
                        try {
                            newStatus = this.length == 0 || documentEvent.getDocument().getText(this.length - 1, 1).charAt(0) == '.' ? 3 : 0;
                        }
                        catch (BadLocationException ex) {
                            assert (false);
                            newStatus = ClassNameTextField.this.determineStatus();
                            this.length = documentEvent.getDocument().getLength();
                        }
                        break;
                    }
                    case 3: {
                        newStatus = 0;
                        break;
                    }
                    case 2: {
                        newStatus = this.length == 0 ? 0 : ClassNameTextField.this.determineStatus();
                        break;
                    }
                    default: {
                        assert (false);
                        newStatus = ClassNameTextField.this.determineStatus();
                    }
                }
            }
            if (newStatus != this.status || this.length == 0) {
                this.status = newStatus;
                ClassNameTextField.this.statusMaybeChanged();
            } else if (this.status == 0 && ClassNameTextField.this.defaultText != null) {
                ClassNameTextField.this.statusMaybeChanged();
            }
            assert (this.length == ClassNameTextField.this.getDocument().getLength());
        }
    }
}

