/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.netbeans.jmi.javamodel.AnnotationType;
import org.netbeans.jmi.javamodel.Array;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.Import;
import org.netbeans.jmi.javamodel.ImportClass;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.ParameterizedType;
import org.netbeans.jmi.javamodel.PrimitiveType;
import org.netbeans.jmi.javamodel.PrimitiveTypeKindEnum;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.TypeClass;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.jmiimpl.javamodel.DiffElement;
import org.netbeans.modules.javacore.jmiimpl.javamodel.MetadataElement;
import org.netbeans.modules.javacore.jmiimpl.javamodel.ResourceImpl;
import org.netbeans.modules.junit.JUnitSettings;
import org.netbeans.modules.junit.TestUtil;
import org.netbeans.modules.junit.plugin.JUnitPlugin;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TestCreator {
    private static final String JUNIT_SUPER_CLASS_NAME = "TestCase";
    private static final String JUNIT_FRAMEWORK_PACKAGE_NAME = "junit.framework";
    private static final String METHOD_NAME_SETUP = "setUp";
    private static final String METHOD_NAME_TEARDOWN = "tearDown";
    private static final String CLASS_COMMENT_LINE1 = "TestCreator.javaClass.addTestsHereComment.l1";
    private static final String CLASS_COMMENT_LINE2 = "TestCreator.javaClass.addTestsHereComment.l2";
    private static final String INSTANCE_VAR_NAME = "instance";
    private static final String RESULT_VAR_NAME = "result";
    private static final String EXP_RESULT_VAR_NAME = "expResult";
    private static final String ARTIFICAL_VAR_NAME_BASE = "arg";
    private static final int ACCESS_MODIFIERS = 7;
    private boolean skipTestClasses = true;
    private boolean skipPkgPrivateClasses = false;
    private boolean skipAbstractClasses = false;
    private boolean skipExceptionClasses = false;
    private boolean generateSuiteClasses = true;
    private int methodAccessModifiers = 5;
    private boolean testPkgPrivateMethods = true;
    private boolean generateDefMethodBody = true;
    private boolean generateMethodJavadoc = true;
    private boolean generateSourceCodeHints = true;
    private boolean generateSetUp = true;
    private boolean generateTearDown = true;
    private boolean generateMainMethod = true;
    private String initialMainMethodBody;
    private final Pattern javaIdFullPattern = Pattern.compile("(?:\\p{Lu}|\\p{Ll}|\\p{Lt}|\\p{Lm}|\\p{Lo}|\\p{Nl}|\\p{Sc}|\\p{Pc})(?:\\p{Lu}|\\p{Ll}|\\p{Lt}|\\p{Lm}|\\p{Lo}|\\p{Nl}|\\p{Sc}|\\p{Pc}|\\p{Mn}|\\p{Mc}|\\p{Nd}|\\p{Cf}|[\\x00-\\x08\\x0e-\\x1b\\x7f-\\x9f])*(?:\\.(?:\\p{Lu}|\\p{Ll}|\\p{Lt}|\\p{Lm}|\\p{Lo}|\\p{Nl}|\\p{Sc}|\\p{Pc})(?:\\p{Lu}|\\p{Ll}|\\p{Lt}|\\p{Lm}|\\p{Lo}|\\p{Nl}|\\p{Sc}|\\p{Pc}|\\p{Mn}|\\p{Mc}|\\p{Nd}|\\p{Cf}|[\\x00-\\x08\\x0e-\\x1b\\x7f-\\x9f])*)*");

    public TestCreator(boolean loadDefaults) {
        if (loadDefaults) {
            this.loadDefaults();
        }
    }

    public TestCreator(Map<JUnitPlugin.CreateTestParam, Object> params) {
        JUnitSettings settings = JUnitSettings.getDefault();
        this.skipTestClasses = !JUnitSettings.GENERATE_TESTS_FROM_TEST_CLASSES;
        this.skipPkgPrivateClasses = !Boolean.TRUE.equals(params.get((Object)JUnitPlugin.CreateTestParam.INC_PKG_PRIVATE_CLASS));
        this.skipAbstractClasses = !Boolean.TRUE.equals(params.get((Object)JUnitPlugin.CreateTestParam.INC_ABSTRACT_CLASS));
        this.skipExceptionClasses = !Boolean.TRUE.equals(params.get((Object)JUnitPlugin.CreateTestParam.INC_EXCEPTION_CLASS));
        this.generateSuiteClasses = Boolean.TRUE.equals(params.get((Object)JUnitPlugin.CreateTestParam.INC_GENERATE_SUITE));
        this.methodAccessModifiers = 0;
        if (Boolean.TRUE.equals(params.get((Object)JUnitPlugin.CreateTestParam.INC_PUBLIC))) {
            this.methodAccessModifiers |= 1;
        }
        if (Boolean.TRUE.equals(params.get((Object)JUnitPlugin.CreateTestParam.INC_PROTECTED))) {
            this.methodAccessModifiers |= 4;
        }
        this.testPkgPrivateMethods = Boolean.TRUE.equals(params.get((Object)JUnitPlugin.CreateTestParam.INC_PKG_PRIVATE));
        this.generateDefMethodBody = Boolean.TRUE.equals(params.get((Object)JUnitPlugin.CreateTestParam.INC_METHOD_BODIES));
        this.generateMethodJavadoc = Boolean.TRUE.equals(params.get((Object)JUnitPlugin.CreateTestParam.INC_JAVADOC));
        this.generateSourceCodeHints = Boolean.TRUE.equals(params.get((Object)JUnitPlugin.CreateTestParam.INC_CODE_HINT));
        this.generateSetUp = Boolean.TRUE.equals(params.get((Object)JUnitPlugin.CreateTestParam.INC_SETUP));
        this.generateTearDown = Boolean.TRUE.equals(params.get((Object)JUnitPlugin.CreateTestParam.INC_TEAR_DOWN));
        this.generateMainMethod = settings.isGenerateMainMethod();
    }

    private void loadDefaults() {
        JUnitSettings settings = JUnitSettings.getDefault();
        this.skipTestClasses = JUnitSettings.GENERATE_TESTS_FROM_TEST_CLASSES;
        this.skipPkgPrivateClasses = !settings.isIncludePackagePrivateClasses();
        this.skipAbstractClasses = !settings.isGenerateAbstractImpl();
        this.skipExceptionClasses = !settings.isGenerateExceptionClasses();
        this.generateSuiteClasses = settings.isGenerateSuiteClasses();
        this.methodAccessModifiers = 0;
        if (settings.isMembersPublic()) {
            this.methodAccessModifiers |= 1;
        }
        if (settings.isMembersProtected()) {
            this.methodAccessModifiers |= 4;
        }
        this.testPkgPrivateMethods = settings.isMembersPackage();
        this.generateDefMethodBody = settings.isBodyContent();
        this.generateMethodJavadoc = settings.isJavaDoc();
        this.generateSourceCodeHints = settings.isBodyComments();
        this.generateSetUp = settings.isGenerateSetUp();
        this.generateTearDown = settings.isGenerateTearDown();
        this.generateMainMethod = settings.isGenerateMainMethod();
    }

    public void setSkipTestClasses(boolean skip) {
        this.skipTestClasses = skip;
    }

    public void setSkipPackagePrivateClasses(boolean skip) {
        this.skipPkgPrivateClasses = skip;
    }

    public void setSkipAbstractClasses(boolean skip) {
        this.skipAbstractClasses = skip;
    }

    public void setSkipExceptionClasses(boolean skip) {
        this.skipExceptionClasses = skip;
    }

    public void setGenerateSuiteClasses(boolean generate) {
        this.generateSuiteClasses = generate;
    }

    public void setTestPublicMethods(boolean test) {
        this.methodAccessModifiers = test ? (this.methodAccessModifiers |= 1) : (this.methodAccessModifiers &= 0xFFFFFFFE);
    }

    public void setTestProtectedMethods(boolean test) {
        this.methodAccessModifiers = test ? (this.methodAccessModifiers |= 4) : (this.methodAccessModifiers &= 0xFFFFFFFB);
    }

    public void setTestPackagePrivateMethods(boolean test) {
        this.testPkgPrivateMethods = test;
    }

    public void setGenerateDefMethodBody(boolean generate) {
        this.generateDefMethodBody = generate;
    }

    public void setGenerateMethodJavadoc(boolean generate) {
        this.generateMethodJavadoc = generate;
    }

    public void setGenerateMethodBodyComment(boolean generate) {
        this.generateSourceCodeHints = generate;
    }

    public void setGenerateSetUp(boolean generate) {
        this.generateSetUp = generate;
    }

    public void setGenerateTearDown(boolean generate) {
        this.generateTearDown = generate;
    }

    public void setGenerateMainMethod(boolean generate) {
        this.generateMainMethod = generate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTestClass(Resource srcRc, JavaClass srcClass, Resource tgtRc, JavaClass tgtClass) {
        JavaModel.getJavaRepository().beginTrans(true);
        try {
            new SingleResourceTestCreator(srcRc, tgtRc).createTest(srcClass, tgtClass);
        }
        finally {
            JavaModel.getJavaRepository().endTrans();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTestSuite(List listMembers, String packageName, JavaClass tgtClass) {
        JavaModel.getJavaRepository().beginTrans(true);
        try {
            new SingleResourceTestCreator(null, tgtClass.getResource()).createTestSuite(listMembers, packageName, tgtClass);
        }
        finally {
            JavaModel.getJavaRepository().endTrans();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createEmptyTest(Resource tstRc, JavaClass tstClass) {
        JavaModel.getJavaRepository().beginTrans(true);
        try {
            new SingleResourceTestCreator(null, tstRc).createEmptyTest(tstClass);
        }
        finally {
            JavaModel.getJavaRepository().endTrans();
        }
        if (this.generateSourceCodeHints) {
            JavaModel.getJavaRepository().beginTrans(true);
            try {
                TestCreator.addClassBodyComment(tstClass);
            }
            finally {
                JavaModel.getJavaRepository().endTrans();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TesteableResult isClassTestable(JavaClass jc) {
        assert (jc != null);
        JavaModel.getJavaRepository().beginTrans(true);
        try {
            TesteableResult result = this.isClassTestableSingle(jc);
            if (result.isTesteable()) {
                TesteableResult testeableResult = TesteableResult.OK;
                return testeableResult;
            }
            List containedClasses = TestUtil.collectFeatures(jc, JavaClass.class, 0, true);
            if (containedClasses.isEmpty()) {
                TesteableResult testeableResult = result;
                return testeableResult;
            }
            ArrayList stack = new ArrayList(Math.max(10, containedClasses.size()));
            stack.addAll(containedClasses);
            int stackSize = stack.size();
            HashSet<JavaClass> nonTestable = new HashSet<JavaClass>(64);
            nonTestable.add(jc);
            do {
                JavaClass classToCheck;
                if (!nonTestable.add(classToCheck = (JavaClass)stack.remove(--stackSize))) continue;
                TesteableResult resultSingle = this.isClassTestableSingle(classToCheck);
                if (resultSingle.isTesteable()) {
                    TesteableResult testeableResult = TesteableResult.OK;
                    return testeableResult;
                }
                result = TesteableResult.combine(result, resultSingle);
                containedClasses = TestUtil.collectFeatures(classToCheck, JavaClass.class, 0, true);
                if (containedClasses.isEmpty()) continue;
                stack.addAll(containedClasses);
                stackSize = stack.size();
            } while (stackSize != 0);
            TesteableResult testeableResult = result;
            return testeableResult;
        }
        finally {
            JavaModel.getJavaRepository().endTrans();
        }
    }

    private TesteableResult isClassTestableSingle(JavaClass jc) {
        assert (jc != null);
        TesteableResult result = TesteableResult.OK;
        int modifiers = jc.getModifiers();
        if (Modifier.isPrivate(modifiers)) {
            result = TesteableResult.combine(result, TesteableResult.PRIVATE_CLASS);
        }
        if (this.skipTestClasses && TestUtil.isClassImplementingTestInterface(jc)) {
            result = TesteableResult.combine(result, TesteableResult.TEST_CLASS);
        }
        if (this.skipPkgPrivateClasses && !Modifier.isPublic(modifiers) && !Modifier.isPrivate(modifiers)) {
            result = TesteableResult.combine(result, TesteableResult.PACKAGE_PRIVATE_CLASS);
        }
        if (this.skipAbstractClasses && Modifier.isAbstract(modifiers)) {
            result = TesteableResult.combine(result, TesteableResult.ABSTRACT_CLASS);
        }
        if (!Modifier.isStatic(modifiers) && jc.isInner()) {
            result = TesteableResult.combine(result, TesteableResult.NONSTATIC_INNER_CLASS);
        }
        if (!this.hasTestableMethods(jc)) {
            result = TesteableResult.combine(result, TesteableResult.NO_TESTEABLE_METHODS);
        }
        if (this.skipExceptionClasses && TestUtil.isClassException(jc)) {
            result = TesteableResult.combine(result, TesteableResult.EXCEPTION_CLASS);
        }
        return result;
    }

    private static boolean hasSuiteMethod(JavaClass tgtClass) {
        return tgtClass.getMethod("suite", Collections.EMPTY_LIST, false) != null;
    }

    private static String createTestMethodName(String smName) {
        return "test" + smName.substring(0, 1).toUpperCase() + smName.substring(1);
    }

    private static String getDefaultValue(Type varType) {
        String varTypeName = varType.getName();
        if (varTypeName.equals("void")) {
            return null;
        }
        if (varTypeName.equals("int")) {
            return "0";
        }
        if (varTypeName.equals("float")) {
            return "0.0F";
        }
        if (varTypeName.equals("long")) {
            return "0L";
        }
        if (varTypeName.equals("double")) {
            return "0.0";
        }
        if (varTypeName.equals("boolean")) {
            return "true";
        }
        if (varTypeName.equals("java.lang.String")) {
            return "\"\"";
        }
        if (varTypeName.equals("short")) {
            return "0";
        }
        if (varTypeName.equals("byte")) {
            return "0";
        }
        if (varTypeName.equals("char")) {
            return "' '";
        }
        assert (!(varType instanceof PrimitiveType));
        return "null";
    }

    private static String[] getTestSkeletonVarNames(List sourceMethodParams) {
        String paramName;
        int i;
        if (sourceMethodParams.isEmpty()) {
            return new String[0];
        }
        int count = sourceMethodParams.size();
        String[] varNames = new String[count];
        boolean[] conflicts = new boolean[count];
        boolean issueFound = false;
        HashSet<String> varNamesSet = new HashSet<String>((int)((double)(count + 2) * 1.4));
        varNamesSet.add(INSTANCE_VAR_NAME);
        varNamesSet.add(RESULT_VAR_NAME);
        varNamesSet.add(EXP_RESULT_VAR_NAME);
        Iterator it = sourceMethodParams.iterator();
        for (i = 0; i < count; ++i) {
            varNames[i] = paramName = ((Parameter)it.next()).getName();
            if (paramName == null) {
                issueFound = true;
                continue;
            }
            if (!varNamesSet.add(paramName)) {
                conflicts[i] = true;
                issueFound = true;
                continue;
            }
            conflicts[i] = false;
        }
        if (issueFound) {
            for (i = 0; i < count; ++i) {
                if (varNames[i] == null) {
                    paramName = ARTIFICAL_VAR_NAME_BASE + i;
                    if (varNamesSet.add(paramName)) {
                        varNames[i] = paramName;
                        continue;
                    }
                    conflicts[i] = true;
                }
                if (!conflicts[i]) continue;
                String paramNamePrefix = varNames[i] + '_';
                int index = 2;
                while (!varNamesSet.add(paramName = paramNamePrefix + index++)) {
                }
                varNames[i] = paramName;
            }
        }
        return varNames;
    }

    private static boolean hasInitMethod(JavaClass cls, String methodName) {
        return cls.getMethod(methodName, Collections.EMPTY_LIST, false) != null;
    }

    private static String getParameterString(List params) {
        StringBuffer paramString = new StringBuffer();
        for (Parameter param : params) {
            if (paramString.length() > 0) {
                paramString.append(", ");
            }
            paramString.append(param.getName());
        }
        return paramString.toString();
    }

    private static void addClassBodyComment(JavaClass cls) {
        int off = cls.getEndOffset() - 1;
        String theComment1 = NbBundle.getMessage(TestCreator.class, (String)CLASS_COMMENT_LINE1);
        String theComment2 = NbBundle.getMessage(TestCreator.class, (String)CLASS_COMMENT_LINE2);
        String indent = TestCreator.getIndentString();
        DiffElement diff = new DiffElement(off, off, indent + theComment1 + '\n' + indent + theComment2 + '\n' + '\n');
        ((ResourceImpl)cls.getResource()).addExtDiff(diff);
    }

    private static String getIndentString() {
        String tabString;
        int spt = MetadataElement.getIndentSpace();
        if (spt < 0) {
            spt = 0;
        }
        if (MetadataElement.isExpandTab()) {
            char[] arr = new char[spt];
            Arrays.fill(arr, ' ');
            tabString = new String(arr);
        } else {
            tabString = "\t";
        }
        return tabString;
    }

    private boolean hasTestableMethods(JavaClass cls) {
        Iterator methods = TestUtil.collectFeatures(cls, Method.class, 0, true).iterator();
        while (methods.hasNext()) {
            if (!this.isMethodAcceptable((Method)methods.next())) continue;
            return true;
        }
        return false;
    }

    private boolean isMethodAcceptable(Method m) {
        int modifiers = m.getModifiers();
        return (modifiers & this.methodAccessModifiers) != 0 || this.testPkgPrivateMethods && (modifiers & 7) == 0;
    }

    private String getInitialMainMethodBody() {
        if (this.initialMainMethodBody == null) {
            this.initialMainMethodBody = JUnitSettings.getDefault().getGenerateMainMethodBody();
            if (this.initialMainMethodBody == null) {
                this.initialMainMethodBody = "";
            }
        }
        return this.initialMainMethodBody;
    }

    public static final class TesteableResult {
        private long reason;
        public static final TesteableResult OK = new TesteableResult(0L);
        public static final TesteableResult PACKAGE_PRIVATE_CLASS = new TesteableResult(1L);
        public static final TesteableResult NO_TESTEABLE_METHODS = new TesteableResult(2L);
        public static final TesteableResult TEST_CLASS = new TesteableResult(4L);
        public static final TesteableResult ABSTRACT_CLASS = new TesteableResult(8L);
        public static final TesteableResult NONSTATIC_INNER_CLASS = new TesteableResult(16L);
        public static final TesteableResult EXCEPTION_CLASS = new TesteableResult(32L);
        public static final TesteableResult PRIVATE_CLASS = new TesteableResult(64L);
        private static final String[] reasonBundleKeys = new String[]{"TesteableResult_PkgPrivate", "TesteableResult_NoTesteableMethods", "TesteableResult_TestClass", "TesteableResult_AbstractClass", "TesteableResult_NonstaticInnerClass", "TesteableResult_ExceptionClass", "TesteableResult_Private"};

        private TesteableResult(long reason) {
            this.reason = reason;
        }

        public static TesteableResult combine(TesteableResult lhs, TesteableResult rhs) {
            return new TesteableResult(lhs.reason | rhs.reason);
        }

        public boolean isTesteable() {
            return this.reason == 0L;
        }

        public boolean isFailed() {
            return this.reason != 0L;
        }

        public String getReason() {
            return this.getReason(", ", ", ");
        }

        public String toString() {
            return this.getReason(", ", ", ");
        }

        public String getReason(String separ, String terminalSepar) {
            try {
                ResourceBundle bundle = NbBundle.getBundle(TestCreator.class);
                if (this.reason == 0L) {
                    return bundle.getString("TesteableResult_OK");
                }
                String str = "";
                boolean lastPrep = true;
                long i = 0L;
                long r = this.reason;
                while (r > 0L) {
                    if ((r & 1L) != 0L) {
                        if (str.length() > 0) {
                            if (lastPrep) {
                                str = terminalSepar + str;
                                lastPrep = false;
                            } else {
                                str = separ + str;
                            }
                        }
                        str = bundle.getString(reasonBundleKeys[(int)i]) + str;
                    }
                    r >>= 1;
                    ++i;
                }
                return str;
            }
            catch (MissingResourceException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
                return "";
            }
        }
    }

    final class SingleResourceTestCreator {
        private final Resource srcRc;
        private final Resource tstRc;
        private final JavaModelPackage tgtPkg;
        private final String tstPkgNameDot;
        private final List tstImports;
        private Map clsNames;
        private Collection simpleImports;
        private Collection importedClsTypes;
        private ClassDefinition runtimeException;

        SingleResourceTestCreator(Resource srcRc, Resource tstRc) {
            this.srcRc = srcRc;
            this.tstRc = tstRc;
            this.tgtPkg = (JavaModelPackage)tstRc.refImmediatePackage();
            this.tstPkgNameDot = tstRc.getPackageName() + '.';
            this.tstImports = tstRc.getImports();
            this.clsNames = new HashMap(20);
        }

        void createTest(JavaClass srcClass, JavaClass tstClass) {
            this.tstRc.setPackageName(this.srcRc.getPackageName());
            this.addFrameworkImport();
            this.copySourceImports();
            this.fillTestClass(srcClass, tstClass);
            if (TestCreator.this.generateMainMethod && !TestUtil.hasMainMethod(tstClass)) {
                this.addMainMethod(tstClass);
            }
        }

        void createEmptyTest(JavaClass tstClass) {
            this.addFrameworkImport();
            this.fillGeneral(tstClass);
        }

        void createTestSuite(List listMembers, String packageName, JavaClass tstClass) {
            this.tstRc.setPackageName(packageName);
            this.addFrameworkImport();
            this.fillSuiteClass(listMembers, packageName, tstClass);
            if (TestCreator.this.generateMainMethod && !TestUtil.hasMainMethod(tstClass)) {
                this.addMainMethod(tstClass);
            }
        }

        private void addFrameworkImport() {
            for (Import imp : this.tstRc.getImports()) {
                if (!imp.getName().equals(TestCreator.JUNIT_FRAMEWORK_PACKAGE_NAME) || !imp.isOnDemand() || imp.isStatic()) continue;
                return;
            }
            this.tstRc.getImports().add(this.tgtPkg.getImport().createImport(TestCreator.JUNIT_FRAMEWORK_PACKAGE_NAME, null, false, true));
        }

        private void copySourceImports() {
            List srcImportsList = this.srcRc.getImports();
            List tstImportsList = this.tstRc.getImports();
            HashSet<ImpEq> tImpSet = new HashSet<ImpEq>((int)((float)tstImportsList.size() * 1.4f));
            Iterator i = tstImportsList.iterator();
            while (i.hasNext()) {
                tImpSet.add(new ImpEq((Import)i.next()));
            }
            ImportClass tstImportFactory = this.tgtPkg.getImport();
            for (Import imp : srcImportsList) {
                if (tImpSet.contains(new ImpEq(imp))) continue;
                tstImportsList.add(tstImportFactory.createImport(imp.getName(), null, imp.isStatic(), imp.isOnDemand()));
            }
        }

        private void addMainMethod(JavaClass tstClass) {
            Method mainMethod = this.createMainMethod();
            if (mainMethod != null) {
                tstClass.getFeatures().add(mainMethod);
            }
        }

        private void fillTestClass(JavaClass srcClass, JavaClass tstClass) {
            this.fillGeneral(tstClass);
            List innerClasses = TestUtil.filterFeatures(srcClass, JavaClass.class);
            for (JavaClass innerCls : innerClasses) {
                if (!TestCreator.this.isClassTestable(innerCls).isTesteable()) continue;
                String innerTestClsName = TestUtil.getTestClassName(innerCls.getSimpleName());
                JavaClass innerTestCls = TestUtil.getClassBySimpleName(tstClass, innerTestClsName);
                if (innerTestCls == null) {
                    innerTestCls = this.tgtPkg.getJavaClass().createJavaClass();
                    innerTestCls.setSimpleName(tstClass.getName() + '.' + innerTestClsName);
                    tstClass.getFeatures().add(innerTestCls);
                }
                this.fillTestClass(innerCls, innerTestCls);
                innerTestCls.setModifiers(innerTestCls.getModifiers() | 8);
            }
            if (TestCreator.this.generateSuiteClasses && !TestCreator.hasSuiteMethod(tstClass)) {
                tstClass.getFeatures().add(this.createTestClassSuiteMethod(tstClass));
            }
            List srcMethods = TestUtil.filterFeatures(srcClass, Method.class);
            for (Method sm : srcMethods) {
                if (!TestCreator.this.isMethodAcceptable(sm) || tstClass.getMethod(TestCreator.createTestMethodName(sm.getName()), Collections.EMPTY_LIST, false) != null) continue;
                Method tm = this.createTestMethod(srcClass, sm);
                tstClass.getFeatures().add(tm);
            }
            if (!TestCreator.this.skipAbstractClasses && (Modifier.isAbstract(srcClass.getModifiers()) || srcClass.isInterface())) {
                this.createAbstractImpl(srcClass, tstClass);
            }
        }

        private void fillSuiteClass(List listMembers, String packageName, JavaClass tstClass) {
            this.fillGeneral(tstClass);
            Method suiteMethod = tstClass.getMethod("suite", Collections.EMPTY_LIST, false);
            tstClass.getFeatures().remove(suiteMethod);
            suiteMethod = this.createSuiteMethod(tstClass, listMembers);
            tstClass.getFeatures().add(suiteMethod);
        }

        private void fillGeneral(JavaClass tstClass) {
            tstClass.setSuperClassName(this.tgtPkg.getMultipartId().createMultipartId(TestCreator.JUNIT_SUPER_CLASS_NAME, null, Collections.EMPTY_LIST));
            tstClass.setModifiers(1);
            List<Type> stringTypeList = Collections.singletonList(this.tgtPkg.getType().resolve("java.lang.String"));
            if (tstClass.getConstructor(stringTypeList, false) == null) {
                tstClass.getFeatures().add(this.createTestConstructor(tstClass.getSimpleName()));
            }
            if (TestCreator.this.generateSetUp && !TestCreator.hasInitMethod(tstClass, TestCreator.METHOD_NAME_SETUP)) {
                tstClass.getFeatures().add(this.createInitMethod(TestCreator.METHOD_NAME_SETUP));
            }
            if (TestCreator.this.generateTearDown && !TestCreator.hasInitMethod(tstClass, TestCreator.METHOD_NAME_TEARDOWN)) {
                tstClass.getFeatures().add(this.createInitMethod(TestCreator.METHOD_NAME_TEARDOWN));
            }
        }

        private Constructor createTestConstructor(String className) {
            Constructor constr = this.tgtPkg.getConstructor().createConstructor(className, Collections.EMPTY_LIST, 1, null, null, null, "super(testName);\n", Collections.EMPTY_LIST, this.createTestConstructorParams(), null);
            return constr;
        }

        private List createTestConstructorParams() {
            Parameter param = this.tgtPkg.getParameter().createParameter("testName", Collections.EMPTY_LIST, false, TestUtil.getTypeReference(this.tgtPkg, "String"), 0, false);
            return Collections.singletonList(param);
        }

        private Method createTestClassSuiteMethod(JavaClass tstClass) {
            StringBuffer body = new StringBuffer(1024);
            body.append("TestSuite suite = new TestSuite(");
            body.append(tstClass.getSimpleName());
            body.append(".class);\n");
            List innerClasses = TestUtil.filterFeatures(tstClass, JavaClass.class);
            for (JavaClass jc : innerClasses) {
                if (!TestUtil.isClassTest(jc)) continue;
                body.append("suite.addTest(");
                body.append(jc.getSimpleName());
                body.append(".suite());\n");
            }
            body.append("\nreturn suite;\n");
            Method method = this.createPublicNoargMethod(null, true, "Test", "suite", body.toString());
            return method;
        }

        private Method createTestMethod(JavaClass srcClass, Method srcMethod) {
            String methodName = TestCreator.createTestMethodName(srcMethod.getName());
            String javadocText = TestCreator.this.generateMethodJavadoc ? this.generateJavadoc(srcClass, srcMethod) : null;
            String methodBody = this.generateMethodBody(srcClass, srcMethod);
            boolean throwsExceptions = false;
            List exceptions = srcMethod.getExceptions();
            if (!exceptions.isEmpty()) {
                for (JavaClass exception : exceptions) {
                    if (exception.isSubTypeOf(this.getRuntimeException())) continue;
                    throwsExceptions = true;
                    break;
                }
            }
            List<MultipartId> exceptNames = throwsExceptions ? Collections.singletonList(this.tgtPkg.getMultipartId().createMultipartId("Exception", null, Collections.EMPTY_LIST)) : Collections.EMPTY_LIST;
            Method method = this.tgtPkg.getMethod().createMethod(methodName, Collections.EMPTY_LIST, 1, javadocText, null, null, methodBody, Collections.EMPTY_LIST, Collections.EMPTY_LIST, exceptNames, TestUtil.getTypeReference(this.tgtPkg, "void"), 0);
            return method;
        }

        private Method createSuiteMethod(JavaClass tstClass, List members) {
            String methodName = "suite";
            String javadocText = TestCreator.this.generateSourceCodeHints ? NbBundle.getMessage(TestCreator.class, (String)"TestCreator.suiteMethod.JavaDoc.comment") : null;
            String methodBody = this.generateSuiteBody(tstClass, members);
            Method method = this.createPublicNoargMethod(javadocText, true, "Test", methodName, methodBody);
            return method;
        }

        private Method createInitMethod(String methodName) {
            Method method = this.tgtPkg.getMethod().createMethod(methodName, Collections.EMPTY_LIST, 4, null, null, null, "\n", Collections.EMPTY_LIST, Collections.EMPTY_LIST, Collections.singletonList(TestUtil.getTypeReference(this.tgtPkg, "Exception")), TestUtil.getTypeReference(this.tgtPkg, "void"), 0);
            return method;
        }

        private Method createMainMethod() {
            String initialMainMethodBody = TestCreator.this.getInitialMainMethodBody();
            if (initialMainMethodBody.length() == 0) {
                return null;
            }
            String methodBody = '\n' + initialMainMethodBody + '\n';
            Array paramType = this.tgtPkg.getArray().resolveArray(TestUtil.getStringType(this.tgtPkg));
            Parameter param = this.tgtPkg.getParameter().createParameter("argList", Collections.EMPTY_LIST, false, null, 0, false);
            param.setType((Type)paramType);
            Method method = this.tgtPkg.getMethod().createMethod("main", Collections.EMPTY_LIST, 9, null, null, null, methodBody, Collections.EMPTY_LIST, Collections.singletonList(param), Collections.EMPTY_LIST, TestUtil.getTypeReference(this.tgtPkg, "void"), 0);
            return method;
        }

        private Method createPublicNoargMethod(String javadocText, boolean isStatic, String retType, String methodName, String methodBody) {
            return this.tgtPkg.getMethod().createMethod(methodName, Collections.EMPTY_LIST, isStatic ? 9 : 1, javadocText, null, null, methodBody, Collections.EMPTY_LIST, Collections.EMPTY_LIST, Collections.EMPTY_LIST, TestUtil.getTypeReference(this.tgtPkg, retType), 0);
        }

        private void createAbstractImpl(JavaClass srcClass, JavaClass tstClass) {
            String implClassName = srcClass.getSimpleName() + "Impl";
            JavaClass innerClass = tstClass.getInnerClass(implClassName, false);
            if (innerClass == null) {
                String javadocText;
                javadocText = TestCreator.this.generateMethodJavadoc ? (javadocText = NbBundle.getMessage(TestCreator.class, (String)"TestCreator.abstracImpl.JavaDoc.comment", (Object)srcClass.getName())) : null;
                MultipartId supClass = this.tgtPkg.getMultipartId().createMultipartId(srcClass.isInner() ? srcClass.getName() : srcClass.getSimpleName(), null, Collections.EMPTY_LIST);
                innerClass = this.tgtPkg.getJavaClass().createJavaClass(implClassName, Collections.EMPTY_LIST, 2, javadocText, null, Collections.EMPTY_LIST, null, Collections.EMPTY_LIST, Collections.EMPTY_LIST);
                if (srcClass.isInterface()) {
                    innerClass.getInterfaceNames().add(supClass);
                } else {
                    innerClass.setSuperClassName(supClass);
                }
                this.createImpleConstructors(srcClass, innerClass);
                tstClass.getFeatures().add(innerClass);
            }
            List abstractMethods = TestUtil.collectFeatures(srcClass, Method.class, 1024, true);
            for (Method oldMethod : abstractMethods) {
                if (innerClass.getMethod(oldMethod.getName(), TestUtil.getParameterTypes(oldMethod.getParameters()), false) != null) continue;
                Method newMethod = this.createMethodImpl(oldMethod);
                innerClass.getFeatures().add(newMethod);
            }
        }

        private void createImpleConstructors(JavaClass srcClass, JavaClass tgtClass) {
            List constructors = TestUtil.filterFeatures(srcClass, Constructor.class);
            for (Constructor ctr : constructors) {
                if (Modifier.isPrivate(ctr.getModifiers())) continue;
                Constructor nctr = this.tgtPkg.getConstructor().createConstructor();
                nctr.setBodyText("super(" + TestCreator.getParameterString(ctr.getParameters()) + ");\n");
                nctr.getParameters().addAll(TestUtil.cloneParams(ctr.getParameters(), this.tgtPkg));
                tgtClass.getFeatures().add(nctr);
            }
        }

        private Method createMethodImpl(Method origMethod) {
            Method newMethod = this.tgtPkg.getMethod().createMethod();
            newMethod.setName(origMethod.getName());
            int mod = origMethod.getModifiers() & 0xFFFFFBFF;
            if (((JavaClass)origMethod.getDeclaringClass()).isInterface()) {
                mod |= 1;
            }
            newMethod.setModifiers(mod);
            StringBuffer body = new StringBuffer(200);
            if (TestCreator.this.generateSourceCodeHints) {
                body.append(NbBundle.getMessage(TestCreator.class, (String)"TestCreator.methodImpl.bodyComment"));
                body.append("\n\n");
            }
            newMethod.setType(origMethod.getType());
            Type type = origMethod.getType();
            if (type != null) {
                String value = null;
                if (type instanceof JavaClass || type instanceof Array) {
                    value = "null";
                } else if (type instanceof PrimitiveType) {
                    PrimitiveTypeKindEnum tke = (PrimitiveTypeKindEnum)((PrimitiveType)type).getKind();
                    if (tke.equals((Object)PrimitiveTypeKindEnum.BOOLEAN)) {
                        value = "false";
                    } else if (!tke.equals((Object)PrimitiveTypeKindEnum.VOID)) {
                        value = "0";
                    }
                }
                if (value != null) {
                    body.append("return ").append(value).append(";\n");
                }
            }
            newMethod.setBodyText(body.toString());
            newMethod.getParameters().addAll(TestUtil.cloneParams(origMethod.getParameters(), this.tgtPkg));
            return newMethod;
        }

        private String generateJavadoc(JavaClass srcClass, Method srcMethod) {
            return NbBundle.getMessage(TestCreator.class, (String)"TestCreator.variantMethods.JavaDoc.comment", (Object)srcMethod.getName(), (Object)srcClass.getName());
        }

        private String generateMethodBody(JavaClass srcClass, Method srcMethod) {
            boolean isStatic = (srcMethod.getModifiers() & 8) != 0;
            String shortClsName = this.getTypeNameString((Type)srcClass);
            StringBuffer newBody = new StringBuffer(512);
            boolean needsEmptyLine = false;
            if (TestCreator.this.generateDefMethodBody) {
                boolean isVoid;
                newBody.append("System.out.println(\"").append(srcMethod.getName()).append("\");\n\n");
                List params = srcMethod.getParameters();
                String[] varNames = TestCreator.getTestSkeletonVarNames(params);
                Iterator i = params.iterator();
                for (int j = 0; j < varNames.length; ++j) {
                    Parameter param = (Parameter)i.next();
                    Type paramType = param.getType();
                    String paramTypeName = this.getTypeNameString(paramType);
                    newBody.append(paramTypeName).append(' ').append(varNames[j]).append(" = ").append(TestCreator.getDefaultValue(paramType)).append(";\n");
                }
                assert (!i.hasNext());
                needsEmptyLine |= varNames.length != 0;
                if (!isStatic) {
                    boolean hasDefConstr = false;
                    Constructor constructor = srcClass.getConstructor(Collections.EMPTY_LIST, false);
                    if (constructor == null) {
                        boolean constrFound = false;
                        Iterator j = srcClass.getContents().iterator();
                        while (j.hasNext()) {
                            if (!(j.next() instanceof Constructor)) continue;
                            constrFound = true;
                            break;
                        }
                        hasDefConstr = !constrFound;
                    } else {
                        hasDefConstr = (constructor.getModifiers() & 2) == 0;
                    }
                    newBody.append(shortClsName).append(' ').append(TestCreator.INSTANCE_VAR_NAME).append(" = ");
                    if (hasDefConstr) {
                        newBody.append("new ").append(shortClsName).append("()");
                    } else {
                        newBody.append("null");
                    }
                    newBody.append(";\n");
                    needsEmptyLine |= true;
                }
                if (needsEmptyLine) {
                    newBody.append('\n');
                    needsEmptyLine = false;
                }
                Type returnType = srcMethod.getType();
                String returnTypeName = this.getTypeNameString(returnType);
                String defaultRetValue = TestCreator.getDefaultValue(returnType);
                boolean bl = isVoid = defaultRetValue == null;
                if (!isVoid) {
                    newBody.append(returnTypeName).append(' ').append(TestCreator.EXP_RESULT_VAR_NAME).append(" = ").append(defaultRetValue).append(";\n");
                    newBody.append(returnTypeName).append(' ').append(TestCreator.RESULT_VAR_NAME).append(" = ");
                }
                newBody.append(isStatic ? shortClsName : TestCreator.INSTANCE_VAR_NAME).append('.').append(srcMethod.getName()).append('(');
                if (varNames.length != 0) {
                    newBody.append(varNames[0]);
                    for (int j = 1; j < varNames.length; ++j) {
                        newBody.append(", ").append(varNames[j]);
                    }
                }
                newBody.append(");\n");
                if (!isVoid) {
                    newBody.append("assertEquals(").append(TestCreator.EXP_RESULT_VAR_NAME).append(", ").append(TestCreator.RESULT_VAR_NAME).append(");\n");
                }
                needsEmptyLine = true;
            }
            if (TestCreator.this.generateSourceCodeHints) {
                if (needsEmptyLine) {
                    newBody.append('\n');
                    needsEmptyLine = false;
                }
                newBody.append(NbBundle.getMessage(TestCreator.class, (String)(TestCreator.this.generateDefMethodBody ? "TestCreator.variantMethods.defaultComment" : "TestCreator.variantMethods.onlyComment"))).append('\n');
            }
            if (TestCreator.this.generateDefMethodBody) {
                if (needsEmptyLine) {
                    newBody.append('\n');
                    needsEmptyLine = false;
                }
                newBody.append(NbBundle.getMessage(TestCreator.class, (String)"TestCreator.variantMethods.defaultBody")).append('\n');
            }
            return newBody.toString();
        }

        private String generateSuiteBody(JavaClass tstClass, List members) {
            StringBuffer body = new StringBuffer(512);
            body.append("TestSuite suite = new TestSuite(\"").append(tstClass.getSimpleName()).append("\");\n");
            TypeClass typeClass = this.tgtPkg.getType();
            for (String name : members) {
                Method suiteMethod;
                Type type = typeClass.resolve(name);
                if (!(type instanceof ClassDefinition) || (suiteMethod = ((ClassDefinition)type).getMethod("suite", Collections.EMPTY_LIST, true)) == null || !Modifier.isStatic(suiteMethod.getModifiers())) continue;
                body.append("suite.addTest(").append(name).append(".suite());\n");
            }
            body.append("return suite;\n");
            return body.toString();
        }

        private String getTypeNameString(Type type) {
            if (!(type instanceof ClassDefinition)) {
                return type.getName();
            }
            if (type instanceof Array) {
                return this.getTypeNameString(((Array)type).getType()) + "[]";
            }
            if (type instanceof ParameterizedType) {
                ParameterizedType paramzedType = (ParameterizedType)type;
                String defTypeName = this.getTypeNameString((Type)paramzedType.getDefinition());
                List typeParams = paramzedType.getParameters();
                if (typeParams.isEmpty()) {
                    return defTypeName;
                }
                StringBuffer buf = new StringBuffer(60);
                buf.append(defTypeName).append('<');
                buf.append(this.getTypeNameString((Type)typeParams.get(0)));
                if (typeParams.size() > 1) {
                    Iterator i = typeParams.iterator();
                    i.next();
                    do {
                        buf.append(", ");
                        buf.append(this.getTypeNameString((Type)i.next()));
                    } while (i.hasNext());
                }
                buf.append('>');
                return buf.toString();
            }
            if (type instanceof AnnotationType) {
                return type.getName();
            }
            if (!(type instanceof JavaClass)) {
                return type.getName();
            }
            String fullClsName = type.getName();
            if (!TestCreator.this.javaIdFullPattern.matcher(fullClsName).matches()) {
                return type.getName();
            }
            return this.getJavaClassTypeNameString((JavaClass)type, fullClsName, fullClsName.startsWith("java.lang."), fullClsName.startsWith(this.tstPkgNameDot));
        }

        private String getJavaClassTypeNameString(JavaClass clsType, String fullClsName, boolean maybeFromJavaLang, boolean maybeFromThisPkg) {
            ClassDefinition declaringCls;
            String result;
            if (fullClsName == null) {
                fullClsName = clsType.getName();
            }
            if ((result = (String)this.clsNames.get(fullClsName)) != null) {
                return result;
            }
            String simpleName = clsType.getSimpleName();
            result = maybeFromThisPkg && this.checkIsFromThisPkg(simpleName, fullClsName) || maybeFromJavaLang && this.checkIsFromJavaLang(simpleName, fullClsName) || this.checkIsImported(clsType) ? simpleName : (clsType.isInner() ? ((declaringCls = clsType.getDeclaringClass()) instanceof JavaClass ? this.getJavaClassTypeNameString((JavaClass)declaringCls, null, maybeFromJavaLang, maybeFromThisPkg) + '.' + simpleName : fullClsName) : fullClsName);
            this.clsNames.put(fullClsName, result);
            return result;
        }

        private boolean checkIsFromThisPkg(String shortName, String fullName) {
            return fullName.length() == this.tstPkgNameDot.length() + shortName.length();
        }

        private boolean checkIsFromJavaLang(String shortName, String fullName) {
            return fullName.length() == 10 + shortName.length();
        }

        private boolean checkIsImported(JavaClass clsType) {
            if (this.simpleImports == null) {
                this.prepareImports();
            }
            return this.simpleImports.contains(clsType) || this.importedClsTypes.contains(clsType);
        }

        private void prepareImports() {
            this.simpleImports = new ArrayList(this.tstImports.size());
            this.importedClsTypes = new ArrayList(20);
            for (Import imp : this.tstImports) {
                if (imp.isStatic()) continue;
                if (!imp.isOnDemand()) {
                    this.simpleImports.add(imp.getImportedNamespace());
                    continue;
                }
                Collection importedElems = imp.getImportedElements();
                for (Object o : importedElems) {
                    if (!(o instanceof JavaClass)) continue;
                    this.importedClsTypes.add(o);
                }
            }
            assert (this.simpleImports instanceof ArrayList);
            if (this.simpleImports.isEmpty()) {
                this.simpleImports = Collections.EMPTY_LIST;
            } else {
                ((ArrayList)this.simpleImports).trimToSize();
            }
            assert (this.importedClsTypes instanceof ArrayList);
            if (this.importedClsTypes.isEmpty()) {
                this.importedClsTypes = Collections.EMPTY_LIST;
            } else {
                ((ArrayList)this.importedClsTypes).trimToSize();
            }
        }

        private ClassDefinition getRuntimeException() {
            if (this.runtimeException == null) {
                Type runtimeExcType = this.tgtPkg.getType().resolve("java.lang.RuntimeException");
                this.runtimeException = (ClassDefinition)runtimeExcType;
            }
            assert (this.runtimeException != null);
            return this.runtimeException;
        }
    }

    private static class ImpEq {
        Import imp;

        ImpEq(Import imp) {
            this.imp = imp;
        }

        public boolean equals(Object rhs) {
            if (rhs instanceof ImpEq) {
                Import i = ((ImpEq)rhs).imp;
                return i.isStatic() == this.imp.isStatic() && i.isOnDemand() == this.imp.isOnDemand() && i.getName().equals(this.imp.getName());
            }
            return false;
        }

        public int hashCode() {
            return this.imp.getName().hashCode();
        }
    }
}

