/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.registry.jaxrpc;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.modules.websvc.registry.jaxrpc.Configuration;
import org.netbeans.modules.websvc.registry.jaxrpc.WsdlType;
import org.openide.util.NbBundle;

public class WSCompileArguments {
    protected String additionalClasspath;
    private List features = new ArrayList();
    private String classpath;
    private String outputDirectory;
    private String gen;
    private boolean keep = true;
    private String nonclassOutputDirectory;
    private String sourceOutputDirectory;
    private boolean define;
    private boolean importGen;
    private boolean verbose;
    private String mappingFile;
    private Configuration configuration;
    private List extraArguments = new LinkedList();
    public static final int TYPE_NEED_NO_PARAM = 0;
    public static final int TYPE_NEED_PARAM = 1;
    public static final int TYPE_INTERNAL = 16;
    public static final int TYPE_NON_COMPILE = 256;

    public WSCompileArguments() {
    }

    public WSCompileArguments(String additionalClasspath) {
        this.additionalClasspath = additionalClasspath;
    }

    public void addArgument(String arg) {
        this.addArgument(arg, null);
    }

    public void addArgument(String arg, String param) {
        if ((arg = arg.intern()) == "-gen") {
            this.setGen("");
        } else if (arg.startsWith("-gen:")) {
            this.setGen(arg.substring(5, arg.length()));
        } else if (arg == "-define") {
            this.setDefine(true);
        } else if (arg == "-import") {
            this.setImportGen(true);
        } else if (arg == "-classpath") {
            this.setClasspath(param);
        } else if (arg == "-d") {
            this.setOutputDirectory(param);
        } else if (arg == "-nd") {
            this.setNonclassOutputDirectory(param);
        } else if (arg == "-s") {
            this.setSourceOutputDirectory(param);
        } else if (arg == "-keep") {
            this.setKeep(true);
        } else if (arg == "-verbose") {
            this.setVerbose(true);
        } else if (arg == "-mapping") {
            this.setMapping(param);
        } else if (param == null) {
            this.extraArguments.add(arg);
        } else {
            this.extraArguments.add(arg + " " + param);
        }
    }

    public void addFeature(String feature) {
        if ("documentliteral".equals(feature)) {
            this.features.remove("rpcliteral");
        } else if ("rpcliteral".equals(feature)) {
            this.features.remove("documentliteral");
        } else if ("unwrap".equals(feature)) {
            this.features.remove("donotunwrap");
        } else if ("donotunwrap".equals(feature)) {
            this.features.remove("unwrap");
        }
        this.features.add(feature);
    }

    public void removeFeature(String feature) {
        this.features.remove(feature);
    }

    public boolean hasFeature(String feature) {
        return this.features.contains(feature);
    }

    public void setSearchSchemaForSubtypes() {
        this.features.add("searchschema");
    }

    public void setUseDataHandlerOnly() {
        this.features.add("datahandleronly");
    }

    public String[] toArgs() {
        LinkedList<String> args = new LinkedList<String>();
        if (this.gen != null) {
            if (this.define || this.importGen) {
                throw new IllegalStateException(NbBundle.getMessage(WSCompileArguments.class, (String)"MSG_MutuallyExclusiveGenDefineImport"));
            }
            if (this.gen.equals("")) {
                args.add("-gen");
            } else {
                args.add("-gen:" + this.gen);
            }
        }
        if (this.define) {
            if (this.gen != null || this.importGen) {
                throw new IllegalStateException(NbBundle.getMessage(WSCompileArguments.class, (String)"MSG_MutuallyExclusiveGenDefineImport"));
            }
            args.add("-define");
        }
        if (this.importGen) {
            if (this.gen != null || this.define) {
                throw new IllegalStateException(NbBundle.getMessage(WSCompileArguments.class, (String)"MSG_MutuallyExclusiveGenDefineImport"));
            }
            args.add("-import");
        }
        if (this.classpath != null) {
            args.add("-classpath");
            args.add(this.classpath);
        }
        if (this.mappingFile != null) {
            args.add("-mapping");
            args.add(this.mappingFile);
        }
        if (this.outputDirectory != null) {
            args.add("-d");
            args.add(this.outputDirectory);
        }
        if (this.nonclassOutputDirectory != null) {
            args.add("-nd");
            args.add(this.nonclassOutputDirectory);
        }
        if (this.sourceOutputDirectory != null) {
            args.add("-s");
            args.add(this.sourceOutputDirectory);
        }
        if (this.keep) {
            args.add("-keep");
        }
        if (this.verbose) {
            args.add("-verbose");
        }
        if (this.features.size() > 0) {
            String featureArg = "-f:";
            boolean first = true;
            Iterator it = this.features.iterator();
            while (it.hasNext()) {
                if (first) {
                    first = false;
                } else {
                    featureArg = featureArg + ",";
                }
                featureArg = featureArg + (String)it.next();
            }
            args.add(featureArg);
        }
        if (this.configuration != null) {
            try {
                File cf = File.createTempFile("jaxrpcconfigfile", ".xml");
                cf.deleteOnExit();
                FileOutputStream out = new FileOutputStream(cf);
                this.configuration.write(out);
                ((OutputStream)out).close();
                args.add(cf.getAbsolutePath());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        String[] result = new String[args.size()];
        return args.toArray(result);
    }

    public String getClasspath() {
        return this.classpath;
    }

    public void setClasspath(String classpath) {
        this.classpath = this.additionalClasspath == null ? classpath : classpath + File.pathSeparator + this.additionalClasspath;
    }

    public String getMapping() {
        return this.mappingFile;
    }

    public void setMapping(String m) {
        this.mappingFile = m;
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory.getAbsolutePath();
    }

    public String getGen() {
        return this.gen;
    }

    public void setGen(String gen) {
        this.gen = gen;
    }

    public boolean isKeep() {
        return this.keep;
    }

    public void setKeep(boolean keep) {
        this.keep = keep;
    }

    public String getNonclassOutputDirectory() {
        return this.nonclassOutputDirectory;
    }

    public void setNonclassOutputDirectory(String nonclassOutputDirectory) {
        this.nonclassOutputDirectory = nonclassOutputDirectory;
    }

    public String getSourceOutputDirectory() {
        return this.sourceOutputDirectory;
    }

    public void setSourceOutputDirectory(String sourceOutputDirectory) {
        this.sourceOutputDirectory = sourceOutputDirectory;
    }

    public boolean isDefine() {
        return this.define;
    }

    public void setDefine(boolean define) {
        this.define = define;
    }

    public boolean isImportGen() {
        return this.importGen;
    }

    public void setImportGen(boolean importGen) {
        this.importGen = importGen;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public String toString() {
        String[] args = this.toArgs();
        String result = "";
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                result = result + " ";
            }
            result = result + args[i];
        }
        return result;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void prepConfigurationForWSDL(URL location, String packageName) {
        if (this.configuration == null) {
            this.configuration = new Configuration();
        }
        if (this.configuration.getWsdl() == null) {
            this.configuration.setWsdl(new WsdlType(location, packageName));
        } else {
            this.configuration.getWsdl().setLocation(location);
            this.configuration.getWsdl().setPackageName(packageName);
        }
    }
}

