/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.util;

import com.sun.xml.rpc.util.MapBase;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class IdentityMap
extends MapBase
implements Map,
Serializable,
Cloneable {
    private static final int DEFAULT_CAPACITY = 32;
    private static final int MINIMUM_CAPACITY = 4;
    private static final int MAXIMUM_CAPACITY = 0x20000000;
    private transient Object[] table;
    private int size;
    private volatile transient int modCount;
    private transient int threshold;
    private static final Object NULL_KEY = new Object();
    private transient Set entrySet = null;

    public int hashCode() {
        int result = 0;
        Object[] tab = this.table;
        int i = 0;
        while (i < tab.length) {
            Object key = tab[i];
            if (key != null) {
                Object k = IdentityMap.unmaskNull(key);
                result += System.identityHashCode(k) ^ System.identityHashCode(tab[i + 1]);
            }
            i += 2;
        }
        return result;
    }

    public int size() {
        return this.size;
    }

    public IdentityMap() {
        this.init(32);
    }

    public void clear() {
        ++this.modCount;
        Object[] tab = this.table;
        int i = 0;
        while (i < tab.length) {
            tab[i] = null;
            ++i;
        }
        this.size = 0;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    private int capacity(int expectedMaxSize) {
        int result;
        int minCapacity = 3 * expectedMaxSize / 2;
        if (minCapacity > 0x20000000 || minCapacity < 0) {
            result = 0x20000000;
        } else {
            result = 4;
            while (result < minCapacity) {
                result <<= 1;
            }
        }
        return result;
    }

    public IdentityMap(int expectedMaxSize) {
        if (expectedMaxSize < 0) {
            throw new IllegalArgumentException("expectedMaxSize is negative: " + expectedMaxSize);
        }
        this.init(this.capacity(expectedMaxSize));
    }

    /*
     * WARNING - void declaration
     */
    private void closeDeletion(int d) {
        Object item;
        Object[] tab = this.table;
        int len = tab.length;
        int i = IdentityMap.nextKeyIndex(d, len);
        while ((item = tab[i]) != null) {
            void var4_5;
            int r = IdentityMap.hash(var4_5, len);
            if (i < r && (r <= d || d <= i) || r <= d && d <= i) {
                tab[d] = var4_5;
                tab[d + 1] = tab[i + 1];
                tab[i] = null;
                tab[i + 1] = null;
                d = i;
            }
            i = IdentityMap.nextKeyIndex(i, len);
        }
    }

    private void init(int initCapacity) {
        this.threshold = initCapacity * 2 / 3;
        this.table = new Object[2 * initCapacity];
    }

    private void resize(int newCapacity) {
        int newLength = newCapacity * 2;
        Object[] oldTable = this.table;
        int oldLength = oldTable.length;
        if (oldLength == 0x40000000) {
            if (this.threshold == 0x1FFFFFFF) {
                throw new IllegalStateException("Capacity exhausted.");
            }
            this.threshold = 0x1FFFFFFF;
            return;
        }
        if (oldLength >= newLength) {
            return;
        }
        Object[] newTable = new Object[newLength];
        this.threshold = newLength / 3;
        int j = 0;
        while (j < oldLength) {
            Object key = oldTable[j];
            if (key != null) {
                Object value = oldTable[j + 1];
                oldTable[j] = null;
                oldTable[j + 1] = null;
                int i = IdentityMap.hash(key, newLength);
                while (newTable[i] != null) {
                    i = IdentityMap.nextKeyIndex(i, newLength);
                }
                newTable[i] = key;
                newTable[i + 1] = value;
            }
            j += 2;
        }
        this.table = newTable;
    }

    private static int nextKeyIndex(int i, int len) {
        return i + 2 < len ? i + 2 : 0;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int size = s.readInt();
        this.init(this.capacity(size * 4 / 3));
        int i = 0;
        while (i < size) {
            Object key = s.readObject();
            Object value = s.readObject();
            this.put(key, value);
            ++i;
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.size);
        Object[] tab = this.table;
        int i = 0;
        while (i < tab.length) {
            Object key = tab[i];
            if (key != null) {
                s.writeObject(IdentityMap.unmaskNull(key));
                s.writeObject(tab[i + 1]);
            }
            i += 2;
        }
    }

    public Object clone() {
        try {
            IdentityMap t = (IdentityMap)super.clone();
            t.entrySet = null;
            t.table = (Object[])this.table.clone();
            return t;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public boolean containsKey(Object key) {
        Object k = IdentityMap.maskNull(key);
        Object[] tab = this.table;
        int len = tab.length;
        int i = IdentityMap.hash(k, len);
        Object item;
        while ((item = tab[i]) != k) {
            if (item == null) {
                return false;
            }
            i = IdentityMap.nextKeyIndex(i, len);
        }
        return true;
    }

    public boolean containsValue(Object value) {
        Object[] tab = this.table;
        int i = 1;
        while (i < tab.length) {
            if (tab[i] == value) {
                return true;
            }
            i += 2;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof IdentityMap) {
            IdentityMap m = (IdentityMap)o;
            if (m.size() != this.size) {
                return false;
            }
            Object[] tab = m.table;
            int i = 0;
            while (i < tab.length) {
                Object k = tab[i];
                if (k != null && !this.containsMapping(k, tab[i + 1])) {
                    return false;
                }
                i += 2;
            }
            return true;
        }
        if (o instanceof Map) {
            Map m = (Map)o;
            return this.entrySet().equals(m.entrySet());
        }
        return false;
    }

    private static int hash(Object x, int length) {
        int h = System.identityHashCode(x);
        return (h << 1) - (h << 8) & length - 1;
    }

    public Collection values() {
        Collection vs = this.values;
        if (vs != null) {
            return vs;
        }
        this.values = new Values();
        return this.values;
    }

    public IdentityMap(Map m) {
        this((int)((double)(1 + m.size()) * 1.1));
        this.putAll(m);
    }

    public void putAll(Map t) {
        int n = t.size();
        if (n == 0) {
            return;
        }
        if (n > this.threshold) {
            this.resize(this.capacity(n));
        }
        Iterator it = t.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            this.put(e.getKey(), e.getValue());
        }
    }

    public Set entrySet() {
        Set es = this.entrySet;
        if (es != null) {
            return es;
        }
        this.entrySet = new EntrySet();
        return this.entrySet;
    }

    public Set keySet() {
        Set ks = this.keySet;
        if (ks != null) {
            return ks;
        }
        this.keySet = new KeySet();
        return this.keySet;
    }

    public Object get(Object key) {
        Object k = IdentityMap.maskNull(key);
        Object[] tab = this.table;
        int len = tab.length;
        int i = IdentityMap.hash(k, len);
        Object item;
        while ((item = tab[i]) != k) {
            if (item == null) {
                return item;
            }
            i = IdentityMap.nextKeyIndex(i, len);
        }
        return tab[i + 1];
    }

    private static Object maskNull(Object key) {
        return key == null ? NULL_KEY : key;
    }

    public Object remove(Object key) {
        Object k = IdentityMap.maskNull(key);
        Object[] tab = this.table;
        int len = tab.length;
        int i = IdentityMap.hash(k, len);
        while (true) {
            Object item;
            if ((item = tab[i]) == k) {
                ++this.modCount;
                --this.size;
                Object oldValue = tab[i + 1];
                tab[i + 1] = null;
                tab[i] = null;
                this.closeDeletion(i);
                return oldValue;
            }
            if (item == null) {
                return null;
            }
            i = IdentityMap.nextKeyIndex(i, len);
        }
    }

    private static Object unmaskNull(Object key) {
        return key == NULL_KEY ? null : key;
    }

    private boolean containsMapping(Object key, Object value) {
        Object k = IdentityMap.maskNull(key);
        Object[] tab = this.table;
        int len = tab.length;
        int i = IdentityMap.hash(k, len);
        Object item;
        while ((item = tab[i]) != k) {
            if (item == null) {
                return false;
            }
            i = IdentityMap.nextKeyIndex(i, len);
        }
        return tab[i + 1] == value;
    }

    private boolean removeMapping(Object key, Object value) {
        Object k = IdentityMap.maskNull(key);
        Object[] tab = this.table;
        int len = tab.length;
        int i = IdentityMap.hash(k, len);
        while (true) {
            Object item;
            if ((item = tab[i]) == k) {
                if (tab[i + 1] != value) {
                    return false;
                }
                ++this.modCount;
                --this.size;
                tab[i] = null;
                tab[i + 1] = null;
                this.closeDeletion(i);
                return true;
            }
            if (item == null) {
                return false;
            }
            i = IdentityMap.nextKeyIndex(i, len);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Object put(Object key, Object value) {
        Object item;
        Object k = IdentityMap.maskNull(key);
        Object[] tab = this.table;
        int len = tab.length;
        int i = IdentityMap.hash(k, len);
        while ((item = tab[i]) != null) {
            void var7_7;
            if (var7_7 == k) {
                Object oldValue = tab[i + 1];
                tab[i + 1] = value;
                return oldValue;
            }
            i = IdentityMap.nextKeyIndex(i, len);
        }
        ++this.modCount;
        tab[i] = k;
        tab[i + 1] = value;
        if (++this.size >= this.threshold) {
            this.resize(len);
        }
        return null;
    }

    private class EntryIterator
    extends IdentityMapIterator
    implements Map.Entry {
        public int hashCode() {
            return System.identityHashCode(this.getKey()) ^ System.identityHashCode(this.getValue());
        }

        private EntryIterator() {
        }

        public Object getKey() {
            if (this.lastReturnedIndex < 0) {
                throw new IllegalStateException("Entry was removed");
            }
            return IdentityMap.unmaskNull(this.traversalTable[this.lastReturnedIndex]);
        }

        public Object getValue() {
            if (this.lastReturnedIndex < 0) {
                throw new IllegalStateException("Entry was removed");
            }
            return this.traversalTable[this.lastReturnedIndex + 1];
        }

        public Object next() {
            this.nextIndex();
            return this;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return e.getKey() == this.getKey() && e.getValue() == this.getValue();
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }

        public Object setValue(Object value) {
            if (this.lastReturnedIndex < 0) {
                throw new IllegalStateException("Entry was removed");
            }
            Object oldValue = this.traversalTable[this.lastReturnedIndex + 1];
            this.traversalTable[this.lastReturnedIndex + 1] = value;
            if (this.traversalTable != IdentityMap.this.table) {
                IdentityMap.this.put(this.traversalTable[this.lastReturnedIndex], value);
            }
            return oldValue;
        }
    }

    private class EntrySet
    extends AbstractSet {
        public int size() {
            return IdentityMap.this.size;
        }

        public void clear() {
            IdentityMap.this.clear();
        }

        private EntrySet() {
        }

        public Object[] toArray() {
            ArrayList<MapBase.SimpleEntry> c = new ArrayList<MapBase.SimpleEntry>(this.size());
            Iterator i = this.iterator();
            while (i.hasNext()) {
                c.add(new MapBase.SimpleEntry((Map.Entry)i.next()));
            }
            return c.toArray();
        }

        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            return IdentityMap.this.containsMapping(entry.getKey(), entry.getValue());
        }

        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            return IdentityMap.this.removeMapping(entry.getKey(), entry.getValue());
        }

        public boolean removeAll(Collection c) {
            boolean modified = false;
            Iterator i = this.iterator();
            while (i.hasNext()) {
                if (!c.contains(i.next())) continue;
                i.remove();
                modified = true;
            }
            return modified;
        }

        public Iterator iterator() {
            return new EntryIterator();
        }

        public Object[] toArray(Object[] a) {
            ArrayList<MapBase.SimpleEntry> c = new ArrayList<MapBase.SimpleEntry>(this.size());
            Iterator i = this.iterator();
            while (i.hasNext()) {
                c.add(new MapBase.SimpleEntry((Map.Entry)i.next()));
            }
            return c.toArray(a);
        }
    }

    private abstract class IdentityMapIterator
    implements Iterator {
        int index;
        int expectedModCount;
        int lastReturnedIndex;
        boolean indexValid;
        Object[] traversalTable;

        protected int nextIndex() {
            if (IdentityMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (!this.indexValid && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.indexValid = false;
            this.lastReturnedIndex = this.index;
            this.index += 2;
            return this.lastReturnedIndex;
        }

        /*
         * WARNING - void declaration
         */
        public void remove() {
            Object item;
            if (this.lastReturnedIndex == -1) {
                throw new IllegalStateException();
            }
            if (IdentityMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.expectedModCount = ++IdentityMap.this.modCount;
            int deletedSlot = this.lastReturnedIndex;
            this.lastReturnedIndex = -1;
            IdentityMap.this.size--;
            this.index = deletedSlot;
            this.indexValid = false;
            Object[] tab = this.traversalTable;
            int len = tab.length;
            int d = deletedSlot;
            Object key = tab[d];
            tab[d] = null;
            tab[d + 1] = null;
            if (tab != IdentityMap.this.table) {
                IdentityMap.this.remove(key);
                this.expectedModCount = IdentityMap.this.modCount;
                return;
            }
            int i = IdentityMap.nextKeyIndex(d, len);
            while ((item = tab[i]) != null) {
                void var6_7;
                int r = IdentityMap.hash(var6_7, len);
                if (i < r && (r <= d || d <= i) || r <= d && d <= i) {
                    if (i < deletedSlot && d >= deletedSlot && this.traversalTable == IdentityMap.this.table) {
                        int remaining = len - deletedSlot;
                        Object[] newTable = new Object[remaining];
                        System.arraycopy(tab, deletedSlot, newTable, 0, remaining);
                        this.traversalTable = newTable;
                        this.index = 0;
                    }
                    tab[d] = var6_7;
                    tab[d + 1] = tab[i + 1];
                    tab[i] = null;
                    tab[i + 1] = null;
                    d = i;
                }
                i = IdentityMap.nextKeyIndex(i, len);
            }
        }

        public boolean hasNext() {
            Object[] tab = this.traversalTable;
            int i = this.index;
            while (i < tab.length) {
                Object key = tab[i];
                if (key != null) {
                    this.index = i;
                    this.indexValid = true;
                    return true;
                }
                i += 2;
            }
            this.index = tab.length;
            return false;
        }

        private IdentityMapIterator() {
            this.index = IdentityMap.this.size != 0 ? 0 : IdentityMap.this.table.length;
            this.expectedModCount = IdentityMap.this.modCount;
            this.lastReturnedIndex = -1;
            this.traversalTable = IdentityMap.this.table;
        }
    }

    private class KeyIterator
    extends IdentityMapIterator {
        private KeyIterator() {
        }

        public Object next() {
            return IdentityMap.unmaskNull(this.traversalTable[this.nextIndex()]);
        }
    }

    private class KeySet
    extends AbstractSet {
        public int hashCode() {
            int result = 0;
            Iterator i = this.iterator();
            while (i.hasNext()) {
                result += System.identityHashCode(i.next());
            }
            return result;
        }

        public int size() {
            return IdentityMap.this.size;
        }

        public void clear() {
            IdentityMap.this.clear();
        }

        private KeySet() {
        }

        public boolean contains(Object o) {
            return IdentityMap.this.containsKey(o);
        }

        public boolean remove(Object o) {
            int oldSize = IdentityMap.this.size;
            IdentityMap.this.remove(o);
            return IdentityMap.this.size != oldSize;
        }

        public boolean removeAll(Collection c) {
            boolean modified = false;
            Iterator i = this.iterator();
            while (i.hasNext()) {
                if (!c.contains(i.next())) continue;
                i.remove();
                modified = true;
            }
            return modified;
        }

        public Iterator iterator() {
            return new KeyIterator();
        }
    }

    private class ValueIterator
    extends IdentityMapIterator {
        private ValueIterator() {
        }

        public Object next() {
            return this.traversalTable[this.nextIndex() + 1];
        }
    }

    private class Values
    extends AbstractCollection {
        public int size() {
            return IdentityMap.this.size;
        }

        public void clear() {
            IdentityMap.this.clear();
        }

        private Values() {
        }

        public boolean contains(Object o) {
            return IdentityMap.this.containsValue(o);
        }

        public boolean remove(Object o) {
            Iterator i = this.iterator();
            while (i.hasNext()) {
                if (i.next() != o) continue;
                i.remove();
                return true;
            }
            return false;
        }

        public Iterator iterator() {
            return new ValueIterator();
        }
    }
}

