/*
 * Copyright 2006 Sun Microsystems, Inc.  All rights reserved.
 * You may not modify, use, reproduce, or distribute this
 * software except in compliance with the terms of the License at:
 *
 *   http://developer.sun.com/berkeley_license.html
 *
 * $Id: script.js,v 1.11 2006/04/06 08:16:26 mattbohm Exp $
 */

/* =============================================================================
   Blueprints AJAX Components -- SelectValueComponent Functions
   ========================================================================== */  


dojo.require("dojo.io.*");

/**
 * Define our component container object (if necessary).
 */
if (bpui_undefined("selectvalue", bpui)) {

  bpui.selectvalue = {


    /**
     * Localizable messages in the default language.  Treat this variable
     * as an associative array keyed by a message identifier.  Robust
     * applications will dynamically replace these messages with a localized
     * version based on the locale of the current user.
     */
    messages : new Object(),


    /**
     * Holder for state information for the component that currently has focus.
     * This would need to be turned into an array if it were possible to have
     * more than one SelectValue Text Field component with focus at the
     * same time.
     */
    state : new Object(),


    /**
     * The version number of this script.
     */
    version : {
      major: 0,
      minor: 1,
      patch: 0,
      flag: "",
      toString: function() {
        with (bpui.selectvalue.version) {
          return major + "." + minor + "." + patch + flag;
        }
      }
    }

  }

}


// Initialize the localizable messages for this component
bpui.selectvalue.messages["bindError"] = "An error occurred performing an asynchronous request";

/**
 * This function gets invoked on onkeyup and onfocus events on the SelectValue
 * TextField. This function will initiate an AJAX request passing in the value
 * of the select value text field and method name to be invoked on the server
 * side as parameters.
 * @param targetName DOM identifier of the <input type="text"> select value
 * text field the user is using
 * @param method Method binding expression passed to the server to retrieve
 * @param callback URL for our asynchronous serverside method callbacks
 * the appropriate values that match value of selectvalue text field.
 */
bpui.selectvalue.executeQuery = function(targetName, method, callback) {
    var target = document.getElementById(targetName + "_text");
    bpui.selectvalue.state.targetName = targetName;
    var bindArgs = {
      url:      callback + "?method=" + escape(method) + "&value=" + escape(target.value),
      mimetype: "text/xml",
      error:    bpui.selectvalue.processError,
      load:     bpui.selectvalue.processLoad
    };
    dojo.io.bind(bindArgs);

}


/*
 * This function processes the XML document that was sent by the server in
 * response to the AJAX request. This XML response is a list of values that match
 * the value of the select value text field. The results will be displayed in 
 * a dropdown list.
 * @param data  XML document that contains the results of the method 
 * invocation on the server.
 * @param targetName DOM identifier of the element that caused the event.  
 */
bpui.selectvalue.populateOptions = function(data, targetName) {        
    var items = data.getElementsByTagName("item");
    bpui.selectvalue.buildSelectArea(targetName);
    var select = document.getElementById(targetName + "_select"); 
    var input = document.getElementById(targetName + "_text"); 
    if ((items != null) && (items.length > 0)) {
        for(var i = 0; i < items.length; i++) {
            var opt = document.createElement("option");
            var item = items[i];
            var els = item.getElementsByTagName("value");
            if (els.length > 0) {
                if (els[0].firstChild == null) {
                    opt.value = "";
                }
                else {
                    opt.value = els[0].firstChild.data;
                }
            }
            els = item.getElementsByTagName("label")
            if (els.length > 0) {
                if (els[0].firstChild == null) {
                    opt.text = "";
                }
                else {
                    opt.text = els[0].firstChild.data;
                }
            }
            /*
            els = item.getElementsByTagName("description");
            if (els.length > 0){
                var des = null;
                if (els[0].firstChild == null) {
                    des = "";
                }
                else {
                    des = els[0].firstChild.data; 
                }
            }
            */

            if ( input.value == opt.value) {
                opt.selected = true;
            }
            select.options[i] = opt;
        }
    }
    // if there is no previous value, set the value of the textfield to the
    // value of the first element in the list.
       
    var selectdiv  = document.getElementById(targetName + "_selectdiv"); 
    if (items.length >= 1) {
       // input.value = select.options[0].value;
        selectdiv.style.display = 'block';
    } else {
        selectdiv.style.display = 'none';
    }
}

/*
 * This function builds a dropdown list that will display the results of the
 * method invocation on the server.
 * @param targetName DOM identifier of the element that caused the event. 
 */
bpui.selectvalue.buildSelectArea = function(targetName) { 
    var selectArea = document.getElementById(targetName + "_selectdiv");
    var inputField = targetName + "_text";
    selectArea.innerHTML = 
      "<br><select id= '" + (targetName + "_select") 
       + "' size=\"1\" onfocus = '(this.form." + inputField 
       + ").value = (this.options[this.selectedIndex]).value' onchange=\"(this.form." + inputField 
       + ").value = (this.options[this.selectedIndex]).value; bpui.selectvalue.clearSelect('" 
       + targetName + "');\" onblur=\"bpui.selectvalue.clearSelect('" 
       + targetName + "')\">" +
        "<option value=\"\"></option></select>";
}


/*
 * This function clear options from dropdown and hides it. At this point
 * the select value from the dropdown would have been assigned to the select
 * value textfield that is associated with the dropdown.
 * @param targetName DOM identifier of the element that caused the event. 
 */
bpui.selectvalue.clearSelect = function(targetName) {
    var select = document.getElementById(targetName + '_select');
    while (select.length > 0) {
        select.remove(0);
    }
    var selectdiv  = document.getElementById(targetName + "_selectdiv"); 
    selectdiv.style.display = 'none';
}

/**
 * Process the failure of an asynchronous response.
 *
 * @param type Event type ("error")
 * @param errorObject Low-level error object
 */
bpui.selectvalue.processError = function(type, errorObject) {

   window.status = bpui.selectvalue.messages["bindError"] + ":  " + errorObject;

}

/**
 * Process an asynchronous response when it is ready.
 *
 * @param type Event type ("load")
 * @param data Data returned with the response
 * @param event Low-level event object
 */
bpui.selectvalue.processLoad = function(type, data, event) {

    if (event.readyState == 4) {
        if (event.status == 200) {
          bpui.selectvalue.populateOptions(data, bpui.selectvalue.state.targetName);
        } else {
          bpui.selectvalue.clearSelect(bpui.selectvalue.state.targetName);
        }
    }

}




