/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.office;

import java.util.LinkedList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import writer2latex.office.TableLine;
import writer2latex.util.Misc;

public class TableGridModel {
    private Node tableNode;
    private LinkedList cols = new LinkedList();
    private LinkedList rows = new LinkedList();
    private LinkedList cells = new LinkedList();
    private int nMaxCols = 0;

    public TableGridModel(Node node) {
        Object object;
        int n;
        this.tableNode = node;
        if (!node.hasChildNodes()) {
            return;
        }
        NodeList nodeList = node.getChildNodes();
        int n2 = nodeList.getLength();
        for (n = 0; n < n2; ++n) {
            Node node2 = nodeList.item(n);
            if (node2.getNodeType() != 1) continue;
            object = node2.getNodeName();
            if (((String)object).equals("table:table-column")) {
                this.readTableColumn(node2, false, false);
                continue;
            }
            if (((String)object).equals("table:table-columns")) {
                this.readTableColumns(node2, false, false);
                continue;
            }
            if (((String)object).equals("table:table-column-group")) {
                this.readTableColumnGroup(node2, false, false);
                continue;
            }
            if (((String)object).equals("table:table-header-columns")) {
                this.readTableHeaderColumns(node2, false, false);
                continue;
            }
            if (((String)object).equals("table:table-row")) {
                this.readTableRow(node2, false, false);
                continue;
            }
            if (((String)object).equals("table:table-rows")) {
                this.readTableRows(node2, false, false);
                continue;
            }
            if (((String)object).equals("table:table-row-group")) {
                this.readTableRowGroup(node2, false, false);
                continue;
            }
            if (!((String)object).equals("table:table-header-rows")) continue;
            this.readTableHeaderRows(node2, false, false);
        }
        n = this.cells.size();
        for (int i = 0; i < n; ++i) {
            object = (LinkedList)this.cells.get(i);
            int n3 = ((LinkedList)object).size();
            int n4 = 0;
            for (int j = 0; j < n3; ++j) {
                Element element = (Element)((LinkedList)object).get(j);
                if (!element.hasChildNodes() || (n4 = j + Misc.getPosInteger(element.getAttribute("table:number-columns-spanned"), 1)) <= this.nMaxCols) continue;
                this.nMaxCols = n4;
            }
        }
    }

    private void readTableColumn(Node node, boolean bl, boolean bl2) {
        int n = Misc.getPosInteger(Misc.getAttribute(node, "table:number-columns-repeated"), 1);
        while (n-- > 0) {
            this.cols.add(new TableLine(node, bl, bl2));
        }
    }

    private void readTableColumns(Node node, boolean bl, boolean bl2) {
        if (!node.hasChildNodes()) {
            return;
        }
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            String string = node2.getNodeName();
            if (string.equals("table:table-column")) {
                this.readTableColumn(node2, bl, bl2);
                continue;
            }
            if (!string.equals("table:table-column-group")) continue;
            this.readTableColumnGroup(node2, bl, bl2);
        }
    }

    private void readTableColumnGroup(Node node, boolean bl, boolean bl2) {
        boolean bl3 = bl2 = !"false".equals(Misc.getAttribute(node, "table:display"));
        if (!node.hasChildNodes()) {
            return;
        }
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            String string = node2.getNodeName();
            if (string.equals("table:table-header-columns")) {
                this.readTableHeaderColumns(node2, bl, bl2);
                continue;
            }
            if (string.equals("table:table-column")) {
                this.readTableColumn(node2, bl, bl2);
                continue;
            }
            if (!string.equals("table:table-column-group")) continue;
            this.readTableColumnGroup(node2, bl, bl2);
        }
    }

    private void readTableHeaderColumns(Node node, boolean bl, boolean bl2) {
        this.readTableColumns(node, true, bl2);
    }

    private void readTableRow(Node node, boolean bl, boolean bl2) {
        int n = Misc.getPosInteger(Misc.getAttribute(node, "table:number-rows-repeated"), 1);
        while (n-- > 0) {
            this.rows.add(new TableLine(node, bl, bl2));
        }
        LinkedList<Element> linkedList = new LinkedList<Element>();
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            int n2 = nodeList.getLength();
            for (int i = 0; i < n2; ++i) {
                Node node2 = nodeList.item(i);
                if (node2.getNodeType() != 1) continue;
                Element element = (Element)node2;
                String string = element.getTagName();
                if (string.equals("table:table-cell")) {
                    n = Misc.getPosInteger(element.getAttribute("table:number-columns-repeated"), 1);
                    while (n-- > 0) {
                        linkedList.add(element);
                    }
                    continue;
                }
                if (!string.equals("table:covered-table-cell")) continue;
                n = Misc.getPosInteger(element.getAttribute("table:number-columns-repeated"), 1);
                while (n-- > 0) {
                    linkedList.add(element);
                }
            }
        }
        this.cells.add(linkedList);
    }

    private void readTableRows(Node node, boolean bl, boolean bl2) {
        if (!node.hasChildNodes()) {
            return;
        }
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            String string = node2.getNodeName();
            if (string.equals("table:table-row")) {
                this.readTableRow(node2, bl, bl2);
                continue;
            }
            if (!string.equals("table:table-row-group")) continue;
            this.readTableRowGroup(node2, bl, bl2);
        }
    }

    private void readTableRowGroup(Node node, boolean bl, boolean bl2) {
        boolean bl3 = bl2 = !"false".equals(Misc.getAttribute(node, "table:display"));
        if (!node.hasChildNodes()) {
            return;
        }
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            String string = node2.getNodeName();
            if (string.equals("table:table-header-rows")) {
                this.readTableHeaderRows(node2, bl, bl2);
                continue;
            }
            if (string.equals("table:table-row")) {
                this.readTableRow(node2, bl, bl2);
                continue;
            }
            if (!string.equals("table:table-row-group")) continue;
            this.readTableRowGroup(node2, bl, bl2);
        }
    }

    private void readTableHeaderRows(Node node, boolean bl, boolean bl2) {
        this.readTableRows(node, true, bl2);
    }

    public int getColCount() {
        return this.cols.size();
    }

    public int getMaxColCount() {
        return this.nMaxCols;
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public Node getTableNode() {
        return this.tableNode;
    }

    public Node getCell(int n, int n2) {
        if (n < 0 || n >= this.cells.size()) {
            return null;
        }
        LinkedList linkedList = (LinkedList)this.cells.get(n);
        if (n2 < 0 || n2 >= linkedList.size()) {
            return null;
        }
        return (Node)linkedList.get(n2);
    }

    public TableLine getRow(int n) {
        if (n < 0 || n >= this.rows.size()) {
            return null;
        }
        return (TableLine)this.rows.get(n);
    }

    public TableLine getCol(int n) {
        if (n < 0 || n >= this.cols.size()) {
            return null;
        }
        return (TableLine)this.cols.get(n);
    }
}

