/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.web;

import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.wizards.common.FileAccess;
import com.sun.star.wizards.web.data.CGStyle;

public class StylePreview {
    private FileAccess fileAccess;
    public String htmlFilename;
    private String cssFilename;
    public String tempDir;
    private String backgroundFilename;
    private String wwRoot;

    public StylePreview(XMultiServiceFactory xMultiServiceFactory, String string) throws Exception {
        this.fileAccess = new FileAccess(xMultiServiceFactory);
        this.tempDir = this.createTempDir(xMultiServiceFactory);
        this.htmlFilename = FileAccess.connectURLs(this.tempDir, "wwpreview.html");
        this.cssFilename = FileAccess.connectURLs(this.tempDir, "style.css");
        this.backgroundFilename = FileAccess.connectURLs(this.tempDir, "images/background.gif");
        this.wwRoot = string;
        this.fileAccess.copy(FileAccess.connectURLs(this.wwRoot, "preview.html"), this.htmlFilename);
    }

    public void refresh(CGStyle cGStyle, String string) throws Exception {
        String string2 = FileAccess.connectURLs(this.wwRoot, "styles/" + cGStyle.cp_CssHref);
        if (string == null || string.equals("")) {
            if (this.fileAccess.exists(this.backgroundFilename, false)) {
                this.fileAccess.delete(this.backgroundFilename);
            }
        } else {
            this.fileAccess.copy(string, this.backgroundFilename);
        }
        this.fileAccess.copy(string2, this.cssFilename);
    }

    public void cleanup() {
        try {
            this.removeTempDir();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String createTempDir(XMultiServiceFactory xMultiServiceFactory) throws Exception {
        String string = FileAccess.getOfficePath(xMultiServiceFactory, "Temp", "", "");
        String string2 = this.fileAccess.createNewDir(string, "wwiz");
        this.fileAccess.createNewDir(string2, "images");
        return string2;
    }

    private void removeTempDir() throws Exception {
        this.fileAccess.delete(this.tempDir);
    }
}

