/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webapp.admin.resources;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.apache.webapp.admin.resources.DataSourcesForm;
import org.apache.webapp.admin.resources.EnvEntriesForm;
import org.apache.webapp.admin.resources.MailSessionsForm;
import org.apache.webapp.admin.resources.ResourceLinksForm;
import org.apache.webapp.admin.resources.UserDatabasesForm;

public class ResourceUtils {
    public static final String ENVIRONMENT_TYPE = ":type=Environment";
    public static final String RESOURCE_TYPE = ":type=Resource";
    public static final String RESOURCELINK_TYPE = ":type=ResourceLink";
    public static final String NAMINGRESOURCES_TYPE = ":type=NamingResources";
    public static final String GLOBAL_TYPE = ",resourcetype=Global";
    public static final String CONTEXT_TYPE = ",resourcetype=Context";
    public static final String SERVICE_DEFAULTCONTEXT_TYPE = ",resourcetype=ServiceDefaultContext";
    public static final String HOST_DEFAULTCONTEXT_TYPE = ",resourcetype=HostDefaultContext";
    public static final String USERDB_CLASS = "org.apache.catalina.UserDatabase";
    public static final String DATASOURCE_CLASS = "javax.sql.DataSource";
    public static final String MAILSESSION_CLASS = "javax.mail.Session";

    public static ObjectName getNamingResourceObjectName(String domain, String resourcetype, String path, String host) throws Exception {
        ObjectName oname = null;
        if (resourcetype == null || domain == null) {
            return null;
        }
        if (resourcetype.equals("Global")) {
            oname = new ObjectName(domain + NAMINGRESOURCES_TYPE + GLOBAL_TYPE);
        } else if (resourcetype.equals("Context")) {
            oname = new ObjectName(domain + NAMINGRESOURCES_TYPE + CONTEXT_TYPE + ",path=" + path + ",host=" + host);
        } else if (resourcetype.equals("DefaultContext")) {
            oname = host.length() > 0 ? new ObjectName(domain + NAMINGRESOURCES_TYPE + HOST_DEFAULTCONTEXT_TYPE + ",host=" + host) : new ObjectName(domain + NAMINGRESOURCES_TYPE + SERVICE_DEFAULTCONTEXT_TYPE);
        }
        return oname;
    }

    public static EnvEntriesForm getEnvEntriesForm(MBeanServer mserver, String resourcetype, String path, String host, String domain) throws Exception {
        ObjectName ename = null;
        if (resourcetype != null) {
            if (resourcetype.equals("Global")) {
                ename = new ObjectName(domain + ENVIRONMENT_TYPE + GLOBAL_TYPE + ",*");
            } else if (resourcetype.equals("Context")) {
                ename = new ObjectName(domain + ENVIRONMENT_TYPE + CONTEXT_TYPE + ",path=" + path + ",host=" + host + ",*");
            } else if (resourcetype.equals("DefaultContext")) {
                ename = host.length() > 0 ? new ObjectName(domain + ENVIRONMENT_TYPE + HOST_DEFAULTCONTEXT_TYPE + ",host=" + host + ",*") : new ObjectName(domain + ENVIRONMENT_TYPE + SERVICE_DEFAULTCONTEXT_TYPE + ",*");
            }
        }
        Iterator<ObjectInstance> iterator = mserver.queryMBeans(ename, null).iterator();
        ArrayList<String> results = new ArrayList<String>();
        while (iterator.hasNext()) {
            ObjectInstance instance = iterator.next();
            results.add(instance.getObjectName().toString());
        }
        Collections.sort(results);
        EnvEntriesForm envEntriesForm = new EnvEntriesForm();
        envEntriesForm.setEnvEntries(results.toArray(new String[results.size()]));
        if (resourcetype != null) {
            envEntriesForm.setResourcetype(resourcetype);
        } else {
            envEntriesForm.setResourcetype("");
        }
        if (path != null) {
            envEntriesForm.setPath(path);
        } else {
            envEntriesForm.setPath("");
        }
        if (host != null) {
            envEntriesForm.setHost(host);
        } else {
            envEntriesForm.setHost("");
        }
        if (domain != null) {
            envEntriesForm.setDomain(domain);
        } else {
            envEntriesForm.setDomain("");
        }
        return envEntriesForm;
    }

    public static DataSourcesForm getDataSourcesForm(MBeanServer mserver, String resourcetype, String path, String host, String domain) throws Exception {
        ObjectName rname = null;
        if (resourcetype != null) {
            if (resourcetype.equals("Global")) {
                rname = new ObjectName(domain + RESOURCE_TYPE + GLOBAL_TYPE + ",class=" + DATASOURCE_CLASS + ",*");
            } else if (resourcetype.equals("Context")) {
                rname = new ObjectName(domain + RESOURCE_TYPE + CONTEXT_TYPE + ",path=" + path + ",host=" + host + ",class=" + DATASOURCE_CLASS + ",*");
            } else if (resourcetype.equals("DefaultContext")) {
                rname = host.length() > 0 ? new ObjectName(domain + RESOURCE_TYPE + HOST_DEFAULTCONTEXT_TYPE + ",host=" + host + ",class=" + DATASOURCE_CLASS + ",*") : new ObjectName(domain + RESOURCE_TYPE + SERVICE_DEFAULTCONTEXT_TYPE + ",class=" + DATASOURCE_CLASS + ",*");
            }
        }
        Iterator<ObjectInstance> iterator = mserver.queryMBeans(rname, null).iterator();
        ArrayList<String> results = new ArrayList<String>();
        while (iterator.hasNext()) {
            ObjectInstance instance = iterator.next();
            ObjectName oname = instance.getObjectName();
            try {
                mserver.getAttribute(oname, "driverClassName");
                results.add(oname.toString());
            }
            catch (AttributeNotFoundException ex) {
                mserver.setAttribute(oname, new Attribute("driverClassName", ""));
            }
        }
        Collections.sort(results);
        DataSourcesForm dataSourcesForm = new DataSourcesForm();
        dataSourcesForm.setDataSources(results.toArray(new String[results.size()]));
        if (resourcetype != null) {
            dataSourcesForm.setResourcetype(resourcetype);
        } else {
            dataSourcesForm.setResourcetype("");
        }
        if (path != null) {
            dataSourcesForm.setPath(path);
        } else {
            dataSourcesForm.setPath("");
        }
        if (host != null) {
            dataSourcesForm.setHost(host);
        } else {
            dataSourcesForm.setHost("");
        }
        if (domain != null) {
            dataSourcesForm.setDomain(domain);
        } else {
            dataSourcesForm.setDomain("");
        }
        return dataSourcesForm;
    }

    public static MailSessionsForm getMailSessionsForm(MBeanServer mserver, String resourcetype, String path, String host, String domain) throws Exception {
        ObjectName rname = null;
        if (resourcetype != null) {
            if (resourcetype.equals("Global")) {
                rname = new ObjectName(domain + RESOURCE_TYPE + GLOBAL_TYPE + ",class=" + MAILSESSION_CLASS + ",*");
            } else if (resourcetype.equals("Context")) {
                rname = new ObjectName(domain + RESOURCE_TYPE + CONTEXT_TYPE + ",path=" + path + ",host=" + host + ",class=" + MAILSESSION_CLASS + ",*");
            } else if (resourcetype.equals("DefaultContext")) {
                rname = host.length() > 0 ? new ObjectName(domain + RESOURCE_TYPE + HOST_DEFAULTCONTEXT_TYPE + ",host=" + host + ",class=" + MAILSESSION_CLASS + ",*") : new ObjectName(domain + RESOURCE_TYPE + SERVICE_DEFAULTCONTEXT_TYPE + ",class=" + MAILSESSION_CLASS + ",*");
            }
        }
        Iterator<ObjectInstance> iterator = mserver.queryMBeans(rname, null).iterator();
        ArrayList<String> results = new ArrayList<String>();
        while (iterator.hasNext()) {
            ObjectInstance instance = iterator.next();
            results.add(instance.getObjectName().toString());
        }
        Collections.sort(results);
        MailSessionsForm mailSessionsForm = new MailSessionsForm();
        mailSessionsForm.setMailSessions(results.toArray(new String[results.size()]));
        if (resourcetype != null) {
            mailSessionsForm.setResourcetype(resourcetype);
        } else {
            mailSessionsForm.setResourcetype("");
        }
        if (path != null) {
            mailSessionsForm.setPath(path);
        } else {
            mailSessionsForm.setPath("");
        }
        if (host != null) {
            mailSessionsForm.setHost(host);
        } else {
            mailSessionsForm.setHost("");
        }
        if (domain != null) {
            mailSessionsForm.setDomain(domain);
        } else {
            mailSessionsForm.setDomain("");
        }
        return mailSessionsForm;
    }

    public static ResourceLinksForm getResourceLinksForm(MBeanServer mserver, String resourcetype, String path, String host, String domain) throws Exception {
        ObjectName rname = null;
        if (resourcetype != null) {
            if (resourcetype.equals("Global")) {
                rname = new ObjectName(domain + RESOURCELINK_TYPE + GLOBAL_TYPE + ",*");
            } else if (resourcetype.equals("Context")) {
                rname = new ObjectName(domain + RESOURCELINK_TYPE + CONTEXT_TYPE + ",path=" + path + ",host=" + host + ",*");
            } else if (resourcetype.equals("DefaultContext")) {
                rname = host.length() > 0 ? new ObjectName(domain + RESOURCELINK_TYPE + HOST_DEFAULTCONTEXT_TYPE + ",host=" + host + ",*") : new ObjectName(domain + RESOURCELINK_TYPE + SERVICE_DEFAULTCONTEXT_TYPE + ",*");
            }
        }
        Iterator<ObjectInstance> iterator = mserver.queryMBeans(rname, null).iterator();
        ArrayList<String> results = new ArrayList<String>();
        while (iterator.hasNext()) {
            ObjectInstance instance = iterator.next();
            results.add(instance.getObjectName().toString());
        }
        Collections.sort(results);
        ResourceLinksForm resourceLinksForm = new ResourceLinksForm();
        resourceLinksForm.setResourceLinks(results.toArray(new String[results.size()]));
        if (resourcetype != null) {
            resourceLinksForm.setResourcetype(resourcetype);
        } else {
            resourceLinksForm.setResourcetype("");
        }
        if (path != null) {
            resourceLinksForm.setPath(path);
        } else {
            resourceLinksForm.setPath("");
        }
        if (host != null) {
            resourceLinksForm.setHost(host);
        } else {
            resourceLinksForm.setHost("");
        }
        if (domain != null) {
            resourceLinksForm.setDomain(domain);
        } else {
            resourceLinksForm.setDomain("");
        }
        return resourceLinksForm;
    }

    public static UserDatabasesForm getUserDatabasesForm(MBeanServer mserver, String domain) throws Exception {
        ObjectName rname = new ObjectName(domain + RESOURCE_TYPE + GLOBAL_TYPE + ",class=" + USERDB_CLASS + ",*");
        Iterator<ObjectInstance> iterator = mserver.queryMBeans(rname, null).iterator();
        ArrayList<String> results = new ArrayList<String>();
        while (iterator.hasNext()) {
            ObjectInstance instance = iterator.next();
            results.add(instance.getObjectName().toString());
        }
        Collections.sort(results);
        UserDatabasesForm userDatabasesForm = new UserDatabasesForm();
        userDatabasesForm.setUserDatabases(results.toArray(new String[results.size()]));
        return userDatabasesForm;
    }
}

