/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecodecvssnap;

import gnu.bytecodecvssnap.ArrayType;
import gnu.bytecodecvssnap.AttrContainer;
import gnu.bytecodecvssnap.Attribute;
import gnu.bytecodecvssnap.ClassType;
import gnu.bytecodecvssnap.ClassTypeWriter;
import gnu.bytecodecvssnap.ConstantPool;
import gnu.bytecodecvssnap.CpoolEntry;
import gnu.bytecodecvssnap.CpoolUtf8;
import gnu.bytecodecvssnap.CpoolValue2;
import gnu.bytecodecvssnap.Field;
import gnu.bytecodecvssnap.IfState;
import gnu.bytecodecvssnap.Label;
import gnu.bytecodecvssnap.LineNumbersAttr;
import gnu.bytecodecvssnap.LocalVarsAttr;
import gnu.bytecodecvssnap.Method;
import gnu.bytecodecvssnap.ObjectType;
import gnu.bytecodecvssnap.PrimType;
import gnu.bytecodecvssnap.Scope;
import gnu.bytecodecvssnap.SourceDebugExtAttr;
import gnu.bytecodecvssnap.TryState;
import gnu.bytecodecvssnap.Type;
import gnu.bytecodecvssnap.Variable;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Array;

public class CodeAttr
extends Attribute
implements AttrContainer {
    static final int FIXUP_NONE = 0;
    static final int FIXUP_DEFINE = 1;
    static final int FIXUP_SWITCH = 2;
    static final int FIXUP_CASE = 3;
    static final int FIXUP_GOTO = 4;
    static final int FIXUP_JSR = 5;
    static final int FIXUP_TRANSFER = 6;
    static final int FIXUP_TRANSFER2 = 7;
    static final int FIXUP_DELETE3 = 8;
    static final int FIXUP_MOVE = 9;
    static final int FIXUP_MOVE_TO_END = 10;
    static final int FIXUP_TRY = 11;
    static final int FIXUP_CATCH = 12;
    static final int FIXUP_LINE_PC = 13;
    static final int FIXUP_LINE_NUMBER = 14;
    Attribute attributes;
    LineNumbersAttr lines;
    public LocalVarsAttr locals;
    SourceDebugExtAttr sourceDbgExt;
    Type[] stack_types;
    int SP;
    private int max_stack;
    private int max_locals;
    int PC;
    byte[] code;
    short[] exception_table;
    int exception_table_length;
    int[] fixup_offsets;
    Label[] fixup_labels;
    int fixup_count;
    IfState if_stack;
    TryState try_stack;
    private boolean unreachable_here;

    public final Attribute getAttributes() {
        return this.attributes;
    }

    public final void setAttributes(Attribute attribute) {
        this.attributes = attribute;
    }

    public final void fixupChain(Label label, Label label2) {
        this.fixupAdd(9, 0, label2);
        label.define(this);
    }

    public final void fixupAdd(int n, Label label) {
        this.fixupAdd(n, this.PC, label);
    }

    final void fixupAdd(int n, int n2, Label label) {
        int n3 = this.fixup_count;
        if (n3 == 0) {
            this.fixup_offsets = new int[30];
            this.fixup_labels = new Label[30];
        } else if (this.fixup_count == this.fixup_offsets.length) {
            int n4 = 2 * n3;
            Label[] labelArray = new Label[n4];
            System.arraycopy(this.fixup_labels, 0, labelArray, 0, n3);
            this.fixup_labels = labelArray;
            int[] nArray = new int[n4];
            System.arraycopy(this.fixup_offsets, 0, nArray, 0, n3);
            this.fixup_offsets = nArray;
        }
        this.fixup_offsets[n3] = n2 << 4 | n;
        this.fixup_labels[n3] = label;
        this.fixup_count = n3 + 1;
    }

    private final int fixupOffset(int n) {
        return this.fixup_offsets[n] >> 4;
    }

    private final int fixupKind(int n) {
        return this.fixup_offsets[n] & 0xF;
    }

    public final Method getMethod() {
        return (Method)this.getContainer();
    }

    public final int getPC() {
        return this.PC;
    }

    public final int getSP() {
        return this.SP;
    }

    public final ConstantPool getConstants() {
        return this.getMethod().classfile.constants;
    }

    public final boolean reachableHere() {
        return this.unreachable_here ^ true;
    }

    public final void setReachable(boolean bl) {
        this.unreachable_here = bl ^ true;
    }

    public final void setUnreachable() {
        this.unreachable_here = true;
    }

    public int getMaxStack() {
        return this.max_stack;
    }

    public int getMaxLocals() {
        return this.max_locals;
    }

    public void setMaxStack(int n) {
        this.max_stack = n;
    }

    public void setMaxLocals(int n) {
        this.max_locals = n;
    }

    public byte[] getCode() {
        return this.code;
    }

    public void setCode(byte[] byArray) {
        this.code = byArray;
        this.PC = byArray.length;
    }

    public void setCodeLength(int n) {
        this.PC = n;
    }

    public int getCodeLength() {
        return this.PC;
    }

    public final void reserve(int n) {
        if (this.code == null) {
            this.code = new byte[100 + n];
        } else if (this.PC + n > this.code.length) {
            byte[] byArray = new byte[2 * this.code.length + n];
            System.arraycopy(this.code, 0, byArray, 0, this.PC);
            this.code = byArray;
        }
    }

    byte invert_opcode(byte by) {
        if (by >= 153 && by <= 166 || by >= 198 && by <= 199) {
            return (byte)(by ^ 1);
        }
        throw new Error("unknown opcode to invert_opcode");
    }

    public final void put1(int n) {
        this.code[this.PC++] = (byte)n;
        this.unreachable_here = false;
    }

    public final void put2(int n) {
        this.code[this.PC++] = (byte)(n >> 8);
        this.code[this.PC++] = (byte)n;
        this.unreachable_here = false;
    }

    public final void put4(int n) {
        this.code[this.PC++] = (byte)(n >> 24);
        this.code[this.PC++] = (byte)(n >> 16);
        this.code[this.PC++] = (byte)(n >> 8);
        this.code[this.PC++] = (byte)n;
        this.unreachable_here = false;
    }

    public final void putIndex2(CpoolEntry cpoolEntry) {
        this.put2(cpoolEntry.index);
    }

    public final void putLineNumber(String string, int n) {
        this.getMethod().classfile.setSourceFile(string);
        this.putLineNumber(n);
    }

    public final void putLineNumber(int n) {
        if (this.sourceDbgExt != null) {
            n = this.sourceDbgExt.fixLine(n);
        }
        this.fixupAdd(13, null);
        this.fixupAdd(14, n, null);
    }

    public final void pushType(Type type) {
        if (type.size == 0) {
            throw new Error("pushing void type onto stack");
        }
        if (this.stack_types == null) {
            this.stack_types = new Type[20];
        } else if (this.SP + 1 >= this.stack_types.length) {
            Type[] typeArray = new Type[2 * this.stack_types.length];
            System.arraycopy(this.stack_types, 0, typeArray, 0, this.SP);
            this.stack_types = typeArray;
        }
        if (type.size == 8) {
            this.stack_types[this.SP++] = Type.void_type;
        }
        this.stack_types[this.SP++] = type;
        if (this.SP > this.max_stack) {
            this.max_stack = this.SP;
        }
    }

    public final Type popType() {
        if (this.SP <= 0) {
            throw new Error("popType called with empty stack " + this.getMethod());
        }
        Type type = this.stack_types[--this.SP];
        if (type.size == 8 && !this.popType().isVoid()) {
            throw new Error("missing void type on stack");
        }
        return type;
    }

    public final Type topType() {
        return this.stack_types[this.SP - 1];
    }

    public void emitPop(int n) {
        while (n > 0) {
            this.reserve(1);
            Type type = this.popType();
            if (type.size > 4) {
                this.put1(88);
            } else if (n > 1) {
                Type type2 = this.popType();
                if (type2.size > 4) {
                    this.put1(87);
                    this.reserve(1);
                }
                this.put1(88);
                --n;
            } else {
                this.put1(87);
            }
            --n;
        }
    }

    public Label getLabel() {
        boolean bl = this.unreachable_here;
        Label label = new Label();
        label.define(this);
        this.unreachable_here = bl;
        return label;
    }

    public void emitSwap() {
        this.reserve(1);
        Type type = this.popType();
        Type type2 = this.popType();
        if (type.size > 4 || type2.size > 4) {
            this.pushType(type2);
            this.pushType(type);
            this.emitDupX();
            this.emitPop(1);
        } else {
            this.pushType(type);
            this.put1(95);
            this.pushType(type2);
        }
    }

    public void emitDup() {
        this.reserve(1);
        Type type = this.topType();
        this.put1(type.size <= 4 ? 89 : 92);
        this.pushType(type);
    }

    public void emitDupX() {
        this.reserve(1);
        Type type = this.popType();
        Type type2 = this.popType();
        if (type2.size <= 4) {
            this.put1(type.size <= 4 ? 90 : 93);
        } else {
            this.put1(type.size <= 4 ? 91 : 94);
        }
        this.pushType(type);
        this.pushType(type2);
        this.pushType(type);
    }

    public void emitDup(int n, int n2) {
        int n3;
        if (n == 0) {
            return;
        }
        this.reserve(1);
        Type type = this.popType();
        Type type2 = null;
        if (n == 1) {
            if (type.size > 4) {
                throw new Error("using dup for 2-word type");
            }
        } else {
            if (n != 2) {
                throw new Error("invalid size to emitDup");
            }
            if (type.size <= 4) {
                type2 = this.popType();
                if (type2.size > 4) {
                    throw new Error("dup will cause invalid types on stack");
                }
            }
        }
        Type type3 = null;
        Type type4 = null;
        if (n2 == 0) {
            n3 = n == 1 ? 89 : 92;
        } else if (n2 == 1) {
            n3 = n == 1 ? 90 : 93;
            type3 = this.popType();
            if (type3.size > 4) {
                throw new Error("dup will cause invalid types on stack");
            }
        } else if (n2 == 2) {
            n3 = n == 1 ? 91 : 94;
            type3 = this.popType();
            if (type3.size <= 4) {
                type4 = this.popType();
                if (type4.size > 4) {
                    throw new Error("dup will cause invalid types on stack");
                }
            }
        } else {
            throw new Error("emitDup:  invalid offset");
        }
        this.put1(n3);
        if (type2 != null) {
            this.pushType(type2);
        }
        this.pushType(type);
        if (type4 != null) {
            this.pushType(type4);
        }
        if (type3 != null) {
            this.pushType(type3);
        }
        if (type2 != null) {
            this.pushType(type2);
        }
        this.pushType(type);
    }

    public void emitDup(int n) {
        this.emitDup(n, 0);
    }

    public void emitDup(Type type) {
        int n = 0;
        if (type.size > 4) {
            n = 1;
        }
        this.emitDup(n + 1, 0);
    }

    public void enterScope(Scope scope) {
        scope.setStartPC(this);
        this.locals.enterScope(scope);
    }

    public Scope pushScope() {
        Scope scope = new Scope();
        if (this.locals == null) {
            this.locals = new LocalVarsAttr(this.getMethod());
        }
        this.enterScope(scope);
        if (this.locals.parameter_scope == null) {
            this.locals.parameter_scope = scope;
        }
        return scope;
    }

    public Scope getCurrentScope() {
        return this.locals.current_scope;
    }

    public Scope popScope() {
        Scope scope = this.locals.current_scope;
        this.locals.current_scope = scope.parent;
        scope.freeLocals(this);
        scope.end = this.getLabel();
        return scope;
    }

    public Variable getArg(int n) {
        return this.locals.parameter_scope.getVariable(n);
    }

    public Variable lookup(String string) {
        Scope scope = this.locals.current_scope;
        while (scope != null) {
            Variable variable = scope.lookup(string);
            if (variable != null) {
                return variable;
            }
            scope = scope.parent;
        }
        return null;
    }

    public Variable addLocal(Type type) {
        return this.locals.current_scope.addVariable(this, type, null);
    }

    public Variable addLocal(Type type, String string) {
        return this.locals.current_scope.addVariable(this, type, string);
    }

    public void addParamLocals() {
        Method method = this.getMethod();
        if ((method.access_flags & 8) == 0) {
            this.addLocal(method.classfile).setParameter(true);
        }
        int n = method.arg_types.length;
        int n2 = 0;
        while (n2 < n) {
            this.addLocal(method.arg_types[n2]).setParameter(true);
            ++n2;
        }
    }

    public final void emitPushConstant(int n, Type type) {
        switch (type.getSignature().charAt(0)) {
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                this.emitPushInt(n);
                break;
            }
            case 'J': {
                this.emitPushLong(n);
                break;
            }
            case 'F': {
                this.emitPushFloat(n);
                break;
            }
            case 'D': {
                this.emitPushDouble(n);
                break;
            }
            default: {
                throw new Error("bad type to emitPushConstant");
            }
        }
    }

    public final void emitPushConstant(CpoolEntry cpoolEntry) {
        this.reserve(3);
        int n = cpoolEntry.index;
        if (cpoolEntry instanceof CpoolValue2) {
            this.put1(20);
            this.put2(n);
        } else if (n < 256) {
            this.put1(18);
            this.put1(n);
        } else {
            this.put1(19);
            this.put2(n);
        }
    }

    public final void emitPushInt(int n) {
        this.reserve(3);
        if (n >= -1 && n <= 5) {
            this.put1(n + 3);
        } else if (n >= -128 && n < 128) {
            this.put1(16);
            this.put1(n);
        } else if (n >= Short.MIN_VALUE && n < 32768) {
            this.put1(17);
            this.put2(n);
        } else {
            this.emitPushConstant(this.getConstants().addInt(n));
        }
        this.pushType(Type.int_type);
    }

    public void emitPushLong(long l) {
        if (l == 0L || l == 1L) {
            this.reserve(1);
            this.put1(9 + (int)l);
        } else if ((long)((int)l) == l) {
            this.emitPushInt((int)l);
            this.reserve(1);
            this.popType();
            this.put1(133);
        } else {
            this.emitPushConstant(this.getConstants().addLong(l));
        }
        this.pushType(Type.long_type);
    }

    public void emitPushFloat(float f) {
        int n = (int)f;
        if ((float)n == f && n >= -128 && n < 128) {
            if (n >= 0 && n <= 2) {
                this.reserve(1);
                this.put1(11 + n);
                if (n == 0 && Float.floatToIntBits(f) != 0) {
                    this.reserve(1);
                    this.put1(118);
                }
            } else {
                this.emitPushInt(n);
                this.reserve(1);
                this.popType();
                this.put1(134);
            }
        } else {
            this.emitPushConstant(this.getConstants().addFloat(f));
        }
        this.pushType(Type.float_type);
    }

    public void emitPushDouble(double d) {
        int n = (int)d;
        if ((double)n == d && n >= -128 && n < 128) {
            if (n == 0 || n == 1) {
                this.reserve(1);
                this.put1(14 + n);
                if (n == 0 && Double.doubleToLongBits(d) != 0L) {
                    this.reserve(1);
                    this.put1(119);
                }
            } else {
                this.emitPushInt(n);
                this.reserve(1);
                this.popType();
                this.put1(135);
            }
        } else {
            this.emitPushConstant(this.getConstants().addDouble(d));
        }
        this.pushType(Type.double_type);
    }

    public final String calculateSplit(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(20);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            int n5;
            int n6;
            char c = string.charAt(n4);
            if (c >= '\u0800') {
                n6 = 3;
            } else {
                int n7 = 0;
                if (c >= '\u0080' || c == '\u0000') {
                    n7 = 1;
                }
                n6 = n5 = n7 + 1;
            }
            if (n3 + n5 > (char)-1) {
                stringBuffer.append((char)(n4 - n2));
                n2 = n4;
                n3 = 0;
            }
            n3 += n5;
            ++n4;
        }
        stringBuffer.append((char)(n - n2));
        return stringBuffer.toString();
    }

    public final void emitPushString(String string) {
        if (string == null) {
            this.emitPushNull();
        } else {
            int n = string.length();
            String string2 = this.calculateSplit(string);
            int n2 = string2.length();
            if (n2 > 1) {
                if (n2 == 2) {
                    char c = string2.charAt(0);
                    this.emitPushString(string.substring(0, c));
                    this.emitPushString(string.substring(c));
                    Method method = Type.string_type.getDeclaredMethod("concat", 1);
                    this.emitInvokeVirtual(method);
                } else {
                    ClassType classType = ClassType.make("java.lang.StringBuffer");
                    this.emitNew(classType);
                    this.emitDup(classType);
                    this.emitPushInt(n);
                    Type[] typeArray = new Type[]{Type.int_type};
                    this.emitInvokeSpecial(classType.getDeclaredMethod("<init>", typeArray));
                    Type[] typeArray2 = new Type[]{Type.string_type};
                    Method method = classType.getDeclaredMethod("append", typeArray2);
                    int n3 = 0;
                    int n4 = 0;
                    while (n4 < n2) {
                        this.emitDup(classType);
                        int n5 = n3 + string2.charAt(n4);
                        this.emitPushString(string.substring(n3, n5));
                        this.emitInvokeVirtual(method);
                        n3 = n5;
                        ++n4;
                    }
                    this.emitInvokeVirtual(Type.toString_method);
                }
                if (string == string.intern()) {
                    this.emitInvokeVirtual(Type.string_type.getDeclaredMethod("intern", 0));
                }
                return;
            }
            this.emitPushConstant(this.getConstants().addString(string));
            this.pushType(Type.string_type);
        }
    }

    public final void emitPushClass(String string) {
        this.emitPushConstant(this.getConstants().addClass(string));
        this.pushType(Type.java_lang_Class_type);
    }

    public void emitPushNull() {
        this.reserve(1);
        this.put1(1);
        this.pushType(Type.pointer_type);
    }

    public final void emitPushThis() {
        this.reserve(1);
        this.put1(42);
        this.pushType(this.getMethod().getDeclaringClass());
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void emitPushPrimArray(Object object, ArrayType arrayType) {
        Type type = arrayType.getComponentType();
        int n = Array.getLength(object);
        this.emitPushInt(n);
        this.emitNewArray(type);
        char c = type.getSignature().charAt(0);
        int n2 = 0;
        while (n2 < n) {
            block17: {
                long l = 0L;
                float f = 0.0f;
                double d = 0.0;
                switch (c) {
                    case 'J': {
                        l = ((long[])object)[n2];
                        if (l != 0L) break;
                        break block17;
                    }
                    case 'I': {
                        l = ((int[])object)[n2];
                        if (l != 0L) break;
                        break block17;
                    }
                    case 'S': {
                        l = ((short[])object)[n2];
                        if (l != 0L) break;
                        break block17;
                    }
                    case 'C': {
                        l = ((char[])object)[n2];
                        if (l != 0L) break;
                        break block17;
                    }
                    case 'B': {
                        l = ((byte[])object)[n2];
                        if (l != 0L) break;
                        break block17;
                    }
                    case 'Z': {
                        l = ((boolean[])object)[n2];
                        if (l != 0L) break;
                        break block17;
                    }
                    case 'F': {
                        f = ((float[])object)[n2];
                        if ((double)f != 0.0) break;
                        break block17;
                    }
                    case 'D': {
                        d = ((double[])object)[n2];
                        if (d == 0.0) break block17;
                    }
                }
                this.emitDup(arrayType);
                this.emitPushInt(n2);
                switch (c) {
                    case 'B': 
                    case 'C': 
                    case 'I': 
                    case 'S': 
                    case 'Z': {
                        this.emitPushInt((int)l);
                        break;
                    }
                    case 'J': {
                        this.emitPushLong(l);
                        break;
                    }
                    case 'F': {
                        this.emitPushFloat(f);
                        break;
                    }
                    case 'D': {
                        this.emitPushDouble(d);
                        break;
                    }
                }
                this.emitArrayStore(type);
            }
            ++n2;
        }
    }

    void emitNewArray(int n) {
        this.reserve(2);
        this.put1(188);
        this.put1(n);
    }

    public final void emitArrayLength() {
        if (!(this.popType() instanceof ArrayType)) {
            throw new Error("non-array type in emitArrayLength");
        }
        this.reserve(1);
        this.put1(190);
        this.pushType(Type.int_type);
    }

    private final int adjustTypedOp(char c) {
        switch (c) {
            case 'I': {
                return 0;
            }
            case 'J': {
                return 1;
            }
            case 'F': {
                return 2;
            }
            case 'D': {
                return 3;
            }
            default: {
                return 4;
            }
            case 'B': 
            case 'Z': {
                return 5;
            }
            case 'C': {
                return 6;
            }
            case 'S': 
        }
        return 7;
    }

    private final int adjustTypedOp(Type type) {
        return this.adjustTypedOp(type.getSignature().charAt(0));
    }

    private final void emitTypedOp(int n, Type type) {
        this.reserve(1);
        this.put1(n + this.adjustTypedOp(type));
    }

    private final void emitTypedOp(int n, char c) {
        this.reserve(1);
        this.put1(n + this.adjustTypedOp(c));
    }

    public void emitArrayStore(Type type) {
        this.popType();
        this.popType();
        this.popType();
        this.emitTypedOp(79, type);
    }

    public void emitArrayLoad(Type type) {
        this.popType();
        this.popType();
        this.emitTypedOp(46, type);
        this.pushType(type);
    }

    public void emitNew(ClassType classType) {
        this.reserve(3);
        this.put1(187);
        this.putIndex2(this.getConstants().addClass(classType));
        this.pushType(classType);
    }

    public void emitNewArray(Type type, int n) {
        if (this.popType().promote() != Type.int_type) {
            throw new Error("non-int dim. spec. in emitNewArray");
        }
        if (type instanceof PrimType) {
            int n2;
            switch (type.getSignature().charAt(0)) {
                case 'B': {
                    n2 = 8;
                    break;
                }
                case 'S': {
                    n2 = 9;
                    break;
                }
                case 'I': {
                    n2 = 10;
                    break;
                }
                case 'J': {
                    n2 = 11;
                    break;
                }
                case 'F': {
                    n2 = 6;
                    break;
                }
                case 'D': {
                    n2 = 7;
                    break;
                }
                case 'Z': {
                    n2 = 4;
                    break;
                }
                case 'C': {
                    n2 = 5;
                    break;
                }
                default: {
                    throw new Error("bad PrimType in emitNewArray");
                }
            }
            this.emitNewArray(n2);
        } else if (type instanceof ObjectType) {
            this.reserve(3);
            this.put1(189);
            this.putIndex2(this.getConstants().addClass((ObjectType)type));
        } else if (type instanceof ArrayType) {
            this.reserve(4);
            this.put1(197);
            this.putIndex2(this.getConstants().addClass(new ArrayType(type)));
            if (n < 1 || n > 255) {
                throw new Error("dims out of range in emitNewArray");
            }
            this.put1(n);
            while (--n > 0) {
                if (this.popType().promote() == Type.int_type) continue;
                throw new Error("non-int dim. spec. in emitNewArray");
            }
        } else {
            throw new Error("unimplemented type in emitNewArray");
        }
        this.pushType(new ArrayType(type));
    }

    public void emitNewArray(Type type) {
        this.emitNewArray(type, 1);
    }

    private final void emitBinop(int n) {
        Type type = this.popType().promote();
        Type type2 = this.popType();
        Type type3 = type2.promote();
        if (type3 != type || !(type3 instanceof PrimType)) {
            throw new Error("non-matching or bad types in binary operation");
        }
        this.emitTypedOp(n, type3);
        this.pushType(type2);
    }

    private final void emitBinop(int n, char c) {
        this.popType();
        this.popType();
        this.emitTypedOp(n, c);
        this.pushType(Type.signatureToPrimitive(c));
    }

    private final void emitBinop(int n, Type type) {
        this.popType();
        this.popType();
        this.emitTypedOp(n, type);
        this.pushType(type);
    }

    public final void emitAdd(char c) {
        this.emitBinop(96, c);
    }

    public final void emitAdd(PrimType primType) {
        this.emitBinop(96, primType);
    }

    public final void emitAdd() {
        this.emitBinop(96);
    }

    public final void emitSub(char c) {
        this.emitBinop(100, c);
    }

    public final void emitSub(PrimType primType) {
        this.emitBinop(100, primType);
    }

    public final void emitSub() {
        this.emitBinop(100);
    }

    public final void emitMul() {
        this.emitBinop(104);
    }

    public final void emitDiv() {
        this.emitBinop(108);
    }

    public final void emitRem() {
        this.emitBinop(112);
    }

    public final void emitAnd() {
        this.emitBinop(126);
    }

    public final void emitIOr() {
        this.emitBinop(128);
    }

    public final void emitXOr() {
        this.emitBinop(130);
    }

    public final void emitShl() {
        this.emitShift(120);
    }

    public final void emitShr() {
        this.emitShift(122);
    }

    public final void emitUshr() {
        this.emitShift(124);
    }

    private final void emitShift(int n) {
        Type type = this.popType().promote();
        Type type2 = this.popType();
        Type type3 = type2.promote();
        if (type3 != Type.int_type && type3 != Type.long_type) {
            throw new Error("the value shifted must be an int or a long");
        }
        if (type != Type.int_type) {
            throw new Error("the amount of shift must be an int");
        }
        this.emitTypedOp(n, type3);
        this.pushType(type2);
    }

    public final void emitNot(Type type) {
        this.emitPushConstant(1, type);
        this.emitAdd();
        this.emitPushConstant(1, type);
        this.emitAnd();
    }

    public void emitPrimop(int n, int n2, Type type) {
        this.reserve(1);
        while (--n2 >= 0) {
            this.popType();
        }
        this.put1(n);
        this.pushType(type);
    }

    void emitMaybeWide(int n, int n2) {
        if (n2 >= 256) {
            this.put1(196);
            this.put1(n);
            this.put2(n2);
        } else {
            this.put1(n);
            this.put1(n2);
        }
    }

    public final void emitLoad(Variable variable) {
        if (variable.dead()) {
            throw new Error("attempting to push dead variable");
        }
        int n = variable.offset;
        if (n < 0 || !variable.isSimple()) {
            throw new Error("attempting to load from unassigned variable " + variable + " simple:" + variable.isSimple() + ", offset: " + n);
        }
        Type type = variable.getType().promote();
        this.reserve(4);
        int n2 = this.adjustTypedOp(type);
        if (n <= 3) {
            this.put1(26 + 4 * n2 + n);
        } else {
            this.emitMaybeWide(21 + n2, n);
        }
        this.pushType(variable.getType());
    }

    public void emitStore(Variable variable) {
        if (variable.dead()) {
            throw new Error("attempting to push dead variable");
        }
        int n = variable.offset;
        if (n < 0 || !variable.isSimple()) {
            throw new Error("attempting to store in unassigned " + variable + " simple:" + variable.isSimple() + ", offset: " + n);
        }
        Type type = variable.getType().promote();
        this.reserve(4);
        this.popType();
        int n2 = this.adjustTypedOp(type);
        if (n <= 3) {
            this.put1(59 + 4 * n2 + n);
        } else {
            this.emitMaybeWide(54 + n2, n);
        }
    }

    public void emitInc(Variable variable, short s) {
        boolean bl;
        if (variable.dead()) {
            throw new Error("attempting to increment dead variable");
        }
        int n = variable.offset;
        if (n < 0 || !variable.isSimple()) {
            throw new Error("attempting to increment unassigned variable" + variable.getName() + " simple:" + variable.isSimple() + ", offset: " + n);
        }
        Type type = variable.getType().promote();
        this.reserve(6);
        if (type != Type.int_type) {
            throw new Error("attempting to increment non-int variable");
        }
        boolean bl2 = false;
        if (n > 255 || s > 255 || s < -256) {
            bl2 = true;
        }
        if (bl = bl2) {
            this.put1(196);
            this.put1(132);
            this.put2(n);
            this.put2(s);
        } else {
            this.put1(132);
            this.put1(n);
            this.put1(s);
        }
    }

    private final void emitFieldop(Field field, int n) {
        this.reserve(3);
        this.put1(n);
        this.putIndex2(this.getConstants().addFieldRef(field));
    }

    public final void emitGetStatic(Field field) {
        this.pushType(field.type);
        this.emitFieldop(field, 178);
    }

    public final void emitGetField(Field field) {
        this.popType();
        this.pushType(field.type);
        this.emitFieldop(field, 180);
    }

    public final void emitPutStatic(Field field) {
        this.popType();
        this.emitFieldop(field, 179);
    }

    public final void emitPutField(Field field) {
        this.popType();
        this.popType();
        this.emitFieldop(field, 181);
    }

    private final int words(Type[] typeArray) {
        int n = 0;
        int n2 = typeArray.length;
        while (--n2 >= 0) {
            if (typeArray[n2].size > 4) {
                n += 2;
                continue;
            }
            ++n;
        }
        return n;
    }

    public void emitInvokeMethod(Method method, int n) {
        this.reserve(n == 185 ? 5 : 3);
        int n2 = method.arg_types.length;
        boolean bl = false;
        if (n == 184) {
            bl = true;
        }
        boolean bl2 = bl;
        boolean bl3 = false;
        if ((method.access_flags & 8) != 0) {
            bl3 = true;
        }
        if (bl2 != bl3) {
            throw new Error("emitInvokeXxx static flag mis-match method.flags=" + method.access_flags);
        }
        if (!bl2) {
            ++n2;
        }
        this.put1(n);
        this.putIndex2(this.getConstants().addMethodRef(method));
        if (n == 185) {
            this.put1(this.words(method.arg_types) + 1);
            this.put1(0);
        }
        while (--n2 >= 0) {
            this.popType();
        }
        if (method.return_type.size != 0) {
            this.pushType(method.return_type);
        }
    }

    public void emitInvoke(Method method) {
        int n = (method.access_flags & 8) != 0 ? 184 : (method.classfile.isInterface() ? 185 : ("<init>".equals(method.getName()) ? 183 : 182));
        this.emitInvokeMethod(method, n);
    }

    public void emitInvokeVirtual(Method method) {
        this.emitInvokeMethod(method, 182);
    }

    public void emitInvokeSpecial(Method method) {
        this.emitInvokeMethod(method, 183);
    }

    public void emitInvokeStatic(Method method) {
        this.emitInvokeMethod(method, 184);
    }

    public void emitInvokeInterface(Method method) {
        this.emitInvokeMethod(method, 185);
    }

    final void emitTransfer(Label label, int n) {
        this.fixupAdd(6, label);
        this.put1(n);
        this.PC += 2;
    }

    public final void emitGoto(Label label) {
        this.fixupAdd(4, label);
        this.reserve(3);
        this.put1(167);
        this.PC += 2;
        this.setUnreachable();
    }

    public final void emitJsr(Label label) {
        this.fixupAdd(5, label);
        this.reserve(3);
        this.put1(168);
        this.PC += 2;
    }

    public final void emitGotoIfCompare1(Label label, int n) {
        this.popType();
        this.reserve(3);
        this.emitTransfer(label, n);
    }

    public final void emitGotoIfIntEqZero(Label label) {
        this.emitGotoIfCompare1(label, 153);
    }

    public final void emitGotoIfIntNeZero(Label label) {
        this.emitGotoIfCompare1(label, 154);
    }

    public final void emitGotoIfIntLtZero(Label label) {
        this.emitGotoIfCompare1(label, 155);
    }

    public final void emitGotoIfIntGeZero(Label label) {
        this.emitGotoIfCompare1(label, 156);
    }

    public final void emitGotoIfIntGtZero(Label label) {
        this.emitGotoIfCompare1(label, 157);
    }

    public final void emitGotoIfIntLeZero(Label label) {
        this.emitGotoIfCompare1(label, 158);
    }

    public final void emitGotoIfCompare2(Label label, int n) {
        int n2;
        if (n < 153 || n > 158) {
            throw new Error("emitGotoIfCompare2: logop must be one of ifeq...ifle");
        }
        Type type = this.popType().promote();
        Type type2 = this.popType().promote();
        this.reserve(4);
        char c = type2.getSignature().charAt(0);
        char c2 = type.getSignature().charAt(0);
        int n3 = 0;
        if (n == 155 || n == 158) {
            n3 = n2 = 1;
        }
        if (c == 'I' && c2 == 'I') {
            n += 6;
        } else if (c == 'J' && c2 == 'J') {
            this.put1(148);
        } else if (c == 'F' && c2 == 'F') {
            this.put1(150 - n2);
        } else if (c == 'D' && c2 == 'D') {
            this.put1(152 - n2);
        } else if (!(c != 'L' && c != '[' || c2 != 'L' && c2 != '[' || n > 154)) {
            n += 12;
        } else {
            throw new Error("invalid types to emitGotoIfCompare2");
        }
        this.emitTransfer(label, n);
    }

    public final void emitGotoIfEq(Label label, boolean bl) {
        this.emitGotoIfCompare2(label, bl + 153);
    }

    public final void emitGotoIfEq(Label label) {
        this.emitGotoIfCompare2(label, 153);
    }

    public final void emitGotoIfNE(Label label) {
        this.emitGotoIfCompare2(label, 154);
    }

    public final void emitGotoIfLt(Label label) {
        this.emitGotoIfCompare2(label, 155);
    }

    public final void emitGotoIfGe(Label label) {
        this.emitGotoIfCompare2(label, 156);
    }

    public final void emitGotoIfGt(Label label) {
        this.emitGotoIfCompare2(label, 157);
    }

    public final void emitGotoIfLe(Label label) {
        this.emitGotoIfCompare2(label, 158);
    }

    public final void emitIfCompare1(int n) {
        IfState ifState = new IfState(this);
        if (this.popType().promote() != Type.int_type) {
            throw new Error("non-int type to emitIfCompare1");
        }
        this.reserve(3);
        this.emitTransfer(ifState.end_label, n);
        ifState.start_stack_size = this.SP;
    }

    public final void emitIfIntNotZero() {
        this.emitIfCompare1(153);
    }

    public final void emitIfIntEqZero() {
        this.emitIfCompare1(154);
    }

    public final void emitIfIntLEqZero() {
        this.emitIfCompare1(157);
    }

    public final void emitIfRefCompare1(int n) {
        IfState ifState = new IfState(this);
        if (!(this.popType() instanceof ObjectType)) {
            throw new Error("non-ref type to emitIfRefCompare1");
        }
        this.reserve(3);
        this.emitTransfer(ifState.end_label, n);
        ifState.start_stack_size = this.SP;
    }

    public final void emitIfNotNull() {
        this.emitIfRefCompare1(198);
    }

    public final void emitIfNull() {
        this.emitIfRefCompare1(199);
    }

    public final void emitIfIntCompare(int n) {
        IfState ifState = new IfState(this);
        this.popType();
        this.popType();
        this.reserve(3);
        this.emitTransfer(ifState.end_label, n);
        ifState.start_stack_size = this.SP;
    }

    public final void emitIfIntLt() {
        this.emitIfIntCompare(162);
    }

    public final void emitIfNEq() {
        IfState ifState = new IfState(this);
        this.emitGotoIfEq(ifState.end_label);
        ifState.start_stack_size = this.SP;
    }

    public final void emitIfEq() {
        IfState ifState = new IfState(this);
        this.emitGotoIfNE(ifState.end_label);
        ifState.start_stack_size = this.SP;
    }

    public final void emitIfLt() {
        IfState ifState = new IfState(this);
        this.emitGotoIfGe(ifState.end_label);
        ifState.start_stack_size = this.SP;
    }

    public final void emitIfGe() {
        IfState ifState = new IfState(this);
        this.emitGotoIfLt(ifState.end_label);
        ifState.start_stack_size = this.SP;
    }

    public final void emitIfGt() {
        IfState ifState = new IfState(this);
        this.emitGotoIfLe(ifState.end_label);
        ifState.start_stack_size = this.SP;
    }

    public final void emitIfLe() {
        IfState ifState = new IfState(this);
        this.emitGotoIfGt(ifState.end_label);
        ifState.start_stack_size = this.SP;
    }

    public void emitRet(Variable variable) {
        int n = variable.offset;
        if (n < 256) {
            this.reserve(2);
            this.put1(169);
            this.put1(n);
        } else {
            this.reserve(4);
            this.put1(196);
            this.put1(169);
            this.put2(n);
        }
    }

    public final void emitThen() {
        this.if_stack.start_stack_size = this.SP;
    }

    public final void emitIfThen() {
        new IfState(this, null);
    }

    public final void emitElse() {
        Label label;
        Label label2 = this.if_stack.end_label;
        this.if_stack.end_label = label = new Label(this);
        if (this.reachableHere()) {
            int n;
            this.if_stack.stack_growth = n = this.SP - this.if_stack.start_stack_size;
            if (n > 0) {
                this.if_stack.then_stacked_types = new Type[n];
                System.arraycopy(this.stack_types, this.if_stack.start_stack_size, this.if_stack.then_stacked_types, 0, n);
            } else {
                this.if_stack.then_stacked_types = new Type[0];
            }
            this.emitGoto(label);
        }
        while (this.SP > this.if_stack.start_stack_size) {
            this.popType();
        }
        this.SP = this.if_stack.start_stack_size;
        if (label2 != null) {
            label2.define(this);
        }
        this.if_stack.doing_else = true;
    }

    public final void emitFi() {
        boolean bl = false;
        if (!this.if_stack.doing_else) {
            if (this.reachableHere() && this.SP != this.if_stack.start_stack_size) {
                throw new Error("at PC " + this.PC + " then clause grows stack with no else clause");
            }
        } else if (this.if_stack.then_stacked_types != null) {
            int n = this.if_stack.start_stack_size + this.if_stack.stack_growth;
            if (!this.reachableHere()) {
                if (this.if_stack.stack_growth > 0) {
                    System.arraycopy(this.if_stack.then_stacked_types, 0, this.stack_types, this.if_stack.start_stack_size, this.if_stack.stack_growth);
                }
                this.SP = n;
            } else if (this.SP != n) {
                throw new Error("at PC " + this.PC + ": SP at end of 'then' was " + n + " while SP at end of 'else' was " + this.SP);
            }
        } else if (this.unreachable_here) {
            bl = true;
        }
        if (this.if_stack.end_label != null) {
            this.if_stack.end_label.define(this);
        }
        if (bl) {
            this.setUnreachable();
        }
        this.if_stack = this.if_stack.previous;
    }

    public final void emitConvert(Type type, Type type2) {
        String string = type2.getSignature();
        String string2 = type.getSignature();
        int n = -1;
        if (string.length() == 1 || string2.length() == 1) {
            int n2 = string.charAt(0);
            int n3 = string2.charAt(0);
            if (n3 == n2) {
                return;
            }
            if (type.size < 4) {
                n3 = 73;
            }
            if (type2.size < 4) {
                this.emitConvert(type, Type.int_type);
                n3 = 73;
            }
            if (n3 == n2) {
                return;
            }
            block0 : switch (n3) {
                case 73: {
                    switch (n2) {
                        case 66: {
                            n = 145;
                            break block0;
                        }
                        case 67: {
                            n = 146;
                            break block0;
                        }
                        case 83: {
                            n = 147;
                            break block0;
                        }
                        case 74: {
                            n = 133;
                            break block0;
                        }
                        case 70: {
                            n = 134;
                            break block0;
                        }
                        case 68: {
                            n = 135;
                            break block0;
                        }
                    }
                    break;
                }
                case 74: {
                    switch (n2) {
                        case 73: {
                            n = 136;
                            break block0;
                        }
                        case 70: {
                            n = 137;
                            break block0;
                        }
                        case 68: {
                            n = 138;
                            break block0;
                        }
                    }
                    break;
                }
                case 70: {
                    switch (n2) {
                        case 73: {
                            n = 139;
                            break block0;
                        }
                        case 74: {
                            n = 140;
                            break block0;
                        }
                        case 68: {
                            n = 141;
                            break block0;
                        }
                    }
                    break;
                }
                case 68: {
                    switch (n2) {
                        case 73: {
                            n = 142;
                            break block0;
                        }
                        case 74: {
                            n = 143;
                            break block0;
                        }
                        case 70: {
                            n = 144;
                            break block0;
                        }
                    }
                    break;
                }
            }
        }
        if (n < 0) {
            throw new Error("unsupported CodeAttr.emitConvert");
        }
        this.reserve(1);
        this.popType();
        this.put1(n);
        this.pushType(type2);
    }

    private final void emitCheckcast(Type type, int n) {
        this.reserve(3);
        this.popType();
        this.put1(n);
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            CpoolUtf8 cpoolUtf8 = this.getConstants().addUtf8(arrayType.signature);
            this.putIndex2(this.getConstants().addClass(cpoolUtf8));
        } else if (type instanceof ClassType) {
            this.putIndex2(this.getConstants().addClass((ClassType)type));
        } else {
            throw new Error("unimplemented type " + type + " in emitCheckcast/emitInstanceof");
        }
    }

    public void emitCheckcast(Type type) {
        Type type2;
        if (type instanceof ClassType && (type2 = this.topType()) instanceof ClassType && ((ClassType)type2).isSubclass((ClassType)type)) {
            return;
        }
        this.emitCheckcast(type, 192);
        this.pushType(type);
    }

    public void emitInstanceof(Type type) {
        this.emitCheckcast(type, 193);
        this.pushType(Type.boolean_type);
    }

    public final void emitThrow() {
        this.popType();
        this.reserve(1);
        this.put1(191);
        this.setUnreachable();
    }

    public final void emitMonitorEnter() {
        this.popType();
        this.reserve(1);
        this.put1(194);
    }

    public final void emitMonitorExit() {
        this.popType();
        this.reserve(1);
        this.put1(195);
    }

    public void doPendingFinalizers(TryState tryState) {
        TryState tryState2 = this.try_stack;
        boolean bl = this.getMethod().getReturnType().isVoid() ^ true;
        Variable variable = null;
        while (tryState2 != tryState) {
            if (tryState2.finally_subr != null && tryState2.finally_ret_addr == null) {
                if (bl && variable == null) {
                    variable = this.addLocal(this.topType());
                    this.emitStore(variable);
                }
                this.emitJsr(tryState2.finally_subr);
            }
            tryState2 = tryState2.previous;
        }
        if (variable != null) {
            this.emitLoad(variable);
        }
    }

    public final void emitReturn() {
        this.doPendingFinalizers(null);
        if (this.getMethod().getReturnType().size == 0) {
            this.reserve(1);
            this.put1(177);
        } else {
            this.emitTypedOp(172, this.popType().promote());
        }
        this.setUnreachable();
    }

    public void addHandler(int n, int n2, int n3, int n4) {
        int n5 = 4 * this.exception_table_length;
        if (this.exception_table == null) {
            this.exception_table = new short[20];
        } else if (this.exception_table.length <= n5) {
            short[] sArray = new short[2 * this.exception_table.length];
            System.arraycopy(this.exception_table, 0, sArray, 0, n5);
            this.exception_table = sArray;
        }
        this.exception_table[n5++] = (short)n;
        this.exception_table[n5++] = (short)n2;
        this.exception_table[n5++] = (short)n3;
        this.exception_table[n5++] = (short)n4;
        ++this.exception_table_length;
    }

    public void addHandler(Label label, Label label2, ClassType classType) {
        ConstantPool constantPool = this.getConstants();
        int n = classType == null ? 0 : constantPool.addClass((ObjectType)classType).index;
        this.fixupAdd(11, label);
        this.fixupAdd(12, n, label2);
    }

    public void emitWithCleanupStart() {
        new TryState(this);
    }

    public void emitWithCleanupCatch(Variable variable) {
        this.emitTryEnd();
        this.try_stack.saved_result = variable;
        int n = this.SP;
        this.emitCatchStart(variable);
        this.SP = n + 1;
    }

    public void emitWithCleanupDone() {
        Variable variable = this.try_stack.saved_result;
        this.try_stack.saved_result = null;
        if (variable != null) {
            this.emitLoad(variable);
        }
        this.emitThrow();
        this.emitCatchEnd();
        this.emitTryCatchEnd();
    }

    public void emitTryStart(boolean bl, Type type) {
        if (type != null && type.isVoid()) {
            type = null;
        }
        Variable[] variableArray = null;
        if (type != null || this.SP > 0) {
            this.pushScope();
        }
        if (this.SP > 0) {
            variableArray = new Variable[this.SP];
            int n = 0;
            while (this.SP > 0) {
                Variable variable = this.addLocal(this.topType());
                this.emitStore(variable);
                variableArray[n++] = variable;
            }
        }
        TryState tryState = new TryState(this);
        tryState.savedStack = variableArray;
        if (type != null) {
            tryState.saved_result = this.addLocal(type);
        }
        if (bl) {
            tryState.finally_subr = new Label();
        }
    }

    public void emitTryEnd() {
        if (this.try_stack.end_label == null) {
            if (this.try_stack.saved_result != null && this.reachableHere()) {
                this.emitStore(this.try_stack.saved_result);
            }
            this.try_stack.end_label = new Label();
            if (this.reachableHere()) {
                if (this.try_stack.finally_subr != null) {
                    this.emitJsr(this.try_stack.finally_subr);
                }
                this.emitGoto(this.try_stack.end_label);
            }
            this.try_stack.end_try = this.getLabel();
        }
    }

    public void emitCatchStart(Variable variable) {
        ClassType classType;
        this.emitTryEnd();
        this.SP = 0;
        if (this.try_stack.try_type != null) {
            this.emitCatchEnd();
        }
        this.try_stack.try_type = classType = variable == null ? null : (ClassType)variable.getType();
        this.addHandler(this.try_stack.start_try, this.try_stack.end_try, classType);
        if (variable != null) {
            this.pushType(classType);
            this.emitStore(variable);
        } else {
            this.pushType(Type.throwable_type);
        }
    }

    public void emitCatchEnd() {
        if (this.reachableHere()) {
            if (this.try_stack.saved_result != null) {
                this.emitStore(this.try_stack.saved_result);
            }
            if (this.try_stack.finally_subr != null) {
                this.emitJsr(this.try_stack.finally_subr);
            }
            this.emitGoto(this.try_stack.end_label);
        }
        this.try_stack.try_type = null;
    }

    public void emitFinallyStart() {
        this.emitTryEnd();
        if (this.try_stack.try_type != null) {
            this.emitCatchEnd();
        }
        this.SP = 0;
        this.try_stack.end_try = this.getLabel();
        this.pushScope();
        ClassType classType = Type.pointer_type;
        Variable variable = this.addLocal(classType);
        this.emitCatchStart(null);
        this.emitStore(variable);
        this.emitJsr(this.try_stack.finally_subr);
        this.emitLoad(variable);
        this.emitThrow();
        this.try_stack.finally_subr.define(this);
        ClassType classType2 = Type.pointer_type;
        this.try_stack.finally_ret_addr = this.addLocal(classType2);
        this.pushType(classType2);
        this.emitStore(this.try_stack.finally_ret_addr);
    }

    public void emitFinallyEnd() {
        this.emitRet(this.try_stack.finally_ret_addr);
        this.setUnreachable();
        this.popScope();
        this.try_stack.finally_subr = null;
    }

    public void emitTryCatchEnd() {
        if (this.try_stack.finally_subr != null) {
            this.emitFinallyEnd();
        }
        this.try_stack.end_label.define(this);
        Variable[] variableArray = this.try_stack.savedStack;
        if (variableArray != null) {
            int n = variableArray.length;
            while (--n >= 0) {
                Variable variable = variableArray[n];
                if (variable == null) continue;
                this.emitLoad(variable);
            }
        }
        if (this.try_stack.saved_result != null) {
            this.emitLoad(this.try_stack.saved_result);
        }
        if (this.try_stack.saved_result != null || variableArray != null) {
            this.popScope();
        }
        this.try_stack = this.try_stack.previous;
    }

    public final TryState getCurrentTry() {
        return this.try_stack;
    }

    public final boolean isInTry() {
        boolean bl = false;
        if (this.try_stack != null) {
            bl = true;
        }
        return bl;
    }

    public void emitTailCall(boolean bl, Scope scope) {
        if (bl) {
            Method method = this.getMethod();
            int n = 0;
            if ((method.access_flags & 8) != 0) {
                n = 1;
            }
            int n2 = 1 - n;
            int n3 = method.arg_types.length;
            while (--n3 >= 0) {
                int n4 = 0;
                if (method.arg_types[n3].size > 4) {
                    n4 = 1;
                }
                n2 += n4 + 1;
            }
            n3 = method.arg_types.length;
            while (--n3 >= 0) {
                int n5 = 0;
                if (method.arg_types[n3].size > 4) {
                    n5 = 1;
                }
                this.emitStore(this.locals.used[n2 -= n5 + 1]);
            }
        }
        this.emitGoto(scope.start);
    }

    /*
     * Unable to fully structure code
     */
    public void processFixups() {
        if (this.fixup_count == 0) {
            return;
        }
        var1_1 = 0;
        var2_2 = this.fixup_count;
        this.fixupAdd(9, 0, null);
        var3_3 = 0;
        block30: while (true) {
            var4_4 = this.fixup_offsets[var3_3];
            var5_6 = var4_4 & 15;
            var4_4 >>= 4;
            var6_7 = this.fixup_labels[var3_3];
            switch (var5_6) {
                case 11: 
                case 13: {
                    ++var3_3;
                }
                case 0: 
                case 3: 
                case 8: {
                    break;
                }
                case 1: {
                    var6_7.position += var1_1;
                    break;
                }
                case 2: {
                    var1_1 += 3;
                    break;
                }
                case 4: {
                    if (var6_7.first_fixup == var3_3 + 1 && this.fixupOffset(var3_3 + 1) == var4_4 + 3) {
                        this.fixup_offsets[var3_3] = var4_4 << 4 | 8;
                        this.fixup_labels[var3_3] = null;
                        var1_1 -= 3;
                        break;
                    }
                }
                case 5: {
                    if (this.PC < 32768) break;
                    var1_1 += 2;
                    break;
                }
                case 6: {
                    if (this.PC < 32768) break;
                    var1_1 += 5;
                    break;
                }
                case 10: {
                    this.fixup_labels[var2_2] = this.fixup_labels[var3_3 + 1];
                    var2_2 = var4_4;
                }
                case 9: {
                    var7_10 = var3_3 + 1 >= this.fixup_count ? this.PC : this.fixupOffset(this.fixup_labels[var3_3 + 1].first_fixup);
                    this.fixup_offsets[var3_3] = var7_10 << 4 | 9;
                    if (var6_7 == null) break block30;
                    var3_3 = var6_7.first_fixup;
                    var8_13 = this.fixupOffset(var3_3);
                    var1_1 = var7_10 + var1_1 - var8_13;
                    continue block30;
                }
                default: {
                    throw new Error("unexpected fixup");
                }
            }
            ++var3_3;
        }
        var3_3 = this.PC;
        var1_1 = 0;
        var4_4 = 0;
        block31: while (var4_4 < this.fixup_count) {
            var5_6 = this.fixup_offsets[var4_4];
            var6_8 = var5_6 & 15;
            var7_11 = this.fixup_labels[var4_4];
            if (var7_11 == null || var7_11.position >= 0) ** GOTO lbl62
            throw new Error("undefined label " + var7_11);
lbl-1000:
            // 1 sources

            {
                this.fixup_labels[var4_4] = var7_11 = this.fixup_labels[var7_11.first_fixup + 1];
lbl62:
                // 2 sources

                ** while (var7_11 != null && var6_8 >= 4 && var6_8 <= 7 && var7_11.first_fixup + 1 < this.fixup_count && this.fixup_offsets[var7_11.first_fixup + 1] == (this.fixup_offsets[var7_11.first_fixup] & 15 | 4))
            }
lbl63:
            // 1 sources

            var5_6 >>= 4;
            switch (var6_8) {
                case 11: 
                case 13: {
                    ++var4_4;
                }
                case 0: 
                case 3: {
                    break;
                }
                case 8: {
                    var1_1 -= 3;
                    var3_3 -= 3;
                    break;
                }
                case 1: {
                    var7_11.position = var5_6 + var1_1;
                    break;
                }
                case 2: {
                    var8_13 = 3 - (var5_6 + var1_1) & 3;
                    var1_1 += var8_13;
                    var3_3 += var8_13;
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    var9_14 = var7_11.position - (var5_6 + var1_1);
                    if ((short)var9_14 == var9_14) {
                        this.fixup_offsets[var4_4] = var5_6 << 4 | 7;
                        break;
                    }
                    var1_1 += var6_8 == 6 ? 5 : 2;
                    var3_3 += var6_8 == 6 ? 5 : 2;
                    break;
                }
                case 9: {
                    if (var7_11 == null) break block31;
                    var4_4 = var7_11.first_fixup;
                    var10_15 = this.fixupOffset(var4_4);
                    var1_1 = var5_6 + var1_1 - var10_15;
                    continue block31;
                }
                default: {
                    throw new Error("unexpected fixup");
                }
            }
            ++var4_4;
        }
        var4_5 = new byte[var3_3];
        var5_6 = 0;
        var6_9 = 0;
        var7_12 = this.fixupOffset(0);
        var8_13 = 0;
        block33: while (true) {
            if (var8_13 < var7_12) {
                var4_5[var5_6++] = this.code[var8_13++];
                continue;
            }
            var9_14 = this.fixup_offsets[var6_9] & 15;
            var10_16 = this.fixup_labels[var6_9];
            switch (var9_14) {
                case 0: 
                case 1: {
                    break;
                }
                case 8: {
                    var8_13 += 3;
                    break;
                }
                case 7: {
                    var1_1 = var10_16.position - var5_6;
                    var4_5[var5_6++] = this.code[var8_13];
                    var4_5[var5_6++] = (byte)(var1_1 >> 8);
                    var4_5[var5_6++] = (byte)(var1_1 & 255);
                    var8_13 += 3;
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    var1_1 = var10_16.position - var5_6;
                    var11_17 = this.code[var8_13];
                    if (var9_14 == 6) {
                        var11_17 = this.invert_opcode((byte)var11_17);
                        var4_5[var5_6++] = var11_17;
                        var4_5[var5_6++] = 0;
                        var4_5[var5_6++] = 8;
                        var11_17 = -56;
                    } else {
                        var11_17 = (byte)(var11_17 + 33);
                    }
                    var4_5[var5_6++] = var11_17;
                    var4_5[var5_6++] = (byte)(var1_1 >> 24);
                    var4_5[var5_6++] = (byte)(var1_1 >> 16);
                    var4_5[var5_6++] = (byte)(var1_1 >> 8);
                    var4_5[var5_6++] = (byte)(var1_1 & 255);
                    var8_13 += 3;
                    break;
                }
                case 2: {
                    var12_18 = 3 - var5_6 & 3;
                    var13_19 = var5_6;
                    var4_5[var5_6++] = this.code[var8_13++];
                    while (--var12_18 >= 0) {
                        var4_5[var5_6++] = 0;
                    }
                    while (var6_9 < this.fixup_count && this.fixupKind(var6_9 + 1) == 3) {
                        var14_20 = this.fixupOffset(++var6_9);
                        while (var8_13 < var14_20) {
                            var4_5[var5_6++] = this.code[var8_13++];
                        }
                        var1_1 = this.fixup_labels[var6_9].position - var13_19;
                        var4_5[var5_6++] = (byte)(var1_1 >> 24);
                        var4_5[var5_6++] = (byte)(var1_1 >> 16);
                        var4_5[var5_6++] = (byte)(var1_1 >> 8);
                        var4_5[var5_6++] = (byte)(var1_1 & 255);
                        var8_13 += 4;
                    }
                    break;
                }
                case 11: {
                    this.addHandler(this.fixup_labels[var6_9].position, this.fixup_labels[var6_9 + 1].position, var5_6, this.fixupOffset(var6_9 + 1));
                    ++var6_9;
                    break;
                }
                case 13: {
                    if (this.lines == null) {
                        this.lines = new LineNumbersAttr(this);
                    }
                    this.lines.put(this.fixupOffset(++var6_9), var5_6);
                    break;
                }
                case 9: {
                    if (var10_16 == null) break block33;
                    var6_9 = var10_16.first_fixup;
                    var7_12 = var8_13 = this.fixupOffset(var6_9);
                    if (var10_16.position == var5_6) continue block33;
                    throw new Error("bad pc");
                }
                default: {
                    throw new Error("unexpected fixup");
                }
            }
            var7_12 = this.fixupOffset(++var6_9);
        }
        if (var3_3 != var5_6) {
            throw new Error("PC confusion new_pc:" + var5_6 + " new_size:" + var3_3);
        }
        this.PC = var3_3;
        this.code = var4_5;
        this.fixup_count = 0;
        this.fixup_labels = null;
        this.fixup_offsets = null;
    }

    public void assignConstants(ClassType classType) {
        super.assignConstants(classType);
        if (this.locals != null && this.locals.container == null && !this.locals.isEmpty()) {
            this.locals.addToFrontOf(this);
        }
        this.processFixups();
        Attribute.assignConstants(this, classType);
    }

    public final int getLength() {
        return 12 + this.getCodeLength() + 8 * this.exception_table_length + Attribute.getLengthAll(this);
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.max_stack);
        dataOutputStream.writeShort(this.max_locals);
        dataOutputStream.writeInt(this.PC);
        dataOutputStream.write(this.code, 0, this.PC);
        dataOutputStream.writeShort(this.exception_table_length);
        int n = this.exception_table_length;
        int n2 = 0;
        while (--n >= 0) {
            dataOutputStream.writeShort(this.exception_table[n2]);
            dataOutputStream.writeShort(this.exception_table[n2 + 1]);
            dataOutputStream.writeShort(this.exception_table[n2 + 2]);
            dataOutputStream.writeShort(this.exception_table[n2 + 3]);
            n2 += 4;
        }
        Attribute.writeAll(this, dataOutputStream);
    }

    public void print(ClassTypeWriter classTypeWriter) {
        classTypeWriter.print("Attribute \"");
        classTypeWriter.print(this.getName());
        classTypeWriter.print("\", length:");
        classTypeWriter.print(this.getLength());
        classTypeWriter.print(", max_stack:");
        classTypeWriter.print(this.max_stack);
        classTypeWriter.print(", max_locals:");
        classTypeWriter.print(this.max_locals);
        classTypeWriter.print(", code_length:");
        int n = this.getCodeLength();
        classTypeWriter.println(n);
        this.disAssemble(classTypeWriter, 0, n);
        if (this.exception_table_length > 0) {
            classTypeWriter.print("Exceptions (count: ");
            classTypeWriter.print(this.exception_table_length);
            classTypeWriter.println("):");
            int n2 = this.exception_table_length;
            int n3 = 0;
            while (--n2 >= 0) {
                classTypeWriter.print("  start: ");
                classTypeWriter.print(this.exception_table[n3] & (char)-1);
                classTypeWriter.print(", end: ");
                classTypeWriter.print(this.exception_table[n3 + 1] & (char)-1);
                classTypeWriter.print(", handler: ");
                classTypeWriter.print(this.exception_table[n3 + 2] & (char)-1);
                classTypeWriter.print(", type: ");
                int n4 = this.exception_table[n3 + 3] & (char)-1;
                if (n4 == 0) {
                    classTypeWriter.print("0 /* finally */");
                } else {
                    classTypeWriter.printOptionalIndex(n4);
                    classTypeWriter.printConstantTersely(n4, 7);
                }
                classTypeWriter.println();
                n3 += 4;
            }
        }
        classTypeWriter.printAttributes(this);
    }

    public void disAssemble(ClassTypeWriter classTypeWriter, int n, int n2) {
        boolean bl = false;
        int n3 = n;
        while (n3 < n2) {
            int n4;
            int n5 = n3++;
            int n6 = this.code[n5] & 0xFF;
            String string = Integer.toString(n5);
            int n7 = 0;
            int n8 = string.length();
            while (++n8 <= 3) {
                classTypeWriter.print(' ');
            }
            classTypeWriter.print(string);
            classTypeWriter.print(": ");
            if (n6 < 120) {
                if (n6 < 87) {
                    if (n6 < 3) {
                        this.print("nop;aconst_null;iconst_m1;", n6, classTypeWriter);
                    } else if (n6 < 9) {
                        classTypeWriter.print("iconst_");
                        classTypeWriter.print(n6 - 3);
                    } else if (n6 < 16) {
                        char c;
                        if (n6 < 11) {
                            c = 'l';
                            n6 -= 9;
                        } else if (n6 < 14) {
                            c = 'f';
                            n6 -= 11;
                        } else {
                            c = 'd';
                            n6 -= 14;
                        }
                        classTypeWriter.print(c);
                        classTypeWriter.print("const_");
                        classTypeWriter.print(n6);
                    } else if (n6 < 21) {
                        if (n6 < 18) {
                            short s;
                            this.print("bipush ;sipush ;", n6 - 16, classTypeWriter);
                            if (n6 == 16) {
                                s = this.code[n3++];
                            } else {
                                s = (short)this.readUnsignedShort(n3);
                                n3 += 2;
                            }
                            classTypeWriter.print(s);
                        } else {
                            int n9 = 0;
                            if (n6 == 18) {
                                n9 = 1;
                            }
                            n7 = 2 - n9;
                            this.print("ldc;ldc_w;ldc2_w;", n6 - 18, classTypeWriter);
                        }
                    } else {
                        String string2;
                        if (n6 < 54) {
                            string2 = "load";
                        } else {
                            string2 = "store";
                            n6 -= 33;
                        }
                        if (n6 < 26) {
                            n4 = -1;
                            n6 -= 21;
                        } else if (n6 < 46) {
                            n4 = (n6 -= 26) % 4;
                            n6 >>= 2;
                        } else {
                            n4 = -2;
                            n6 -= 46;
                        }
                        classTypeWriter.print("ilfdabcs".charAt(n6));
                        if (n4 == -2) {
                            classTypeWriter.write(97);
                        }
                        classTypeWriter.print(string2);
                        if (n4 >= 0) {
                            classTypeWriter.write(95);
                            classTypeWriter.print(n4);
                        } else if (n4 == -1) {
                            if (bl) {
                                n4 = this.readUnsignedShort(n3);
                                n3 += 2;
                            } else {
                                n4 = this.code[n3] & 0xFF;
                                ++n3;
                            }
                            bl = false;
                            classTypeWriter.print(' ');
                            classTypeWriter.print(n4);
                        }
                    }
                } else if (n6 < 96) {
                    this.print("pop;pop2;dup;dup_x1;dup_x2;dup2;dup2_x1;dup2_x2;swap;", n6 - 87, classTypeWriter);
                } else {
                    classTypeWriter.print("ilfda".charAt((n6 - 96) % 4));
                    this.print("add;sub;mul;div;rem;neg;", n6 - 96 >> 2, classTypeWriter);
                }
            } else if (n6 < 170) {
                if (n6 < 132) {
                    classTypeWriter.print((n6 & 1) == 0 ? (char)'i' : 'l');
                    this.print("shl;shr;ushr;and;or;xor;", n6 - 120 >> 1, classTypeWriter);
                } else if (n6 == 132) {
                    int n10;
                    classTypeWriter.print("iinc");
                    if (!bl) {
                        n10 = 0xFF & this.code[n3++];
                        n4 = this.code[n3++];
                    } else {
                        n10 = this.readUnsignedShort(n3);
                        n4 = this.readUnsignedShort(n3 += 2);
                        n3 += 2;
                        bl = false;
                    }
                    classTypeWriter.print(' ');
                    classTypeWriter.print(n10);
                    classTypeWriter.print(' ');
                    classTypeWriter.print(n4);
                } else if (n6 < 148) {
                    classTypeWriter.print("ilfdi".charAt((n6 - 133) / 3));
                    classTypeWriter.print('2');
                    classTypeWriter.print("lfdifdildilfbcs".charAt(n6 - 133));
                } else if (n6 < 153) {
                    this.print("lcmp;fcmpl;fcmpg;dcmpl;dcmpg;", n6 - 148, classTypeWriter);
                } else if (n6 < 169) {
                    if (n6 < 159) {
                        classTypeWriter.print("if");
                        this.print("eq;ne;lt;ge;gt;le;", n6 - 153, classTypeWriter);
                    } else if (n6 < 167) {
                        if (n6 < 165) {
                            classTypeWriter.print("if_icmp");
                        } else {
                            classTypeWriter.print("if_acmp");
                            n6 -= 6;
                        }
                        this.print("eq;ne;lt;ge;gt;le;", n6 - 159, classTypeWriter);
                    } else {
                        this.print("goto;jsr;", n6 - 167, classTypeWriter);
                    }
                    short s = (short)this.readUnsignedShort(n3);
                    n3 += 2;
                    classTypeWriter.print(' ');
                    classTypeWriter.print(n5 + s);
                } else {
                    int n11;
                    classTypeWriter.print("ret ");
                    if (bl) {
                        n11 = this.readUnsignedShort(n3);
                        n11 += 2;
                    } else {
                        n11 = this.code[n3] & 0xFF;
                        ++n3;
                    }
                    bl = false;
                    classTypeWriter.print(n11);
                }
            } else if (n6 < 172) {
                int n12;
                if (this.fixup_count == 0) {
                    n3 = n3 + 3 & 0xFFFFFFFC;
                }
                int n13 = this.readInt(n3);
                n3 += 4;
                if (n6 == 170) {
                    classTypeWriter.print("tableswitch");
                    n4 = this.readInt(n3);
                    n12 = this.readInt(n3 += 4);
                    n3 += 4;
                    classTypeWriter.print(" low: ");
                    classTypeWriter.print(n4);
                    classTypeWriter.print(" high: ");
                    classTypeWriter.print(n12);
                    classTypeWriter.print(" default: ");
                    classTypeWriter.print(n5 + n13);
                    while (n4 <= n12) {
                        n13 = this.readInt(n3);
                        n3 += 4;
                        classTypeWriter.println();
                        classTypeWriter.print("  ");
                        classTypeWriter.print(n4);
                        classTypeWriter.print(": ");
                        classTypeWriter.print(n5 + n13);
                        ++n4;
                    }
                } else {
                    classTypeWriter.print("lookupswitch");
                    n4 = this.readInt(n3);
                    n3 += 4;
                    classTypeWriter.print(" npairs: ");
                    classTypeWriter.print(n4);
                    classTypeWriter.print(" default: ");
                    classTypeWriter.print(n5 + n13);
                    while (--n4 >= 0) {
                        n12 = this.readInt(n3);
                        n13 = this.readInt(n3 += 4);
                        n3 += 4;
                        classTypeWriter.println();
                        classTypeWriter.print("  ");
                        classTypeWriter.print(n12);
                        classTypeWriter.print(": ");
                        classTypeWriter.print(n5 + n13);
                    }
                }
            } else if (n6 < 178) {
                if (n6 < 177) {
                    classTypeWriter.print("ilfda".charAt(n6 - 172));
                }
                classTypeWriter.print("return");
            } else if (n6 < 182) {
                this.print("getstatic;putstatic;getfield;putfield;", n6 - 178, classTypeWriter);
                n7 = 2;
            } else if (n6 < 185) {
                classTypeWriter.print("invoke");
                this.print("virtual;special;static;", n6 - 182, classTypeWriter);
                n7 = 2;
            } else if (n6 == 185) {
                classTypeWriter.print("invokeinterface (");
                int n14 = this.readUnsignedShort(n3);
                n4 = 0xFF & this.code[n3 += 2];
                n3 += 2;
                classTypeWriter.print(n4 + " args)");
                classTypeWriter.printConstantOperand(n14);
            } else if (n6 < 196) {
                this.print("186;new;newarray;anewarray;arraylength;athrow;checkcast;instanceof;monitorenter;monitorexit;", n6 - 186, classTypeWriter);
                if (n6 == 187 || n6 == 189 || n6 == 192 || n6 == 193) {
                    n7 = 2;
                } else if (n6 == 188) {
                    byte by = this.code[n3++];
                    classTypeWriter.print(' ');
                    if (by >= 4 && by <= 11) {
                        this.print("boolean;char;float;double;byte;short;int;long;", by - 4, classTypeWriter);
                    } else {
                        classTypeWriter.print(by);
                    }
                }
            } else if (n6 == 196) {
                classTypeWriter.print("wide");
                bl = true;
            } else if (n6 == 197) {
                classTypeWriter.print("multianewarray");
                int n15 = this.readUnsignedShort(n3);
                n3 += 2;
                classTypeWriter.printConstantOperand(n15);
                n4 = 0xFF & this.code[n3++];
                classTypeWriter.print(' ');
                classTypeWriter.print(n4);
            } else if (n6 < 200) {
                this.print("ifnull;ifnonnull;", n6 - 198, classTypeWriter);
                short s = (short)this.readUnsignedShort(n3);
                n3 += 2;
                classTypeWriter.print(' ');
                classTypeWriter.print(n5 + s);
            } else if (n6 < 202) {
                this.print("goto_w;jsr_w;", n6 - 200, classTypeWriter);
                int n16 = this.readInt(n3);
                n3 += 4;
                classTypeWriter.print(' ');
                classTypeWriter.print(n5 + n16);
            } else {
                classTypeWriter.print(n6);
            }
            if (n7 > 0) {
                int n17;
                if (n7 == 1) {
                    n17 = 0xFF & this.code[n3++];
                } else {
                    n17 = this.readUnsignedShort(n3);
                    n3 += 2;
                }
                classTypeWriter.printConstantOperand(n17);
            }
            classTypeWriter.println();
        }
    }

    private final int readUnsignedShort(int n) {
        return (0xFF & this.code[n]) << 8 | 0xFF & this.code[n + 1];
    }

    private final int readInt(int n) {
        return this.readUnsignedShort(n) << 16 | this.readUnsignedShort(n + 2);
    }

    private final void print(String string, int n, PrintWriter printWriter) {
        int n2 = 0;
        int n3 = -1;
        while (n >= 0) {
            n2 = ++n3;
            n3 = string.indexOf(59, n2);
            --n;
        }
        printWriter.write(string, n2, n3 - n2);
    }

    public Type[] saveStackTypeState(boolean bl) {
        if (this.SP == 0) {
            return null;
        }
        Type[] typeArray = new Type[this.SP];
        System.arraycopy(this.stack_types, 0, typeArray, 0, this.SP);
        if (bl) {
            this.SP = 0;
        }
        return typeArray;
    }

    public void restoreStackTypeState(Type[] typeArray) {
        if (typeArray == null) {
            this.SP = 0;
        } else {
            this.SP = typeArray.length;
            System.arraycopy(typeArray, 0, this.stack_types, 0, this.SP);
        }
    }

    public int beginFragment(Label label, Label label2) {
        int n = this.fixup_count;
        this.fixupAdd(10, label2);
        label.define(this);
        return n;
    }

    public void endFragment(int n) {
        this.fixup_offsets[n] = this.fixup_count << 4 | 0xA;
        Label label = this.fixup_labels[n];
        this.fixupAdd(9, 0, null);
        label.define(this);
    }

    public CodeAttr(Method method) {
        super("Code");
        this.addToFrontOf(method);
        method.code = this;
    }
}

