/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecodecvssnap;

import gnu.bytecodecvssnap.Attribute;
import gnu.bytecodecvssnap.ClassType;
import gnu.bytecodecvssnap.ClassTypeWriter;
import gnu.bytecodecvssnap.CodeAttr;
import gnu.bytecodecvssnap.Method;
import gnu.bytecodecvssnap.Scope;
import gnu.bytecodecvssnap.VarEnumerator;
import gnu.bytecodecvssnap.Variable;
import java.io.DataOutputStream;
import java.io.IOException;

public class LocalVarsAttr
extends Attribute {
    private Method method;
    Variable[] used;
    public Scope current_scope;
    Scope parameter_scope;

    public final Method getMethod() {
        return this.method;
    }

    public VarEnumerator allVars() {
        return new VarEnumerator(this.parameter_scope);
    }

    public void enterScope(Scope scope) {
        scope.linkChild(this.current_scope);
        this.current_scope = scope;
        CodeAttr codeAttr = this.method.getCode();
        Variable variable = scope.firstVar();
        while (variable != null) {
            if (variable.isSimple()) {
                if (!variable.isAssigned()) {
                    variable.allocateLocal(codeAttr);
                } else if (this.used[variable.offset] == null) {
                    this.used[variable.offset] = variable;
                } else if (this.used[variable.offset] != variable) {
                    throw new Error("inconsistent local variable assignments for " + variable + " != " + this.used[variable.offset]);
                }
            }
            variable = variable.nextVar();
        }
    }

    public void preserveVariablesUpto(Scope scope) {
        Scope scope2 = this.current_scope;
        while (scope2 != scope) {
            scope2.preserved = true;
            scope2 = scope2.parent;
        }
    }

    public final boolean isEmpty() {
        Variable variable;
        VarEnumerator varEnumerator = this.allVars();
        while ((variable = varEnumerator.nextVar()) != null) {
            if (!variable.isSimple() || variable.name == null) continue;
            return false;
        }
        return true;
    }

    public final int getCount() {
        Variable variable;
        int n = 0;
        VarEnumerator varEnumerator = this.allVars();
        while ((variable = varEnumerator.nextVar()) != null) {
            if (!variable.shouldEmit()) continue;
            ++n;
        }
        return n;
    }

    public final int getLength() {
        return 2 + 10 * this.getCount();
    }

    public void assignConstants(ClassType classType) {
        Variable variable;
        super.assignConstants(classType);
        VarEnumerator varEnumerator = this.allVars();
        while ((variable = varEnumerator.nextVar()) != null) {
            if (!variable.isSimple() || variable.name == null) continue;
            if (variable.name_index == 0) {
                variable.name_index = classType.getConstants().addUtf8((String)variable.getName()).index;
            }
            if (variable.signature_index != 0) continue;
            variable.signature_index = classType.getConstants().addUtf8((String)variable.getType().signature).index;
        }
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        Variable variable;
        VarEnumerator varEnumerator = this.allVars();
        dataOutputStream.writeShort(this.getCount());
        varEnumerator.reset();
        while ((variable = varEnumerator.nextVar()) != null) {
            if (!variable.shouldEmit()) continue;
            Scope scope = variable.scope;
            int n = scope.start.position;
            int n2 = scope.end.position;
            dataOutputStream.writeShort(n);
            dataOutputStream.writeShort(n2 - n);
            dataOutputStream.writeShort(variable.name_index);
            dataOutputStream.writeShort(variable.signature_index);
            dataOutputStream.writeShort(variable.offset);
        }
    }

    public void print(ClassTypeWriter classTypeWriter) {
        Variable variable;
        VarEnumerator varEnumerator = this.allVars();
        classTypeWriter.print("Attribute \"");
        classTypeWriter.print(this.getName());
        classTypeWriter.print("\", length:");
        classTypeWriter.print(this.getLength());
        classTypeWriter.print(", count: ");
        classTypeWriter.println(this.getCount());
        varEnumerator.reset();
        while ((variable = varEnumerator.nextVar()) != null) {
            int n;
            int n2;
            if (!variable.isSimple() || variable.name == null) continue;
            classTypeWriter.print("  slot#");
            classTypeWriter.print(variable.offset);
            classTypeWriter.print(": name: ");
            classTypeWriter.printOptionalIndex(variable.name_index);
            classTypeWriter.print(variable.getName());
            classTypeWriter.print(", type: ");
            classTypeWriter.printOptionalIndex(variable.signature_index);
            classTypeWriter.printSignature(variable.getType());
            classTypeWriter.print(" (pc: ");
            Scope scope = variable.scope;
            if (scope == null || scope.start == null || scope.end == null || (n2 = scope.start.position) < 0 || (n = scope.end.position) < 0) {
                classTypeWriter.print("unknown");
            } else {
                classTypeWriter.print(n2);
                classTypeWriter.print(" length: ");
                classTypeWriter.print(n - n2);
            }
            classTypeWriter.println(')');
        }
    }

    public LocalVarsAttr(CodeAttr codeAttr) {
        super("LocalVariableTable");
        this.addToFrontOf(codeAttr);
        this.method = (Method)codeAttr.getContainer();
        codeAttr.locals = this;
    }

    public LocalVarsAttr(Method method) {
        super("LocalVariableTable");
        CodeAttr codeAttr = method.code;
        this.method = method;
        codeAttr.locals = this;
    }
}

