/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.net.protocol.http;

import gnu.classpath.SystemProperties;
import gnu.java.net.EmptyX509TrustManager;
import gnu.java.net.protocol.http.Cookie;
import gnu.java.net.protocol.http.CookieManager;
import gnu.java.net.protocol.http.Request;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class HTTPConnection {
    public static final int HTTP_PORT = 80;
    public static final int HTTPS_PORT = 443;
    private static final String userAgent = SystemProperties.getProperty("http.agent");
    protected final String hostname;
    protected final int port;
    protected final boolean secure;
    protected final int connectionTimeout;
    protected final int timeout;
    protected String proxyHostname;
    protected int proxyPort;
    protected int majorVersion;
    protected int minorVersion;
    private final List handshakeCompletedListeners;
    protected Socket socket;
    private SSLSocketFactory sslSocketFactory;
    protected InputStream in;
    protected OutputStream out;
    private Map nonceCounts;
    protected CookieManager cookieManager;
    private Pool pool;
    int useCount;
    long timeLastUsed;

    public String getHostName() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public String getVersion() {
        return "HTTP/" + this.majorVersion + '.' + this.minorVersion;
    }

    public void setVersion(int n, int n2) {
        if (n != 1) {
            throw new IllegalArgumentException("major version not supported: " + n);
        }
        if (n2 < 0 || n2 > 1) {
            throw new IllegalArgumentException("minor version not supported: " + n2);
        }
        this.majorVersion = n;
        this.minorVersion = n2;
    }

    public void setProxy(String string, int n) {
        this.proxyHostname = string;
        this.proxyPort = n;
    }

    public boolean isUsingProxy() {
        boolean bl = false;
        if (this.proxyHostname != null && this.proxyPort > 0) {
            bl = true;
        }
        return bl;
    }

    public void setCookieManager(CookieManager cookieManager) {
        this.cookieManager = cookieManager;
    }

    public CookieManager getCookieManager() {
        return this.cookieManager;
    }

    void setPool(Pool pool) {
        this.pool = pool;
    }

    void release() {
        if (this.pool != null) {
            ++this.useCount;
            this.pool.put(this);
        } else {
            try {
                this.closeConnection();
            }
            catch (IOException iOException) {}
        }
    }

    public Request newRequest(String string, String string2) {
        Cookie[] cookieArray;
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("method must have non-zero length");
        }
        if (string2 == null || string2.length() == 0) {
            string2 = "/";
        }
        Request request = new Request(this, string, string2);
        if (this.secure && this.port != 443 || !this.secure && this.port != 80) {
            request.setHeader("Host", this.hostname + ':' + this.port);
        } else {
            request.setHeader("Host", this.hostname);
        }
        request.setHeader("User-Agent", userAgent);
        request.setHeader("Connection", "keep-alive");
        request.setHeader("Accept-Encoding", "chunked;q=1.0, gzip;q=0.9, deflate;q=0.8, identity;q=0.6, *;q=0");
        if (this.cookieManager != null && (cookieArray = this.cookieManager.getCookies(this.hostname, this.secure, string2)) != null && cookieArray.length > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("$Version=1");
            int n = 0;
            while (n < cookieArray.length) {
                stringBuilder.append(',');
                stringBuilder.append(' ');
                stringBuilder.append(cookieArray[n].toString());
                ++n;
            }
            request.setHeader("Cookie", stringBuilder.toString());
        }
        return request;
    }

    public void close() throws IOException {
        this.closeConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized Socket getSocket() throws IOException {
        if (this.socket == null) {
            String string = this.hostname;
            int n = this.port;
            if (this.isUsingProxy()) {
                string = this.proxyHostname;
                n = this.proxyPort;
            }
            this.socket = new Socket();
            InetSocketAddress inetSocketAddress = new InetSocketAddress(string, n);
            if (this.connectionTimeout > 0) {
                this.socket.connect(inetSocketAddress, this.connectionTimeout);
            } else {
                this.socket.connect(inetSocketAddress);
            }
            if (this.timeout > 0) {
                this.socket.setSoTimeout(this.timeout);
            }
            if (this.secure) {
                try {
                    SSLSocket sSLSocket;
                    block12: {
                        SSLSocketFactory sSLSocketFactory = this.getSSLSocketFactory();
                        sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(this.socket, string, n, true);
                        String[] stringArray = new String[]{"TLSv1", "SSLv3"};
                        sSLSocket.setEnabledProtocols(stringArray);
                        sSLSocket.setUseClientMode(true);
                        List list2 = this.handshakeCompletedListeners;
                        synchronized (list2) {
                            if (this.handshakeCompletedListeners.isEmpty()) break block12;
                            Iterator iterator = this.handshakeCompletedListeners.iterator();
                            while (iterator.hasNext()) {
                                HandshakeCompletedListener handshakeCompletedListener = (HandshakeCompletedListener)iterator.next();
                                sSLSocket.addHandshakeCompletedListener(handshakeCompletedListener);
                            }
                        }
                    }
                    sSLSocket.startHandshake();
                    this.socket = sSLSocket;
                }
                catch (GeneralSecurityException generalSecurityException) {
                    throw new IOException(generalSecurityException.getMessage());
                }
            }
            this.in = this.socket.getInputStream();
            this.in = new BufferedInputStream(this.in);
            this.out = this.socket.getOutputStream();
            this.out = new BufferedOutputStream(this.out);
        }
        return this.socket;
    }

    SSLSocketFactory getSSLSocketFactory() throws GeneralSecurityException {
        if (this.sslSocketFactory == null) {
            EmptyX509TrustManager emptyX509TrustManager = new EmptyX509TrustManager();
            SSLContext sSLContext = SSLContext.getInstance("SSL");
            TrustManager[] trustManagerArray = new TrustManager[]{emptyX509TrustManager};
            sSLContext.init(null, trustManagerArray, null);
            this.sslSocketFactory = sSLContext.getSocketFactory();
        }
        return this.sslSocketFactory;
    }

    void setSSLSocketFactory(SSLSocketFactory sSLSocketFactory) {
        this.sslSocketFactory = sSLSocketFactory;
    }

    protected synchronized InputStream getInputStream() throws IOException {
        if (this.socket == null) {
            this.getSocket();
        }
        return this.in;
    }

    protected synchronized OutputStream getOutputStream() throws IOException {
        if (this.socket == null) {
            this.getSocket();
        }
        return this.out;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized void closeConnection() throws IOException {
        if (this.socket == null) return;
        try {
            this.socket.close();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.socket = null;
            throw throwable;
        }
        {
            Object var2_3 = null;
            this.socket = null;
            return;
        }
    }

    protected String getURI() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.secure ? "https://" : "http://");
        stringBuilder.append(this.hostname);
        if (this.secure) {
            if (this.port != 443) {
                stringBuilder.append(':');
                stringBuilder.append(this.port);
            }
        } else if (this.port != 80) {
            stringBuilder.append(':');
            stringBuilder.append(this.port);
        }
        return stringBuilder.toString();
    }

    int getNonceCount(String string) {
        if (this.nonceCounts == null) {
            return 0;
        }
        return (Integer)this.nonceCounts.get(string);
    }

    void incrementNonce(String string) {
        int n = this.getNonceCount(string);
        if (this.nonceCounts == null) {
            this.nonceCounts = new HashMap();
        }
        this.nonceCounts.put(string, new Integer(n + 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void addHandshakeCompletedListener(HandshakeCompletedListener handshakeCompletedListener) {
        List list2 = this.handshakeCompletedListeners;
        synchronized (list2) {
            this.handshakeCompletedListeners.add(handshakeCompletedListener);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void removeHandshakeCompletedListener(HandshakeCompletedListener handshakeCompletedListener) {
        List list2 = this.handshakeCompletedListeners;
        synchronized (list2) {
            this.handshakeCompletedListeners.remove(handshakeCompletedListener);
            return;
        }
    }

    public HTTPConnection(String string) {
        this(string, 80, false, 0, 0);
    }

    public HTTPConnection(String string, boolean bl) {
        this(string, bl ? 443 : 80, bl, 0, 0);
    }

    public HTTPConnection(String string, boolean bl, int n, int n2) {
        this(string, bl ? 443 : 80, bl, n, n2);
    }

    public HTTPConnection(String string, int n) {
        this(string, n, false, 0, 0);
    }

    public HTTPConnection(String string, int n, boolean bl) {
        this(string, n, bl, 0, 0);
    }

    public HTTPConnection(String string, int n, boolean bl, int n2, int n3) {
        this.hostname = string;
        this.port = n;
        this.secure = bl;
        this.connectionTimeout = n2;
        this.timeout = n3;
        this.minorVersion = 1;
        this.majorVersion = 1;
        this.handshakeCompletedListeners = new ArrayList(2);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static class Pool {
        static Pool instance = new Pool();
        final LinkedList connectionPool;
        int maxConnections;
        int connectionTTL;
        Reaper reaper;

        private static final boolean matches(HTTPConnection hTTPConnection, String string, int n, boolean bl) {
            boolean bl2 = false;
            if (string.equals(hTTPConnection.hostname) && n == hTTPConnection.port && bl == hTTPConnection.secure) {
                bl2 = true;
            }
            return bl2;
        }

        synchronized HTTPConnection get(String string, int n, boolean bl) {
            String string2 = SystemProperties.getProperty("classpath.net.http.keepAliveTTL");
            this.connectionTTL = string2 != null && string2.length() > 0 ? 1000 * Math.max(1, Integer.parseInt(string2)) : 10000;
            String string3 = SystemProperties.getProperty("http.maxConnections");
            int n2 = this.maxConnections = string3 != null && string3.length() > 0 ? Math.max(Integer.parseInt(string3), 1) : 5;
            if (this.maxConnections < 1) {
                this.maxConnections = 1;
            }
            HTTPConnection hTTPConnection = null;
            ListIterator listIterator = this.connectionPool.listIterator(0);
            while (listIterator.hasNext()) {
                HTTPConnection hTTPConnection2 = (HTTPConnection)listIterator.next();
                if (!Pool.matches(hTTPConnection2, string, n, bl)) continue;
                hTTPConnection = hTTPConnection2;
                listIterator.remove();
                break;
            }
            if (hTTPConnection == null) {
                hTTPConnection = new HTTPConnection(string, n, bl);
                hTTPConnection.setPool(this);
            }
            return hTTPConnection;
        }

        synchronized void put(HTTPConnection hTTPConnection) {
            hTTPConnection.timeLastUsed = System.currentTimeMillis();
            this.connectionPool.addLast(hTTPConnection);
            while (this.connectionPool.size() >= this.maxConnections) {
                this.removeOldest();
            }
            if (this.connectionTTL > 0 && this.reaper == null) {
                this.reaper = new Reaper();
                Thread thread = new Thread(this.reaper, "HTTPConnection.Reaper");
                thread.setDaemon(true);
                thread.start();
            }
        }

        void removeOldest() {
            HTTPConnection hTTPConnection = (HTTPConnection)this.connectionPool.removeFirst();
            try {
                hTTPConnection.closeConnection();
            }
            catch (IOException iOException) {}
        }

        private final /* synthetic */ void this() {
            this.connectionPool = new LinkedList();
        }

        private Pool() {
            this.this();
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        class Reaper
        implements Runnable {
            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                var1_1 = Pool.this;
                synchronized (var1_1) {
                    try {
                        while (true) {
                            block12: {
                                if (Pool.this.connectionPool.size() > 0) break block12;
                                try {}
                                catch (InterruptedException v0) {}
                                ** GOTO lbl-1000
                            }
                            var5_2 = System.currentTimeMillis();
                            var7_3 = (HTTPConnection)Pool.this.connectionPool.getFirst();
                            var8_4 = var7_3.timeLastUsed + (long)Pool.this.connectionTTL - var5_2;
                            if (var8_4 <= 0L) {
                                Pool.this.removeOldest();
                                continue;
                            }
                            try {
                                Pool.this.wait(var8_4);
                            }
                            catch (InterruptedException v1) {}
                            continue;
lbl-1000:
                            // 1 sources

                            {
                                Pool.this.wait(Pool.this.connectionTTL);
                            }
                            if (Pool.this.connectionPool.size() <= 0) break;
                        }
                    }
                    catch (Throwable var3_5) {
                        var4_6 = null;
                        Pool.this.reaper = null;
                        throw var3_5;
                    }
                    {
                        var4_7 = null;
                        Pool.this.reaper = null;
                    }
                    return;
                }
            }

            Reaper() {
            }
        }
    }
}

