/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.activation;

import gnu.java.rmi.server.ActivatableServerRef;
import gnu.java.rmi.server.UnicastServer;
import gnu.java.rmi.server.UnicastServerRef;
import java.lang.reflect.Field;
import java.rmi.MarshalledObject;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.activation.ActivationDesc;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationGroup;
import java.rmi.activation.ActivationID;
import java.rmi.activation.UnknownGroupException;
import java.rmi.activation.UnknownObjectException;
import java.rmi.server.ObjID;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RemoteObject;
import java.rmi.server.RemoteServer;
import java.rmi.server.UnicastRemoteObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class Activatable
extends RemoteServer {
    static final long serialVersionUID = -3120617863591563455L;
    final ActivationID id;
    static /* synthetic */ Class class$java$rmi$server$ObjID;
    static /* synthetic */ Class class$java$rmi$activation$ActivationID;

    protected ActivationID getID() {
        return this.id;
    }

    static ActivationID obtainId(ActivationDesc activationDesc) throws RemoteException, UnknownGroupException, ActivationException {
        return ActivationGroup.currentGroupID().getSystem().registerObject(activationDesc);
    }

    public static Remote register(ActivationDesc activationDesc) throws UnknownGroupException, ActivationException, RemoteException {
        ActivationID activationID = Activatable.obtainId(activationDesc);
        return activationID.activate(false);
    }

    public static boolean inactive(ActivationID activationID) throws UnknownObjectException, ActivationException, RemoteException {
        if (activationID.group != null) {
            activationID.group.inactiveObject(activationID);
        }
        return UnicastRemoteObject.unexportObject(activationID.activate(false), false);
    }

    public static void unregister(ActivationID activationID) throws UnknownObjectException, ActivationException, RemoteException {
        ActivationGroup.currentGroupId.getSystem().unregisterObject(activationID);
        UnicastServer.unregisterActivatable(activationID);
    }

    public static ActivationID exportObject(Remote remote, String string, MarshalledObject marshalledObject, boolean bl, int n) throws ActivationException, RemoteException {
        ActivationDesc activationDesc = new ActivationDesc(remote.getClass().getName(), string, marshalledObject, bl);
        ActivationID activationID = Activatable.obtainId(activationDesc);
        Remote remote2 = Activatable.exportObject(remote, activationID, n);
        return activationID;
    }

    public static ActivationID exportObject(Remote remote, String string, MarshalledObject marshalledObject, boolean bl, int n, RMIClientSocketFactory rMIClientSocketFactory, RMIServerSocketFactory rMIServerSocketFactory) throws ActivationException, RemoteException {
        ActivationDesc activationDesc = new ActivationDesc(remote.getClass().getName(), string, marshalledObject, bl);
        ActivationID activationID = Activatable.obtainId(activationDesc);
        Remote remote2 = Activatable.exportObject(remote, activationID, n, rMIClientSocketFactory, rMIServerSocketFactory);
        return activationID;
    }

    public static Remote exportObject(Remote remote, ActivationID activationID, int n) throws RemoteException {
        Remote remote2 = Activatable.export(activationID, remote, n, null);
        return remote2;
    }

    public static Remote exportObject(Remote remote, ActivationID activationID, int n, RMIClientSocketFactory rMIClientSocketFactory, RMIServerSocketFactory rMIServerSocketFactory) throws RemoteException {
        Remote remote2 = Activatable.export(activationID, remote, n, rMIServerSocketFactory);
        return remote2;
    }

    public static boolean unexportObject(Remote remote, boolean bl) throws NoSuchObjectException {
        UnicastServerRef unicastServerRef = UnicastServer.getExportedRef(remote);
        if (unicastServerRef instanceof ActivatableServerRef) {
            ActivatableServerRef activatableServerRef = (ActivatableServerRef)unicastServerRef;
            UnicastServer.unregisterActivatable(activatableServerRef.actId);
        }
        return UnicastRemoteObject.unexportObject(remote, bl);
    }

    static Remote exportObject(Remote remote, int n, RMIServerSocketFactory rMIServerSocketFactory) throws RemoteException {
        UnicastServerRef unicastServerRef = null;
        if (remote instanceof RemoteObject) {
            unicastServerRef = (UnicastServerRef)((RemoteObject)remote).getRef();
        }
        if (unicastServerRef == null) {
            unicastServerRef = new UnicastServerRef(new ObjID(), n, rMIServerSocketFactory);
        }
        Remote remote2 = unicastServerRef.exportObject(remote);
        return remote2;
    }

    public static Remote export(ActivationID activationID, Remote remote, int n, RMIServerSocketFactory rMIServerSocketFactory) throws RemoteException {
        UnicastServerRef unicastServerRef = null;
        if (remote instanceof RemoteObject) {
            unicastServerRef = (UnicastServerRef)((RemoteObject)remote).getRef();
        }
        if (unicastServerRef == null) {
            unicastServerRef = new ActivatableServerRef(Activatable.makeId(activationID), activationID, n, rMIServerSocketFactory);
        }
        Remote remote2 = unicastServerRef.exportObject(remote);
        return remote2;
    }

    public static ObjID makeId(ActivationID activationID) {
        ObjID objID = new ObjID(0);
        try {
            Class clazz = class$java$rmi$server$ObjID;
            if (clazz == null) {
                clazz = class$java$rmi$server$ObjID = Activatable.class("[Ljava.rmi.server.ObjID;", false);
            }
            Field field = clazz.getDeclaredField("space");
            Class clazz2 = class$java$rmi$activation$ActivationID;
            if (clazz2 == null) {
                clazz2 = class$java$rmi$activation$ActivationID = Activatable.class("[Ljava.rmi.activation.ActivationID;", false);
            }
            Field field2 = clazz2.getDeclaredField("uid");
            field2.setAccessible(true);
            field.setAccessible(true);
            field.set(objID, field2.get(activationID));
        }
        catch (Exception exception) {
            InternalError internalError = new InternalError("Unable to set UID field");
            internalError.initCause(exception);
            throw internalError;
        }
        return objID;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    protected Activatable(String string, MarshalledObject marshalledObject, boolean bl, int n) throws ActivationException, RemoteException {
        ActivationDesc activationDesc = new ActivationDesc(this.getClass().getName(), string, marshalledObject, bl);
        this.id = Activatable.obtainId(activationDesc);
        Activatable.exportObject((Remote)this, this.id, n);
    }

    protected Activatable(String string, MarshalledObject marshalledObject, boolean bl, int n, RMIClientSocketFactory rMIClientSocketFactory, RMIServerSocketFactory rMIServerSocketFactory) throws ActivationException, RemoteException {
        ActivationDesc activationDesc = new ActivationDesc(this.getClass().getName(), string, marshalledObject, bl);
        this.id = Activatable.obtainId(activationDesc);
        Activatable.exportObject((Remote)this, this.id, n);
    }

    protected Activatable(ActivationID activationID, int n) throws RemoteException {
        this.id = activationID;
        try {
            Activatable.exportObject((Remote)this, activationID, n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            RemoteException remoteException = new RemoteException("cannot export Activatable", exception);
            throw remoteException;
        }
    }

    protected Activatable(ActivationID activationID, int n, RMIClientSocketFactory rMIClientSocketFactory, RMIServerSocketFactory rMIServerSocketFactory) throws RemoteException {
        this.id = activationID;
        try {
            Activatable.exportObject((Remote)this, activationID, n, rMIClientSocketFactory, rMIServerSocketFactory);
        }
        catch (Exception exception) {
            RemoteException remoteException = new RemoteException();
            remoteException.initCause(exception);
            throw remoteException;
        }
    }
}

