/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Graphics;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleValue;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ProgressBarUI;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JProgressBar
extends JComponent
implements SwingConstants,
Accessible {
    private static final long serialVersionUID = 1980046021813598781L;
    private transient boolean indeterminate;
    protected int orientation;
    protected boolean paintBorder;
    protected BoundedRangeModel model;
    protected String progressString;
    protected boolean paintString;
    protected transient ChangeEvent changeEvent;
    protected ChangeListener changeListener;
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    public int getValue() {
        return this.model.getValue();
    }

    public void setValue(int n) {
        this.model.setValue(n);
    }

    protected void paintBorder(Graphics graphics) {
        Border border = this.getBorder();
        if (this.paintBorder && border != null) {
            border.paintBorder(this, graphics, 0, 0, this.getWidth(), this.getHeight());
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int n) {
        if (n != 1 && n != 0) {
            throw new IllegalArgumentException(n + " is not a legal orientation");
        }
        if (this.orientation != n) {
            int n2 = this.orientation;
            this.orientation = n;
            this.firePropertyChange("orientation", n2, this.orientation);
        }
    }

    public boolean isStringPainted() {
        return this.paintString;
    }

    public void setStringPainted(boolean bl) {
        if (this.paintString != bl) {
            boolean bl2 = this.paintString;
            this.paintString = bl;
            this.firePropertyChange("stringPainted", bl2, this.paintString);
        }
    }

    public String getString() {
        if (this.progressString != null) {
            return this.progressString;
        }
        return "" + (int)(this.getPercentComplete() * 100.0) + '%';
    }

    public void setString(String string) {
        if ((string == null || this.progressString == null) && string != this.progressString || string != null && !string.equals(this.progressString)) {
            String string2 = this.progressString;
            this.progressString = string;
            this.firePropertyChange("string", string2, this.progressString);
        }
    }

    public double getPercentComplete() {
        if (this.getMaximum() == this.getMinimum()) {
            return 1.0;
        }
        return (double)(this.model.getValue() - this.model.getMinimum()) / (double)(this.model.getMaximum() - this.model.getMinimum());
    }

    public boolean isBorderPainted() {
        return this.paintBorder;
    }

    public void setBorderPainted(boolean bl) {
        if (bl != this.paintBorder) {
            boolean bl2 = this.paintBorder;
            this.paintBorder = bl;
            this.firePropertyChange("borderPainted", bl2, this.paintBorder);
        }
    }

    public ProgressBarUI getUI() {
        return (ProgressBarUI)this.ui;
    }

    public void setUI(ProgressBarUI progressBarUI) {
        super.setUI(progressBarUI);
    }

    public void updateUI() {
        this.setUI((ProgressBarUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return "ProgressBarUI";
    }

    protected ChangeListener createChangeListener() {
        return new ChangeListener(){

            public final void stateChanged(ChangeEvent changeEvent) {
                JProgressBar.this.fireStateChanged();
            }
        };
    }

    public void addChangeListener(ChangeListener changeListener) {
        Class clazz = class$javax$swing$event$ChangeListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$ChangeListener = JProgressBar.class("[Ljavax.swing.event.ChangeListener;", false);
        }
        this.listenerList.add(clazz, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        Class clazz = class$javax$swing$event$ChangeListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$ChangeListener = JProgressBar.class("[Ljavax.swing.event.ChangeListener;", false);
        }
        this.listenerList.remove(clazz, changeListener);
    }

    public ChangeListener[] getChangeListeners() {
        Class clazz = class$javax$swing$event$ChangeListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$ChangeListener = JProgressBar.class("[Ljavax.swing.event.ChangeListener;", false);
        }
        return (ChangeListener[])this.listenerList.getListeners(clazz);
    }

    protected void fireStateChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        if (this.changeEvent == null) {
            this.changeEvent = new ChangeEvent(this);
        }
        int n = objectArray.length - 2;
        while (n >= 0) {
            Object object = objectArray[n];
            Class clazz = class$javax$swing$event$ChangeListener;
            if (clazz == null) {
                clazz = JProgressBar.class("[Ljavax.swing.event.ChangeListener;", false);
            }
            if (object == clazz) {
                ((ChangeListener)objectArray[n + 1]).stateChanged(this.changeEvent);
            }
            n -= 2;
        }
    }

    public BoundedRangeModel getModel() {
        return this.model;
    }

    public void setModel(BoundedRangeModel boundedRangeModel) {
        if (boundedRangeModel != this.model) {
            this.model.removeChangeListener(this.changeListener);
            this.model = boundedRangeModel;
            this.model.addChangeListener(this.changeListener);
            this.fireStateChanged();
        }
    }

    public int getMinimum() {
        return this.model.getMinimum();
    }

    public void setMinimum(int n) {
        this.model.setMinimum(n);
    }

    public int getMaximum() {
        return this.model.getMaximum();
    }

    public void setMaximum(int n) {
        this.model.setMaximum(n);
    }

    protected String paramString() {
        return "JProgressBar";
    }

    public void setIndeterminate(boolean bl) {
        if (this.indeterminate != bl) {
            boolean bl2 = this.indeterminate;
            this.indeterminate = bl;
            this.firePropertyChange("indeterminate", bl2, this.indeterminate);
        }
    }

    public boolean isIndeterminate() {
        return this.indeterminate;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJProgressBar();
        }
        return this.accessibleContext;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.indeterminate = false;
        this.paintBorder = true;
        this.paintString = false;
    }

    public JProgressBar() {
        this(0, 0, 100);
    }

    public JProgressBar(int n) {
        this(n, 0, 100);
    }

    public JProgressBar(int n, int n2) {
        this(0, n, n2);
    }

    public JProgressBar(int n, int n2, int n3) {
        this.this();
        this.model = new DefaultBoundedRangeModel(n2, 0, n2, n3);
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException(n + " is not a legal orientation");
        }
        this.orientation = n;
        this.changeListener = this.createChangeListener();
        this.model.addChangeListener(this.changeListener);
        this.updateUI();
    }

    public JProgressBar(BoundedRangeModel boundedRangeModel) {
        this.this();
        this.model = boundedRangeModel;
        this.changeListener = this.createChangeListener();
        if (boundedRangeModel != null) {
            boundedRangeModel.addChangeListener(this.changeListener);
        }
        this.updateUI();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class AccessibleJProgressBar
    extends JComponent.AccessibleJComponent
    implements AccessibleValue {
        private static final long serialVersionUID = -2938130009392721813L;

        public AccessibleStateSet getAccessibleStateSet() {
            return null;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PROGRESS_BAR;
        }

        public AccessibleValue getAccessibleValue() {
            return null;
        }

        public Number getCurrentAccessibleValue() {
            return null;
        }

        public boolean setCurrentAccessibleValue(Number number) {
            return false;
        }

        public Number getMinimumAccessibleValue() {
            return null;
        }

        public Number getMaximumAccessibleValue() {
            return null;
        }

        protected AccessibleJProgressBar() {
        }
    }
}

