/* ex: set ro ft=c:
 * !!!!!!!   DO NOT EDIT THIS FILE   !!!!!!!
 *
 * This file is generated automatically by tools/build/nativecall.pl
 * from definitions in src/call_list.txt
 *
 * Any changes made here will be lost!
 *
 */

/* nci.c
 *  Copyright (C) 2001-2007, The Perl Foundation.
 *  SVN Info
 *     $Id$
 *  Overview:
 *     Native Call Interface routines. The code needed to build a
 *     parrot to C call frame is in here
 *  Data Structure and Algorithms:
 *  History:
 *  Notes:
 *  References:
 */
#include "parrot/parrot.h"
#include "parrot/hash.h"
#include "parrot/oplib/ops.h"
#include "nci.str"

/* HEADERIZER HFILE: none */
/* HEADERIZER STOP */

/*
 * if the architecture can build some or all of these signatures
 * enable the define below
 * - the JITed function will be called first
 * - if it returns NULL, the hardcoded version will do the job
 */

#if defined(HAS_JIT) && defined(I386)
#  include "parrot/exec.h"
#  include "jit.h"
#  define CAN_BUILD_CALL_FRAMES
#endif

/*
 * helper funcs - get argument n
 */
static INTVAL
get_nci_I(PARROT_INTERP, ARGMOD(call_state *st), int n)
{
    if (n >= st->src.n)
        Parrot_ex_throw_from_c_args(interp, NULL, EXCEPTION_INVALID_OPERATION,
            "too few arguments passed to NCI function");

    Parrot_fetch_arg_nci(interp, st);

    return UVal_int(st->val);
}

static FLOATVAL
get_nci_N(PARROT_INTERP, ARGMOD(call_state *st), int n)
{
    if (n >= st->src.n)
        Parrot_ex_throw_from_c_args(interp, NULL, EXCEPTION_INVALID_OPERATION,
            "too few arguments passed to NCI function");

    Parrot_fetch_arg_nci(interp, st);

    return UVal_num(st->val);
}

PARROT_WARN_UNUSED_RESULT
PARROT_CANNOT_RETURN_NULL
static STRING*
get_nci_S(PARROT_INTERP, ARGMOD(call_state *st), int n)
{
    /* TODO or act like below? */
    if (n >= st->src.n)
        Parrot_ex_throw_from_c_args(interp, NULL, EXCEPTION_INVALID_OPERATION,
            "too few arguments passed to NCI function");

    Parrot_fetch_arg_nci(interp, st);

    return UVal_str(st->val);
}

PARROT_WARN_UNUSED_RESULT
PARROT_CANNOT_RETURN_NULL
static PMC*
get_nci_P(PARROT_INTERP, ARGMOD(call_state *st), int n)
{
    /*
     * exessive args are passed as NULL
     * used by e.g. MMD infix like __add
     */
    if (n < st->src.n)
        Parrot_fetch_arg_nci(interp, st);
    else
        UVal_pmc(st->val) = PMCNULL;

    return UVal_pmc(st->val);
}

#define GET_NCI_I(n) get_nci_I(interp, &st, n)
#define GET_NCI_S(n) get_nci_S(interp, &st, n)
#define GET_NCI_N(n) get_nci_N(interp, &st, n)
#define GET_NCI_P(n) get_nci_P(interp, &st, n)

/*
 * set return value
 */
static void
set_nci_I(PARROT_INTERP, ARGOUT(call_state *st), INTVAL val)
{
    Parrot_init_ret_nci(interp, st, "I");
    if (st->dest.i < st->dest.n) {
        UVal_int(st->val) = val;
        Parrot_convert_arg(interp, st);
        Parrot_store_arg(interp, st);
    }
}

static void
set_nci_N(PARROT_INTERP, ARGOUT(call_state *st), FLOATVAL val)
{
    Parrot_init_ret_nci(interp, st, "N");
    if (st->dest.i < st->dest.n) {
        UVal_num(st->val) = val;
        Parrot_convert_arg(interp, st);
        Parrot_store_arg(interp, st);
    }
}

static void
set_nci_S(PARROT_INTERP, ARGOUT(call_state *st), STRING *val)
{
    Parrot_init_ret_nci(interp, st, "S");
    if (st->dest.i < st->dest.n) {
        UVal_str(st->val) = val;
        Parrot_convert_arg(interp, st);
        Parrot_store_arg(interp, st);
    }
}

static void
set_nci_P(PARROT_INTERP, ARGOUT(call_state *st), PMC* val)
{
    Parrot_init_ret_nci(interp, st, "P");
    if (st->dest.i < st->dest.n) {
        UVal_pmc(st->val) = val;
        Parrot_convert_arg(interp, st);
        Parrot_store_arg(interp, st);
    }
}

/* All our static functions that call in various ways. Yes, terribly
   hackish, but that is just fine */

static void
pcf_d_JOd(PARROT_INTERP, PMC *self)
{
    typedef double (*func_t)(PARROT_INTERP, PMC *, double);
    func_t pointer;
    call_state st;
    double return_data;
    
    PMC *t_1;
    double t_2;
    Parrot_init_arg_nci(interp, &st, "PN");
    t_1 = GET_NCI_P(0);
    t_2 = (double)GET_NCI_N(1);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (double)(*pointer)(interp,PMC_IS_NULL(t_1) ? NULL : t_1,t_2);
    
    set_nci_N(interp, &st, return_data);
    
}
static void
pcf_I_JOS(PARROT_INTERP, PMC *self)
{
    typedef INTVAL (*func_t)(PARROT_INTERP, PMC *, STRING *);
    func_t pointer;
    call_state st;
    INTVAL return_data;
    
    PMC *t_4;
    STRING * t_5;
    Parrot_init_arg_nci(interp, &st, "PS");
    t_4 = GET_NCI_P(0);
    t_5 = (STRING *)GET_NCI_S(1);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (INTVAL)(*pointer)(interp,PMC_IS_NULL(t_4) ? NULL : t_4,t_5);
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_P_JOl(PARROT_INTERP, PMC *self)
{
    typedef PMC * (*func_t)(PARROT_INTERP, PMC *, long);
    func_t pointer;
    call_state st;
    PMC * return_data;
    
    PMC *t_7;
    long t_8;
    Parrot_init_arg_nci(interp, &st, "PI");
    t_7 = GET_NCI_P(0);
    t_8 = (long)GET_NCI_I(1);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (PMC *)(*pointer)(interp,PMC_IS_NULL(t_7) ? NULL : t_7,t_8);
    
    set_nci_P(interp, &st, return_data);
    
}
static void
pcf_P_Jt(PARROT_INTERP, PMC *self)
{
    typedef PMC * (*func_t)(PARROT_INTERP, char *);
    func_t pointer;
    call_state st;
    PMC * return_data;
    
    char *t_10;
    Parrot_init_arg_nci(interp, &st, "S");
    {STRING * s= GET_NCI_S(0); t_10 = s ? string_to_cstring(interp, s) : (char *) NULL;}

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (PMC *)(*pointer)(interp,t_10);
    
    set_nci_P(interp, &st, return_data);
    do { if (t_10) string_cstring_free(t_10); } while (0);
}
static void
pcf_S_JOS(PARROT_INTERP, PMC *self)
{
    typedef STRING * (*func_t)(PARROT_INTERP, PMC *, STRING *);
    func_t pointer;
    call_state st;
    STRING * return_data;
    
    PMC *t_12;
    STRING * t_13;
    Parrot_init_arg_nci(interp, &st, "PS");
    t_12 = GET_NCI_P(0);
    t_13 = (STRING *)GET_NCI_S(1);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (STRING *)(*pointer)(interp,PMC_IS_NULL(t_12) ? NULL : t_12,t_13);
    
    set_nci_S(interp, &st, return_data);
    
}
static void
pcf_I_JI(PARROT_INTERP, PMC *self)
{
    typedef INTVAL (*func_t)(PARROT_INTERP, INTVAL);
    func_t pointer;
    call_state st;
    INTVAL return_data;
    
    INTVAL t_15;
    Parrot_init_arg_nci(interp, &st, "I");
    t_15 = (INTVAL)GET_NCI_I(0);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (INTVAL)(*pointer)(interp,t_15);
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_v_JOSP(PARROT_INTERP, PMC *self)
{
    typedef void (*func_t)(PARROT_INTERP, PMC *, STRING *, PMC *);
    func_t pointer;
    call_state st;
    
    
    PMC *t_17;
    STRING * t_18;
    PMC *t_19;
    Parrot_init_arg_nci(interp, &st, "PSP");
    t_17 = GET_NCI_P(0);
    t_18 = (STRING *)GET_NCI_S(1);
    t_19 = GET_NCI_P(2);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
     (void)(*pointer)(interp,PMC_IS_NULL(t_17) ? NULL : t_17,t_18,PMC_IS_NULL(t_19) ? NULL : t_19);
    
    
    
}
static void
pcf_v_JOS(PARROT_INTERP, PMC *self)
{
    typedef void (*func_t)(PARROT_INTERP, PMC *, STRING *);
    func_t pointer;
    call_state st;
    
    
    PMC *t_21;
    STRING * t_22;
    Parrot_init_arg_nci(interp, &st, "PS");
    t_21 = GET_NCI_P(0);
    t_22 = (STRING *)GET_NCI_S(1);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
     (void)(*pointer)(interp,PMC_IS_NULL(t_21) ? NULL : t_21,t_22);
    
    
    
}
static void
pcf_P_JOS(PARROT_INTERP, PMC *self)
{
    typedef PMC * (*func_t)(PARROT_INTERP, PMC *, STRING *);
    func_t pointer;
    call_state st;
    PMC * return_data;
    
    PMC *t_24;
    STRING * t_25;
    Parrot_init_arg_nci(interp, &st, "PS");
    t_24 = GET_NCI_P(0);
    t_25 = (STRING *)GET_NCI_S(1);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (PMC *)(*pointer)(interp,PMC_IS_NULL(t_24) ? NULL : t_24,t_25);
    
    set_nci_P(interp, &st, return_data);
    
}
static void
pcf_I_JOI(PARROT_INTERP, PMC *self)
{
    typedef INTVAL (*func_t)(PARROT_INTERP, PMC *, INTVAL);
    func_t pointer;
    call_state st;
    INTVAL return_data;
    
    PMC *t_27;
    INTVAL t_28;
    Parrot_init_arg_nci(interp, &st, "PI");
    t_27 = GET_NCI_P(0);
    t_28 = (INTVAL)GET_NCI_I(1);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (INTVAL)(*pointer)(interp,PMC_IS_NULL(t_27) ? NULL : t_27,t_28);
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_P_JOP(PARROT_INTERP, PMC *self)
{
    typedef PMC * (*func_t)(PARROT_INTERP, PMC *, PMC *);
    func_t pointer;
    call_state st;
    PMC * return_data;
    
    PMC *t_30;
    PMC *t_31;
    Parrot_init_arg_nci(interp, &st, "PP");
    t_30 = GET_NCI_P(0);
    t_31 = GET_NCI_P(1);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (PMC *)(*pointer)(interp,PMC_IS_NULL(t_30) ? NULL : t_30,PMC_IS_NULL(t_31) ? NULL : t_31);
    
    set_nci_P(interp, &st, return_data);
    
}
static void
pcf_P_JOPS(PARROT_INTERP, PMC *self)
{
    typedef PMC * (*func_t)(PARROT_INTERP, PMC *, PMC *, STRING *);
    func_t pointer;
    call_state st;
    PMC * return_data;
    
    PMC *t_33;
    PMC *t_34;
    STRING * t_35;
    Parrot_init_arg_nci(interp, &st, "PPS");
    t_33 = GET_NCI_P(0);
    t_34 = GET_NCI_P(1);
    t_35 = (STRING *)GET_NCI_S(2);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (PMC *)(*pointer)(interp,PMC_IS_NULL(t_33) ? NULL : t_33,PMC_IS_NULL(t_34) ? NULL : t_34,t_35);
    
    set_nci_P(interp, &st, return_data);
    
}
static void
pcf_v_JOPSP(PARROT_INTERP, PMC *self)
{
    typedef void (*func_t)(PARROT_INTERP, PMC *, PMC *, STRING *, PMC *);
    func_t pointer;
    call_state st;
    
    
    PMC *t_37;
    PMC *t_38;
    STRING * t_39;
    PMC *t_40;
    Parrot_init_arg_nci(interp, &st, "PPSP");
    t_37 = GET_NCI_P(0);
    t_38 = GET_NCI_P(1);
    t_39 = (STRING *)GET_NCI_S(2);
    t_40 = GET_NCI_P(3);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
     (void)(*pointer)(interp,PMC_IS_NULL(t_37) ? NULL : t_37,PMC_IS_NULL(t_38) ? NULL : t_38,t_39,PMC_IS_NULL(t_40) ? NULL : t_40);
    
    
    
}
static void
pcf_v_JPPP(PARROT_INTERP, PMC *self)
{
    typedef void (*func_t)(PARROT_INTERP, PMC *, PMC *, PMC *);
    func_t pointer;
    call_state st;
    
    
    PMC *t_42;
    PMC *t_43;
    PMC *t_44;
    Parrot_init_arg_nci(interp, &st, "PPP");
    t_42 = GET_NCI_P(0);
    t_43 = GET_NCI_P(1);
    t_44 = GET_NCI_P(2);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
     (void)(*pointer)(interp,PMC_IS_NULL(t_42) ? NULL : t_42,PMC_IS_NULL(t_43) ? NULL : t_43,PMC_IS_NULL(t_44) ? NULL : t_44);
    
    
    
}
static void
pcf_v_JPIP(PARROT_INTERP, PMC *self)
{
    typedef void (*func_t)(PARROT_INTERP, PMC *, INTVAL, PMC *);
    func_t pointer;
    call_state st;
    
    
    PMC *t_46;
    INTVAL t_47;
    PMC *t_48;
    Parrot_init_arg_nci(interp, &st, "PIP");
    t_46 = GET_NCI_P(0);
    t_47 = (INTVAL)GET_NCI_I(1);
    t_48 = GET_NCI_P(2);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
     (void)(*pointer)(interp,PMC_IS_NULL(t_46) ? NULL : t_46,t_47,PMC_IS_NULL(t_48) ? NULL : t_48);
    
    
    
}
static void
pcf_v_JPSP(PARROT_INTERP, PMC *self)
{
    typedef void (*func_t)(PARROT_INTERP, PMC *, STRING *, PMC *);
    func_t pointer;
    call_state st;
    
    
    PMC *t_50;
    STRING * t_51;
    PMC *t_52;
    Parrot_init_arg_nci(interp, &st, "PSP");
    t_50 = GET_NCI_P(0);
    t_51 = (STRING *)GET_NCI_S(1);
    t_52 = GET_NCI_P(2);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
     (void)(*pointer)(interp,PMC_IS_NULL(t_50) ? NULL : t_50,t_51,PMC_IS_NULL(t_52) ? NULL : t_52);
    
    
    
}
static void
pcf_v_JPNP(PARROT_INTERP, PMC *self)
{
    typedef void (*func_t)(PARROT_INTERP, PMC *, FLOATVAL, PMC *);
    func_t pointer;
    call_state st;
    
    
    PMC *t_54;
    FLOATVAL t_55;
    PMC *t_56;
    Parrot_init_arg_nci(interp, &st, "PNP");
    t_54 = GET_NCI_P(0);
    t_55 = (FLOATVAL)GET_NCI_N(1);
    t_56 = GET_NCI_P(2);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
     (void)(*pointer)(interp,PMC_IS_NULL(t_54) ? NULL : t_54,t_55,PMC_IS_NULL(t_56) ? NULL : t_56);
    
    
    
}
static void
pcf_v_JPP(PARROT_INTERP, PMC *self)
{
    typedef void (*func_t)(PARROT_INTERP, PMC *, PMC *);
    func_t pointer;
    call_state st;
    
    
    PMC *t_58;
    PMC *t_59;
    Parrot_init_arg_nci(interp, &st, "PP");
    t_58 = GET_NCI_P(0);
    t_59 = GET_NCI_P(1);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
     (void)(*pointer)(interp,PMC_IS_NULL(t_58) ? NULL : t_58,PMC_IS_NULL(t_59) ? NULL : t_59);
    
    
    
}
static void
pcf_v_JPI(PARROT_INTERP, PMC *self)
{
    typedef void (*func_t)(PARROT_INTERP, PMC *, INTVAL);
    func_t pointer;
    call_state st;
    
    
    PMC *t_61;
    INTVAL t_62;
    Parrot_init_arg_nci(interp, &st, "PI");
    t_61 = GET_NCI_P(0);
    t_62 = (INTVAL)GET_NCI_I(1);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
     (void)(*pointer)(interp,PMC_IS_NULL(t_61) ? NULL : t_61,t_62);
    
    
    
}
static void
pcf_v_JPS(PARROT_INTERP, PMC *self)
{
    typedef void (*func_t)(PARROT_INTERP, PMC *, STRING *);
    func_t pointer;
    call_state st;
    
    
    PMC *t_64;
    STRING * t_65;
    Parrot_init_arg_nci(interp, &st, "PS");
    t_64 = GET_NCI_P(0);
    t_65 = (STRING *)GET_NCI_S(1);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
     (void)(*pointer)(interp,PMC_IS_NULL(t_64) ? NULL : t_64,t_65);
    
    
    
}
static void
pcf_v_JPN(PARROT_INTERP, PMC *self)
{
    typedef void (*func_t)(PARROT_INTERP, PMC *, FLOATVAL);
    func_t pointer;
    call_state st;
    
    
    PMC *t_67;
    FLOATVAL t_68;
    Parrot_init_arg_nci(interp, &st, "PN");
    t_67 = GET_NCI_P(0);
    t_68 = (FLOATVAL)GET_NCI_N(1);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
     (void)(*pointer)(interp,PMC_IS_NULL(t_67) ? NULL : t_67,t_68);
    
    
    
}
static void
pcf_P_JPPP(PARROT_INTERP, PMC *self)
{
    typedef PMC * (*func_t)(PARROT_INTERP, PMC *, PMC *, PMC *);
    func_t pointer;
    call_state st;
    PMC * return_data;
    
    PMC *t_70;
    PMC *t_71;
    PMC *t_72;
    Parrot_init_arg_nci(interp, &st, "PPP");
    t_70 = GET_NCI_P(0);
    t_71 = GET_NCI_P(1);
    t_72 = GET_NCI_P(2);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (PMC *)(*pointer)(interp,PMC_IS_NULL(t_70) ? NULL : t_70,PMC_IS_NULL(t_71) ? NULL : t_71,PMC_IS_NULL(t_72) ? NULL : t_72);
    
    set_nci_P(interp, &st, return_data);
    
}
static void
pcf_P_JPIP(PARROT_INTERP, PMC *self)
{
    typedef PMC * (*func_t)(PARROT_INTERP, PMC *, INTVAL, PMC *);
    func_t pointer;
    call_state st;
    PMC * return_data;
    
    PMC *t_74;
    INTVAL t_75;
    PMC *t_76;
    Parrot_init_arg_nci(interp, &st, "PIP");
    t_74 = GET_NCI_P(0);
    t_75 = (INTVAL)GET_NCI_I(1);
    t_76 = GET_NCI_P(2);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (PMC *)(*pointer)(interp,PMC_IS_NULL(t_74) ? NULL : t_74,t_75,PMC_IS_NULL(t_76) ? NULL : t_76);
    
    set_nci_P(interp, &st, return_data);
    
}
static void
pcf_P_JPSP(PARROT_INTERP, PMC *self)
{
    typedef PMC * (*func_t)(PARROT_INTERP, PMC *, STRING *, PMC *);
    func_t pointer;
    call_state st;
    PMC * return_data;
    
    PMC *t_78;
    STRING * t_79;
    PMC *t_80;
    Parrot_init_arg_nci(interp, &st, "PSP");
    t_78 = GET_NCI_P(0);
    t_79 = (STRING *)GET_NCI_S(1);
    t_80 = GET_NCI_P(2);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (PMC *)(*pointer)(interp,PMC_IS_NULL(t_78) ? NULL : t_78,t_79,PMC_IS_NULL(t_80) ? NULL : t_80);
    
    set_nci_P(interp, &st, return_data);
    
}
static void
pcf_P_JPNP(PARROT_INTERP, PMC *self)
{
    typedef PMC * (*func_t)(PARROT_INTERP, PMC *, FLOATVAL, PMC *);
    func_t pointer;
    call_state st;
    PMC * return_data;
    
    PMC *t_82;
    FLOATVAL t_83;
    PMC *t_84;
    Parrot_init_arg_nci(interp, &st, "PNP");
    t_82 = GET_NCI_P(0);
    t_83 = (FLOATVAL)GET_NCI_N(1);
    t_84 = GET_NCI_P(2);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (PMC *)(*pointer)(interp,PMC_IS_NULL(t_82) ? NULL : t_82,t_83,PMC_IS_NULL(t_84) ? NULL : t_84);
    
    set_nci_P(interp, &st, return_data);
    
}
static void
pcf_I_JPP(PARROT_INTERP, PMC *self)
{
    typedef INTVAL (*func_t)(PARROT_INTERP, PMC *, PMC *);
    func_t pointer;
    call_state st;
    INTVAL return_data;
    
    PMC *t_86;
    PMC *t_87;
    Parrot_init_arg_nci(interp, &st, "PP");
    t_86 = GET_NCI_P(0);
    t_87 = GET_NCI_P(1);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (INTVAL)(*pointer)(interp,PMC_IS_NULL(t_86) ? NULL : t_86,PMC_IS_NULL(t_87) ? NULL : t_87);
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_i_JP(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(PARROT_INTERP, PMC *);
    func_t pointer;
    call_state st;
    int return_data;
    
    PMC *t_89;
    Parrot_init_arg_nci(interp, &st, "P");
    t_89 = GET_NCI_P(0);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(interp,PMC_IS_NULL(t_89) ? NULL : t_89);
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_v_JP(PARROT_INTERP, PMC *self)
{
    typedef void (*func_t)(PARROT_INTERP, PMC *);
    func_t pointer;
    call_state st;
    
    
    PMC *t_91;
    Parrot_init_arg_nci(interp, &st, "P");
    t_91 = GET_NCI_P(0);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
     (void)(*pointer)(interp,PMC_IS_NULL(t_91) ? NULL : t_91);
    
    
    
}
static void
pcf_i_JPi(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(PARROT_INTERP, PMC *, int);
    func_t pointer;
    call_state st;
    int return_data;
    
    PMC *t_93;
    int t_94;
    Parrot_init_arg_nci(interp, &st, "PI");
    t_93 = GET_NCI_P(0);
    t_94 = (int)GET_NCI_I(1);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(interp,PMC_IS_NULL(t_93) ? NULL : t_93,t_94);
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_i_JPii(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(PARROT_INTERP, PMC *, int, int);
    func_t pointer;
    call_state st;
    int return_data;
    
    PMC *t_96;
    int t_97;
    int t_98;
    Parrot_init_arg_nci(interp, &st, "PII");
    t_96 = GET_NCI_P(0);
    t_97 = (int)GET_NCI_I(1);
    t_98 = (int)GET_NCI_I(2);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(interp,PMC_IS_NULL(t_96) ? NULL : t_96,t_97,t_98);
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_i_JPiii(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(PARROT_INTERP, PMC *, int, int, int);
    func_t pointer;
    call_state st;
    int return_data;
    
    PMC *t_100;
    int t_101;
    int t_102;
    int t_103;
    Parrot_init_arg_nci(interp, &st, "PIII");
    t_100 = GET_NCI_P(0);
    t_101 = (int)GET_NCI_I(1);
    t_102 = (int)GET_NCI_I(2);
    t_103 = (int)GET_NCI_I(3);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(interp,PMC_IS_NULL(t_100) ? NULL : t_100,t_101,t_102,t_103);
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_i_JPt(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(PARROT_INTERP, PMC *, char *);
    func_t pointer;
    call_state st;
    int return_data;
    
    PMC *t_105;
    char *t_106;
    Parrot_init_arg_nci(interp, &st, "PS");
    t_105 = GET_NCI_P(0);
    {STRING * s= GET_NCI_S(1); t_106 = s ? string_to_cstring(interp, s) : (char *) NULL;}

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(interp,PMC_IS_NULL(t_105) ? NULL : t_105,t_106);
    
    set_nci_I(interp, &st, return_data);
    do { if (t_106) string_cstring_free(t_106); } while (0);
}
static void
pcf_P_JOSSS(PARROT_INTERP, PMC *self)
{
    typedef PMC * (*func_t)(PARROT_INTERP, PMC *, STRING *, STRING *, STRING *);
    func_t pointer;
    call_state st;
    PMC * return_data;
    
    PMC *t_108;
    STRING * t_109;
    STRING * t_110;
    STRING * t_111;
    Parrot_init_arg_nci(interp, &st, "PSSS");
    t_108 = GET_NCI_P(0);
    t_109 = (STRING *)GET_NCI_S(1);
    t_110 = (STRING *)GET_NCI_S(2);
    t_111 = (STRING *)GET_NCI_S(3);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (PMC *)(*pointer)(interp,PMC_IS_NULL(t_108) ? NULL : t_108,t_109,t_110,t_111);
    
    set_nci_P(interp, &st, return_data);
    
}
static void
pcf_v_JOSS(PARROT_INTERP, PMC *self)
{
    typedef void (*func_t)(PARROT_INTERP, PMC *, STRING *, STRING *);
    func_t pointer;
    call_state st;
    
    
    PMC *t_113;
    STRING * t_114;
    STRING * t_115;
    Parrot_init_arg_nci(interp, &st, "PSS");
    t_113 = GET_NCI_P(0);
    t_114 = (STRING *)GET_NCI_S(1);
    t_115 = (STRING *)GET_NCI_S(2);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
     (void)(*pointer)(interp,PMC_IS_NULL(t_113) ? NULL : t_113,t_114,t_115);
    
    
    
}
static void
pcf_S_JOI(PARROT_INTERP, PMC *self)
{
    typedef STRING * (*func_t)(PARROT_INTERP, PMC *, INTVAL);
    func_t pointer;
    call_state st;
    STRING * return_data;
    
    PMC *t_117;
    INTVAL t_118;
    Parrot_init_arg_nci(interp, &st, "PI");
    t_117 = GET_NCI_P(0);
    t_118 = (INTVAL)GET_NCI_I(1);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (STRING *)(*pointer)(interp,PMC_IS_NULL(t_117) ? NULL : t_117,t_118);
    
    set_nci_S(interp, &st, return_data);
    
}
static void
pcf_v_JOb(PARROT_INTERP, PMC *self)
{
    typedef void (*func_t)(PARROT_INTERP, PMC *, void *);
    func_t pointer;
    call_state st;
    
    
    PMC *t_120;
    STRING *t_121;
    Parrot_init_arg_nci(interp, &st, "PS");
    t_120 = GET_NCI_P(0);
    t_121 = GET_NCI_S(1);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
     (void)(*pointer)(interp,PMC_IS_NULL(t_120) ? NULL : t_120,PObj_bufstart(t_121));
    
    
    
}
static void
pcf_i_JOPxAT_(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(PARROT_INTERP, PMC *, PMC *, PMC *);
    func_t pointer;
    call_state st;
    int return_data;
    
    PMC *t_123;
    PMC *t_124;
    PMC *t_125;
    Parrot_init_arg_nci(interp, &st, "PP@");
    t_123 = GET_NCI_P(0);
    t_124 = GET_NCI_P(1);
    t_125 = GET_NCI_P(2);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(interp,PMC_IS_NULL(t_123) ? NULL : t_123,PMC_IS_NULL(t_124) ? NULL : t_124,PMC_IS_NULL(t_125) ? NULL : t_125);
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_I_JOPxAT_(PARROT_INTERP, PMC *self)
{
    typedef INTVAL (*func_t)(PARROT_INTERP, PMC *, PMC *, PMC *);
    func_t pointer;
    call_state st;
    INTVAL return_data;
    
    PMC *t_127;
    PMC *t_128;
    PMC *t_129;
    Parrot_init_arg_nci(interp, &st, "PP@");
    t_127 = GET_NCI_P(0);
    t_128 = GET_NCI_P(1);
    t_129 = GET_NCI_P(2);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (INTVAL)(*pointer)(interp,PMC_IS_NULL(t_127) ? NULL : t_127,PMC_IS_NULL(t_128) ? NULL : t_128,PMC_IS_NULL(t_129) ? NULL : t_129);
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_I_JOIPxAT_(PARROT_INTERP, PMC *self)
{
    typedef INTVAL (*func_t)(PARROT_INTERP, PMC *, INTVAL, PMC *, PMC *);
    func_t pointer;
    call_state st;
    INTVAL return_data;
    
    PMC *t_131;
    INTVAL t_132;
    PMC *t_133;
    PMC *t_134;
    Parrot_init_arg_nci(interp, &st, "PIP@");
    t_131 = GET_NCI_P(0);
    t_132 = (INTVAL)GET_NCI_I(1);
    t_133 = GET_NCI_P(2);
    t_134 = GET_NCI_P(3);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (INTVAL)(*pointer)(interp,PMC_IS_NULL(t_131) ? NULL : t_131,t_132,PMC_IS_NULL(t_133) ? NULL : t_133,PMC_IS_NULL(t_134) ? NULL : t_134);
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_P_JO(PARROT_INTERP, PMC *self)
{
    typedef PMC * (*func_t)(PARROT_INTERP, PMC *);
    func_t pointer;
    call_state st;
    PMC * return_data;
    
    PMC *t_136;
    Parrot_init_arg_nci(interp, &st, "P");
    t_136 = GET_NCI_P(0);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (PMC *)(*pointer)(interp,PMC_IS_NULL(t_136) ? NULL : t_136);
    
    set_nci_P(interp, &st, return_data);
    
}
static void
pcf_v_JOP(PARROT_INTERP, PMC *self)
{
    typedef void (*func_t)(PARROT_INTERP, PMC *, PMC *);
    func_t pointer;
    call_state st;
    
    
    PMC *t_138;
    PMC *t_139;
    Parrot_init_arg_nci(interp, &st, "PP");
    t_138 = GET_NCI_P(0);
    t_139 = GET_NCI_P(1);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
     (void)(*pointer)(interp,PMC_IS_NULL(t_138) ? NULL : t_138,PMC_IS_NULL(t_139) ? NULL : t_139);
    
    
    
}
static void
pcf_P_Ji(PARROT_INTERP, PMC *self)
{
    typedef PMC * (*func_t)(PARROT_INTERP, int);
    func_t pointer;
    call_state st;
    PMC * return_data;
    
    int t_141;
    Parrot_init_arg_nci(interp, &st, "I");
    t_141 = (int)GET_NCI_I(0);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (PMC *)(*pointer)(interp,t_141);
    
    set_nci_P(interp, &st, return_data);
    
}
static void
pcf_i_ip(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(int, void *);
    func_t pointer;
    call_state st;
    int return_data;
    
    int t_142;
    PMC *t_143;
    Parrot_init_arg_nci(interp, &st, "IP");
    t_142 = (int)GET_NCI_I(0);
    t_143 = GET_NCI_P(1);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(t_142,PMC_data(t_143));
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_i_JPip(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(PARROT_INTERP, PMC *, int, void *);
    func_t pointer;
    call_state st;
    int return_data;
    
    PMC *t_145;
    int t_146;
    PMC *t_147;
    Parrot_init_arg_nci(interp, &st, "PIP");
    t_145 = GET_NCI_P(0);
    t_146 = (int)GET_NCI_I(1);
    t_147 = GET_NCI_P(2);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(interp,PMC_IS_NULL(t_145) ? NULL : t_145,t_146,PMC_data(t_147));
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_i_JpP(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(PARROT_INTERP, void *, PMC *);
    func_t pointer;
    call_state st;
    int return_data;
    
    PMC *t_149;
    PMC *t_150;
    Parrot_init_arg_nci(interp, &st, "PP");
    t_149 = GET_NCI_P(0);
    t_150 = GET_NCI_P(1);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(interp,PMC_data(t_149),PMC_IS_NULL(t_150) ? NULL : t_150);
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_i_Jpii(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(PARROT_INTERP, void *, int, int);
    func_t pointer;
    call_state st;
    int return_data;
    
    PMC *t_152;
    int t_153;
    int t_154;
    Parrot_init_arg_nci(interp, &st, "PII");
    t_152 = GET_NCI_P(0);
    t_153 = (int)GET_NCI_I(1);
    t_154 = (int)GET_NCI_I(2);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(interp,PMC_data(t_152),t_153,t_154);
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_i_p(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(void *);
    func_t pointer;
    call_state st;
    int return_data;
    
    PMC *t_155;
    Parrot_init_arg_nci(interp, &st, "P");
    t_155 = GET_NCI_P(0);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(PMC_data(t_155));
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_i_tp(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(char *, void *);
    func_t pointer;
    call_state st;
    int return_data;
    
    char *t_156;
    PMC *t_157;
    Parrot_init_arg_nci(interp, &st, "SP");
    {STRING * s= GET_NCI_S(0); t_156 = s ? string_to_cstring(interp, s) : (char *) NULL;}
    t_157 = GET_NCI_P(1);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(t_156,PMC_data(t_157));
    
    set_nci_I(interp, &st, return_data);
    do { if (t_156) string_cstring_free(t_156); } while (0);
}
static void
pcf_p_J(PARROT_INTERP, PMC *self)
{
    typedef void * (*func_t)(PARROT_INTERP);
    func_t pointer;
    call_state st;
    void * return_data;
    
    PMC * const final_destination = pmc_new(interp, enum_class_UnManagedStruct);
    Parrot_init_arg_nci(interp, &st, "");
    

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (void *)(*pointer)(interp);
    
    PMC_data(final_destination) = return_data;    set_nci_P(interp, &st, final_destination);
    
}
static void
pcf_p_Jp(PARROT_INTERP, PMC *self)
{
    typedef void * (*func_t)(PARROT_INTERP, void *);
    func_t pointer;
    call_state st;
    void * return_data;
    
    PMC * const final_destination = pmc_new(interp, enum_class_UnManagedStruct);PMC *t_160;
    Parrot_init_arg_nci(interp, &st, "P");
    t_160 = GET_NCI_P(0);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (void *)(*pointer)(interp,PMC_data(t_160));
    
    PMC_data(final_destination) = return_data;    set_nci_P(interp, &st, final_destination);
    
}
static void
pcf_t_J(PARROT_INTERP, PMC *self)
{
    typedef char * (*func_t)(PARROT_INTERP);
    func_t pointer;
    call_state st;
    char * return_data;
    
    STRING *final_destination;
    Parrot_init_arg_nci(interp, &st, "");
    

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (char *)(*pointer)(interp);
    
    final_destination = string_from_cstring(interp, return_data, 0);
    set_nci_S(interp, &st, final_destination);
    
}
static void
pcf_t_Jpti(PARROT_INTERP, PMC *self)
{
    typedef char * (*func_t)(PARROT_INTERP, void *, char *, int);
    func_t pointer;
    call_state st;
    char * return_data;
    
    STRING *final_destination;PMC *t_163;
    char *t_164;
    int t_165;
    Parrot_init_arg_nci(interp, &st, "PSI");
    t_163 = GET_NCI_P(0);
    {STRING * s= GET_NCI_S(1); t_164 = s ? string_to_cstring(interp, s) : (char *) NULL;}
    t_165 = (int)GET_NCI_I(2);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (char *)(*pointer)(interp,PMC_data(t_163),t_164,t_165);
    
    final_destination = string_from_cstring(interp, return_data, 0);
    set_nci_S(interp, &st, final_destination);
    do { if (t_164) string_cstring_free(t_164); } while (0);
}
static void
pcf_t_p(PARROT_INTERP, PMC *self)
{
    typedef char * (*func_t)(void *);
    func_t pointer;
    call_state st;
    char * return_data;
    
    STRING *final_destination;PMC *t_166;
    Parrot_init_arg_nci(interp, &st, "P");
    t_166 = GET_NCI_P(0);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (char *)(*pointer)(PMC_data(t_166));
    
    final_destination = string_from_cstring(interp, return_data, 0);
    set_nci_S(interp, &st, final_destination);
    
}
static void
pcf_t_pt(PARROT_INTERP, PMC *self)
{
    typedef char * (*func_t)(void *, char *);
    func_t pointer;
    call_state st;
    char * return_data;
    
    STRING *final_destination;PMC *t_167;
    char *t_168;
    Parrot_init_arg_nci(interp, &st, "PS");
    t_167 = GET_NCI_P(0);
    {STRING * s= GET_NCI_S(1); t_168 = s ? string_to_cstring(interp, s) : (char *) NULL;}

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (char *)(*pointer)(PMC_data(t_167),t_168);
    
    final_destination = string_from_cstring(interp, return_data, 0);
    set_nci_S(interp, &st, final_destination);
    do { if (t_168) string_cstring_free(t_168); } while (0);
}
static void
pcf_v_p(PARROT_INTERP, PMC *self)
{
    typedef void (*func_t)(void *);
    func_t pointer;
    call_state st;
    
    
    PMC *t_169;
    Parrot_init_arg_nci(interp, &st, "P");
    t_169 = GET_NCI_P(0);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
     (void)(*pointer)(PMC_data(t_169));
    
    
    
}
static void
pcf_v_pit(PARROT_INTERP, PMC *self)
{
    typedef void (*func_t)(void *, int, char *);
    func_t pointer;
    call_state st;
    
    
    PMC *t_170;
    int t_171;
    char *t_172;
    Parrot_init_arg_nci(interp, &st, "PIS");
    t_170 = GET_NCI_P(0);
    t_171 = (int)GET_NCI_I(1);
    {STRING * s= GET_NCI_S(2); t_172 = s ? string_to_cstring(interp, s) : (char *) NULL;}

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
     (void)(*pointer)(PMC_data(t_170),t_171,t_172);
    
    
    do { if (t_172) string_cstring_free(t_172); } while (0);
}
static void
pcf_v_ptt(PARROT_INTERP, PMC *self)
{
    typedef void (*func_t)(void *, char *, char *);
    func_t pointer;
    call_state st;
    
    
    PMC *t_173;
    char *t_174;
    char *t_175;
    Parrot_init_arg_nci(interp, &st, "PSS");
    t_173 = GET_NCI_P(0);
    {STRING * s= GET_NCI_S(1); t_174 = s ? string_to_cstring(interp, s) : (char *) NULL;}
    {STRING * s= GET_NCI_S(2); t_175 = s ? string_to_cstring(interp, s) : (char *) NULL;}

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
     (void)(*pointer)(PMC_data(t_173),t_174,t_175);
    
    
    do { if (t_174) string_cstring_free(t_174); } while (0);
    do { if (t_175) string_cstring_free(t_175); } while (0);
}
static void
pcf_v_Jtiiipt(PARROT_INTERP, PMC *self)
{
    typedef void (*func_t)(PARROT_INTERP, char *, int, int, int, void *, char *);
    func_t pointer;
    call_state st;
    
    
    char *t_177;
    int t_178;
    int t_179;
    int t_180;
    PMC *t_181;
    char *t_182;
    Parrot_init_arg_nci(interp, &st, "SIIIPS");
    {STRING * s= GET_NCI_S(0); t_177 = s ? string_to_cstring(interp, s) : (char *) NULL;}
    t_178 = (int)GET_NCI_I(1);
    t_179 = (int)GET_NCI_I(2);
    t_180 = (int)GET_NCI_I(3);
    t_181 = GET_NCI_P(4);
    {STRING * s= GET_NCI_S(5); t_182 = s ? string_to_cstring(interp, s) : (char *) NULL;}

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
     (void)(*pointer)(interp,t_177,t_178,t_179,t_180,PMC_data(t_181),t_182);
    
    
    do { if (t_177) string_cstring_free(t_177); } while (0);
    do { if (t_182) string_cstring_free(t_182); } while (0);
}
static void
pcf_p_JttPP(PARROT_INTERP, PMC *self)
{
    typedef void * (*func_t)(PARROT_INTERP, char *, char *, PMC *, PMC *);
    func_t pointer;
    call_state st;
    void * return_data;
    
    PMC * const final_destination = pmc_new(interp, enum_class_UnManagedStruct);char *t_184;
    char *t_185;
    PMC *t_186;
    PMC *t_187;
    Parrot_init_arg_nci(interp, &st, "SSPP");
    {STRING * s= GET_NCI_S(0); t_184 = s ? string_to_cstring(interp, s) : (char *) NULL;}
    {STRING * s= GET_NCI_S(1); t_185 = s ? string_to_cstring(interp, s) : (char *) NULL;}
    t_186 = GET_NCI_P(2);
    t_187 = GET_NCI_P(3);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (void *)(*pointer)(interp,t_184,t_185,PMC_IS_NULL(t_186) ? NULL : t_186,PMC_IS_NULL(t_187) ? NULL : t_187);
    
    PMC_data(final_destination) = return_data;    set_nci_P(interp, &st, final_destination);
    do { if (t_184) string_cstring_free(t_184); } while (0);
    do { if (t_185) string_cstring_free(t_185); } while (0);
}
static void
pcf_P_Jtpi(PARROT_INTERP, PMC *self)
{
    typedef PMC * (*func_t)(PARROT_INTERP, char *, void *, int);
    func_t pointer;
    call_state st;
    PMC * return_data;
    
    char *t_189;
    PMC *t_190;
    int t_191;
    Parrot_init_arg_nci(interp, &st, "SPI");
    {STRING * s= GET_NCI_S(0); t_189 = s ? string_to_cstring(interp, s) : (char *) NULL;}
    t_190 = GET_NCI_P(1);
    t_191 = (int)GET_NCI_I(2);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (PMC *)(*pointer)(interp,t_189,PMC_data(t_190),t_191);
    
    set_nci_P(interp, &st, return_data);
    do { if (t_189) string_cstring_free(t_189); } while (0);
}
static void
pcf_i_Vppp(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(void **, void *, void *, void *);
    func_t pointer;
    call_state st;
    int return_data;
    void* arg0;
    PMC *t_192;
    PMC *t_193;
    PMC *t_194;
    PMC *t_195;
    Parrot_init_arg_nci(interp, &st, "PPPP");
    t_192 = GET_NCI_P(0);
    t_193 = GET_NCI_P(1);
    t_194 = GET_NCI_P(2);
    t_195 = GET_NCI_P(3);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    arg0 = PMC_data(t_192);
    return_data =  (int)(*pointer)(&arg0,PMC_data(t_193),PMC_data(t_194),PMC_data(t_195));
    PMC_data(t_192) = arg0;
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_v_JpPP(PARROT_INTERP, PMC *self)
{
    typedef void (*func_t)(PARROT_INTERP, void *, PMC *, PMC *);
    func_t pointer;
    call_state st;
    
    
    PMC *t_197;
    PMC *t_198;
    PMC *t_199;
    Parrot_init_arg_nci(interp, &st, "PPP");
    t_197 = GET_NCI_P(0);
    t_198 = GET_NCI_P(1);
    t_199 = GET_NCI_P(2);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
     (void)(*pointer)(interp,PMC_data(t_197),PMC_IS_NULL(t_198) ? NULL : t_198,PMC_IS_NULL(t_199) ? NULL : t_199);
    
    
    
}
static void
pcf_v_pt(PARROT_INTERP, PMC *self)
{
    typedef void (*func_t)(void *, char *);
    func_t pointer;
    call_state st;
    
    
    PMC *t_200;
    char *t_201;
    Parrot_init_arg_nci(interp, &st, "PS");
    t_200 = GET_NCI_P(0);
    {STRING * s= GET_NCI_S(1); t_201 = s ? string_to_cstring(interp, s) : (char *) NULL;}

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
     (void)(*pointer)(PMC_data(t_200),t_201);
    
    
    do { if (t_201) string_cstring_free(t_201); } while (0);
}
static void
pcf_v_(PARROT_INTERP, PMC *self)
{
    void (*pointer)(void);
    
    
    
    

    pointer =  (void (*)(void))D2FPTR(PMC_struct_val(self));
     (void)(*pointer)();
    
    
}
static void
pcf_v_Jiiip(PARROT_INTERP, PMC *self)
{
    typedef void (*func_t)(PARROT_INTERP, int, int, int, void *);
    func_t pointer;
    call_state st;
    
    
    int t_203;
    int t_204;
    int t_205;
    PMC *t_206;
    Parrot_init_arg_nci(interp, &st, "IIIP");
    t_203 = (int)GET_NCI_I(0);
    t_204 = (int)GET_NCI_I(1);
    t_205 = (int)GET_NCI_I(2);
    t_206 = GET_NCI_P(3);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
     (void)(*pointer)(interp,t_203,t_204,t_205,PMC_data(t_206));
    
    
    
}
static void
pcf_v_i(PARROT_INTERP, PMC *self)
{
    typedef void (*func_t)(int);
    func_t pointer;
    call_state st;
    
    
    int t_207;
    Parrot_init_arg_nci(interp, &st, "I");
    t_207 = (int)GET_NCI_I(0);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
     (void)(*pointer)(t_207);
    
    
    
}
static void
pcf_v_ii(PARROT_INTERP, PMC *self)
{
    typedef void (*func_t)(int, int);
    func_t pointer;
    call_state st;
    
    
    int t_208;
    int t_209;
    Parrot_init_arg_nci(interp, &st, "II");
    t_208 = (int)GET_NCI_I(0);
    t_209 = (int)GET_NCI_I(1);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
     (void)(*pointer)(t_208,t_209);
    
    
    
}
static void
pcf_v_illllllll(PARROT_INTERP, PMC *self)
{
    typedef void (*func_t)(int, long, long, long, long, long, long, long, long);
    func_t pointer;
    call_state st;
    
    
    int t_210;
    long t_211;
    long t_212;
    long t_213;
    long t_214;
    long t_215;
    long t_216;
    long t_217;
    long t_218;
    Parrot_init_arg_nci(interp, &st, "IIIIIIIII");
    t_210 = (int)GET_NCI_I(0);
    t_211 = (long)GET_NCI_I(1);
    t_212 = (long)GET_NCI_I(2);
    t_213 = (long)GET_NCI_I(3);
    t_214 = (long)GET_NCI_I(4);
    t_215 = (long)GET_NCI_I(5);
    t_216 = (long)GET_NCI_I(6);
    t_217 = (long)GET_NCI_I(7);
    t_218 = (long)GET_NCI_I(8);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
     (void)(*pointer)(t_210,t_211,t_212,t_213,t_214,t_215,t_216,t_217,t_218);
    
    
    
}
static void
pcf_v_l(PARROT_INTERP, PMC *self)
{
    typedef void (*func_t)(long);
    func_t pointer;
    call_state st;
    
    
    long t_219;
    Parrot_init_arg_nci(interp, &st, "I");
    t_219 = (long)GET_NCI_I(0);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
     (void)(*pointer)(t_219);
    
    
    
}
static void
pcf_v_pbip(PARROT_INTERP, PMC *self)
{
    typedef void (*func_t)(void *, void *, int, void *);
    func_t pointer;
    call_state st;
    
    
    PMC *t_220;
    STRING *t_221;
    int t_222;
    PMC *t_223;
    Parrot_init_arg_nci(interp, &st, "PSIP");
    t_220 = GET_NCI_P(0);
    t_221 = GET_NCI_S(1);
    t_222 = (int)GET_NCI_I(2);
    t_223 = GET_NCI_P(3);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
     (void)(*pointer)(PMC_data(t_220),PObj_bufstart(t_221),t_222,PMC_data(t_223));
    
    
    
}
static void
pcf_v_pi(PARROT_INTERP, PMC *self)
{
    typedef void (*func_t)(void *, int);
    func_t pointer;
    call_state st;
    
    
    PMC *t_224;
    int t_225;
    Parrot_init_arg_nci(interp, &st, "PI");
    t_224 = GET_NCI_P(0);
    t_225 = (int)GET_NCI_I(1);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
     (void)(*pointer)(PMC_data(t_224),t_225);
    
    
    
}
static void
pcf_v_piiii(PARROT_INTERP, PMC *self)
{
    typedef void (*func_t)(void *, int, int, int, int);
    func_t pointer;
    call_state st;
    
    
    PMC *t_226;
    int t_227;
    int t_228;
    int t_229;
    int t_230;
    Parrot_init_arg_nci(interp, &st, "PIIII");
    t_226 = GET_NCI_P(0);
    t_227 = (int)GET_NCI_I(1);
    t_228 = (int)GET_NCI_I(2);
    t_229 = (int)GET_NCI_I(3);
    t_230 = (int)GET_NCI_I(4);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
     (void)(*pointer)(PMC_data(t_226),t_227,t_228,t_229,t_230);
    
    
    
}
static void
pcf_v_pl(PARROT_INTERP, PMC *self)
{
    typedef void (*func_t)(void *, long);
    func_t pointer;
    call_state st;
    
    
    PMC *t_231;
    long t_232;
    Parrot_init_arg_nci(interp, &st, "PI");
    t_231 = GET_NCI_P(0);
    t_232 = (long)GET_NCI_I(1);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
     (void)(*pointer)(PMC_data(t_231),t_232);
    
    
    
}
static void
pcf_v_pp(PARROT_INTERP, PMC *self)
{
    typedef void (*func_t)(void *, void *);
    func_t pointer;
    call_state st;
    
    
    PMC *t_233;
    PMC *t_234;
    Parrot_init_arg_nci(interp, &st, "PP");
    t_233 = GET_NCI_P(0);
    t_234 = GET_NCI_P(1);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
     (void)(*pointer)(PMC_data(t_233),PMC_data(t_234));
    
    
    
}
static void
pcf_i_JPP(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(PARROT_INTERP, PMC *, PMC *);
    func_t pointer;
    call_state st;
    int return_data;
    
    PMC *t_236;
    PMC *t_237;
    Parrot_init_arg_nci(interp, &st, "PP");
    t_236 = GET_NCI_P(0);
    t_237 = GET_NCI_P(1);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(interp,PMC_IS_NULL(t_236) ? NULL : t_236,PMC_IS_NULL(t_237) ? NULL : t_237);
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_P_JP(PARROT_INTERP, PMC *self)
{
    typedef PMC * (*func_t)(PARROT_INTERP, PMC *);
    func_t pointer;
    call_state st;
    PMC * return_data;
    
    PMC *t_239;
    Parrot_init_arg_nci(interp, &st, "P");
    t_239 = GET_NCI_P(0);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (PMC *)(*pointer)(interp,PMC_IS_NULL(t_239) ? NULL : t_239);
    
    set_nci_P(interp, &st, return_data);
    
}
static void
pcf_P_JPP(PARROT_INTERP, PMC *self)
{
    typedef PMC * (*func_t)(PARROT_INTERP, PMC *, PMC *);
    func_t pointer;
    call_state st;
    PMC * return_data;
    
    PMC *t_241;
    PMC *t_242;
    Parrot_init_arg_nci(interp, &st, "PP");
    t_241 = GET_NCI_P(0);
    t_242 = GET_NCI_P(1);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (PMC *)(*pointer)(interp,PMC_IS_NULL(t_241) ? NULL : t_241,PMC_IS_NULL(t_242) ? NULL : t_242);
    
    set_nci_P(interp, &st, return_data);
    
}
static void
pcf_S_JO(PARROT_INTERP, PMC *self)
{
    typedef STRING * (*func_t)(PARROT_INTERP, PMC *);
    func_t pointer;
    call_state st;
    STRING * return_data;
    
    PMC *t_244;
    Parrot_init_arg_nci(interp, &st, "P");
    t_244 = GET_NCI_P(0);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (STRING *)(*pointer)(interp,PMC_IS_NULL(t_244) ? NULL : t_244);
    
    set_nci_S(interp, &st, return_data);
    
}
static void
pcf_i_P(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(PMC *);
    func_t pointer;
    call_state st;
    int return_data;
    
    PMC *t_245;
    Parrot_init_arg_nci(interp, &st, "P");
    t_245 = GET_NCI_P(0);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(PMC_IS_NULL(t_245) ? NULL : t_245);
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_P_JOPP(PARROT_INTERP, PMC *self)
{
    typedef PMC * (*func_t)(PARROT_INTERP, PMC *, PMC *, PMC *);
    func_t pointer;
    call_state st;
    PMC * return_data;
    
    PMC *t_247;
    PMC *t_248;
    PMC *t_249;
    Parrot_init_arg_nci(interp, &st, "PPP");
    t_247 = GET_NCI_P(0);
    t_248 = GET_NCI_P(1);
    t_249 = GET_NCI_P(2);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (PMC *)(*pointer)(interp,PMC_IS_NULL(t_247) ? NULL : t_247,PMC_IS_NULL(t_248) ? NULL : t_248,PMC_IS_NULL(t_249) ? NULL : t_249);
    
    set_nci_P(interp, &st, return_data);
    
}
static void
pcf_P_JOPPP(PARROT_INTERP, PMC *self)
{
    typedef PMC * (*func_t)(PARROT_INTERP, PMC *, PMC *, PMC *, PMC *);
    func_t pointer;
    call_state st;
    PMC * return_data;
    
    PMC *t_251;
    PMC *t_252;
    PMC *t_253;
    PMC *t_254;
    Parrot_init_arg_nci(interp, &st, "PPPP");
    t_251 = GET_NCI_P(0);
    t_252 = GET_NCI_P(1);
    t_253 = GET_NCI_P(2);
    t_254 = GET_NCI_P(3);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (PMC *)(*pointer)(interp,PMC_IS_NULL(t_251) ? NULL : t_251,PMC_IS_NULL(t_252) ? NULL : t_252,PMC_IS_NULL(t_253) ? NULL : t_253,PMC_IS_NULL(t_254) ? NULL : t_254);
    
    set_nci_P(interp, &st, return_data);
    
}
static void
pcf_v_JOPP(PARROT_INTERP, PMC *self)
{
    typedef void (*func_t)(PARROT_INTERP, PMC *, PMC *, PMC *);
    func_t pointer;
    call_state st;
    
    
    PMC *t_256;
    PMC *t_257;
    PMC *t_258;
    Parrot_init_arg_nci(interp, &st, "PPP");
    t_256 = GET_NCI_P(0);
    t_257 = GET_NCI_P(1);
    t_258 = GET_NCI_P(2);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
     (void)(*pointer)(interp,PMC_IS_NULL(t_256) ? NULL : t_256,PMC_IS_NULL(t_257) ? NULL : t_257,PMC_IS_NULL(t_258) ? NULL : t_258);
    
    
    
}
static void
pcf_v_JOPPP(PARROT_INTERP, PMC *self)
{
    typedef void (*func_t)(PARROT_INTERP, PMC *, PMC *, PMC *, PMC *);
    func_t pointer;
    call_state st;
    
    
    PMC *t_260;
    PMC *t_261;
    PMC *t_262;
    PMC *t_263;
    Parrot_init_arg_nci(interp, &st, "PPPP");
    t_260 = GET_NCI_P(0);
    t_261 = GET_NCI_P(1);
    t_262 = GET_NCI_P(2);
    t_263 = GET_NCI_P(3);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
     (void)(*pointer)(interp,PMC_IS_NULL(t_260) ? NULL : t_260,PMC_IS_NULL(t_261) ? NULL : t_261,PMC_IS_NULL(t_262) ? NULL : t_262,PMC_IS_NULL(t_263) ? NULL : t_263);
    
    
    
}
static void
pcf_P_JOPPPP(PARROT_INTERP, PMC *self)
{
    typedef PMC * (*func_t)(PARROT_INTERP, PMC *, PMC *, PMC *, PMC *, PMC *);
    func_t pointer;
    call_state st;
    PMC * return_data;
    
    PMC *t_265;
    PMC *t_266;
    PMC *t_267;
    PMC *t_268;
    PMC *t_269;
    Parrot_init_arg_nci(interp, &st, "PPPPP");
    t_265 = GET_NCI_P(0);
    t_266 = GET_NCI_P(1);
    t_267 = GET_NCI_P(2);
    t_268 = GET_NCI_P(3);
    t_269 = GET_NCI_P(4);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (PMC *)(*pointer)(interp,PMC_IS_NULL(t_265) ? NULL : t_265,PMC_IS_NULL(t_266) ? NULL : t_266,PMC_IS_NULL(t_267) ? NULL : t_267,PMC_IS_NULL(t_268) ? NULL : t_268,PMC_IS_NULL(t_269) ? NULL : t_269);
    
    set_nci_P(interp, &st, return_data);
    
}
static void
pcf_P_JOPPPPP(PARROT_INTERP, PMC *self)
{
    typedef PMC * (*func_t)(PARROT_INTERP, PMC *, PMC *, PMC *, PMC *, PMC *, PMC *);
    func_t pointer;
    call_state st;
    PMC * return_data;
    
    PMC *t_271;
    PMC *t_272;
    PMC *t_273;
    PMC *t_274;
    PMC *t_275;
    PMC *t_276;
    Parrot_init_arg_nci(interp, &st, "PPPPPP");
    t_271 = GET_NCI_P(0);
    t_272 = GET_NCI_P(1);
    t_273 = GET_NCI_P(2);
    t_274 = GET_NCI_P(3);
    t_275 = GET_NCI_P(4);
    t_276 = GET_NCI_P(5);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (PMC *)(*pointer)(interp,PMC_IS_NULL(t_271) ? NULL : t_271,PMC_IS_NULL(t_272) ? NULL : t_272,PMC_IS_NULL(t_273) ? NULL : t_273,PMC_IS_NULL(t_274) ? NULL : t_274,PMC_IS_NULL(t_275) ? NULL : t_275,PMC_IS_NULL(t_276) ? NULL : t_276);
    
    set_nci_P(interp, &st, return_data);
    
}
static void
pcf_I_JOSI(PARROT_INTERP, PMC *self)
{
    typedef INTVAL (*func_t)(PARROT_INTERP, PMC *, STRING *, INTVAL);
    func_t pointer;
    call_state st;
    INTVAL return_data;
    
    PMC *t_278;
    STRING * t_279;
    INTVAL t_280;
    Parrot_init_arg_nci(interp, &st, "PSI");
    t_278 = GET_NCI_P(0);
    t_279 = (STRING *)GET_NCI_S(1);
    t_280 = (INTVAL)GET_NCI_I(2);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (INTVAL)(*pointer)(interp,PMC_IS_NULL(t_278) ? NULL : t_278,t_279,t_280);
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_P_JOSII(PARROT_INTERP, PMC *self)
{
    typedef PMC * (*func_t)(PARROT_INTERP, PMC *, STRING *, INTVAL, INTVAL);
    func_t pointer;
    call_state st;
    PMC * return_data;
    
    PMC *t_282;
    STRING * t_283;
    INTVAL t_284;
    INTVAL t_285;
    Parrot_init_arg_nci(interp, &st, "PSII");
    t_282 = GET_NCI_P(0);
    t_283 = (STRING *)GET_NCI_S(1);
    t_284 = (INTVAL)GET_NCI_I(2);
    t_285 = (INTVAL)GET_NCI_I(3);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (PMC *)(*pointer)(interp,PMC_IS_NULL(t_282) ? NULL : t_282,t_283,t_284,t_285);
    
    set_nci_P(interp, &st, return_data);
    
}
static void
pcf_p_Ji(PARROT_INTERP, PMC *self)
{
    typedef void * (*func_t)(PARROT_INTERP, int);
    func_t pointer;
    call_state st;
    void * return_data;
    
    PMC * const final_destination = pmc_new(interp, enum_class_UnManagedStruct);int t_287;
    Parrot_init_arg_nci(interp, &st, "I");
    t_287 = (int)GET_NCI_I(0);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (void *)(*pointer)(interp,t_287);
    
    PMC_data(final_destination) = return_data;    set_nci_P(interp, &st, final_destination);
    
}
static void
pcf_p_Jipp(PARROT_INTERP, PMC *self)
{
    typedef void * (*func_t)(PARROT_INTERP, int, void *, void *);
    func_t pointer;
    call_state st;
    void * return_data;
    
    PMC * const final_destination = pmc_new(interp, enum_class_UnManagedStruct);int t_289;
    PMC *t_290;
    PMC *t_291;
    Parrot_init_arg_nci(interp, &st, "IPP");
    t_289 = (int)GET_NCI_I(0);
    t_290 = GET_NCI_P(1);
    t_291 = GET_NCI_P(2);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (void *)(*pointer)(interp,t_289,PMC_data(t_290),PMC_data(t_291));
    
    PMC_data(final_destination) = return_data;    set_nci_P(interp, &st, final_destination);
    
}
static void
pcf_p_Jbip(PARROT_INTERP, PMC *self)
{
    typedef void * (*func_t)(PARROT_INTERP, void *, int, void *);
    func_t pointer;
    call_state st;
    void * return_data;
    
    PMC * const final_destination = pmc_new(interp, enum_class_UnManagedStruct);STRING *t_293;
    int t_294;
    PMC *t_295;
    Parrot_init_arg_nci(interp, &st, "SIP");
    t_293 = GET_NCI_S(0);
    t_294 = (int)GET_NCI_I(1);
    t_295 = GET_NCI_P(2);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (void *)(*pointer)(interp,PObj_bufstart(t_293),t_294,PMC_data(t_295));
    
    PMC_data(final_destination) = return_data;    set_nci_P(interp, &st, final_destination);
    
}
static void
pcf_v_Jp(PARROT_INTERP, PMC *self)
{
    typedef void (*func_t)(PARROT_INTERP, void *);
    func_t pointer;
    call_state st;
    
    
    PMC *t_297;
    Parrot_init_arg_nci(interp, &st, "P");
    t_297 = GET_NCI_P(0);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
     (void)(*pointer)(interp,PMC_data(t_297));
    
    
    
}
static void
pcf_v_JS(PARROT_INTERP, PMC *self)
{
    typedef void (*func_t)(PARROT_INTERP, STRING *);
    func_t pointer;
    call_state st;
    
    
    STRING * t_299;
    Parrot_init_arg_nci(interp, &st, "S");
    t_299 = (STRING *)GET_NCI_S(0);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
     (void)(*pointer)(interp,t_299);
    
    
    
}
static void
pcf_t_tt(PARROT_INTERP, PMC *self)
{
    typedef char * (*func_t)(char *, char *);
    func_t pointer;
    call_state st;
    char * return_data;
    
    STRING *final_destination;char *t_300;
    char *t_301;
    Parrot_init_arg_nci(interp, &st, "SS");
    {STRING * s= GET_NCI_S(0); t_300 = s ? string_to_cstring(interp, s) : (char *) NULL;}
    {STRING * s= GET_NCI_S(1); t_301 = s ? string_to_cstring(interp, s) : (char *) NULL;}

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (char *)(*pointer)(t_300,t_301);
    
    final_destination = string_from_cstring(interp, return_data, 0);
    set_nci_S(interp, &st, final_destination);
    do { if (t_300) string_cstring_free(t_300); } while (0);
    do { if (t_301) string_cstring_free(t_301); } while (0);
}
static void
pcf_I_JOt(PARROT_INTERP, PMC *self)
{
    typedef INTVAL (*func_t)(PARROT_INTERP, PMC *, char *);
    func_t pointer;
    call_state st;
    INTVAL return_data;
    
    PMC *t_303;
    char *t_304;
    Parrot_init_arg_nci(interp, &st, "PS");
    t_303 = GET_NCI_P(0);
    {STRING * s= GET_NCI_S(1); t_304 = s ? string_to_cstring(interp, s) : (char *) NULL;}

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (INTVAL)(*pointer)(interp,PMC_IS_NULL(t_303) ? NULL : t_303,t_304);
    
    set_nci_I(interp, &st, return_data);
    do { if (t_304) string_cstring_free(t_304); } while (0);
}
static void
pcf_v_JOSI(PARROT_INTERP, PMC *self)
{
    typedef void (*func_t)(PARROT_INTERP, PMC *, STRING *, INTVAL);
    func_t pointer;
    call_state st;
    
    
    PMC *t_306;
    STRING * t_307;
    INTVAL t_308;
    Parrot_init_arg_nci(interp, &st, "PSI");
    t_306 = GET_NCI_P(0);
    t_307 = (STRING *)GET_NCI_S(1);
    t_308 = (INTVAL)GET_NCI_I(2);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
     (void)(*pointer)(interp,PMC_IS_NULL(t_306) ? NULL : t_306,t_307,t_308);
    
    
    
}
static void
pcf_S_JOi(PARROT_INTERP, PMC *self)
{
    typedef STRING * (*func_t)(PARROT_INTERP, PMC *, int);
    func_t pointer;
    call_state st;
    STRING * return_data;
    
    PMC *t_310;
    int t_311;
    Parrot_init_arg_nci(interp, &st, "PI");
    t_310 = GET_NCI_P(0);
    t_311 = (int)GET_NCI_I(1);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (STRING *)(*pointer)(interp,PMC_IS_NULL(t_310) ? NULL : t_310,t_311);
    
    set_nci_S(interp, &st, return_data);
    
}
static void
pcf_v_JOi(PARROT_INTERP, PMC *self)
{
    typedef void (*func_t)(PARROT_INTERP, PMC *, int);
    func_t pointer;
    call_state st;
    
    
    PMC *t_313;
    int t_314;
    Parrot_init_arg_nci(interp, &st, "PI");
    t_313 = GET_NCI_P(0);
    t_314 = (int)GET_NCI_I(1);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
     (void)(*pointer)(interp,PMC_IS_NULL(t_313) ? NULL : t_313,t_314);
    
    
    
}
static void
pcf_I_JO(PARROT_INTERP, PMC *self)
{
    typedef INTVAL (*func_t)(PARROT_INTERP, PMC *);
    func_t pointer;
    call_state st;
    INTVAL return_data;
    
    PMC *t_316;
    Parrot_init_arg_nci(interp, &st, "P");
    t_316 = GET_NCI_P(0);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (INTVAL)(*pointer)(interp,PMC_IS_NULL(t_316) ? NULL : t_316);
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_N_JO(PARROT_INTERP, PMC *self)
{
    typedef FLOATVAL (*func_t)(PARROT_INTERP, PMC *);
    func_t pointer;
    call_state st;
    FLOATVAL return_data;
    
    PMC *t_318;
    Parrot_init_arg_nci(interp, &st, "P");
    t_318 = GET_NCI_P(0);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (FLOATVAL)(*pointer)(interp,PMC_IS_NULL(t_318) ? NULL : t_318);
    
    set_nci_N(interp, &st, return_data);
    
}
static void
pcf_v_JON(PARROT_INTERP, PMC *self)
{
    typedef void (*func_t)(PARROT_INTERP, PMC *, FLOATVAL);
    func_t pointer;
    call_state st;
    
    
    PMC *t_320;
    FLOATVAL t_321;
    Parrot_init_arg_nci(interp, &st, "PN");
    t_320 = GET_NCI_P(0);
    t_321 = (FLOATVAL)GET_NCI_N(1);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
     (void)(*pointer)(interp,PMC_IS_NULL(t_320) ? NULL : t_320,t_321);
    
    
    
}
static void
pcf_P_JOi(PARROT_INTERP, PMC *self)
{
    typedef PMC * (*func_t)(PARROT_INTERP, PMC *, int);
    func_t pointer;
    call_state st;
    PMC * return_data;
    
    PMC *t_323;
    int t_324;
    Parrot_init_arg_nci(interp, &st, "PI");
    t_323 = GET_NCI_P(0);
    t_324 = (int)GET_NCI_I(1);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (PMC *)(*pointer)(interp,PMC_IS_NULL(t_323) ? NULL : t_323,t_324);
    
    set_nci_P(interp, &st, return_data);
    
}
static void
pcf_v_JOI(PARROT_INTERP, PMC *self)
{
    typedef void (*func_t)(PARROT_INTERP, PMC *, INTVAL);
    func_t pointer;
    call_state st;
    
    
    PMC *t_326;
    INTVAL t_327;
    Parrot_init_arg_nci(interp, &st, "PI");
    t_326 = GET_NCI_P(0);
    t_327 = (INTVAL)GET_NCI_I(1);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
     (void)(*pointer)(interp,PMC_IS_NULL(t_326) ? NULL : t_326,t_327);
    
    
    
}
static void
pcf_P_JOI(PARROT_INTERP, PMC *self)
{
    typedef PMC * (*func_t)(PARROT_INTERP, PMC *, INTVAL);
    func_t pointer;
    call_state st;
    PMC * return_data;
    
    PMC *t_329;
    INTVAL t_330;
    Parrot_init_arg_nci(interp, &st, "PI");
    t_329 = GET_NCI_P(0);
    t_330 = (INTVAL)GET_NCI_I(1);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (PMC *)(*pointer)(interp,PMC_IS_NULL(t_329) ? NULL : t_329,t_330);
    
    set_nci_P(interp, &st, return_data);
    
}
static void
pcf_P_JOIS(PARROT_INTERP, PMC *self)
{
    typedef PMC * (*func_t)(PARROT_INTERP, PMC *, INTVAL, STRING *);
    func_t pointer;
    call_state st;
    PMC * return_data;
    
    PMC *t_332;
    INTVAL t_333;
    STRING * t_334;
    Parrot_init_arg_nci(interp, &st, "PIS");
    t_332 = GET_NCI_P(0);
    t_333 = (INTVAL)GET_NCI_I(1);
    t_334 = (STRING *)GET_NCI_S(2);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (PMC *)(*pointer)(interp,PMC_IS_NULL(t_332) ? NULL : t_332,t_333,t_334);
    
    set_nci_P(interp, &st, return_data);
    
}
static void
pcf_S_JOSP(PARROT_INTERP, PMC *self)
{
    typedef STRING * (*func_t)(PARROT_INTERP, PMC *, STRING *, PMC *);
    func_t pointer;
    call_state st;
    STRING * return_data;
    
    PMC *t_336;
    STRING * t_337;
    PMC *t_338;
    Parrot_init_arg_nci(interp, &st, "PSP");
    t_336 = GET_NCI_P(0);
    t_337 = (STRING *)GET_NCI_S(1);
    t_338 = GET_NCI_P(2);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (STRING *)(*pointer)(interp,PMC_IS_NULL(t_336) ? NULL : t_336,t_337,PMC_IS_NULL(t_338) ? NULL : t_338);
    
    set_nci_S(interp, &st, return_data);
    
}
static void
pcf_i_(PARROT_INTERP, PMC *self)
{
    int (*pointer)(void);
    int return_data;
    
    call_state st;
    

    pointer =  (int (*)(void))D2FPTR(PMC_struct_val(self));
    return_data =  (int)(*pointer)();
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_i_i3i(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(int, int *, int);
    func_t pointer;
    call_state st;
    int return_data;
    int  arg1;
    int t_339;
    PMC *t_340;
    int t_341;
    Parrot_init_arg_nci(interp, &st, "IPI");
    t_339 = (int)GET_NCI_I(0);
    t_340 = GET_NCI_P(1);
    t_341 = (int)GET_NCI_I(2);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    arg1 = PMC_int_val(t_340);
    return_data =  (int)(*pointer)(t_339,&arg1,t_341);
    PMC_int_val(t_340) = arg1;
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_i_ibi(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(int, void *, int);
    func_t pointer;
    call_state st;
    int return_data;
    
    int t_342;
    STRING *t_343;
    int t_344;
    Parrot_init_arg_nci(interp, &st, "ISI");
    t_342 = (int)GET_NCI_I(0);
    t_343 = GET_NCI_S(1);
    t_344 = (int)GET_NCI_I(2);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(t_342,PObj_bufstart(t_343),t_344);
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_l_lttl(PARROT_INTERP, PMC *self)
{
    typedef long (*func_t)(long, char *, char *, long);
    func_t pointer;
    call_state st;
    long return_data;
    
    long t_345;
    char *t_346;
    char *t_347;
    long t_348;
    Parrot_init_arg_nci(interp, &st, "ISSI");
    t_345 = (long)GET_NCI_I(0);
    {STRING * s= GET_NCI_S(1); t_346 = s ? string_to_cstring(interp, s) : (char *) NULL;}
    {STRING * s= GET_NCI_S(2); t_347 = s ? string_to_cstring(interp, s) : (char *) NULL;}
    t_348 = (long)GET_NCI_I(3);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (long)(*pointer)(t_345,t_346,t_347,t_348);
    
    set_nci_I(interp, &st, return_data);
    do { if (t_346) string_cstring_free(t_346); } while (0);
    do { if (t_347) string_cstring_free(t_347); } while (0);
}
static void
pcf_i_pip(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(void *, int, void *);
    func_t pointer;
    call_state st;
    int return_data;
    
    PMC *t_349;
    int t_350;
    PMC *t_351;
    Parrot_init_arg_nci(interp, &st, "PIP");
    t_349 = GET_NCI_P(0);
    t_350 = (int)GET_NCI_I(1);
    t_351 = GET_NCI_P(2);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(PMC_data(t_349),t_350,PMC_data(t_351));
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_i_piS(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(void *, int, STRING *);
    func_t pointer;
    call_state st;
    int return_data;
    
    PMC *t_352;
    int t_353;
    STRING * t_354;
    Parrot_init_arg_nci(interp, &st, "PIS");
    t_352 = GET_NCI_P(0);
    t_353 = (int)GET_NCI_I(1);
    t_354 = (STRING *)GET_NCI_S(2);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(PMC_data(t_352),t_353,t_354);
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_S_i(PARROT_INTERP, PMC *self)
{
    typedef STRING * (*func_t)(int);
    func_t pointer;
    call_state st;
    STRING * return_data;
    
    int t_355;
    Parrot_init_arg_nci(interp, &st, "I");
    t_355 = (int)GET_NCI_I(0);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (STRING *)(*pointer)(t_355);
    
    set_nci_S(interp, &st, return_data);
    
}
static void
pcf_l_p(PARROT_INTERP, PMC *self)
{
    typedef long (*func_t)(void *);
    func_t pointer;
    call_state st;
    long return_data;
    
    PMC *t_356;
    Parrot_init_arg_nci(interp, &st, "P");
    t_356 = GET_NCI_P(0);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (long)(*pointer)(PMC_data(t_356));
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_c_p(PARROT_INTERP, PMC *self)
{
    typedef char (*func_t)(void *);
    func_t pointer;
    call_state st;
    char return_data;
    
    PMC *t_357;
    Parrot_init_arg_nci(interp, &st, "P");
    t_357 = GET_NCI_P(0);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (char)(*pointer)(PMC_data(t_357));
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_p_pi(PARROT_INTERP, PMC *self)
{
    typedef void * (*func_t)(void *, int);
    func_t pointer;
    call_state st;
    void * return_data;
    
    PMC * const final_destination = pmc_new(interp, enum_class_UnManagedStruct);PMC *t_358;
    int t_359;
    Parrot_init_arg_nci(interp, &st, "PI");
    t_358 = GET_NCI_P(0);
    t_359 = (int)GET_NCI_I(1);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (void *)(*pointer)(PMC_data(t_358),t_359);
    
    PMC_data(final_destination) = return_data;    set_nci_P(interp, &st, final_destination);
    
}
static void
pcf_p_p(PARROT_INTERP, PMC *self)
{
    typedef void * (*func_t)(void *);
    func_t pointer;
    call_state st;
    void * return_data;
    
    PMC * const final_destination = pmc_new(interp, enum_class_UnManagedStruct);PMC *t_360;
    Parrot_init_arg_nci(interp, &st, "P");
    t_360 = GET_NCI_P(0);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (void *)(*pointer)(PMC_data(t_360));
    
    PMC_data(final_destination) = return_data;    set_nci_P(interp, &st, final_destination);
    
}
static void
pcf_i_pttttt(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(void *, char *, char *, char *, char *, char *);
    func_t pointer;
    call_state st;
    int return_data;
    
    PMC *t_361;
    char *t_362;
    char *t_363;
    char *t_364;
    char *t_365;
    char *t_366;
    Parrot_init_arg_nci(interp, &st, "PSSSSS");
    t_361 = GET_NCI_P(0);
    {STRING * s= GET_NCI_S(1); t_362 = s ? string_to_cstring(interp, s) : (char *) NULL;}
    {STRING * s= GET_NCI_S(2); t_363 = s ? string_to_cstring(interp, s) : (char *) NULL;}
    {STRING * s= GET_NCI_S(3); t_364 = s ? string_to_cstring(interp, s) : (char *) NULL;}
    {STRING * s= GET_NCI_S(4); t_365 = s ? string_to_cstring(interp, s) : (char *) NULL;}
    {STRING * s= GET_NCI_S(5); t_366 = s ? string_to_cstring(interp, s) : (char *) NULL;}

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(PMC_data(t_361),t_362,t_363,t_364,t_365,t_366);
    
    set_nci_I(interp, &st, return_data);
    do { if (t_362) string_cstring_free(t_362); } while (0);
    do { if (t_363) string_cstring_free(t_363); } while (0);
    do { if (t_364) string_cstring_free(t_364); } while (0);
    do { if (t_365) string_cstring_free(t_365); } while (0);
    do { if (t_366) string_cstring_free(t_366); } while (0);
}
static void
pcf_c_pttt(PARROT_INTERP, PMC *self)
{
    typedef char (*func_t)(void *, char *, char *, char *);
    func_t pointer;
    call_state st;
    char return_data;
    
    PMC *t_367;
    char *t_368;
    char *t_369;
    char *t_370;
    Parrot_init_arg_nci(interp, &st, "PSSS");
    t_367 = GET_NCI_P(0);
    {STRING * s= GET_NCI_S(1); t_368 = s ? string_to_cstring(interp, s) : (char *) NULL;}
    {STRING * s= GET_NCI_S(2); t_369 = s ? string_to_cstring(interp, s) : (char *) NULL;}
    {STRING * s= GET_NCI_S(3); t_370 = s ? string_to_cstring(interp, s) : (char *) NULL;}

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (char)(*pointer)(PMC_data(t_367),t_368,t_369,t_370);
    
    set_nci_I(interp, &st, return_data);
    do { if (t_368) string_cstring_free(t_368); } while (0);
    do { if (t_369) string_cstring_free(t_369); } while (0);
    do { if (t_370) string_cstring_free(t_370); } while (0);
}
static void
pcf_p_pttttiti(PARROT_INTERP, PMC *self)
{
    typedef void * (*func_t)(void *, char *, char *, char *, char *, int, char *, int);
    func_t pointer;
    call_state st;
    void * return_data;
    
    PMC * const final_destination = pmc_new(interp, enum_class_UnManagedStruct);PMC *t_371;
    char *t_372;
    char *t_373;
    char *t_374;
    char *t_375;
    int t_376;
    char *t_377;
    int t_378;
    Parrot_init_arg_nci(interp, &st, "PSSSSISI");
    t_371 = GET_NCI_P(0);
    {STRING * s= GET_NCI_S(1); t_372 = s ? string_to_cstring(interp, s) : (char *) NULL;}
    {STRING * s= GET_NCI_S(2); t_373 = s ? string_to_cstring(interp, s) : (char *) NULL;}
    {STRING * s= GET_NCI_S(3); t_374 = s ? string_to_cstring(interp, s) : (char *) NULL;}
    {STRING * s= GET_NCI_S(4); t_375 = s ? string_to_cstring(interp, s) : (char *) NULL;}
    t_376 = (int)GET_NCI_I(5);
    {STRING * s= GET_NCI_S(6); t_377 = s ? string_to_cstring(interp, s) : (char *) NULL;}
    t_378 = (int)GET_NCI_I(7);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (void *)(*pointer)(PMC_data(t_371),t_372,t_373,t_374,t_375,t_376,t_377,t_378);
    
    PMC_data(final_destination) = return_data;    set_nci_P(interp, &st, final_destination);
    do { if (t_372) string_cstring_free(t_372); } while (0);
    do { if (t_373) string_cstring_free(t_373); } while (0);
    do { if (t_374) string_cstring_free(t_374); } while (0);
    do { if (t_375) string_cstring_free(t_375); } while (0);
    do { if (t_377) string_cstring_free(t_377); } while (0);
}
static void
pcf_i_pt(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(void *, char *);
    func_t pointer;
    call_state st;
    int return_data;
    
    PMC *t_379;
    char *t_380;
    Parrot_init_arg_nci(interp, &st, "PS");
    t_379 = GET_NCI_P(0);
    {STRING * s= GET_NCI_S(1); t_380 = s ? string_to_cstring(interp, s) : (char *) NULL;}

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(PMC_data(t_379),t_380);
    
    set_nci_I(interp, &st, return_data);
    do { if (t_380) string_cstring_free(t_380); } while (0);
}
static void
pcf_i_ptl(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(void *, char *, long);
    func_t pointer;
    call_state st;
    int return_data;
    
    PMC *t_381;
    char *t_382;
    long t_383;
    Parrot_init_arg_nci(interp, &st, "PSI");
    t_381 = GET_NCI_P(0);
    {STRING * s= GET_NCI_S(1); t_382 = s ? string_to_cstring(interp, s) : (char *) NULL;}
    t_383 = (long)GET_NCI_I(2);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(PMC_data(t_381),t_382,t_383);
    
    set_nci_I(interp, &st, return_data);
    do { if (t_382) string_cstring_free(t_382); } while (0);
}
static void
pcf_i_pi(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(void *, int);
    func_t pointer;
    call_state st;
    int return_data;
    
    PMC *t_384;
    int t_385;
    Parrot_init_arg_nci(interp, &st, "PI");
    t_384 = GET_NCI_P(0);
    t_385 = (int)GET_NCI_I(1);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(PMC_data(t_384),t_385);
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_i_pl(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(void *, long);
    func_t pointer;
    call_state st;
    int return_data;
    
    PMC *t_386;
    long t_387;
    Parrot_init_arg_nci(interp, &st, "PI");
    t_386 = GET_NCI_P(0);
    t_387 = (long)GET_NCI_I(1);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(PMC_data(t_386),t_387);
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_l_(PARROT_INTERP, PMC *self)
{
    long (*pointer)(void);
    long return_data;
    
    call_state st;
    

    pointer =  (long (*)(void))D2FPTR(PMC_struct_val(self));
    return_data =  (long)(*pointer)();
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_p_pt(PARROT_INTERP, PMC *self)
{
    typedef void * (*func_t)(void *, char *);
    func_t pointer;
    call_state st;
    void * return_data;
    
    PMC * const final_destination = pmc_new(interp, enum_class_UnManagedStruct);PMC *t_388;
    char *t_389;
    Parrot_init_arg_nci(interp, &st, "PS");
    t_388 = GET_NCI_P(0);
    {STRING * s= GET_NCI_S(1); t_389 = s ? string_to_cstring(interp, s) : (char *) NULL;}

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (void *)(*pointer)(PMC_data(t_388),t_389);
    
    PMC_data(final_destination) = return_data;    set_nci_P(interp, &st, final_destination);
    do { if (t_389) string_cstring_free(t_389); } while (0);
}
static void
pcf_p_ptt(PARROT_INTERP, PMC *self)
{
    typedef void * (*func_t)(void *, char *, char *);
    func_t pointer;
    call_state st;
    void * return_data;
    
    PMC * const final_destination = pmc_new(interp, enum_class_UnManagedStruct);PMC *t_390;
    char *t_391;
    char *t_392;
    Parrot_init_arg_nci(interp, &st, "PSS");
    t_390 = GET_NCI_P(0);
    {STRING * s= GET_NCI_S(1); t_391 = s ? string_to_cstring(interp, s) : (char *) NULL;}
    {STRING * s= GET_NCI_S(2); t_392 = s ? string_to_cstring(interp, s) : (char *) NULL;}

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (void *)(*pointer)(PMC_data(t_390),t_391,t_392);
    
    PMC_data(final_destination) = return_data;    set_nci_P(interp, &st, final_destination);
    do { if (t_391) string_cstring_free(t_391); } while (0);
    do { if (t_392) string_cstring_free(t_392); } while (0);
}
static void
pcf_i_pit(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(void *, int, char *);
    func_t pointer;
    call_state st;
    int return_data;
    
    PMC *t_393;
    int t_394;
    char *t_395;
    Parrot_init_arg_nci(interp, &st, "PIS");
    t_393 = GET_NCI_P(0);
    t_394 = (int)GET_NCI_I(1);
    {STRING * s= GET_NCI_S(2); t_395 = s ? string_to_cstring(interp, s) : (char *) NULL;}

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(PMC_data(t_393),t_394,t_395);
    
    set_nci_I(interp, &st, return_data);
    do { if (t_395) string_cstring_free(t_395); } while (0);
}
static void
pcf_p_pp(PARROT_INTERP, PMC *self)
{
    typedef void * (*func_t)(void *, void *);
    func_t pointer;
    call_state st;
    void * return_data;
    
    PMC * const final_destination = pmc_new(interp, enum_class_UnManagedStruct);PMC *t_396;
    PMC *t_397;
    Parrot_init_arg_nci(interp, &st, "PP");
    t_396 = GET_NCI_P(0);
    t_397 = GET_NCI_P(1);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (void *)(*pointer)(PMC_data(t_396),PMC_data(t_397));
    
    PMC_data(final_destination) = return_data;    set_nci_P(interp, &st, final_destination);
    
}
static void
pcf_l_ttl(PARROT_INTERP, PMC *self)
{
    typedef long (*func_t)(char *, char *, long);
    func_t pointer;
    call_state st;
    long return_data;
    
    char *t_398;
    char *t_399;
    long t_400;
    Parrot_init_arg_nci(interp, &st, "SSI");
    {STRING * s= GET_NCI_S(0); t_398 = s ? string_to_cstring(interp, s) : (char *) NULL;}
    {STRING * s= GET_NCI_S(1); t_399 = s ? string_to_cstring(interp, s) : (char *) NULL;}
    t_400 = (long)GET_NCI_I(2);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (long)(*pointer)(t_398,t_399,t_400);
    
    set_nci_I(interp, &st, return_data);
    do { if (t_398) string_cstring_free(t_398); } while (0);
    do { if (t_399) string_cstring_free(t_399); } while (0);
}
static void
pcf_l_pttl(PARROT_INTERP, PMC *self)
{
    typedef long (*func_t)(void *, char *, char *, long);
    func_t pointer;
    call_state st;
    long return_data;
    
    PMC *t_401;
    char *t_402;
    char *t_403;
    long t_404;
    Parrot_init_arg_nci(interp, &st, "PSSI");
    t_401 = GET_NCI_P(0);
    {STRING * s= GET_NCI_S(1); t_402 = s ? string_to_cstring(interp, s) : (char *) NULL;}
    {STRING * s= GET_NCI_S(2); t_403 = s ? string_to_cstring(interp, s) : (char *) NULL;}
    t_404 = (long)GET_NCI_I(3);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (long)(*pointer)(PMC_data(t_401),t_402,t_403,t_404);
    
    set_nci_I(interp, &st, return_data);
    do { if (t_402) string_cstring_free(t_402); } while (0);
    do { if (t_403) string_cstring_free(t_403); } while (0);
}
static void
pcf_v_t(PARROT_INTERP, PMC *self)
{
    typedef void (*func_t)(char *);
    func_t pointer;
    call_state st;
    
    
    char *t_405;
    Parrot_init_arg_nci(interp, &st, "S");
    {STRING * s= GET_NCI_S(0); t_405 = s ? string_to_cstring(interp, s) : (char *) NULL;}

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
     (void)(*pointer)(t_405);
    
    
    do { if (t_405) string_cstring_free(t_405); } while (0);
}
static void
pcf_p_pttttitl(PARROT_INTERP, PMC *self)
{
    typedef void * (*func_t)(void *, char *, char *, char *, char *, int, char *, long);
    func_t pointer;
    call_state st;
    void * return_data;
    
    PMC * const final_destination = pmc_new(interp, enum_class_UnManagedStruct);PMC *t_406;
    char *t_407;
    char *t_408;
    char *t_409;
    char *t_410;
    int t_411;
    char *t_412;
    long t_413;
    Parrot_init_arg_nci(interp, &st, "PSSSSISI");
    t_406 = GET_NCI_P(0);
    {STRING * s= GET_NCI_S(1); t_407 = s ? string_to_cstring(interp, s) : (char *) NULL;}
    {STRING * s= GET_NCI_S(2); t_408 = s ? string_to_cstring(interp, s) : (char *) NULL;}
    {STRING * s= GET_NCI_S(3); t_409 = s ? string_to_cstring(interp, s) : (char *) NULL;}
    {STRING * s= GET_NCI_S(4); t_410 = s ? string_to_cstring(interp, s) : (char *) NULL;}
    t_411 = (int)GET_NCI_I(5);
    {STRING * s= GET_NCI_S(6); t_412 = s ? string_to_cstring(interp, s) : (char *) NULL;}
    t_413 = (long)GET_NCI_I(7);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (void *)(*pointer)(PMC_data(t_406),t_407,t_408,t_409,t_410,t_411,t_412,t_413);
    
    PMC_data(final_destination) = return_data;    set_nci_P(interp, &st, final_destination);
    do { if (t_407) string_cstring_free(t_407); } while (0);
    do { if (t_408) string_cstring_free(t_408); } while (0);
    do { if (t_409) string_cstring_free(t_409); } while (0);
    do { if (t_410) string_cstring_free(t_410); } while (0);
    do { if (t_412) string_cstring_free(t_412); } while (0);
}
static void
pcf_p_tiB3P(PARROT_INTERP, PMC *self)
{
    typedef void * (*func_t)(char *, int, void **, int *, PMC *);
    func_t pointer;
    call_state st;
    void * return_data;
    int  arg3;
    PMC * const final_destination = pmc_new(interp, enum_class_UnManagedStruct);char *t_414;
    int t_415;
    char *s_416;
    char *t_416;
    void** v_416 = (void **) &t_416;
    PMC *t_417;
    PMC *t_418;
    Parrot_init_arg_nci(interp, &st, "SISPP");
    {STRING * s= GET_NCI_S(0); t_414 = s ? string_to_cstring(interp, s) : (char *) NULL;}
    t_415 = (int)GET_NCI_I(1);
    {STRING * s= GET_NCI_S(2); t_416 = s ? string_to_cstring(interp, s) : (char *) NULL; s_416 = t_416;}
    t_417 = GET_NCI_P(3);
    t_418 = GET_NCI_P(4);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    arg3 = PMC_int_val(t_417);
    return_data =  (void *)(*pointer)(t_414,t_415,v_416,&arg3,PMC_IS_NULL(t_418) ? NULL : t_418);
    PMC_int_val(t_417) = arg3;
    PMC_data(final_destination) = return_data;    set_nci_P(interp, &st, final_destination);
    do { if (t_414) string_cstring_free(t_414); } while (0);
    do { if (s_416) string_cstring_free(s_416); } while (0);
}
static void
pcf_p_tip3P(PARROT_INTERP, PMC *self)
{
    typedef void * (*func_t)(char *, int, void *, int *, PMC *);
    func_t pointer;
    call_state st;
    void * return_data;
    int  arg3;
    PMC * const final_destination = pmc_new(interp, enum_class_UnManagedStruct);char *t_419;
    int t_420;
    PMC *t_421;
    PMC *t_422;
    PMC *t_423;
    Parrot_init_arg_nci(interp, &st, "SIPPP");
    {STRING * s= GET_NCI_S(0); t_419 = s ? string_to_cstring(interp, s) : (char *) NULL;}
    t_420 = (int)GET_NCI_I(1);
    t_421 = GET_NCI_P(2);
    t_422 = GET_NCI_P(3);
    t_423 = GET_NCI_P(4);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    arg3 = PMC_int_val(t_422);
    return_data =  (void *)(*pointer)(t_419,t_420,PMC_data(t_421),&arg3,PMC_IS_NULL(t_423) ? NULL : t_423);
    PMC_int_val(t_422) = arg3;
    PMC_data(final_destination) = return_data;    set_nci_P(interp, &st, final_destination);
    do { if (t_419) string_cstring_free(t_419); } while (0);
}
static void
pcf_i_pPtiiipi(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(void *, PMC *, char *, int, int, int, void *, int);
    func_t pointer;
    call_state st;
    int return_data;
    
    PMC *t_424;
    PMC *t_425;
    char *t_426;
    int t_427;
    int t_428;
    int t_429;
    PMC *t_430;
    int t_431;
    Parrot_init_arg_nci(interp, &st, "PPSIIIPI");
    t_424 = GET_NCI_P(0);
    t_425 = GET_NCI_P(1);
    {STRING * s= GET_NCI_S(2); t_426 = s ? string_to_cstring(interp, s) : (char *) NULL;}
    t_427 = (int)GET_NCI_I(3);
    t_428 = (int)GET_NCI_I(4);
    t_429 = (int)GET_NCI_I(5);
    t_430 = GET_NCI_P(6);
    t_431 = (int)GET_NCI_I(7);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(PMC_data(t_424),PMC_IS_NULL(t_425) ? NULL : t_425,t_426,t_427,t_428,t_429,PMC_data(t_430),t_431);
    
    set_nci_I(interp, &st, return_data);
    do { if (t_426) string_cstring_free(t_426); } while (0);
}
static void
pcf_i_tpiibi(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(char *, void *, int, int, void *, int);
    func_t pointer;
    call_state st;
    int return_data;
    
    char *t_432;
    PMC *t_433;
    int t_434;
    int t_435;
    STRING *t_436;
    int t_437;
    Parrot_init_arg_nci(interp, &st, "SPIISI");
    {STRING * s= GET_NCI_S(0); t_432 = s ? string_to_cstring(interp, s) : (char *) NULL;}
    t_433 = GET_NCI_P(1);
    t_434 = (int)GET_NCI_I(2);
    t_435 = (int)GET_NCI_I(3);
    t_436 = GET_NCI_S(4);
    t_437 = (int)GET_NCI_I(5);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(t_432,PMC_data(t_433),t_434,t_435,PObj_bufstart(t_436),t_437);
    
    set_nci_I(interp, &st, return_data);
    do { if (t_432) string_cstring_free(t_432); } while (0);
}
static void
pcf_p_ptippppi(PARROT_INTERP, PMC *self)
{
    typedef void * (*func_t)(void *, char *, int, void *, void *, void *, void *, int);
    func_t pointer;
    call_state st;
    void * return_data;
    
    PMC * const final_destination = pmc_new(interp, enum_class_UnManagedStruct);PMC *t_438;
    char *t_439;
    int t_440;
    PMC *t_441;
    PMC *t_442;
    PMC *t_443;
    PMC *t_444;
    int t_445;
    Parrot_init_arg_nci(interp, &st, "PSIPPPPI");
    t_438 = GET_NCI_P(0);
    {STRING * s= GET_NCI_S(1); t_439 = s ? string_to_cstring(interp, s) : (char *) NULL;}
    t_440 = (int)GET_NCI_I(2);
    t_441 = GET_NCI_P(3);
    t_442 = GET_NCI_P(4);
    t_443 = GET_NCI_P(5);
    t_444 = GET_NCI_P(6);
    t_445 = (int)GET_NCI_I(7);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (void *)(*pointer)(PMC_data(t_438),t_439,t_440,PMC_data(t_441),PMC_data(t_442),PMC_data(t_443),PMC_data(t_444),t_445);
    
    PMC_data(final_destination) = return_data;    set_nci_P(interp, &st, final_destination);
    do { if (t_439) string_cstring_free(t_439); } while (0);
}
static void
pcf_p_pi33ipi(PARROT_INTERP, PMC *self)
{
    typedef void * (*func_t)(void *, int, int *, int *, int, void *, int);
    func_t pointer;
    call_state st;
    void * return_data;
    int  arg2;
    int  arg3;
    PMC * const final_destination = pmc_new(interp, enum_class_UnManagedStruct);PMC *t_446;
    int t_447;
    PMC *t_448;
    PMC *t_449;
    int t_450;
    PMC *t_451;
    int t_452;
    Parrot_init_arg_nci(interp, &st, "PIPPIPI");
    t_446 = GET_NCI_P(0);
    t_447 = (int)GET_NCI_I(1);
    t_448 = GET_NCI_P(2);
    t_449 = GET_NCI_P(3);
    t_450 = (int)GET_NCI_I(4);
    t_451 = GET_NCI_P(5);
    t_452 = (int)GET_NCI_I(6);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    arg2 = PMC_int_val(t_448);
    arg3 = PMC_int_val(t_449);
    return_data =  (void *)(*pointer)(PMC_data(t_446),t_447,&arg2,&arg3,t_450,PMC_data(t_451),t_452);
    PMC_int_val(t_448) = arg2;
    PMC_int_val(t_449) = arg3;
    PMC_data(final_destination) = return_data;    set_nci_P(interp, &st, final_destination);
    
}
static void
pcf_p_pttip(PARROT_INTERP, PMC *self)
{
    typedef void * (*func_t)(void *, char *, char *, int, void *);
    func_t pointer;
    call_state st;
    void * return_data;
    
    PMC * const final_destination = pmc_new(interp, enum_class_UnManagedStruct);PMC *t_453;
    char *t_454;
    char *t_455;
    int t_456;
    PMC *t_457;
    Parrot_init_arg_nci(interp, &st, "PSSIP");
    t_453 = GET_NCI_P(0);
    {STRING * s= GET_NCI_S(1); t_454 = s ? string_to_cstring(interp, s) : (char *) NULL;}
    {STRING * s= GET_NCI_S(2); t_455 = s ? string_to_cstring(interp, s) : (char *) NULL;}
    t_456 = (int)GET_NCI_I(3);
    t_457 = GET_NCI_P(4);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (void *)(*pointer)(PMC_data(t_453),t_454,t_455,t_456,PMC_data(t_457));
    
    PMC_data(final_destination) = return_data;    set_nci_P(interp, &st, final_destination);
    do { if (t_454) string_cstring_free(t_454); } while (0);
    do { if (t_455) string_cstring_free(t_455); } while (0);
}
static void
pcf_p_ptipppi(PARROT_INTERP, PMC *self)
{
    typedef void * (*func_t)(void *, char *, int, void *, void *, void *, int);
    func_t pointer;
    call_state st;
    void * return_data;
    
    PMC * const final_destination = pmc_new(interp, enum_class_UnManagedStruct);PMC *t_458;
    char *t_459;
    int t_460;
    PMC *t_461;
    PMC *t_462;
    PMC *t_463;
    int t_464;
    Parrot_init_arg_nci(interp, &st, "PSIPPPI");
    t_458 = GET_NCI_P(0);
    {STRING * s= GET_NCI_S(1); t_459 = s ? string_to_cstring(interp, s) : (char *) NULL;}
    t_460 = (int)GET_NCI_I(2);
    t_461 = GET_NCI_P(3);
    t_462 = GET_NCI_P(4);
    t_463 = GET_NCI_P(5);
    t_464 = (int)GET_NCI_I(6);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (void *)(*pointer)(PMC_data(t_458),t_459,t_460,PMC_data(t_461),PMC_data(t_462),PMC_data(t_463),t_464);
    
    PMC_data(final_destination) = return_data;    set_nci_P(interp, &st, final_destination);
    do { if (t_459) string_cstring_free(t_459); } while (0);
}
static void
pcf_p_ppP(PARROT_INTERP, PMC *self)
{
    typedef void * (*func_t)(void *, void *, PMC *);
    func_t pointer;
    call_state st;
    void * return_data;
    
    PMC * const final_destination = pmc_new(interp, enum_class_UnManagedStruct);PMC *t_465;
    PMC *t_466;
    PMC *t_467;
    Parrot_init_arg_nci(interp, &st, "PPP");
    t_465 = GET_NCI_P(0);
    t_466 = GET_NCI_P(1);
    t_467 = GET_NCI_P(2);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (void *)(*pointer)(PMC_data(t_465),PMC_data(t_466),PMC_IS_NULL(t_467) ? NULL : t_467);
    
    PMC_data(final_destination) = return_data;    set_nci_P(interp, &st, final_destination);
    
}
static void
pcf_p_iiil(PARROT_INTERP, PMC *self)
{
    typedef void * (*func_t)(int, int, int, long);
    func_t pointer;
    call_state st;
    void * return_data;
    
    PMC * const final_destination = pmc_new(interp, enum_class_UnManagedStruct);int t_468;
    int t_469;
    int t_470;
    long t_471;
    Parrot_init_arg_nci(interp, &st, "IIII");
    t_468 = (int)GET_NCI_I(0);
    t_469 = (int)GET_NCI_I(1);
    t_470 = (int)GET_NCI_I(2);
    t_471 = (long)GET_NCI_I(3);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (void *)(*pointer)(t_468,t_469,t_470,t_471);
    
    PMC_data(final_destination) = return_data;    set_nci_P(interp, &st, final_destination);
    
}
static void
pcf_i_ppl(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(void *, void *, long);
    func_t pointer;
    call_state st;
    int return_data;
    
    PMC *t_472;
    PMC *t_473;
    long t_474;
    Parrot_init_arg_nci(interp, &st, "PPI");
    t_472 = GET_NCI_P(0);
    t_473 = GET_NCI_P(1);
    t_474 = (long)GET_NCI_I(2);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(PMC_data(t_472),PMC_data(t_473),t_474);
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_v_pip(PARROT_INTERP, PMC *self)
{
    typedef void (*func_t)(void *, int, void *);
    func_t pointer;
    call_state st;
    
    
    PMC *t_475;
    int t_476;
    PMC *t_477;
    Parrot_init_arg_nci(interp, &st, "PIP");
    t_475 = GET_NCI_P(0);
    t_476 = (int)GET_NCI_I(1);
    t_477 = GET_NCI_P(2);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
     (void)(*pointer)(PMC_data(t_475),t_476,PMC_data(t_477));
    
    
    
}
static void
pcf_p_pti(PARROT_INTERP, PMC *self)
{
    typedef void * (*func_t)(void *, char *, int);
    func_t pointer;
    call_state st;
    void * return_data;
    
    PMC * const final_destination = pmc_new(interp, enum_class_UnManagedStruct);PMC *t_478;
    char *t_479;
    int t_480;
    Parrot_init_arg_nci(interp, &st, "PSI");
    t_478 = GET_NCI_P(0);
    {STRING * s= GET_NCI_S(1); t_479 = s ? string_to_cstring(interp, s) : (char *) NULL;}
    t_480 = (int)GET_NCI_I(2);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (void *)(*pointer)(PMC_data(t_478),t_479,t_480);
    
    PMC_data(final_destination) = return_data;    set_nci_P(interp, &st, final_destination);
    do { if (t_479) string_cstring_free(t_479); } while (0);
}
static void
pcf_i_ppp(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(void *, void *, void *);
    func_t pointer;
    call_state st;
    int return_data;
    
    PMC *t_481;
    PMC *t_482;
    PMC *t_483;
    Parrot_init_arg_nci(interp, &st, "PPP");
    t_481 = GET_NCI_P(0);
    t_482 = GET_NCI_P(1);
    t_483 = GET_NCI_P(2);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(PMC_data(t_481),PMC_data(t_482),PMC_data(t_483));
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_p_ti(PARROT_INTERP, PMC *self)
{
    typedef void * (*func_t)(char *, int);
    func_t pointer;
    call_state st;
    void * return_data;
    
    PMC * const final_destination = pmc_new(interp, enum_class_UnManagedStruct);char *t_484;
    int t_485;
    Parrot_init_arg_nci(interp, &st, "SI");
    {STRING * s= GET_NCI_S(0); t_484 = s ? string_to_cstring(interp, s) : (char *) NULL;}
    t_485 = (int)GET_NCI_I(1);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (void *)(*pointer)(t_484,t_485);
    
    PMC_data(final_destination) = return_data;    set_nci_P(interp, &st, final_destination);
    do { if (t_484) string_cstring_free(t_484); } while (0);
}
static void
pcf_p_ptp(PARROT_INTERP, PMC *self)
{
    typedef void * (*func_t)(void *, char *, void *);
    func_t pointer;
    call_state st;
    void * return_data;
    
    PMC * const final_destination = pmc_new(interp, enum_class_UnManagedStruct);PMC *t_486;
    char *t_487;
    PMC *t_488;
    Parrot_init_arg_nci(interp, &st, "PSP");
    t_486 = GET_NCI_P(0);
    {STRING * s= GET_NCI_S(1); t_487 = s ? string_to_cstring(interp, s) : (char *) NULL;}
    t_488 = GET_NCI_P(2);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (void *)(*pointer)(PMC_data(t_486),t_487,PMC_data(t_488));
    
    PMC_data(final_destination) = return_data;    set_nci_P(interp, &st, final_destination);
    do { if (t_487) string_cstring_free(t_487); } while (0);
}
static void
pcf_i_pt33(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(void *, char *, int *, int *);
    func_t pointer;
    call_state st;
    int return_data;
    int  arg2;
    int  arg3;
    PMC *t_489;
    char *t_490;
    PMC *t_491;
    PMC *t_492;
    Parrot_init_arg_nci(interp, &st, "PSPP");
    t_489 = GET_NCI_P(0);
    {STRING * s= GET_NCI_S(1); t_490 = s ? string_to_cstring(interp, s) : (char *) NULL;}
    t_491 = GET_NCI_P(2);
    t_492 = GET_NCI_P(3);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    arg2 = PMC_int_val(t_491);
    arg3 = PMC_int_val(t_492);
    return_data =  (int)(*pointer)(PMC_data(t_489),t_490,&arg2,&arg3);
    PMC_int_val(t_491) = arg2;
    PMC_int_val(t_492) = arg3;
    set_nci_I(interp, &st, return_data);
    do { if (t_490) string_cstring_free(t_490); } while (0);
}
static void
pcf_c_(PARROT_INTERP, PMC *self)
{
    char (*pointer)(void);
    char return_data;
    
    call_state st;
    

    pointer =  (char (*)(void))D2FPTR(PMC_struct_val(self));
    return_data =  (char)(*pointer)();
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_c_pi(PARROT_INTERP, PMC *self)
{
    typedef char (*func_t)(void *, int);
    func_t pointer;
    call_state st;
    char return_data;
    
    PMC *t_493;
    int t_494;
    Parrot_init_arg_nci(interp, &st, "PI");
    t_493 = GET_NCI_P(0);
    t_494 = (int)GET_NCI_I(1);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (char)(*pointer)(PMC_data(t_493),t_494);
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_d_(PARROT_INTERP, PMC *self)
{
    double (*pointer)(void);
    double return_data;
    
    call_state st;
    

    pointer =  (double (*)(void))D2FPTR(PMC_struct_val(self));
    return_data =  (double)(*pointer)();
    set_nci_N(interp, &st, return_data);
    
}
static void
pcf_d_d(PARROT_INTERP, PMC *self)
{
    typedef double (*func_t)(double);
    func_t pointer;
    call_state st;
    double return_data;
    
    double t_495;
    Parrot_init_arg_nci(interp, &st, "N");
    t_495 = (double)GET_NCI_N(0);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (double)(*pointer)(t_495);
    
    set_nci_N(interp, &st, return_data);
    
}
static void
pcf_f_(PARROT_INTERP, PMC *self)
{
    float (*pointer)(void);
    float return_data;
    
    call_state st;
    

    pointer =  (float (*)(void))D2FPTR(PMC_struct_val(self));
    return_data =  (float)(*pointer)();
    set_nci_N(interp, &st, return_data);
    
}
static void
pcf_f_ff(PARROT_INTERP, PMC *self)
{
    typedef float (*func_t)(float, float);
    func_t pointer;
    call_state st;
    float return_data;
    
    float t_496;
    float t_497;
    Parrot_init_arg_nci(interp, &st, "NN");
    t_496 = (float)GET_NCI_N(0);
    t_497 = (float)GET_NCI_N(1);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (float)(*pointer)(t_496,t_497);
    
    set_nci_N(interp, &st, return_data);
    
}
static void
pcf_f_is(PARROT_INTERP, PMC *self)
{
    typedef float (*func_t)(int, short);
    func_t pointer;
    call_state st;
    float return_data;
    
    int t_498;
    short t_499;
    Parrot_init_arg_nci(interp, &st, "II");
    t_498 = (int)GET_NCI_I(0);
    t_499 = (short)GET_NCI_I(1);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (float)(*pointer)(t_498,t_499);
    
    set_nci_N(interp, &st, return_data);
    
}
static void
pcf_i_b(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(void *);
    func_t pointer;
    call_state st;
    int return_data;
    
    STRING *t_500;
    Parrot_init_arg_nci(interp, &st, "S");
    t_500 = GET_NCI_S(0);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(PObj_bufstart(t_500));
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_i_d(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(double);
    func_t pointer;
    call_state st;
    int return_data;
    
    double t_501;
    Parrot_init_arg_nci(interp, &st, "N");
    t_501 = (double)GET_NCI_N(0);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(t_501);
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_i_i(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(int);
    func_t pointer;
    call_state st;
    int return_data;
    
    int t_502;
    Parrot_init_arg_nci(interp, &st, "I");
    t_502 = (int)GET_NCI_I(0);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(t_502);
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_i_ii(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(int, int);
    func_t pointer;
    call_state st;
    int return_data;
    
    int t_503;
    int t_504;
    Parrot_init_arg_nci(interp, &st, "II");
    t_503 = (int)GET_NCI_I(0);
    t_504 = (int)GET_NCI_I(1);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(t_503,t_504);
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_i_ii4(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(int, int, long *);
    func_t pointer;
    call_state st;
    int return_data;
    long  arg2;
    int t_505;
    int t_506;
    PMC *t_507;
    Parrot_init_arg_nci(interp, &st, "IIP");
    t_505 = (int)GET_NCI_I(0);
    t_506 = (int)GET_NCI_I(1);
    t_507 = GET_NCI_P(2);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    arg2 = PMC_int_val(t_507);
    return_data =  (int)(*pointer)(t_505,t_506,&arg2);
    PMC_int_val(t_507) = arg2;
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_i_ii4i(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(int, int, long *, int);
    func_t pointer;
    call_state st;
    int return_data;
    long  arg2;
    int t_508;
    int t_509;
    PMC *t_510;
    int t_511;
    Parrot_init_arg_nci(interp, &st, "IIPI");
    t_508 = (int)GET_NCI_I(0);
    t_509 = (int)GET_NCI_I(1);
    t_510 = GET_NCI_P(2);
    t_511 = (int)GET_NCI_I(3);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    arg2 = PMC_int_val(t_510);
    return_data =  (int)(*pointer)(t_508,t_509,&arg2,t_511);
    PMC_int_val(t_510) = arg2;
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_i_iiii(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(int, int, int, int);
    func_t pointer;
    call_state st;
    int return_data;
    
    int t_512;
    int t_513;
    int t_514;
    int t_515;
    Parrot_init_arg_nci(interp, &st, "IIII");
    t_512 = (int)GET_NCI_I(0);
    t_513 = (int)GET_NCI_I(1);
    t_514 = (int)GET_NCI_I(2);
    t_515 = (int)GET_NCI_I(3);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(t_512,t_513,t_514,t_515);
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_i_iiilsp(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(int, int, int, long, short, void *);
    func_t pointer;
    call_state st;
    int return_data;
    
    int t_516;
    int t_517;
    int t_518;
    long t_519;
    short t_520;
    PMC *t_521;
    Parrot_init_arg_nci(interp, &st, "IIIIIP");
    t_516 = (int)GET_NCI_I(0);
    t_517 = (int)GET_NCI_I(1);
    t_518 = (int)GET_NCI_I(2);
    t_519 = (long)GET_NCI_I(3);
    t_520 = (short)GET_NCI_I(4);
    t_521 = GET_NCI_P(5);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(t_516,t_517,t_518,t_519,t_520,PMC_data(t_521));
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_i_iil(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(int, int, long);
    func_t pointer;
    call_state st;
    int return_data;
    
    int t_522;
    int t_523;
    long t_524;
    Parrot_init_arg_nci(interp, &st, "III");
    t_522 = (int)GET_NCI_I(0);
    t_523 = (int)GET_NCI_I(1);
    t_524 = (long)GET_NCI_I(2);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(t_522,t_523,t_524);
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_i_iili(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(int, int, long, int);
    func_t pointer;
    call_state st;
    int return_data;
    
    int t_525;
    int t_526;
    long t_527;
    int t_528;
    Parrot_init_arg_nci(interp, &st, "IIII");
    t_525 = (int)GET_NCI_I(0);
    t_526 = (int)GET_NCI_I(1);
    t_527 = (long)GET_NCI_I(2);
    t_528 = (int)GET_NCI_I(3);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(t_525,t_526,t_527,t_528);
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_i_iip(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(int, int, void *);
    func_t pointer;
    call_state st;
    int return_data;
    
    int t_529;
    int t_530;
    PMC *t_531;
    Parrot_init_arg_nci(interp, &st, "IIP");
    t_529 = (int)GET_NCI_I(0);
    t_530 = (int)GET_NCI_I(1);
    t_531 = GET_NCI_P(2);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(t_529,t_530,PMC_data(t_531));
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_i_iit(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(int, int, char *);
    func_t pointer;
    call_state st;
    int return_data;
    
    int t_532;
    int t_533;
    char *t_534;
    Parrot_init_arg_nci(interp, &st, "IIS");
    t_532 = (int)GET_NCI_I(0);
    t_533 = (int)GET_NCI_I(1);
    {STRING * s= GET_NCI_S(2); t_534 = s ? string_to_cstring(interp, s) : (char *) NULL;}

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(t_532,t_533,t_534);
    
    set_nci_I(interp, &st, return_data);
    do { if (t_534) string_cstring_free(t_534); } while (0);
}
static void
pcf_i_iiti(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(int, int, char *, int);
    func_t pointer;
    call_state st;
    int return_data;
    
    int t_535;
    int t_536;
    char *t_537;
    int t_538;
    Parrot_init_arg_nci(interp, &st, "IISI");
    t_535 = (int)GET_NCI_I(0);
    t_536 = (int)GET_NCI_I(1);
    {STRING * s= GET_NCI_S(2); t_537 = s ? string_to_cstring(interp, s) : (char *) NULL;}
    t_538 = (int)GET_NCI_I(3);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(t_535,t_536,t_537,t_538);
    
    set_nci_I(interp, &st, return_data);
    do { if (t_537) string_cstring_free(t_537); } while (0);
}
static void
pcf_i_ilsp(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(int, long, short, void *);
    func_t pointer;
    call_state st;
    int return_data;
    
    int t_539;
    long t_540;
    short t_541;
    PMC *t_542;
    Parrot_init_arg_nci(interp, &st, "IIIP");
    t_539 = (int)GET_NCI_I(0);
    t_540 = (long)GET_NCI_I(1);
    t_541 = (short)GET_NCI_I(2);
    t_542 = GET_NCI_P(3);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(t_539,t_540,t_541,PMC_data(t_542));
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_i_iti(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(int, char *, int);
    func_t pointer;
    call_state st;
    int return_data;
    
    int t_543;
    char *t_544;
    int t_545;
    Parrot_init_arg_nci(interp, &st, "ISI");
    t_543 = (int)GET_NCI_I(0);
    {STRING * s= GET_NCI_S(1); t_544 = s ? string_to_cstring(interp, s) : (char *) NULL;}
    t_545 = (int)GET_NCI_I(2);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(t_543,t_544,t_545);
    
    set_nci_I(interp, &st, return_data);
    do { if (t_544) string_cstring_free(t_544); } while (0);
}
static void
pcf_i_l(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(long);
    func_t pointer;
    call_state st;
    int return_data;
    
    long t_546;
    Parrot_init_arg_nci(interp, &st, "I");
    t_546 = (long)GET_NCI_I(0);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(t_546);
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_i_li(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(long, int);
    func_t pointer;
    call_state st;
    int return_data;
    
    long t_547;
    int t_548;
    Parrot_init_arg_nci(interp, &st, "II");
    t_547 = (long)GET_NCI_I(0);
    t_548 = (int)GET_NCI_I(1);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(t_547,t_548);
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_i_lp(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(long, void *);
    func_t pointer;
    call_state st;
    int return_data;
    
    long t_549;
    PMC *t_550;
    Parrot_init_arg_nci(interp, &st, "IP");
    t_549 = (long)GET_NCI_I(0);
    t_550 = GET_NCI_P(1);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(t_549,PMC_data(t_550));
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_i_lsp(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(long, short, void *);
    func_t pointer;
    call_state st;
    int return_data;
    
    long t_551;
    short t_552;
    PMC *t_553;
    Parrot_init_arg_nci(interp, &st, "IIP");
    t_551 = (long)GET_NCI_I(0);
    t_552 = (short)GET_NCI_I(1);
    t_553 = GET_NCI_P(2);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(t_551,t_552,PMC_data(t_553));
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_i_p33(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(void *, int *, int *);
    func_t pointer;
    call_state st;
    int return_data;
    int  arg1;
    int  arg2;
    PMC *t_554;
    PMC *t_555;
    PMC *t_556;
    Parrot_init_arg_nci(interp, &st, "PPP");
    t_554 = GET_NCI_P(0);
    t_555 = GET_NCI_P(1);
    t_556 = GET_NCI_P(2);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    arg1 = PMC_int_val(t_555);
    arg2 = PMC_int_val(t_556);
    return_data =  (int)(*pointer)(PMC_data(t_554),&arg1,&arg2);
    PMC_int_val(t_555) = arg1;
    PMC_int_val(t_556) = arg2;
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_i_p333(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(void *, int *, int *, int *);
    func_t pointer;
    call_state st;
    int return_data;
    int  arg1;
    int  arg2;
    int  arg3;
    PMC *t_557;
    PMC *t_558;
    PMC *t_559;
    PMC *t_560;
    Parrot_init_arg_nci(interp, &st, "PPPP");
    t_557 = GET_NCI_P(0);
    t_558 = GET_NCI_P(1);
    t_559 = GET_NCI_P(2);
    t_560 = GET_NCI_P(3);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    arg1 = PMC_int_val(t_558);
    arg2 = PMC_int_val(t_559);
    arg3 = PMC_int_val(t_560);
    return_data =  (int)(*pointer)(PMC_data(t_557),&arg1,&arg2,&arg3);
    PMC_int_val(t_558) = arg1;
    PMC_int_val(t_559) = arg2;
    PMC_int_val(t_560) = arg3;
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_i_p333333(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(void *, int *, int *, int *, int *, int *, int *);
    func_t pointer;
    call_state st;
    int return_data;
    int  arg1;
    int  arg2;
    int  arg3;
    int  arg4;
    int  arg5;
    int  arg6;
    PMC *t_561;
    PMC *t_562;
    PMC *t_563;
    PMC *t_564;
    PMC *t_565;
    PMC *t_566;
    PMC *t_567;
    Parrot_init_arg_nci(interp, &st, "PPPPPPP");
    t_561 = GET_NCI_P(0);
    t_562 = GET_NCI_P(1);
    t_563 = GET_NCI_P(2);
    t_564 = GET_NCI_P(3);
    t_565 = GET_NCI_P(4);
    t_566 = GET_NCI_P(5);
    t_567 = GET_NCI_P(6);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    arg1 = PMC_int_val(t_562);
    arg2 = PMC_int_val(t_563);
    arg3 = PMC_int_val(t_564);
    arg4 = PMC_int_val(t_565);
    arg5 = PMC_int_val(t_566);
    arg6 = PMC_int_val(t_567);
    return_data =  (int)(*pointer)(PMC_data(t_561),&arg1,&arg2,&arg3,&arg4,&arg5,&arg6);
    PMC_int_val(t_562) = arg1;
    PMC_int_val(t_563) = arg2;
    PMC_int_val(t_564) = arg3;
    PMC_int_val(t_565) = arg4;
    PMC_int_val(t_566) = arg5;
    PMC_int_val(t_567) = arg6;
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_i_p4(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(void *, long *);
    func_t pointer;
    call_state st;
    int return_data;
    long  arg1;
    PMC *t_568;
    PMC *t_569;
    Parrot_init_arg_nci(interp, &st, "PP");
    t_568 = GET_NCI_P(0);
    t_569 = GET_NCI_P(1);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    arg1 = PMC_int_val(t_569);
    return_data =  (int)(*pointer)(PMC_data(t_568),&arg1);
    PMC_int_val(t_569) = arg1;
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_i_p42p(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(void *, long *, short *, void *);
    func_t pointer;
    call_state st;
    int return_data;
    long  arg1;
    short  arg2;
    PMC *t_570;
    PMC *t_571;
    PMC *t_572;
    PMC *t_573;
    Parrot_init_arg_nci(interp, &st, "PPPP");
    t_570 = GET_NCI_P(0);
    t_571 = GET_NCI_P(1);
    t_572 = GET_NCI_P(2);
    t_573 = GET_NCI_P(3);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    arg1 = PMC_int_val(t_571);
    arg2 = PMC_int_val(t_572);
    return_data =  (int)(*pointer)(PMC_data(t_570),&arg1,&arg2,PMC_data(t_573));
    PMC_int_val(t_571) = arg1;
    PMC_int_val(t_572) = arg2;
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_i_p4i(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(void *, long *, int);
    func_t pointer;
    call_state st;
    int return_data;
    long  arg1;
    PMC *t_574;
    PMC *t_575;
    int t_576;
    Parrot_init_arg_nci(interp, &st, "PPI");
    t_574 = GET_NCI_P(0);
    t_575 = GET_NCI_P(1);
    t_576 = (int)GET_NCI_I(2);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    arg1 = PMC_int_val(t_575);
    return_data =  (int)(*pointer)(PMC_data(t_574),&arg1,t_576);
    PMC_int_val(t_575) = arg1;
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_i_pb(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(void *, void *);
    func_t pointer;
    call_state st;
    int return_data;
    
    PMC *t_577;
    STRING *t_578;
    Parrot_init_arg_nci(interp, &st, "PS");
    t_577 = GET_NCI_P(0);
    t_578 = GET_NCI_S(1);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(PMC_data(t_577),PObj_bufstart(t_578));
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_i_pii(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(void *, int, int);
    func_t pointer;
    call_state st;
    int return_data;
    
    PMC *t_579;
    int t_580;
    int t_581;
    Parrot_init_arg_nci(interp, &st, "PII");
    t_579 = GET_NCI_P(0);
    t_580 = (int)GET_NCI_I(1);
    t_581 = (int)GET_NCI_I(2);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(PMC_data(t_579),t_580,t_581);
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_i_pii4(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(void *, int, int, long *);
    func_t pointer;
    call_state st;
    int return_data;
    long  arg3;
    PMC *t_582;
    int t_583;
    int t_584;
    PMC *t_585;
    Parrot_init_arg_nci(interp, &st, "PIIP");
    t_582 = GET_NCI_P(0);
    t_583 = (int)GET_NCI_I(1);
    t_584 = (int)GET_NCI_I(2);
    t_585 = GET_NCI_P(3);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    arg3 = PMC_int_val(t_585);
    return_data =  (int)(*pointer)(PMC_data(t_582),t_583,t_584,&arg3);
    PMC_int_val(t_585) = arg3;
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_i_pii4i(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(void *, int, int, long *, int);
    func_t pointer;
    call_state st;
    int return_data;
    long  arg3;
    PMC *t_586;
    int t_587;
    int t_588;
    PMC *t_589;
    int t_590;
    Parrot_init_arg_nci(interp, &st, "PIIPI");
    t_586 = GET_NCI_P(0);
    t_587 = (int)GET_NCI_I(1);
    t_588 = (int)GET_NCI_I(2);
    t_589 = GET_NCI_P(3);
    t_590 = (int)GET_NCI_I(4);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    arg3 = PMC_int_val(t_589);
    return_data =  (int)(*pointer)(PMC_data(t_586),t_587,t_588,&arg3,t_590);
    PMC_int_val(t_589) = arg3;
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_i_piii(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(void *, int, int, int);
    func_t pointer;
    call_state st;
    int return_data;
    
    PMC *t_591;
    int t_592;
    int t_593;
    int t_594;
    Parrot_init_arg_nci(interp, &st, "PIII");
    t_591 = GET_NCI_P(0);
    t_592 = (int)GET_NCI_I(1);
    t_593 = (int)GET_NCI_I(2);
    t_594 = (int)GET_NCI_I(3);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(PMC_data(t_591),t_592,t_593,t_594);
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_i_piiiiii(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(void *, int, int, int, int, int, int);
    func_t pointer;
    call_state st;
    int return_data;
    
    PMC *t_595;
    int t_596;
    int t_597;
    int t_598;
    int t_599;
    int t_600;
    int t_601;
    Parrot_init_arg_nci(interp, &st, "PIIIIII");
    t_595 = GET_NCI_P(0);
    t_596 = (int)GET_NCI_I(1);
    t_597 = (int)GET_NCI_I(2);
    t_598 = (int)GET_NCI_I(3);
    t_599 = (int)GET_NCI_I(4);
    t_600 = (int)GET_NCI_I(5);
    t_601 = (int)GET_NCI_I(6);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(PMC_data(t_595),t_596,t_597,t_598,t_599,t_600,t_601);
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_i_piiilsp(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(void *, int, int, int, long, short, void *);
    func_t pointer;
    call_state st;
    int return_data;
    
    PMC *t_602;
    int t_603;
    int t_604;
    int t_605;
    long t_606;
    short t_607;
    PMC *t_608;
    Parrot_init_arg_nci(interp, &st, "PIIIIIP");
    t_602 = GET_NCI_P(0);
    t_603 = (int)GET_NCI_I(1);
    t_604 = (int)GET_NCI_I(2);
    t_605 = (int)GET_NCI_I(3);
    t_606 = (long)GET_NCI_I(4);
    t_607 = (short)GET_NCI_I(5);
    t_608 = GET_NCI_P(6);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(PMC_data(t_602),t_603,t_604,t_605,t_606,t_607,PMC_data(t_608));
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_i_piil(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(void *, int, int, long);
    func_t pointer;
    call_state st;
    int return_data;
    
    PMC *t_609;
    int t_610;
    int t_611;
    long t_612;
    Parrot_init_arg_nci(interp, &st, "PIII");
    t_609 = GET_NCI_P(0);
    t_610 = (int)GET_NCI_I(1);
    t_611 = (int)GET_NCI_I(2);
    t_612 = (long)GET_NCI_I(3);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(PMC_data(t_609),t_610,t_611,t_612);
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_i_piili(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(void *, int, int, long, int);
    func_t pointer;
    call_state st;
    int return_data;
    
    PMC *t_613;
    int t_614;
    int t_615;
    long t_616;
    int t_617;
    Parrot_init_arg_nci(interp, &st, "PIIII");
    t_613 = GET_NCI_P(0);
    t_614 = (int)GET_NCI_I(1);
    t_615 = (int)GET_NCI_I(2);
    t_616 = (long)GET_NCI_I(3);
    t_617 = (int)GET_NCI_I(4);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(PMC_data(t_613),t_614,t_615,t_616,t_617);
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_i_piit(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(void *, int, int, char *);
    func_t pointer;
    call_state st;
    int return_data;
    
    PMC *t_618;
    int t_619;
    int t_620;
    char *t_621;
    Parrot_init_arg_nci(interp, &st, "PIIS");
    t_618 = GET_NCI_P(0);
    t_619 = (int)GET_NCI_I(1);
    t_620 = (int)GET_NCI_I(2);
    {STRING * s= GET_NCI_S(3); t_621 = s ? string_to_cstring(interp, s) : (char *) NULL;}

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(PMC_data(t_618),t_619,t_620,t_621);
    
    set_nci_I(interp, &st, return_data);
    do { if (t_621) string_cstring_free(t_621); } while (0);
}
static void
pcf_i_piiti(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(void *, int, int, char *, int);
    func_t pointer;
    call_state st;
    int return_data;
    
    PMC *t_622;
    int t_623;
    int t_624;
    char *t_625;
    int t_626;
    Parrot_init_arg_nci(interp, &st, "PIISI");
    t_622 = GET_NCI_P(0);
    t_623 = (int)GET_NCI_I(1);
    t_624 = (int)GET_NCI_I(2);
    {STRING * s= GET_NCI_S(3); t_625 = s ? string_to_cstring(interp, s) : (char *) NULL;}
    t_626 = (int)GET_NCI_I(4);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(PMC_data(t_622),t_623,t_624,t_625,t_626);
    
    set_nci_I(interp, &st, return_data);
    do { if (t_625) string_cstring_free(t_625); } while (0);
}
static void
pcf_i_pilsp(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(void *, int, long, short, void *);
    func_t pointer;
    call_state st;
    int return_data;
    
    PMC *t_627;
    int t_628;
    long t_629;
    short t_630;
    PMC *t_631;
    Parrot_init_arg_nci(interp, &st, "PIIIP");
    t_627 = GET_NCI_P(0);
    t_628 = (int)GET_NCI_I(1);
    t_629 = (long)GET_NCI_I(2);
    t_630 = (short)GET_NCI_I(3);
    t_631 = GET_NCI_P(4);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(PMC_data(t_627),t_628,t_629,t_630,PMC_data(t_631));
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_i_pli(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(void *, long, int);
    func_t pointer;
    call_state st;
    int return_data;
    
    PMC *t_632;
    long t_633;
    int t_634;
    Parrot_init_arg_nci(interp, &st, "PII");
    t_632 = GET_NCI_P(0);
    t_633 = (long)GET_NCI_I(1);
    t_634 = (int)GET_NCI_I(2);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(PMC_data(t_632),t_633,t_634);
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_i_pll(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(void *, long, long);
    func_t pointer;
    call_state st;
    int return_data;
    
    PMC *t_635;
    long t_636;
    long t_637;
    Parrot_init_arg_nci(interp, &st, "PII");
    t_635 = GET_NCI_P(0);
    t_636 = (long)GET_NCI_I(1);
    t_637 = (long)GET_NCI_I(2);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(PMC_data(t_635),t_636,t_637);
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_i_pllllllll(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(void *, long, long, long, long, long, long, long, long);
    func_t pointer;
    call_state st;
    int return_data;
    
    PMC *t_638;
    long t_639;
    long t_640;
    long t_641;
    long t_642;
    long t_643;
    long t_644;
    long t_645;
    long t_646;
    Parrot_init_arg_nci(interp, &st, "PIIIIIIII");
    t_638 = GET_NCI_P(0);
    t_639 = (long)GET_NCI_I(1);
    t_640 = (long)GET_NCI_I(2);
    t_641 = (long)GET_NCI_I(3);
    t_642 = (long)GET_NCI_I(4);
    t_643 = (long)GET_NCI_I(5);
    t_644 = (long)GET_NCI_I(6);
    t_645 = (long)GET_NCI_I(7);
    t_646 = (long)GET_NCI_I(8);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(PMC_data(t_638),t_639,t_640,t_641,t_642,t_643,t_644,t_645,t_646);
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_i_plp(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(void *, long, void *);
    func_t pointer;
    call_state st;
    int return_data;
    
    PMC *t_647;
    long t_648;
    PMC *t_649;
    Parrot_init_arg_nci(interp, &st, "PIP");
    t_647 = GET_NCI_P(0);
    t_648 = (long)GET_NCI_I(1);
    t_649 = GET_NCI_P(2);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(PMC_data(t_647),t_648,PMC_data(t_649));
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_i_plsp(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(void *, long, short, void *);
    func_t pointer;
    call_state st;
    int return_data;
    
    PMC *t_650;
    long t_651;
    short t_652;
    PMC *t_653;
    Parrot_init_arg_nci(interp, &st, "PIIP");
    t_650 = GET_NCI_P(0);
    t_651 = (long)GET_NCI_I(1);
    t_652 = (short)GET_NCI_I(2);
    t_653 = GET_NCI_P(3);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(PMC_data(t_650),t_651,t_652,PMC_data(t_653));
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_i_pp(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(void *, void *);
    func_t pointer;
    call_state st;
    int return_data;
    
    PMC *t_654;
    PMC *t_655;
    Parrot_init_arg_nci(interp, &st, "PP");
    t_654 = GET_NCI_P(0);
    t_655 = GET_NCI_P(1);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(PMC_data(t_654),PMC_data(t_655));
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_i_ppi(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(void *, void *, int);
    func_t pointer;
    call_state st;
    int return_data;
    
    PMC *t_656;
    PMC *t_657;
    int t_658;
    Parrot_init_arg_nci(interp, &st, "PPI");
    t_656 = GET_NCI_P(0);
    t_657 = GET_NCI_P(1);
    t_658 = (int)GET_NCI_I(2);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(PMC_data(t_656),PMC_data(t_657),t_658);
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_i_ppiiiiiiii(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(void *, void *, int, int, int, int, int, int, int, int);
    func_t pointer;
    call_state st;
    int return_data;
    
    PMC *t_659;
    PMC *t_660;
    int t_661;
    int t_662;
    int t_663;
    int t_664;
    int t_665;
    int t_666;
    int t_667;
    int t_668;
    Parrot_init_arg_nci(interp, &st, "PPIIIIIIII");
    t_659 = GET_NCI_P(0);
    t_660 = GET_NCI_P(1);
    t_661 = (int)GET_NCI_I(2);
    t_662 = (int)GET_NCI_I(3);
    t_663 = (int)GET_NCI_I(4);
    t_664 = (int)GET_NCI_I(5);
    t_665 = (int)GET_NCI_I(6);
    t_666 = (int)GET_NCI_I(7);
    t_667 = (int)GET_NCI_I(8);
    t_668 = (int)GET_NCI_I(9);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(PMC_data(t_659),PMC_data(t_660),t_661,t_662,t_663,t_664,t_665,t_666,t_667,t_668);
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_i_pppp(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(void *, void *, void *, void *);
    func_t pointer;
    call_state st;
    int return_data;
    
    PMC *t_669;
    PMC *t_670;
    PMC *t_671;
    PMC *t_672;
    Parrot_init_arg_nci(interp, &st, "PPPP");
    t_669 = GET_NCI_P(0);
    t_670 = GET_NCI_P(1);
    t_671 = GET_NCI_P(2);
    t_672 = GET_NCI_P(3);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(PMC_data(t_669),PMC_data(t_670),PMC_data(t_671),PMC_data(t_672));
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_i_psp(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(void *, short, void *);
    func_t pointer;
    call_state st;
    int return_data;
    
    PMC *t_673;
    short t_674;
    PMC *t_675;
    Parrot_init_arg_nci(interp, &st, "PIP");
    t_673 = GET_NCI_P(0);
    t_674 = (short)GET_NCI_I(1);
    t_675 = GET_NCI_P(2);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(PMC_data(t_673),t_674,PMC_data(t_675));
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_i_pti(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(void *, char *, int);
    func_t pointer;
    call_state st;
    int return_data;
    
    PMC *t_676;
    char *t_677;
    int t_678;
    Parrot_init_arg_nci(interp, &st, "PSI");
    t_676 = GET_NCI_P(0);
    {STRING * s= GET_NCI_S(1); t_677 = s ? string_to_cstring(interp, s) : (char *) NULL;}
    t_678 = (int)GET_NCI_I(2);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(PMC_data(t_676),t_677,t_678);
    
    set_nci_I(interp, &st, return_data);
    do { if (t_677) string_cstring_free(t_677); } while (0);
}
static void
pcf_i_pitl(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(void *, int, char *, long);
    func_t pointer;
    call_state st;
    int return_data;
    
    PMC *t_679;
    int t_680;
    char *t_681;
    long t_682;
    Parrot_init_arg_nci(interp, &st, "PISI");
    t_679 = GET_NCI_P(0);
    t_680 = (int)GET_NCI_I(1);
    {STRING * s= GET_NCI_S(2); t_681 = s ? string_to_cstring(interp, s) : (char *) NULL;}
    t_682 = (long)GET_NCI_I(3);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(PMC_data(t_679),t_680,t_681,t_682);
    
    set_nci_I(interp, &st, return_data);
    do { if (t_681) string_cstring_free(t_681); } while (0);
}
static void
pcf_i_s(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(short);
    func_t pointer;
    call_state st;
    int return_data;
    
    short t_683;
    Parrot_init_arg_nci(interp, &st, "I");
    t_683 = (short)GET_NCI_I(0);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(t_683);
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_i_s22(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(short, short *, short *);
    func_t pointer;
    call_state st;
    int return_data;
    short  arg1;
    short  arg2;
    short t_684;
    PMC *t_685;
    PMC *t_686;
    Parrot_init_arg_nci(interp, &st, "IPP");
    t_684 = (short)GET_NCI_I(0);
    t_685 = GET_NCI_P(1);
    t_686 = GET_NCI_P(2);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    arg1 = PMC_int_val(t_685);
    arg2 = PMC_int_val(t_686);
    return_data =  (int)(*pointer)(t_684,&arg1,&arg2);
    PMC_int_val(t_685) = arg1;
    PMC_int_val(t_686) = arg2;
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_i_s222(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(short, short *, short *, short *);
    func_t pointer;
    call_state st;
    int return_data;
    short  arg1;
    short  arg2;
    short  arg3;
    short t_687;
    PMC *t_688;
    PMC *t_689;
    PMC *t_690;
    Parrot_init_arg_nci(interp, &st, "IPPP");
    t_687 = (short)GET_NCI_I(0);
    t_688 = GET_NCI_P(1);
    t_689 = GET_NCI_P(2);
    t_690 = GET_NCI_P(3);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    arg1 = PMC_int_val(t_688);
    arg2 = PMC_int_val(t_689);
    arg3 = PMC_int_val(t_690);
    return_data =  (int)(*pointer)(t_687,&arg1,&arg2,&arg3);
    PMC_int_val(t_688) = arg1;
    PMC_int_val(t_689) = arg2;
    PMC_int_val(t_690) = arg3;
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_i_sp(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(short, void *);
    func_t pointer;
    call_state st;
    int return_data;
    
    short t_691;
    PMC *t_692;
    Parrot_init_arg_nci(interp, &st, "IP");
    t_691 = (short)GET_NCI_I(0);
    t_692 = GET_NCI_P(1);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(t_691,PMC_data(t_692));
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_i_sss(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(short, short, short);
    func_t pointer;
    call_state st;
    int return_data;
    
    short t_693;
    short t_694;
    short t_695;
    Parrot_init_arg_nci(interp, &st, "III");
    t_693 = (short)GET_NCI_I(0);
    t_694 = (short)GET_NCI_I(1);
    t_695 = (short)GET_NCI_I(2);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(t_693,t_694,t_695);
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_i_ssss(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(short, short, short, short);
    func_t pointer;
    call_state st;
    int return_data;
    
    short t_696;
    short t_697;
    short t_698;
    short t_699;
    Parrot_init_arg_nci(interp, &st, "IIII");
    t_696 = (short)GET_NCI_I(0);
    t_697 = (short)GET_NCI_I(1);
    t_698 = (short)GET_NCI_I(2);
    t_699 = (short)GET_NCI_I(3);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(t_696,t_697,t_698,t_699);
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_i_t(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(char *);
    func_t pointer;
    call_state st;
    int return_data;
    
    char *t_700;
    Parrot_init_arg_nci(interp, &st, "S");
    {STRING * s= GET_NCI_S(0); t_700 = s ? string_to_cstring(interp, s) : (char *) NULL;}

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(t_700);
    
    set_nci_I(interp, &st, return_data);
    do { if (t_700) string_cstring_free(t_700); } while (0);
}
static void
pcf_i_ti(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(char *, int);
    func_t pointer;
    call_state st;
    int return_data;
    
    char *t_701;
    int t_702;
    Parrot_init_arg_nci(interp, &st, "SI");
    {STRING * s= GET_NCI_S(0); t_701 = s ? string_to_cstring(interp, s) : (char *) NULL;}
    t_702 = (int)GET_NCI_I(1);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(t_701,t_702);
    
    set_nci_I(interp, &st, return_data);
    do { if (t_701) string_cstring_free(t_701); } while (0);
}
static void
pcf_i_4(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(long *);
    func_t pointer;
    call_state st;
    int return_data;
    long  arg0;
    PMC *t_703;
    Parrot_init_arg_nci(interp, &st, "P");
    t_703 = GET_NCI_P(0);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    arg0 = PMC_int_val(t_703);
    return_data =  (int)(*pointer)(&arg0);
    PMC_int_val(t_703) = arg0;
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_i_4i(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(long *, int);
    func_t pointer;
    call_state st;
    int return_data;
    long  arg0;
    PMC *t_704;
    int t_705;
    Parrot_init_arg_nci(interp, &st, "PI");
    t_704 = GET_NCI_P(0);
    t_705 = (int)GET_NCI_I(1);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    arg0 = PMC_int_val(t_704);
    return_data =  (int)(*pointer)(&arg0,t_705);
    PMC_int_val(t_704) = arg0;
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_i_42p(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(long *, short *, void *);
    func_t pointer;
    call_state st;
    int return_data;
    long  arg0;
    short  arg1;
    PMC *t_706;
    PMC *t_707;
    PMC *t_708;
    Parrot_init_arg_nci(interp, &st, "PPP");
    t_706 = GET_NCI_P(0);
    t_707 = GET_NCI_P(1);
    t_708 = GET_NCI_P(2);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    arg0 = PMC_int_val(t_706);
    arg1 = PMC_int_val(t_707);
    return_data =  (int)(*pointer)(&arg0,&arg1,PMC_data(t_708));
    PMC_int_val(t_706) = arg0;
    PMC_int_val(t_707) = arg1;
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_l_ii(PARROT_INTERP, PMC *self)
{
    typedef long (*func_t)(int, int);
    func_t pointer;
    call_state st;
    long return_data;
    
    int t_709;
    int t_710;
    Parrot_init_arg_nci(interp, &st, "II");
    t_709 = (int)GET_NCI_I(0);
    t_710 = (int)GET_NCI_I(1);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (long)(*pointer)(t_709,t_710);
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_l_l4(PARROT_INTERP, PMC *self)
{
    typedef long (*func_t)(long, long *);
    func_t pointer;
    call_state st;
    long return_data;
    long  arg1;
    long t_711;
    PMC *t_712;
    Parrot_init_arg_nci(interp, &st, "IP");
    t_711 = (long)GET_NCI_I(0);
    t_712 = GET_NCI_P(1);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    arg1 = PMC_int_val(t_712);
    return_data =  (long)(*pointer)(t_711,&arg1);
    PMC_int_val(t_712) = arg1;
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_l_pi(PARROT_INTERP, PMC *self)
{
    typedef long (*func_t)(void *, int);
    func_t pointer;
    call_state st;
    long return_data;
    
    PMC *t_713;
    int t_714;
    Parrot_init_arg_nci(interp, &st, "PI");
    t_713 = GET_NCI_P(0);
    t_714 = (int)GET_NCI_I(1);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (long)(*pointer)(PMC_data(t_713),t_714);
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_l_pii(PARROT_INTERP, PMC *self)
{
    typedef long (*func_t)(void *, int, int);
    func_t pointer;
    call_state st;
    long return_data;
    
    PMC *t_715;
    int t_716;
    int t_717;
    Parrot_init_arg_nci(interp, &st, "PII");
    t_715 = GET_NCI_P(0);
    t_716 = (int)GET_NCI_I(1);
    t_717 = (int)GET_NCI_I(2);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (long)(*pointer)(PMC_data(t_715),t_716,t_717);
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_l_p33l(PARROT_INTERP, PMC *self)
{
    typedef long (*func_t)(void *, int *, int *, long);
    func_t pointer;
    call_state st;
    long return_data;
    int  arg1;
    int  arg2;
    PMC *t_718;
    PMC *t_719;
    PMC *t_720;
    long t_721;
    Parrot_init_arg_nci(interp, &st, "PPPI");
    t_718 = GET_NCI_P(0);
    t_719 = GET_NCI_P(1);
    t_720 = GET_NCI_P(2);
    t_721 = (long)GET_NCI_I(3);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    arg1 = PMC_int_val(t_719);
    arg2 = PMC_int_val(t_720);
    return_data =  (long)(*pointer)(PMC_data(t_718),&arg1,&arg2,t_721);
    PMC_int_val(t_719) = arg1;
    PMC_int_val(t_720) = arg2;
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_l_33l(PARROT_INTERP, PMC *self)
{
    typedef long (*func_t)(int *, int *, long);
    func_t pointer;
    call_state st;
    long return_data;
    int  arg0;
    int  arg1;
    PMC *t_722;
    PMC *t_723;
    long t_724;
    Parrot_init_arg_nci(interp, &st, "PPI");
    t_722 = GET_NCI_P(0);
    t_723 = GET_NCI_P(1);
    t_724 = (long)GET_NCI_I(2);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    arg0 = PMC_int_val(t_722);
    arg1 = PMC_int_val(t_723);
    return_data =  (long)(*pointer)(&arg0,&arg1,t_724);
    PMC_int_val(t_722) = arg0;
    PMC_int_val(t_723) = arg1;
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_p_(PARROT_INTERP, PMC *self)
{
    void * (*pointer)(void);
    void * return_data;
    PMC * const final_destination = pmc_new(interp, enum_class_UnManagedStruct);
    call_state st;
    

    pointer =  (void * (*)(void))D2FPTR(PMC_struct_val(self));
    return_data =  (void *)(*pointer)();
    PMC_data(final_destination) = return_data;    set_nci_P(interp, &st, final_destination);
    
}
static void
pcf_p_B(PARROT_INTERP, PMC *self)
{
    typedef void * (*func_t)(void **);
    func_t pointer;
    call_state st;
    void * return_data;
    
    PMC * const final_destination = pmc_new(interp, enum_class_UnManagedStruct);char *s_725;
    char *t_725;
    void** v_725 = (void **) &t_725;
    Parrot_init_arg_nci(interp, &st, "S");
    {STRING * s= GET_NCI_S(0); t_725 = s ? string_to_cstring(interp, s) : (char *) NULL; s_725 = t_725;}

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (void *)(*pointer)(v_725);
    
    PMC_data(final_destination) = return_data;    set_nci_P(interp, &st, final_destination);
    do { if (s_725) string_cstring_free(s_725); } while (0);
}
static void
pcf_p_b(PARROT_INTERP, PMC *self)
{
    typedef void * (*func_t)(void *);
    func_t pointer;
    call_state st;
    void * return_data;
    
    PMC * const final_destination = pmc_new(interp, enum_class_UnManagedStruct);STRING *t_726;
    Parrot_init_arg_nci(interp, &st, "S");
    t_726 = GET_NCI_S(0);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (void *)(*pointer)(PObj_bufstart(t_726));
    
    PMC_data(final_destination) = return_data;    set_nci_P(interp, &st, final_destination);
    
}
static void
pcf_p_Jt(PARROT_INTERP, PMC *self)
{
    typedef void * (*func_t)(PARROT_INTERP, char *);
    func_t pointer;
    call_state st;
    void * return_data;
    
    PMC * const final_destination = pmc_new(interp, enum_class_UnManagedStruct);char *t_728;
    Parrot_init_arg_nci(interp, &st, "S");
    {STRING * s= GET_NCI_S(0); t_728 = s ? string_to_cstring(interp, s) : (char *) NULL;}

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (void *)(*pointer)(interp,t_728);
    
    PMC_data(final_destination) = return_data;    set_nci_P(interp, &st, final_destination);
    do { if (t_728) string_cstring_free(t_728); } while (0);
}
static void
pcf_p_i(PARROT_INTERP, PMC *self)
{
    typedef void * (*func_t)(int);
    func_t pointer;
    call_state st;
    void * return_data;
    
    PMC * const final_destination = pmc_new(interp, enum_class_UnManagedStruct);int t_729;
    Parrot_init_arg_nci(interp, &st, "I");
    t_729 = (int)GET_NCI_I(0);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (void *)(*pointer)(t_729);
    
    PMC_data(final_destination) = return_data;    set_nci_P(interp, &st, final_destination);
    
}
static void
pcf_p_ii(PARROT_INTERP, PMC *self)
{
    typedef void * (*func_t)(int, int);
    func_t pointer;
    call_state st;
    void * return_data;
    
    PMC * const final_destination = pmc_new(interp, enum_class_UnManagedStruct);int t_730;
    int t_731;
    Parrot_init_arg_nci(interp, &st, "II");
    t_730 = (int)GET_NCI_I(0);
    t_731 = (int)GET_NCI_I(1);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (void *)(*pointer)(t_730,t_731);
    
    PMC_data(final_destination) = return_data;    set_nci_P(interp, &st, final_destination);
    
}
static void
pcf_p_iiii(PARROT_INTERP, PMC *self)
{
    typedef void * (*func_t)(int, int, int, int);
    func_t pointer;
    call_state st;
    void * return_data;
    
    PMC * const final_destination = pmc_new(interp, enum_class_UnManagedStruct);int t_732;
    int t_733;
    int t_734;
    int t_735;
    Parrot_init_arg_nci(interp, &st, "IIII");
    t_732 = (int)GET_NCI_I(0);
    t_733 = (int)GET_NCI_I(1);
    t_734 = (int)GET_NCI_I(2);
    t_735 = (int)GET_NCI_I(3);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (void *)(*pointer)(t_732,t_733,t_734,t_735);
    
    PMC_data(final_destination) = return_data;    set_nci_P(interp, &st, final_destination);
    
}
static void
pcf_p_iiiiii(PARROT_INTERP, PMC *self)
{
    typedef void * (*func_t)(int, int, int, int, int, int);
    func_t pointer;
    call_state st;
    void * return_data;
    
    PMC * const final_destination = pmc_new(interp, enum_class_UnManagedStruct);int t_736;
    int t_737;
    int t_738;
    int t_739;
    int t_740;
    int t_741;
    Parrot_init_arg_nci(interp, &st, "IIIIII");
    t_736 = (int)GET_NCI_I(0);
    t_737 = (int)GET_NCI_I(1);
    t_738 = (int)GET_NCI_I(2);
    t_739 = (int)GET_NCI_I(3);
    t_740 = (int)GET_NCI_I(4);
    t_741 = (int)GET_NCI_I(5);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (void *)(*pointer)(t_736,t_737,t_738,t_739,t_740,t_741);
    
    PMC_data(final_destination) = return_data;    set_nci_P(interp, &st, final_destination);
    
}
static void
pcf_p_iiiiiiii(PARROT_INTERP, PMC *self)
{
    typedef void * (*func_t)(int, int, int, int, int, int, int, int);
    func_t pointer;
    call_state st;
    void * return_data;
    
    PMC * const final_destination = pmc_new(interp, enum_class_UnManagedStruct);int t_742;
    int t_743;
    int t_744;
    int t_745;
    int t_746;
    int t_747;
    int t_748;
    int t_749;
    Parrot_init_arg_nci(interp, &st, "IIIIIIII");
    t_742 = (int)GET_NCI_I(0);
    t_743 = (int)GET_NCI_I(1);
    t_744 = (int)GET_NCI_I(2);
    t_745 = (int)GET_NCI_I(3);
    t_746 = (int)GET_NCI_I(4);
    t_747 = (int)GET_NCI_I(5);
    t_748 = (int)GET_NCI_I(6);
    t_749 = (int)GET_NCI_I(7);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (void *)(*pointer)(t_742,t_743,t_744,t_745,t_746,t_747,t_748,t_749);
    
    PMC_data(final_destination) = return_data;    set_nci_P(interp, &st, final_destination);
    
}
static void
pcf_p_pii(PARROT_INTERP, PMC *self)
{
    typedef void * (*func_t)(void *, int, int);
    func_t pointer;
    call_state st;
    void * return_data;
    
    PMC * const final_destination = pmc_new(interp, enum_class_UnManagedStruct);PMC *t_750;
    int t_751;
    int t_752;
    Parrot_init_arg_nci(interp, &st, "PII");
    t_750 = GET_NCI_P(0);
    t_751 = (int)GET_NCI_I(1);
    t_752 = (int)GET_NCI_I(2);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (void *)(*pointer)(PMC_data(t_750),t_751,t_752);
    
    PMC_data(final_destination) = return_data;    set_nci_P(interp, &st, final_destination);
    
}
static void
pcf_p_piiii(PARROT_INTERP, PMC *self)
{
    typedef void * (*func_t)(void *, int, int, int, int);
    func_t pointer;
    call_state st;
    void * return_data;
    
    PMC * const final_destination = pmc_new(interp, enum_class_UnManagedStruct);PMC *t_753;
    int t_754;
    int t_755;
    int t_756;
    int t_757;
    Parrot_init_arg_nci(interp, &st, "PIIII");
    t_753 = GET_NCI_P(0);
    t_754 = (int)GET_NCI_I(1);
    t_755 = (int)GET_NCI_I(2);
    t_756 = (int)GET_NCI_I(3);
    t_757 = (int)GET_NCI_I(4);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (void *)(*pointer)(PMC_data(t_753),t_754,t_755,t_756,t_757);
    
    PMC_data(final_destination) = return_data;    set_nci_P(interp, &st, final_destination);
    
}
static void
pcf_p_t(PARROT_INTERP, PMC *self)
{
    typedef void * (*func_t)(char *);
    func_t pointer;
    call_state st;
    void * return_data;
    
    PMC * const final_destination = pmc_new(interp, enum_class_UnManagedStruct);char *t_758;
    Parrot_init_arg_nci(interp, &st, "S");
    {STRING * s= GET_NCI_S(0); t_758 = s ? string_to_cstring(interp, s) : (char *) NULL;}

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (void *)(*pointer)(t_758);
    
    PMC_data(final_destination) = return_data;    set_nci_P(interp, &st, final_destination);
    do { if (t_758) string_cstring_free(t_758); } while (0);
}
static void
pcf_p_tpp(PARROT_INTERP, PMC *self)
{
    typedef void * (*func_t)(char *, void *, void *);
    func_t pointer;
    call_state st;
    void * return_data;
    
    PMC * const final_destination = pmc_new(interp, enum_class_UnManagedStruct);char *t_759;
    PMC *t_760;
    PMC *t_761;
    Parrot_init_arg_nci(interp, &st, "SPP");
    {STRING * s= GET_NCI_S(0); t_759 = s ? string_to_cstring(interp, s) : (char *) NULL;}
    t_760 = GET_NCI_P(1);
    t_761 = GET_NCI_P(2);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (void *)(*pointer)(t_759,PMC_data(t_760),PMC_data(t_761));
    
    PMC_data(final_destination) = return_data;    set_nci_P(interp, &st, final_destination);
    do { if (t_759) string_cstring_free(t_759); } while (0);
}
static void
pcf_p_ttttttt(PARROT_INTERP, PMC *self)
{
    typedef void * (*func_t)(char *, char *, char *, char *, char *, char *, char *);
    func_t pointer;
    call_state st;
    void * return_data;
    
    PMC * const final_destination = pmc_new(interp, enum_class_UnManagedStruct);char *t_762;
    char *t_763;
    char *t_764;
    char *t_765;
    char *t_766;
    char *t_767;
    char *t_768;
    Parrot_init_arg_nci(interp, &st, "SSSSSSS");
    {STRING * s= GET_NCI_S(0); t_762 = s ? string_to_cstring(interp, s) : (char *) NULL;}
    {STRING * s= GET_NCI_S(1); t_763 = s ? string_to_cstring(interp, s) : (char *) NULL;}
    {STRING * s= GET_NCI_S(2); t_764 = s ? string_to_cstring(interp, s) : (char *) NULL;}
    {STRING * s= GET_NCI_S(3); t_765 = s ? string_to_cstring(interp, s) : (char *) NULL;}
    {STRING * s= GET_NCI_S(4); t_766 = s ? string_to_cstring(interp, s) : (char *) NULL;}
    {STRING * s= GET_NCI_S(5); t_767 = s ? string_to_cstring(interp, s) : (char *) NULL;}
    {STRING * s= GET_NCI_S(6); t_768 = s ? string_to_cstring(interp, s) : (char *) NULL;}

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (void *)(*pointer)(t_762,t_763,t_764,t_765,t_766,t_767,t_768);
    
    PMC_data(final_destination) = return_data;    set_nci_P(interp, &st, final_destination);
    do { if (t_762) string_cstring_free(t_762); } while (0);
    do { if (t_763) string_cstring_free(t_763); } while (0);
    do { if (t_764) string_cstring_free(t_764); } while (0);
    do { if (t_765) string_cstring_free(t_765); } while (0);
    do { if (t_766) string_cstring_free(t_766); } while (0);
    do { if (t_767) string_cstring_free(t_767); } while (0);
    do { if (t_768) string_cstring_free(t_768); } while (0);
}
static void
pcf_s_(PARROT_INTERP, PMC *self)
{
    short (*pointer)(void);
    short return_data;
    
    call_state st;
    

    pointer =  (short (*)(void))D2FPTR(PMC_struct_val(self));
    return_data =  (short)(*pointer)();
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_t_(PARROT_INTERP, PMC *self)
{
    char * (*pointer)(void);
    char * return_data;
    STRING *final_destination;
    call_state st;
    

    pointer =  (char * (*)(void))D2FPTR(PMC_struct_val(self));
    return_data =  (char *)(*pointer)();
    final_destination = string_from_cstring(interp, return_data, 0);
    set_nci_S(interp, &st, final_destination);
    
}
static void
pcf_t_i(PARROT_INTERP, PMC *self)
{
    typedef char * (*func_t)(int);
    func_t pointer;
    call_state st;
    char * return_data;
    
    STRING *final_destination;int t_769;
    Parrot_init_arg_nci(interp, &st, "I");
    t_769 = (int)GET_NCI_I(0);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (char *)(*pointer)(t_769);
    
    final_destination = string_from_cstring(interp, return_data, 0);
    set_nci_S(interp, &st, final_destination);
    
}
static void
pcf_t_ii(PARROT_INTERP, PMC *self)
{
    typedef char * (*func_t)(int, int);
    func_t pointer;
    call_state st;
    char * return_data;
    
    STRING *final_destination;int t_770;
    int t_771;
    Parrot_init_arg_nci(interp, &st, "II");
    t_770 = (int)GET_NCI_I(0);
    t_771 = (int)GET_NCI_I(1);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (char *)(*pointer)(t_770,t_771);
    
    final_destination = string_from_cstring(interp, return_data, 0);
    set_nci_S(interp, &st, final_destination);
    
}
static void
pcf_t_pi(PARROT_INTERP, PMC *self)
{
    typedef char * (*func_t)(void *, int);
    func_t pointer;
    call_state st;
    char * return_data;
    
    STRING *final_destination;PMC *t_772;
    int t_773;
    Parrot_init_arg_nci(interp, &st, "PI");
    t_772 = GET_NCI_P(0);
    t_773 = (int)GET_NCI_I(1);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (char *)(*pointer)(PMC_data(t_772),t_773);
    
    final_destination = string_from_cstring(interp, return_data, 0);
    set_nci_S(interp, &st, final_destination);
    
}
static void
pcf_t_pii(PARROT_INTERP, PMC *self)
{
    typedef char * (*func_t)(void *, int, int);
    func_t pointer;
    call_state st;
    char * return_data;
    
    STRING *final_destination;PMC *t_774;
    int t_775;
    int t_776;
    Parrot_init_arg_nci(interp, &st, "PII");
    t_774 = GET_NCI_P(0);
    t_775 = (int)GET_NCI_I(1);
    t_776 = (int)GET_NCI_I(2);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (char *)(*pointer)(PMC_data(t_774),t_775,t_776);
    
    final_destination = string_from_cstring(interp, return_data, 0);
    set_nci_S(interp, &st, final_destination);
    
}
static void
pcf_t_t(PARROT_INTERP, PMC *self)
{
    typedef char * (*func_t)(char *);
    func_t pointer;
    call_state st;
    char * return_data;
    
    STRING *final_destination;char *t_777;
    Parrot_init_arg_nci(interp, &st, "S");
    {STRING * s= GET_NCI_S(0); t_777 = s ? string_to_cstring(interp, s) : (char *) NULL;}

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (char *)(*pointer)(t_777);
    
    final_destination = string_from_cstring(interp, return_data, 0);
    set_nci_S(interp, &st, final_destination);
    do { if (t_777) string_cstring_free(t_777); } while (0);
}
static void
pcf_t_tl4(PARROT_INTERP, PMC *self)
{
    typedef char * (*func_t)(char *, long, long *);
    func_t pointer;
    call_state st;
    char * return_data;
    long  arg2;
    STRING *final_destination;char *t_778;
    long t_779;
    PMC *t_780;
    Parrot_init_arg_nci(interp, &st, "SIP");
    {STRING * s= GET_NCI_S(0); t_778 = s ? string_to_cstring(interp, s) : (char *) NULL;}
    t_779 = (long)GET_NCI_I(1);
    t_780 = GET_NCI_P(2);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    arg2 = PMC_int_val(t_780);
    return_data =  (char *)(*pointer)(t_778,t_779,&arg2);
    PMC_int_val(t_780) = arg2;
    final_destination = string_from_cstring(interp, return_data, 0);
    set_nci_S(interp, &st, final_destination);
    do { if (t_778) string_cstring_free(t_778); } while (0);
}
static void
pcf_t_t4(PARROT_INTERP, PMC *self)
{
    typedef char * (*func_t)(char *, long *);
    func_t pointer;
    call_state st;
    char * return_data;
    long  arg1;
    STRING *final_destination;char *t_781;
    PMC *t_782;
    Parrot_init_arg_nci(interp, &st, "SP");
    {STRING * s= GET_NCI_S(0); t_781 = s ? string_to_cstring(interp, s) : (char *) NULL;}
    t_782 = GET_NCI_P(1);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    arg1 = PMC_int_val(t_782);
    return_data =  (char *)(*pointer)(t_781,&arg1);
    PMC_int_val(t_782) = arg1;
    final_destination = string_from_cstring(interp, return_data, 0);
    set_nci_S(interp, &st, final_destination);
    do { if (t_781) string_cstring_free(t_781); } while (0);
}
static void
pcf_i_sc(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(short, char);
    func_t pointer;
    call_state st;
    int return_data;
    
    short t_783;
    char t_784;
    Parrot_init_arg_nci(interp, &st, "II");
    t_783 = (short)GET_NCI_I(0);
    t_784 = (char)GET_NCI_I(1);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(t_783,t_784);
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_s_sc(PARROT_INTERP, PMC *self)
{
    typedef short (*func_t)(short, char);
    func_t pointer;
    call_state st;
    short return_data;
    
    short t_785;
    char t_786;
    Parrot_init_arg_nci(interp, &st, "II");
    t_785 = (short)GET_NCI_I(0);
    t_786 = (char)GET_NCI_I(1);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (short)(*pointer)(t_785,t_786);
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_c_sc(PARROT_INTERP, PMC *self)
{
    typedef char (*func_t)(short, char);
    func_t pointer;
    call_state st;
    char return_data;
    
    short t_787;
    char t_788;
    Parrot_init_arg_nci(interp, &st, "II");
    t_787 = (short)GET_NCI_I(0);
    t_788 = (char)GET_NCI_I(1);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (char)(*pointer)(t_787,t_788);
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_i_iii(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(int, int, int);
    func_t pointer;
    call_state st;
    int return_data;
    
    int t_789;
    int t_790;
    int t_791;
    Parrot_init_arg_nci(interp, &st, "III");
    t_789 = (int)GET_NCI_I(0);
    t_790 = (int)GET_NCI_I(1);
    t_791 = (int)GET_NCI_I(2);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(t_789,t_790,t_791);
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_i_i3(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(int, int *);
    func_t pointer;
    call_state st;
    int return_data;
    int  arg1;
    int t_792;
    PMC *t_793;
    Parrot_init_arg_nci(interp, &st, "IP");
    t_792 = (int)GET_NCI_I(0);
    t_793 = GET_NCI_P(1);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    arg1 = PMC_int_val(t_793);
    return_data =  (int)(*pointer)(t_792,&arg1);
    PMC_int_val(t_793) = arg1;
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_t_b(PARROT_INTERP, PMC *self)
{
    typedef char * (*func_t)(void *);
    func_t pointer;
    call_state st;
    char * return_data;
    
    STRING *final_destination;STRING *t_794;
    Parrot_init_arg_nci(interp, &st, "S");
    t_794 = GET_NCI_S(0);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (char *)(*pointer)(PObj_bufstart(t_794));
    
    final_destination = string_from_cstring(interp, return_data, 0);
    set_nci_S(interp, &st, final_destination);
    
}
static void
pcf_t_B(PARROT_INTERP, PMC *self)
{
    typedef char * (*func_t)(void **);
    func_t pointer;
    call_state st;
    char * return_data;
    
    STRING *final_destination;char *s_795;
    char *t_795;
    void** v_795 = (void **) &t_795;
    Parrot_init_arg_nci(interp, &st, "S");
    {STRING * s= GET_NCI_S(0); t_795 = s ? string_to_cstring(interp, s) : (char *) NULL; s_795 = t_795;}

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (char *)(*pointer)(v_795);
    
    final_destination = string_from_cstring(interp, return_data, 0);
    set_nci_S(interp, &st, final_destination);
    do { if (s_795) string_cstring_free(s_795); } while (0);
}
static void
pcf_v_P(PARROT_INTERP, PMC *self)
{
    typedef void (*func_t)(PMC *);
    func_t pointer;
    call_state st;
    
    
    PMC *t_796;
    Parrot_init_arg_nci(interp, &st, "P");
    t_796 = GET_NCI_P(0);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
     (void)(*pointer)(PMC_IS_NULL(t_796) ? NULL : t_796);
    
    
    
}
static void
pcf_v_pP(PARROT_INTERP, PMC *self)
{
    typedef void (*func_t)(void *, PMC *);
    func_t pointer;
    call_state st;
    
    
    PMC *t_797;
    PMC *t_798;
    Parrot_init_arg_nci(interp, &st, "PP");
    t_797 = GET_NCI_P(0);
    t_798 = GET_NCI_P(1);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
     (void)(*pointer)(PMC_data(t_797),PMC_IS_NULL(t_798) ? NULL : t_798);
    
    
    
}
static void
pcf_p_ip(PARROT_INTERP, PMC *self)
{
    typedef void * (*func_t)(int, void *);
    func_t pointer;
    call_state st;
    void * return_data;
    
    PMC * const final_destination = pmc_new(interp, enum_class_UnManagedStruct);int t_799;
    PMC *t_800;
    Parrot_init_arg_nci(interp, &st, "IP");
    t_799 = (int)GET_NCI_I(0);
    t_800 = GET_NCI_P(1);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (void *)(*pointer)(t_799,PMC_data(t_800));
    
    PMC_data(final_destination) = return_data;    set_nci_P(interp, &st, final_destination);
    
}
static void
pcf_i_33(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(int *, int *);
    func_t pointer;
    call_state st;
    int return_data;
    int  arg0;
    int  arg1;
    PMC *t_801;
    PMC *t_802;
    Parrot_init_arg_nci(interp, &st, "PP");
    t_801 = GET_NCI_P(0);
    t_802 = GET_NCI_P(1);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    arg0 = PMC_int_val(t_801);
    arg1 = PMC_int_val(t_802);
    return_data =  (int)(*pointer)(&arg0,&arg1);
    PMC_int_val(t_801) = arg0;
    PMC_int_val(t_802) = arg1;
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_v_pii(PARROT_INTERP, PMC *self)
{
    typedef void (*func_t)(void *, int, int);
    func_t pointer;
    call_state st;
    
    
    PMC *t_803;
    int t_804;
    int t_805;
    Parrot_init_arg_nci(interp, &st, "PII");
    t_803 = GET_NCI_P(0);
    t_804 = (int)GET_NCI_I(1);
    t_805 = (int)GET_NCI_I(2);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
     (void)(*pointer)(PMC_data(t_803),t_804,t_805);
    
    
    
}
static void
pcf_v_JO(PARROT_INTERP, PMC *self)
{
    typedef void (*func_t)(PARROT_INTERP, PMC *);
    func_t pointer;
    call_state st;
    
    
    PMC *t_807;
    Parrot_init_arg_nci(interp, &st, "P");
    t_807 = GET_NCI_P(0);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
     (void)(*pointer)(interp,PMC_IS_NULL(t_807) ? NULL : t_807);
    
    
    
}
static void
pcf_i_JO(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(PARROT_INTERP, PMC *);
    func_t pointer;
    call_state st;
    int return_data;
    
    PMC *t_809;
    Parrot_init_arg_nci(interp, &st, "P");
    t_809 = GET_NCI_P(0);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(interp,PMC_IS_NULL(t_809) ? NULL : t_809);
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_i_JOi(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(PARROT_INTERP, PMC *, int);
    func_t pointer;
    call_state st;
    int return_data;
    
    PMC *t_811;
    int t_812;
    Parrot_init_arg_nci(interp, &st, "PI");
    t_811 = GET_NCI_P(0);
    t_812 = (int)GET_NCI_I(1);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(interp,PMC_IS_NULL(t_811) ? NULL : t_811,t_812);
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_i_JOt(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(PARROT_INTERP, PMC *, char *);
    func_t pointer;
    call_state st;
    int return_data;
    
    PMC *t_814;
    char *t_815;
    Parrot_init_arg_nci(interp, &st, "PS");
    t_814 = GET_NCI_P(0);
    {STRING * s= GET_NCI_S(1); t_815 = s ? string_to_cstring(interp, s) : (char *) NULL;}

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(interp,PMC_IS_NULL(t_814) ? NULL : t_814,t_815);
    
    set_nci_I(interp, &st, return_data);
    do { if (t_815) string_cstring_free(t_815); } while (0);
}
static void
pcf_i_Jt(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(PARROT_INTERP, char *);
    func_t pointer;
    call_state st;
    int return_data;
    
    char *t_817;
    Parrot_init_arg_nci(interp, &st, "S");
    {STRING * s= GET_NCI_S(0); t_817 = s ? string_to_cstring(interp, s) : (char *) NULL;}

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(interp,t_817);
    
    set_nci_I(interp, &st, return_data);
    do { if (t_817) string_cstring_free(t_817); } while (0);
}
static void
pcf_i_Ji(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(PARROT_INTERP, int);
    func_t pointer;
    call_state st;
    int return_data;
    
    int t_819;
    Parrot_init_arg_nci(interp, &st, "I");
    t_819 = (int)GET_NCI_I(0);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(interp,t_819);
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_v_Vi(PARROT_INTERP, PMC *self)
{
    typedef void (*func_t)(void **, int);
    func_t pointer;
    call_state st;
    
    void* arg0;
    PMC *t_820;
    int t_821;
    Parrot_init_arg_nci(interp, &st, "PI");
    t_820 = GET_NCI_P(0);
    t_821 = (int)GET_NCI_I(1);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    arg0 = PMC_data(t_820);
     (void)(*pointer)(&arg0,t_821);
    PMC_data(t_820) = arg0;
    
    
}
static void
pcf_p_ppiii(PARROT_INTERP, PMC *self)
{
    typedef void * (*func_t)(void *, void *, int, int, int);
    func_t pointer;
    call_state st;
    void * return_data;
    
    PMC * const final_destination = pmc_new(interp, enum_class_UnManagedStruct);PMC *t_822;
    PMC *t_823;
    int t_824;
    int t_825;
    int t_826;
    Parrot_init_arg_nci(interp, &st, "PPIII");
    t_822 = GET_NCI_P(0);
    t_823 = GET_NCI_P(1);
    t_824 = (int)GET_NCI_I(2);
    t_825 = (int)GET_NCI_I(3);
    t_826 = (int)GET_NCI_I(4);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (void *)(*pointer)(PMC_data(t_822),PMC_data(t_823),t_824,t_825,t_826);
    
    PMC_data(final_destination) = return_data;    set_nci_P(interp, &st, final_destination);
    
}
static void
pcf_p_ppiiiiiii(PARROT_INTERP, PMC *self)
{
    typedef void * (*func_t)(void *, void *, int, int, int, int, int, int, int);
    func_t pointer;
    call_state st;
    void * return_data;
    
    PMC * const final_destination = pmc_new(interp, enum_class_UnManagedStruct);PMC *t_827;
    PMC *t_828;
    int t_829;
    int t_830;
    int t_831;
    int t_832;
    int t_833;
    int t_834;
    int t_835;
    Parrot_init_arg_nci(interp, &st, "PPIIIIIII");
    t_827 = GET_NCI_P(0);
    t_828 = GET_NCI_P(1);
    t_829 = (int)GET_NCI_I(2);
    t_830 = (int)GET_NCI_I(3);
    t_831 = (int)GET_NCI_I(4);
    t_832 = (int)GET_NCI_I(5);
    t_833 = (int)GET_NCI_I(6);
    t_834 = (int)GET_NCI_I(7);
    t_835 = (int)GET_NCI_I(8);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (void *)(*pointer)(PMC_data(t_827),PMC_data(t_828),t_829,t_830,t_831,t_832,t_833,t_834,t_835);
    
    PMC_data(final_destination) = return_data;    set_nci_P(interp, &st, final_destination);
    
}
static void
pcf_i_ppt(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(void *, void *, char *);
    func_t pointer;
    call_state st;
    int return_data;
    
    PMC *t_836;
    PMC *t_837;
    char *t_838;
    Parrot_init_arg_nci(interp, &st, "PPS");
    t_836 = GET_NCI_P(0);
    t_837 = GET_NCI_P(1);
    {STRING * s= GET_NCI_S(2); t_838 = s ? string_to_cstring(interp, s) : (char *) NULL;}

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(PMC_data(t_836),PMC_data(t_837),t_838);
    
    set_nci_I(interp, &st, return_data);
    do { if (t_838) string_cstring_free(t_838); } while (0);
}
static void
pcf_i_pppi(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(void *, void *, void *, int);
    func_t pointer;
    call_state st;
    int return_data;
    
    PMC *t_839;
    PMC *t_840;
    PMC *t_841;
    int t_842;
    Parrot_init_arg_nci(interp, &st, "PPPI");
    t_839 = GET_NCI_P(0);
    t_840 = GET_NCI_P(1);
    t_841 = GET_NCI_P(2);
    t_842 = (int)GET_NCI_I(3);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(PMC_data(t_839),PMC_data(t_840),PMC_data(t_841),t_842);
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_i_pppii(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(void *, void *, void *, int, int);
    func_t pointer;
    call_state st;
    int return_data;
    
    PMC *t_843;
    PMC *t_844;
    PMC *t_845;
    int t_846;
    int t_847;
    Parrot_init_arg_nci(interp, &st, "PPPII");
    t_843 = GET_NCI_P(0);
    t_844 = GET_NCI_P(1);
    t_845 = GET_NCI_P(2);
    t_846 = (int)GET_NCI_I(3);
    t_847 = (int)GET_NCI_I(4);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(PMC_data(t_843),PMC_data(t_844),PMC_data(t_845),t_846,t_847);
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_i_pppiiii(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(void *, void *, void *, int, int, int, int);
    func_t pointer;
    call_state st;
    int return_data;
    
    PMC *t_848;
    PMC *t_849;
    PMC *t_850;
    int t_851;
    int t_852;
    int t_853;
    int t_854;
    Parrot_init_arg_nci(interp, &st, "PPPIIII");
    t_848 = GET_NCI_P(0);
    t_849 = GET_NCI_P(1);
    t_850 = GET_NCI_P(2);
    t_851 = (int)GET_NCI_I(3);
    t_852 = (int)GET_NCI_I(4);
    t_853 = (int)GET_NCI_I(5);
    t_854 = (int)GET_NCI_I(6);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(PMC_data(t_848),PMC_data(t_849),PMC_data(t_850),t_851,t_852,t_853,t_854);
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_i_ppppiiiiii(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(void *, void *, void *, void *, int, int, int, int, int, int);
    func_t pointer;
    call_state st;
    int return_data;
    
    PMC *t_855;
    PMC *t_856;
    PMC *t_857;
    PMC *t_858;
    int t_859;
    int t_860;
    int t_861;
    int t_862;
    int t_863;
    int t_864;
    Parrot_init_arg_nci(interp, &st, "PPPPIIIIII");
    t_855 = GET_NCI_P(0);
    t_856 = GET_NCI_P(1);
    t_857 = GET_NCI_P(2);
    t_858 = GET_NCI_P(3);
    t_859 = (int)GET_NCI_I(4);
    t_860 = (int)GET_NCI_I(5);
    t_861 = (int)GET_NCI_I(6);
    t_862 = (int)GET_NCI_I(7);
    t_863 = (int)GET_NCI_I(8);
    t_864 = (int)GET_NCI_I(9);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(PMC_data(t_855),PMC_data(t_856),PMC_data(t_857),PMC_data(t_858),t_859,t_860,t_861,t_862,t_863,t_864);
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_v_fff(PARROT_INTERP, PMC *self)
{
    typedef void (*func_t)(float, float, float);
    func_t pointer;
    call_state st;
    
    
    float t_865;
    float t_866;
    float t_867;
    Parrot_init_arg_nci(interp, &st, "NNN");
    t_865 = (float)GET_NCI_N(0);
    t_866 = (float)GET_NCI_N(1);
    t_867 = (float)GET_NCI_N(2);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
     (void)(*pointer)(t_865,t_866,t_867);
    
    
    
}
static void
pcf_v_V(PARROT_INTERP, PMC *self)
{
    typedef void (*func_t)(void **);
    func_t pointer;
    call_state st;
    
    void* arg0;
    PMC *t_868;
    Parrot_init_arg_nci(interp, &st, "P");
    t_868 = GET_NCI_P(0);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    arg0 = PMC_data(t_868);
     (void)(*pointer)(&arg0);
    PMC_data(t_868) = arg0;
    
    
}
static void
pcf_i_tV(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(char *, void **);
    func_t pointer;
    call_state st;
    int return_data;
    void* arg1;
    char *t_869;
    PMC *t_870;
    Parrot_init_arg_nci(interp, &st, "SP");
    {STRING * s= GET_NCI_S(0); t_869 = s ? string_to_cstring(interp, s) : (char *) NULL;}
    t_870 = GET_NCI_P(1);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    arg1 = PMC_data(t_870);
    return_data =  (int)(*pointer)(t_869,&arg1);
    PMC_data(t_870) = arg1;
    set_nci_I(interp, &st, return_data);
    do { if (t_869) string_cstring_free(t_869); } while (0);
}
static void
pcf_i_ptiVp(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(void *, char *, int, void **, void *);
    func_t pointer;
    call_state st;
    int return_data;
    void* arg3;
    PMC *t_871;
    char *t_872;
    int t_873;
    PMC *t_874;
    PMC *t_875;
    Parrot_init_arg_nci(interp, &st, "PSIPP");
    t_871 = GET_NCI_P(0);
    {STRING * s= GET_NCI_S(1); t_872 = s ? string_to_cstring(interp, s) : (char *) NULL;}
    t_873 = (int)GET_NCI_I(2);
    t_874 = GET_NCI_P(3);
    t_875 = GET_NCI_P(4);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    arg3 = PMC_data(t_874);
    return_data =  (int)(*pointer)(PMC_data(t_871),t_872,t_873,&arg3,PMC_data(t_875));
    PMC_data(t_874) = arg3;
    set_nci_I(interp, &st, return_data);
    do { if (t_872) string_cstring_free(t_872); } while (0);
}
static void
pcf_i_pid(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(void *, int, double);
    func_t pointer;
    call_state st;
    int return_data;
    
    PMC *t_876;
    int t_877;
    double t_878;
    Parrot_init_arg_nci(interp, &st, "PIN");
    t_876 = GET_NCI_P(0);
    t_877 = (int)GET_NCI_I(1);
    t_878 = (double)GET_NCI_N(2);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(PMC_data(t_876),t_877,t_878);
    
    set_nci_I(interp, &st, return_data);
    
}
static void
pcf_i_pitii(PARROT_INTERP, PMC *self)
{
    typedef int (*func_t)(void *, int, char *, int, int);
    func_t pointer;
    call_state st;
    int return_data;
    
    PMC *t_879;
    int t_880;
    char *t_881;
    int t_882;
    int t_883;
    Parrot_init_arg_nci(interp, &st, "PISII");
    t_879 = GET_NCI_P(0);
    t_880 = (int)GET_NCI_I(1);
    {STRING * s= GET_NCI_S(2); t_881 = s ? string_to_cstring(interp, s) : (char *) NULL;}
    t_882 = (int)GET_NCI_I(3);
    t_883 = (int)GET_NCI_I(4);

    pointer =  (func_t)D2FPTR(PMC_struct_val(self));
    
    return_data =  (int)(*pointer)(PMC_data(t_879),t_880,t_881,t_882,t_883);
    
    set_nci_I(interp, &st, return_data);
    do { if (t_881) string_cstring_free(t_881); } while (0);
}


/* This function serves a single purpose. It takes the function
   signature for a C function we want to call and returns a pointer
   to a function that can call it. */
void *
build_call_func(PARROT_INTERP,
#if defined(CAN_BUILD_CALL_FRAMES)
PMC *pmc_nci,
#else
SHIM(PMC *pmc_nci),
#endif
NOTNULL(STRING *signature), NOTNULL(int *jitted))
{
    char       *c;
    STRING     *ns, *message;
    STRING     *jit_key_name;
    PMC        *b;
    PMC        *iglobals;
    PMC        *temp_pmc;
    UINTVAL    signature_len;

    PMC        *HashPointer   = NULL;

    /* And in here is the platform-independent way. Which is to say
       "here there be hacks" */
    signature_len = string_length(interp, signature);
    if (0 == signature_len)
       return F2DPTR(pcf_v_);
    /* remove deprecated void argument 'v' character */
    if (2 == signature_len && 'v' == string_index(interp, signature, 1)) {
       Parrot_warn(interp, PARROT_WARNINGS_ALL_FLAG, "function signature argument character 'v' ignored");
       string_chopn_inplace(interp, signature, 1);
       signature_len = string_length(interp, signature);
    }

    iglobals = interp->iglobals;

    if (PMC_IS_NULL(iglobals))
        PANIC(interp, "iglobals isn't created yet");
    HashPointer = VTABLE_get_pmc_keyed_int(interp, iglobals,
            IGLOBALS_NCI_FUNCS);

    if (!HashPointer) {
        HashPointer = pmc_new(interp, enum_class_Hash);
        VTABLE_set_pmc_keyed_int(interp, iglobals, IGLOBALS_NCI_FUNCS,
                HashPointer);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_d_JOd;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "dJOd"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_I_JOS;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "IJOS"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_P_JOl;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "PJOl"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_P_Jt;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "PJt"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_S_JOS;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "SJOS"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_I_JI;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "IJI"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_v_JOSP;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "vJOSP"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_v_JOS;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "vJOS"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_P_JOS;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "PJOS"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_I_JOI;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "IJOI"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_P_JOP;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "PJOP"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_P_JOPS;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "PJOPS"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_v_JOPSP;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "vJOPSP"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_v_JPPP;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "vJPPP"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_v_JPIP;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "vJPIP"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_v_JPSP;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "vJPSP"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_v_JPNP;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "vJPNP"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_v_JPP;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "vJPP"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_v_JPI;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "vJPI"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_v_JPS;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "vJPS"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_v_JPN;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "vJPN"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_P_JPPP;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "PJPPP"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_P_JPIP;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "PJPIP"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_P_JPSP;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "PJPSP"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_P_JPNP;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "PJPNP"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_I_JPP;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "IJPP"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_JP;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "iJP"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_v_JP;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "vJP"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_JPi;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "iJPi"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_JPii;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "iJPii"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_JPiii;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "iJPiii"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_JPt;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "iJPt"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_P_JOSSS;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "PJOSSS"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_v_JOSS;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "vJOSS"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_S_JOI;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "SJOI"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_v_JOb;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "vJOb"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_JOPxAT_;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "iJOP@"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_I_JOPxAT_;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "IJOP@"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_I_JOIPxAT_;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "IJOIP@"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_P_JO;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "PJO"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_v_JOP;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "vJOP"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_P_Ji;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "PJi"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_ip;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "iip"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_JPip;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "iJPip"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_JpP;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "iJpP"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_Jpii;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "iJpii"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_p;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "ip"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_tp;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "itp"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_p_J;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "pJ"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_p_Jp;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "pJp"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_t_J;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "tJ"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_t_Jpti;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "tJpti"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_t_p;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "tp"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_t_pt;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "tpt"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_v_p;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "vp"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_v_pit;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "vpit"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_v_ptt;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "vptt"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_v_Jtiiipt;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "vJtiiipt"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_p_JttPP;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "pJttPP"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_P_Jtpi;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "PJtpi"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_Vppp;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "iVppp"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_v_JpPP;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "vJpPP"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_v_pt;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "vpt"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_v_;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "v"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_v_Jiiip;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "vJiiip"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_v_i;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "vi"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_v_ii;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "vii"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_v_illllllll;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "villllllll"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_v_l;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "vl"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_v_pbip;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "vpbip"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_v_pi;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "vpi"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_v_piiii;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "vpiiii"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_v_pl;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "vpl"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_v_pp;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "vpp"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_JPP;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "iJPP"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_P_JP;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "PJP"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_P_JPP;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "PJPP"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_S_JO;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "SJO"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_P;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "iP"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_P_JOPP;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "PJOPP"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_P_JOPPP;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "PJOPPP"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_v_JOPP;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "vJOPP"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_v_JOPPP;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "vJOPPP"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_P_JOPPPP;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "PJOPPPP"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_P_JOPPPPP;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "PJOPPPPP"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_I_JOSI;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "IJOSI"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_P_JOSII;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "PJOSII"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_p_Ji;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "pJi"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_p_Jipp;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "pJipp"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_p_Jbip;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "pJbip"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_v_Jp;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "vJp"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_v_JS;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "vJS"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_t_tt;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "ttt"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_I_JOt;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "IJOt"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_v_JOSI;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "vJOSI"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_S_JOi;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "SJOi"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_v_JOi;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "vJOi"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_I_JO;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "IJO"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_N_JO;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "NJO"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_v_JON;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "vJON"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_P_JOi;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "PJOi"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_v_JOI;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "vJOI"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_P_JOI;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "PJOI"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_P_JOIS;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "PJOIS"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_S_JOSP;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "SJOSP"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "i"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_i3i;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "ii3i"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_ibi;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "iibi"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_l_lttl;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "llttl"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_pip;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "ipip"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_piS;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "ipiS"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_S_i;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "Si"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_l_p;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "lp"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_c_p;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "cp"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_p_pi;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "ppi"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_p_p;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "pp"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_pttttt;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "ipttttt"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_c_pttt;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "cpttt"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_p_pttttiti;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "ppttttiti"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_pt;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "ipt"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_ptl;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "iptl"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_pi;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "ipi"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_pl;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "ipl"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_l_;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "l"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_p_pt;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "ppt"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_p_ptt;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "pptt"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_pit;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "ipit"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_p_pp;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "ppp"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_l_ttl;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "lttl"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_l_pttl;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "lpttl"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_v_t;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "vt"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_p_pttttitl;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "ppttttitl"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_p_tiB3P;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "ptiB3P"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_p_tip3P;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "ptip3P"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_pPtiiipi;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "ipPtiiipi"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_tpiibi;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "itpiibi"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_p_ptippppi;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "pptippppi"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_p_pi33ipi;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "ppi33ipi"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_p_pttip;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "ppttip"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_p_ptipppi;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "pptipppi"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_p_ppP;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "pppP"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_p_iiil;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "piiil"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_ppl;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "ippl"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_v_pip;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "vpip"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_p_pti;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "ppti"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_ppp;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "ippp"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_p_ti;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "pti"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_p_ptp;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "pptp"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_pt33;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "ipt33"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_c_;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "c"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_c_pi;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "cpi"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_d_;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "d"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_d_d;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "dd"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_f_;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "f"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_f_ff;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "fff"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_f_is;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "fis"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_b;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "ib"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_d;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "id"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_i;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "ii"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_ii;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "iii"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_ii4;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "iii4"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_ii4i;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "iii4i"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_iiii;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "iiiii"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_iiilsp;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "iiiilsp"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_iil;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "iiil"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_iili;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "iiili"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_iip;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "iiip"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_iit;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "iiit"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_iiti;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "iiiti"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_ilsp;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "iilsp"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_iti;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "iiti"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_l;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "il"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_li;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "ili"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_lp;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "ilp"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_lsp;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "ilsp"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_p33;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "ip33"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_p333;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "ip333"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_p333333;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "ip333333"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_p4;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "ip4"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_p42p;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "ip42p"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_p4i;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "ip4i"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_pb;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "ipb"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_pii;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "ipii"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_pii4;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "ipii4"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_pii4i;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "ipii4i"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_piii;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "ipiii"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_piiiiii;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "ipiiiiii"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_piiilsp;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "ipiiilsp"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_piil;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "ipiil"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_piili;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "ipiili"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_piit;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "ipiit"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_piiti;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "ipiiti"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_pilsp;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "ipilsp"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_pli;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "ipli"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_pll;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "ipll"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_pllllllll;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "ipllllllll"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_plp;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "iplp"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_plsp;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "iplsp"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_pp;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "ipp"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_ppi;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "ippi"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_ppiiiiiiii;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "ippiiiiiiii"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_pppp;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "ipppp"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_psp;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "ipsp"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_pti;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "ipti"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_pitl;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "ipitl"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_s;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "is"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_s22;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "is22"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_s222;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "is222"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_sp;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "isp"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_sss;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "isss"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_ssss;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "issss"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_t;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "it"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_ti;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "iti"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_4;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "i4"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_4i;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "i4i"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_42p;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "i42p"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_l_ii;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "lii"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_l_l4;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "ll4"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_l_pi;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "lpi"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_l_pii;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "lpii"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_l_p33l;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "lp33l"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_l_33l;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "l33l"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_p_;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "p"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_p_B;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "pB"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_p_b;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "pb"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_p_Jt;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "pJt"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_p_i;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "pi"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_p_ii;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "pii"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_p_iiii;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "piiii"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_p_iiiiii;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "piiiiii"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_p_iiiiiiii;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "piiiiiiii"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_p_pii;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "ppii"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_p_piiii;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "ppiiii"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_p_t;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "pt"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_p_tpp;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "ptpp"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_p_ttttttt;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "pttttttt"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_s_;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "s"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_t_;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "t"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_t_i;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "ti"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_t_ii;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "tii"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_t_pi;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "tpi"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_t_pii;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "tpii"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_t_t;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "tt"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_t_tl4;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "ttl4"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_t_t4;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "tt4"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_sc;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "isc"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_s_sc;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "ssc"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_c_sc;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "csc"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_iii;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "iiii"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_i3;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "ii3"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_t_b;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "tb"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_t_B;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "tB"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_v_P;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "vP"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_v_pP;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "vpP"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_p_ip;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "pip"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_33;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "i33"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_v_pii;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "vpii"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_v_JO;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "vJO"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_JO;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "iJO"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_JOi;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "iJOi"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_JOt;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "iJOt"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_Jt;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "iJt"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_Ji;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "iJi"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_v_Vi;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "vVi"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_p_ppiii;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "pppiii"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_p_ppiiiiiii;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "pppiiiiiii"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_ppt;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "ippt"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_pppi;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "ipppi"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_pppii;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "ipppii"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_pppiiii;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "ipppiiii"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_ppppiiiiii;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "ippppiiiiii"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_v_fff;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "vfff"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_v_V;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "vV"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_tV;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "itV"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_ptiVp;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "iptiVp"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_pid;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "ipid"), temp_pmc);

        temp_pmc = pmc_new(interp, enum_class_UnManagedStruct);
        PMC_data(temp_pmc) = (void *)pcf_i_pitii;
        VTABLE_set_pmc_keyed_str(interp, HashPointer, CONST_STRING(interp, "ipitii"), temp_pmc);


    }

#if defined(CAN_BUILD_CALL_FRAMES)
    /* Try if JIT code can build that signature. If yes, we are done */

    jit_key_name = CONST_STRING(interp, "_XJIT_");
    jit_key_name = string_concat(interp, jit_key_name, signature, 0);
    b            = VTABLE_get_pmc_keyed_str(interp, HashPointer, jit_key_name);

    if (b && b->vtable->base_type == enum_class_ManagedStruct) {
        *jitted = 1;
        return F2DPTR(VTABLE_get_pointer(interp, b));
    }
    else {
        void * const result = Parrot_jit_build_call_func(interp, pmc_nci, signature);
        if (result) {
            *jitted = 1;
            temp_pmc = pmc_new(interp, enum_class_ManagedStruct);
            VTABLE_set_pointer(interp, temp_pmc, (void *)result);
            VTABLE_set_pmc_keyed_str(interp, HashPointer, jit_key_name, temp_pmc);
            return result;
        }
    }

#endif

    b = VTABLE_get_pmc_keyed_str(interp, HashPointer, signature);

    if (b && b->vtable->base_type == enum_class_UnManagedStruct)
        return F2DPTR(PMC_data(b));

    /*
      These three lines have been added to aid debugging. I want to be able to
      see which signature has an unknown type. I am sure someone can come up
      with a neater way to do this.
     */
    ns = string_make(interp, " is an unknown signature type", 29, "ascii", 0);
    message = string_concat(interp, signature, ns, 0);

#if defined(CAN_BUILD_CALL_FRAMES)
    ns = string_make(interp, ".\nCAN_BUILD_CALL_FRAMES is enabled, this should not happen", 58, "ascii", 0);
#else
    ns = string_make(interp, ".\nCAN_BUILD_CALL_FRAMES is disabled, add the signature to src/call_list.txt", 75, "ascii", 0);
#endif
    message = string_concat(interp, message, ns, 0);

    /*
     * I think there may be memory issues with this but if we get to here we are
     * aborting.
     */
    c = string_to_cstring(interp, message);
    PANIC(interp, c);
}


/*
 * Local variables:
 *   c-file-style: "parrot"
 * End:
 * vim: expandtab shiftwidth=4:
 */
