/*
 * Decompiled with CFR 0.152.
 */
package br.arca.morcego;

import br.arca.morcego.Config;
import br.arca.morcego.Graph;
import br.arca.morcego.Node;
import java.util.Enumeration;
import java.util.Vector;

public class Animator
implements Runnable {
    private Graph graph;
    private Vector addedStack;
    private Vector removedStack;

    public Animator(Graph g) {
        this.graph = g;
        this.addedStack = new Vector();
        this.removedStack = new Vector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void animate(Vector add, Vector remove) {
        Animator animator = this;
        synchronized (animator) {
            this.addedStack = add;
            this.removedStack = remove;
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Thread.currentThread().setPriority(1);
        while (true) {
            block11: {
                try {
                    if (!this.addedStack.isEmpty() || !this.removedStack.isEmpty()) break block11;
                    Animator animator = this;
                    synchronized (animator) {
                        this.wait();
                    }
                }
                catch (InterruptedException e2) {
                    e2.printStackTrace();
                }
            }
            Enumeration e = this.removedStack.elements();
            while (e.hasMoreElements()) {
                this.graph.removeNode((Node)e.nextElement());
            }
            while (!this.addedStack.isEmpty()) {
                Node node = (Node)this.addedStack.remove(0);
                int i = 0;
                while (i++ < this.addedStack.size() && !this.graph.connected(node)) {
                    this.addedStack.add(node);
                    node = (Node)this.addedStack.remove(0);
                }
                this.graph.add(node);
                try {
                    Thread.sleep(((Integer)Config.getValue("feedAnimationInterval")).intValue());
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
            }
            this.addedStack = new Vector();
            this.removedStack = new Vector();
        }
    }
}

